/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.redis;

import backtype.storm.task.IMetricsContext;
import backtype.storm.tuple.Values;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool.impl.GenericObjectPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import storm.trident.state.JSONNonTransactionalSerializer;
import storm.trident.state.JSONOpaqueSerializer;
import storm.trident.state.JSONTransactionalSerializer;
import storm.trident.state.OpaqueValue;
import storm.trident.state.Serializer;
import storm.trident.state.State;
import storm.trident.state.StateFactory;
import storm.trident.state.StateType;
import storm.trident.state.TransactionalValue;
import storm.trident.state.map.CachedMap;
import storm.trident.state.map.IBackingMap;
import storm.trident.state.map.MapState;
import storm.trident.state.map.NonTransactionalMap;
import storm.trident.state.map.OpaqueMap;
import storm.trident.state.map.SnapshottableMap;
import storm.trident.state.map.TransactionalMap;

public class RedisState<T>
implements IBackingMap<T> {
    private static final Map<StateType, Serializer> DEFAULT_SERIALIZERS = new HashMap<StateType, Serializer>(){
        {
            this.put(StateType.NON_TRANSACTIONAL, new JSONNonTransactionalSerializer());
            this.put(StateType.TRANSACTIONAL, new JSONTransactionalSerializer());
            this.put(StateType.OPAQUE, new JSONOpaqueSerializer());
        }
    };
    private final JedisPool pool;
    private Options options;
    private Serializer serializer;
    private KeyFactory keyFactory;

    public static StateFactory opaque(InetSocketAddress server) {
        return RedisState.opaque(server, new Options<OpaqueValue>());
    }

    public static StateFactory opaque(InetSocketAddress server, Options<OpaqueValue> opts) {
        return RedisState.opaque(server, opts, new DefaultKeyFactory());
    }

    public static StateFactory opaque(InetSocketAddress server, Options<OpaqueValue> opts, KeyFactory factory) {
        return new Factory(server, StateType.OPAQUE, opts, factory);
    }

    public static StateFactory transactional(InetSocketAddress server) {
        return RedisState.transactional(server, new Options<TransactionalValue>());
    }

    public static StateFactory transactional(InetSocketAddress server, Options<TransactionalValue> opts) {
        return RedisState.transactional(server, opts, new DefaultKeyFactory());
    }

    public static StateFactory transactional(InetSocketAddress server, Options<TransactionalValue> opts, KeyFactory factory) {
        return new Factory(server, StateType.TRANSACTIONAL, opts, factory);
    }

    public static StateFactory nonTransactional(InetSocketAddress server) {
        return RedisState.nonTransactional(server, new Options<Object>());
    }

    public static StateFactory nonTransactional(InetSocketAddress server, Options<Object> opts) {
        return RedisState.nonTransactional(server, opts, new DefaultKeyFactory());
    }

    public static StateFactory nonTransactional(InetSocketAddress server, Options<Object> opts, KeyFactory factory) {
        return new Factory(server, StateType.NON_TRANSACTIONAL, opts, factory);
    }

    public RedisState(JedisPool pool, Options options, Serializer<T> serializer, KeyFactory keyFactory) {
        this.pool = pool;
        this.options = options;
        this.serializer = serializer;
        this.keyFactory = keyFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> multiGet(List<List<Object>> keys) {
        if (keys.size() > 0) {
            String[] stringKeys = new String[keys.size()];
            int index = 0;
            for (List<Object> key : keys) {
                stringKeys[index++] = this.keyFactory.build(key);
            }
            ArrayList<Object> result = new ArrayList<Object>(keys.size());
            Jedis jedis = (Jedis)this.pool.getResource();
            try {
                List values = jedis.mget(stringKeys);
                for (String value : values) {
                    if (value != null) {
                        result.add(this.serializer.deserialize(value.getBytes()));
                        continue;
                    }
                    result.add(null);
                }
            }
            finally {
                this.pool.returnResource((Object)jedis);
            }
            return result;
        }
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multiPut(List<List<Object>> keys, List<T> vals) {
        if (keys.size() > 0) {
            String[] keyValues = new String[keys.size() * 2];
            for (int i = 0; i < keys.size(); ++i) {
                keyValues[i * 2] = this.keyFactory.build(keys.get(i));
                keyValues[i * 2 + 1] = new String(this.serializer.serialize(vals.get(i)));
            }
            Jedis jedis = (Jedis)this.pool.getResource();
            try {
                jedis.mset(keyValues);
            }
            finally {
                this.pool.returnResource((Object)jedis);
            }
        }
    }

    protected static class Factory
    implements StateFactory {
        StateType type;
        InetSocketAddress server;
        Serializer serializer;
        KeyFactory factory;
        Options options;

        public Factory(InetSocketAddress server, StateType type, Options options, KeyFactory factory) {
            this.type = type;
            this.server = server;
            this.options = options;
            this.factory = factory;
            if (options.serializer == null) {
                this.serializer = (Serializer)DEFAULT_SERIALIZERS.get(type);
                if (this.serializer == null) {
                    throw new RuntimeException("Couldn't find serializer for state type: " + type);
                }
            } else {
                this.serializer = options.serializer;
            }
        }

        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            MapState ms;
            JedisPool pool = new JedisPool((GenericObjectPool.Config)new JedisPoolConfig(), this.server.getHostName(), this.server.getPort(), this.options.connectionTimeout, this.options.password, this.options.database);
            RedisState state = new RedisState(pool, this.options, this.serializer, this.factory);
            CachedMap c = new CachedMap(state, this.options.localCacheSize);
            if (this.type == StateType.NON_TRANSACTIONAL) {
                ms = NonTransactionalMap.build((IBackingMap)c);
            } else if (this.type == StateType.OPAQUE) {
                ms = OpaqueMap.build((IBackingMap)c);
            } else if (this.type == StateType.TRANSACTIONAL) {
                ms = TransactionalMap.build((IBackingMap)c);
            } else {
                throw new RuntimeException("Unknown state type: " + this.type);
            }
            return new SnapshottableMap(ms, (List)new Values(new Object[]{this.options.globalKey}));
        }
    }

    public static interface KeyFactory
    extends Serializable {
        public String build(List<Object> var1);
    }

    public static class Options<T>
    implements Serializable {
        public int localCacheSize = 1000;
        public String globalKey = "$REDIS-MAP-STATE-GLOBAL";
        public Serializer<T> serializer = null;
        public KeyFactory keyFactory = null;
        public int connectionTimeout = 2000;
        public String password = null;
        public int database = 0;
    }

    public static class DefaultKeyFactory
    implements KeyFactory {
        @Override
        public String build(List<Object> key) {
            if (key.size() != 1) {
                throw new RuntimeException("Default KeyFactory does not support compound keys");
            }
            return (String)key.get(0);
        }
    }
}

