// Compiled by ClojureScript 1.10.312 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__3713 = arguments.length;
switch (G__3713) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3714 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3714 = (function (f,blockable,meta3715){
this.f = f;
this.blockable = blockable;
this.meta3715 = meta3715;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async3714.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_3716,meta3715__$1){
var self__ = this;
var _3716__$1 = this;
return (new cljs.core.async.t_cljs$core$async3714(self__.f,self__.blockable,meta3715__$1));
});

cljs.core.async.t_cljs$core$async3714.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_3716){
var self__ = this;
var _3716__$1 = this;
return self__.meta3715;
});

cljs.core.async.t_cljs$core$async3714.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3714.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async3714.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async3714.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async3714.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta3715","meta3715",1521584230,null)], null);
});

cljs.core.async.t_cljs$core$async3714.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async3714.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3714";

cljs.core.async.t_cljs$core$async3714.cljs$lang$ctorPrWriter = (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write.call(null,writer__4180__auto__,"cljs.core.async/t_cljs$core$async3714");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3714.
 */
cljs.core.async.__GT_t_cljs$core$async3714 = (function cljs$core$async$__GT_t_cljs$core$async3714(f__$1,blockable__$1,meta3715){
return (new cljs.core.async.t_cljs$core$async3714(f__$1,blockable__$1,meta3715));
});

}

return (new cljs.core.async.t_cljs$core$async3714(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__3720 = arguments.length;
switch (G__3720) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__3723 = arguments.length;
switch (G__3723) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__3726 = arguments.length;
switch (G__3726) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_3728 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_3728);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_3728,ret){
return (function (){
return fn1.call(null,val_3728);
});})(val_3728,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__3730 = arguments.length;
switch (G__3730) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4394__auto___3732 = n;
var x_3733 = (0);
while(true){
if((x_3733 < n__4394__auto___3732)){
(a[x_3733] = (0));

var G__3734 = (x_3733 + (1));
x_3733 = G__3734;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__3735 = (i + (1));
i = G__3735;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3736 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3736 = (function (flag,meta3737){
this.flag = flag;
this.meta3737 = meta3737;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async3736.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_3738,meta3737__$1){
var self__ = this;
var _3738__$1 = this;
return (new cljs.core.async.t_cljs$core$async3736(self__.flag,meta3737__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async3736.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_3738){
var self__ = this;
var _3738__$1 = this;
return self__.meta3737;
});})(flag))
;

cljs.core.async.t_cljs$core$async3736.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3736.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async3736.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async3736.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async3736.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta3737","meta3737",1726783371,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async3736.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async3736.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3736";

cljs.core.async.t_cljs$core$async3736.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write.call(null,writer__4180__auto__,"cljs.core.async/t_cljs$core$async3736");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3736.
 */
cljs.core.async.__GT_t_cljs$core$async3736 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async3736(flag__$1,meta3737){
return (new cljs.core.async.t_cljs$core$async3736(flag__$1,meta3737));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async3736(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3739 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3739 = (function (flag,cb,meta3740){
this.flag = flag;
this.cb = cb;
this.meta3740 = meta3740;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async3739.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_3741,meta3740__$1){
var self__ = this;
var _3741__$1 = this;
return (new cljs.core.async.t_cljs$core$async3739(self__.flag,self__.cb,meta3740__$1));
});

cljs.core.async.t_cljs$core$async3739.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_3741){
var self__ = this;
var _3741__$1 = this;
return self__.meta3740;
});

cljs.core.async.t_cljs$core$async3739.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3739.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async3739.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async3739.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async3739.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta3740","meta3740",-385256646,null)], null);
});

cljs.core.async.t_cljs$core$async3739.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async3739.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3739";

cljs.core.async.t_cljs$core$async3739.cljs$lang$ctorPrWriter = (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write.call(null,writer__4180__auto__,"cljs.core.async/t_cljs$core$async3739");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3739.
 */
cljs.core.async.__GT_t_cljs$core$async3739 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async3739(flag__$1,cb__$1,meta3740){
return (new cljs.core.async.t_cljs$core$async3739(flag__$1,cb__$1,meta3740));
});

}

return (new cljs.core.async.t_cljs$core$async3739(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__3742_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__3742_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__3743_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__3743_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__3936__auto__ = wport;
if(cljs.core.truth_(or__3936__auto__)){
return or__3936__auto__;
} else {
return port;
}
})()], null));
} else {
var G__3744 = (i + (1));
i = G__3744;
continue;
}
} else {
return null;
}
break;
}
})();
var or__3936__auto__ = ret;
if(cljs.core.truth_(or__3936__auto__)){
return or__3936__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__3925__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__3925__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__3925__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4520__auto__ = [];
var len__4517__auto___3750 = arguments.length;
var i__4518__auto___3751 = (0);
while(true){
if((i__4518__auto___3751 < len__4517__auto___3750)){
args__4520__auto__.push((arguments[i__4518__auto___3751]));

var G__3752 = (i__4518__auto___3751 + (1));
i__4518__auto___3751 = G__3752;
continue;
} else {
}
break;
}

var argseq__4521__auto__ = ((((1) < args__4520__auto__.length))?(new cljs.core.IndexedSeq(args__4520__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4521__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__3747){
var map__3748 = p__3747;
var map__3748__$1 = ((((!((map__3748 == null)))?(((((map__3748.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3748.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3748):map__3748);
var opts = map__3748__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq3745){
var G__3746 = cljs.core.first.call(null,seq3745);
var seq3745__$1 = cljs.core.next.call(null,seq3745);
var self__4504__auto__ = this;
return self__4504__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3746,seq3745__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__3754 = arguments.length;
switch (G__3754) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__3667__auto___3800 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto___3800){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto___3800){
return (function (state_3778){
var state_val_3779 = (state_3778[(1)]);
if((state_val_3779 === (7))){
var inst_3774 = (state_3778[(2)]);
var state_3778__$1 = state_3778;
var statearr_3780_3801 = state_3778__$1;
(statearr_3780_3801[(2)] = inst_3774);

(statearr_3780_3801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3779 === (1))){
var state_3778__$1 = state_3778;
var statearr_3781_3802 = state_3778__$1;
(statearr_3781_3802[(2)] = null);

(statearr_3781_3802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3779 === (4))){
var inst_3757 = (state_3778[(7)]);
var inst_3757__$1 = (state_3778[(2)]);
var inst_3758 = (inst_3757__$1 == null);
var state_3778__$1 = (function (){var statearr_3782 = state_3778;
(statearr_3782[(7)] = inst_3757__$1);

return statearr_3782;
})();
if(cljs.core.truth_(inst_3758)){
var statearr_3783_3803 = state_3778__$1;
(statearr_3783_3803[(1)] = (5));

} else {
var statearr_3784_3804 = state_3778__$1;
(statearr_3784_3804[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3779 === (13))){
var state_3778__$1 = state_3778;
var statearr_3785_3805 = state_3778__$1;
(statearr_3785_3805[(2)] = null);

(statearr_3785_3805[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3779 === (6))){
var inst_3757 = (state_3778[(7)]);
var state_3778__$1 = state_3778;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3778__$1,(11),to,inst_3757);
} else {
if((state_val_3779 === (3))){
var inst_3776 = (state_3778[(2)]);
var state_3778__$1 = state_3778;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3778__$1,inst_3776);
} else {
if((state_val_3779 === (12))){
var state_3778__$1 = state_3778;
var statearr_3786_3806 = state_3778__$1;
(statearr_3786_3806[(2)] = null);

(statearr_3786_3806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3779 === (2))){
var state_3778__$1 = state_3778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3778__$1,(4),from);
} else {
if((state_val_3779 === (11))){
var inst_3767 = (state_3778[(2)]);
var state_3778__$1 = state_3778;
if(cljs.core.truth_(inst_3767)){
var statearr_3787_3807 = state_3778__$1;
(statearr_3787_3807[(1)] = (12));

} else {
var statearr_3788_3808 = state_3778__$1;
(statearr_3788_3808[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3779 === (9))){
var state_3778__$1 = state_3778;
var statearr_3789_3809 = state_3778__$1;
(statearr_3789_3809[(2)] = null);

(statearr_3789_3809[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3779 === (5))){
var state_3778__$1 = state_3778;
if(cljs.core.truth_(close_QMARK_)){
var statearr_3790_3810 = state_3778__$1;
(statearr_3790_3810[(1)] = (8));

} else {
var statearr_3791_3811 = state_3778__$1;
(statearr_3791_3811[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3779 === (14))){
var inst_3772 = (state_3778[(2)]);
var state_3778__$1 = state_3778;
var statearr_3792_3812 = state_3778__$1;
(statearr_3792_3812[(2)] = inst_3772);

(statearr_3792_3812[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3779 === (10))){
var inst_3764 = (state_3778[(2)]);
var state_3778__$1 = state_3778;
var statearr_3793_3813 = state_3778__$1;
(statearr_3793_3813[(2)] = inst_3764);

(statearr_3793_3813[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3779 === (8))){
var inst_3761 = cljs.core.async.close_BANG_.call(null,to);
var state_3778__$1 = state_3778;
var statearr_3794_3814 = state_3778__$1;
(statearr_3794_3814[(2)] = inst_3761);

(statearr_3794_3814[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3667__auto___3800))
;
return ((function (switch__3579__auto__,c__3667__auto___3800){
return (function() {
var cljs$core$async$state_machine__3580__auto__ = null;
var cljs$core$async$state_machine__3580__auto____0 = (function (){
var statearr_3795 = [null,null,null,null,null,null,null,null];
(statearr_3795[(0)] = cljs$core$async$state_machine__3580__auto__);

(statearr_3795[(1)] = (1));

return statearr_3795;
});
var cljs$core$async$state_machine__3580__auto____1 = (function (state_3778){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_3778);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e3796){if((e3796 instanceof Object)){
var ex__3583__auto__ = e3796;
var statearr_3797_3815 = state_3778;
(statearr_3797_3815[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3778);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3796;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3816 = state_3778;
state_3778 = G__3816;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$state_machine__3580__auto__ = function(state_3778){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3580__auto____1.call(this,state_3778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3580__auto____0;
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3580__auto____1;
return cljs$core$async$state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto___3800))
})();
var state__3669__auto__ = (function (){var statearr_3798 = f__3668__auto__.call(null);
(statearr_3798[(6)] = c__3667__auto___3800);

return statearr_3798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto___3800))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__3817){
var vec__3818 = p__3817;
var v = cljs.core.nth.call(null,vec__3818,(0),null);
var p = cljs.core.nth.call(null,vec__3818,(1),null);
var job = vec__3818;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__3667__auto___3989 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto___3989,res,vec__3818,v,p,job,jobs,results){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto___3989,res,vec__3818,v,p,job,jobs,results){
return (function (state_3825){
var state_val_3826 = (state_3825[(1)]);
if((state_val_3826 === (1))){
var state_3825__$1 = state_3825;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3825__$1,(2),res,v);
} else {
if((state_val_3826 === (2))){
var inst_3822 = (state_3825[(2)]);
var inst_3823 = cljs.core.async.close_BANG_.call(null,res);
var state_3825__$1 = (function (){var statearr_3827 = state_3825;
(statearr_3827[(7)] = inst_3822);

return statearr_3827;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3825__$1,inst_3823);
} else {
return null;
}
}
});})(c__3667__auto___3989,res,vec__3818,v,p,job,jobs,results))
;
return ((function (switch__3579__auto__,c__3667__auto___3989,res,vec__3818,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____0 = (function (){
var statearr_3828 = [null,null,null,null,null,null,null,null];
(statearr_3828[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__);

(statearr_3828[(1)] = (1));

return statearr_3828;
});
var cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____1 = (function (state_3825){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_3825);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e3829){if((e3829 instanceof Object)){
var ex__3583__auto__ = e3829;
var statearr_3830_3990 = state_3825;
(statearr_3830_3990[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3825);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3829;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3991 = state_3825;
state_3825 = G__3991;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__ = function(state_3825){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____1.call(this,state_3825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto___3989,res,vec__3818,v,p,job,jobs,results))
})();
var state__3669__auto__ = (function (){var statearr_3831 = f__3668__auto__.call(null);
(statearr_3831[(6)] = c__3667__auto___3989);

return statearr_3831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto___3989,res,vec__3818,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__3832){
var vec__3833 = p__3832;
var v = cljs.core.nth.call(null,vec__3833,(0),null);
var p = cljs.core.nth.call(null,vec__3833,(1),null);
var job = vec__3833;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4394__auto___3992 = n;
var __3993 = (0);
while(true){
if((__3993 < n__4394__auto___3992)){
var G__3836_3994 = type;
var G__3836_3995__$1 = (((G__3836_3994 instanceof cljs.core.Keyword))?G__3836_3994.fqn:null);
switch (G__3836_3995__$1) {
case "compute":
var c__3667__auto___3997 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__3993,c__3667__auto___3997,G__3836_3994,G__3836_3995__$1,n__4394__auto___3992,jobs,results,process,async){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (__3993,c__3667__auto___3997,G__3836_3994,G__3836_3995__$1,n__4394__auto___3992,jobs,results,process,async){
return (function (state_3849){
var state_val_3850 = (state_3849[(1)]);
if((state_val_3850 === (1))){
var state_3849__$1 = state_3849;
var statearr_3851_3998 = state_3849__$1;
(statearr_3851_3998[(2)] = null);

(statearr_3851_3998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3850 === (2))){
var state_3849__$1 = state_3849;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3849__$1,(4),jobs);
} else {
if((state_val_3850 === (3))){
var inst_3847 = (state_3849[(2)]);
var state_3849__$1 = state_3849;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3849__$1,inst_3847);
} else {
if((state_val_3850 === (4))){
var inst_3839 = (state_3849[(2)]);
var inst_3840 = process.call(null,inst_3839);
var state_3849__$1 = state_3849;
if(cljs.core.truth_(inst_3840)){
var statearr_3852_3999 = state_3849__$1;
(statearr_3852_3999[(1)] = (5));

} else {
var statearr_3853_4000 = state_3849__$1;
(statearr_3853_4000[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3850 === (5))){
var state_3849__$1 = state_3849;
var statearr_3854_4001 = state_3849__$1;
(statearr_3854_4001[(2)] = null);

(statearr_3854_4001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3850 === (6))){
var state_3849__$1 = state_3849;
var statearr_3855_4002 = state_3849__$1;
(statearr_3855_4002[(2)] = null);

(statearr_3855_4002[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3850 === (7))){
var inst_3845 = (state_3849[(2)]);
var state_3849__$1 = state_3849;
var statearr_3856_4003 = state_3849__$1;
(statearr_3856_4003[(2)] = inst_3845);

(statearr_3856_4003[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__3993,c__3667__auto___3997,G__3836_3994,G__3836_3995__$1,n__4394__auto___3992,jobs,results,process,async))
;
return ((function (__3993,switch__3579__auto__,c__3667__auto___3997,G__3836_3994,G__3836_3995__$1,n__4394__auto___3992,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____0 = (function (){
var statearr_3857 = [null,null,null,null,null,null,null];
(statearr_3857[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__);

(statearr_3857[(1)] = (1));

return statearr_3857;
});
var cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____1 = (function (state_3849){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_3849);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e3858){if((e3858 instanceof Object)){
var ex__3583__auto__ = e3858;
var statearr_3859_4004 = state_3849;
(statearr_3859_4004[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3849);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3858;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4005 = state_3849;
state_3849 = G__4005;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__ = function(state_3849){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____1.call(this,state_3849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__;
})()
;})(__3993,switch__3579__auto__,c__3667__auto___3997,G__3836_3994,G__3836_3995__$1,n__4394__auto___3992,jobs,results,process,async))
})();
var state__3669__auto__ = (function (){var statearr_3860 = f__3668__auto__.call(null);
(statearr_3860[(6)] = c__3667__auto___3997);

return statearr_3860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(__3993,c__3667__auto___3997,G__3836_3994,G__3836_3995__$1,n__4394__auto___3992,jobs,results,process,async))
);


break;
case "async":
var c__3667__auto___4006 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__3993,c__3667__auto___4006,G__3836_3994,G__3836_3995__$1,n__4394__auto___3992,jobs,results,process,async){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (__3993,c__3667__auto___4006,G__3836_3994,G__3836_3995__$1,n__4394__auto___3992,jobs,results,process,async){
return (function (state_3873){
var state_val_3874 = (state_3873[(1)]);
if((state_val_3874 === (1))){
var state_3873__$1 = state_3873;
var statearr_3875_4007 = state_3873__$1;
(statearr_3875_4007[(2)] = null);

(statearr_3875_4007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3874 === (2))){
var state_3873__$1 = state_3873;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3873__$1,(4),jobs);
} else {
if((state_val_3874 === (3))){
var inst_3871 = (state_3873[(2)]);
var state_3873__$1 = state_3873;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3873__$1,inst_3871);
} else {
if((state_val_3874 === (4))){
var inst_3863 = (state_3873[(2)]);
var inst_3864 = async.call(null,inst_3863);
var state_3873__$1 = state_3873;
if(cljs.core.truth_(inst_3864)){
var statearr_3876_4008 = state_3873__$1;
(statearr_3876_4008[(1)] = (5));

} else {
var statearr_3877_4009 = state_3873__$1;
(statearr_3877_4009[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3874 === (5))){
var state_3873__$1 = state_3873;
var statearr_3878_4010 = state_3873__$1;
(statearr_3878_4010[(2)] = null);

(statearr_3878_4010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3874 === (6))){
var state_3873__$1 = state_3873;
var statearr_3879_4011 = state_3873__$1;
(statearr_3879_4011[(2)] = null);

(statearr_3879_4011[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3874 === (7))){
var inst_3869 = (state_3873[(2)]);
var state_3873__$1 = state_3873;
var statearr_3880_4012 = state_3873__$1;
(statearr_3880_4012[(2)] = inst_3869);

(statearr_3880_4012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__3993,c__3667__auto___4006,G__3836_3994,G__3836_3995__$1,n__4394__auto___3992,jobs,results,process,async))
;
return ((function (__3993,switch__3579__auto__,c__3667__auto___4006,G__3836_3994,G__3836_3995__$1,n__4394__auto___3992,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____0 = (function (){
var statearr_3881 = [null,null,null,null,null,null,null];
(statearr_3881[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__);

(statearr_3881[(1)] = (1));

return statearr_3881;
});
var cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____1 = (function (state_3873){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_3873);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e3882){if((e3882 instanceof Object)){
var ex__3583__auto__ = e3882;
var statearr_3883_4013 = state_3873;
(statearr_3883_4013[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3873);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3882;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4014 = state_3873;
state_3873 = G__4014;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__ = function(state_3873){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____1.call(this,state_3873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__;
})()
;})(__3993,switch__3579__auto__,c__3667__auto___4006,G__3836_3994,G__3836_3995__$1,n__4394__auto___3992,jobs,results,process,async))
})();
var state__3669__auto__ = (function (){var statearr_3884 = f__3668__auto__.call(null);
(statearr_3884[(6)] = c__3667__auto___4006);

return statearr_3884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(__3993,c__3667__auto___4006,G__3836_3994,G__3836_3995__$1,n__4394__auto___3992,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__3836_3995__$1)].join('')));

}

var G__4015 = (__3993 + (1));
__3993 = G__4015;
continue;
} else {
}
break;
}

var c__3667__auto___4016 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto___4016,jobs,results,process,async){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto___4016,jobs,results,process,async){
return (function (state_3906){
var state_val_3907 = (state_3906[(1)]);
if((state_val_3907 === (1))){
var state_3906__$1 = state_3906;
var statearr_3908_4017 = state_3906__$1;
(statearr_3908_4017[(2)] = null);

(statearr_3908_4017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3907 === (2))){
var state_3906__$1 = state_3906;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3906__$1,(4),from);
} else {
if((state_val_3907 === (3))){
var inst_3904 = (state_3906[(2)]);
var state_3906__$1 = state_3906;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3906__$1,inst_3904);
} else {
if((state_val_3907 === (4))){
var inst_3887 = (state_3906[(7)]);
var inst_3887__$1 = (state_3906[(2)]);
var inst_3888 = (inst_3887__$1 == null);
var state_3906__$1 = (function (){var statearr_3909 = state_3906;
(statearr_3909[(7)] = inst_3887__$1);

return statearr_3909;
})();
if(cljs.core.truth_(inst_3888)){
var statearr_3910_4018 = state_3906__$1;
(statearr_3910_4018[(1)] = (5));

} else {
var statearr_3911_4019 = state_3906__$1;
(statearr_3911_4019[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3907 === (5))){
var inst_3890 = cljs.core.async.close_BANG_.call(null,jobs);
var state_3906__$1 = state_3906;
var statearr_3912_4020 = state_3906__$1;
(statearr_3912_4020[(2)] = inst_3890);

(statearr_3912_4020[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3907 === (6))){
var inst_3887 = (state_3906[(7)]);
var inst_3892 = (state_3906[(8)]);
var inst_3892__$1 = cljs.core.async.chan.call(null,(1));
var inst_3893 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_3894 = [inst_3887,inst_3892__$1];
var inst_3895 = (new cljs.core.PersistentVector(null,2,(5),inst_3893,inst_3894,null));
var state_3906__$1 = (function (){var statearr_3913 = state_3906;
(statearr_3913[(8)] = inst_3892__$1);

return statearr_3913;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3906__$1,(8),jobs,inst_3895);
} else {
if((state_val_3907 === (7))){
var inst_3902 = (state_3906[(2)]);
var state_3906__$1 = state_3906;
var statearr_3914_4021 = state_3906__$1;
(statearr_3914_4021[(2)] = inst_3902);

(statearr_3914_4021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3907 === (8))){
var inst_3892 = (state_3906[(8)]);
var inst_3897 = (state_3906[(2)]);
var state_3906__$1 = (function (){var statearr_3915 = state_3906;
(statearr_3915[(9)] = inst_3897);

return statearr_3915;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3906__$1,(9),results,inst_3892);
} else {
if((state_val_3907 === (9))){
var inst_3899 = (state_3906[(2)]);
var state_3906__$1 = (function (){var statearr_3916 = state_3906;
(statearr_3916[(10)] = inst_3899);

return statearr_3916;
})();
var statearr_3917_4022 = state_3906__$1;
(statearr_3917_4022[(2)] = null);

(statearr_3917_4022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__3667__auto___4016,jobs,results,process,async))
;
return ((function (switch__3579__auto__,c__3667__auto___4016,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____0 = (function (){
var statearr_3918 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_3918[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__);

(statearr_3918[(1)] = (1));

return statearr_3918;
});
var cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____1 = (function (state_3906){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_3906);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e3919){if((e3919 instanceof Object)){
var ex__3583__auto__ = e3919;
var statearr_3920_4023 = state_3906;
(statearr_3920_4023[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3906);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3919;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4024 = state_3906;
state_3906 = G__4024;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__ = function(state_3906){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____1.call(this,state_3906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto___4016,jobs,results,process,async))
})();
var state__3669__auto__ = (function (){var statearr_3921 = f__3668__auto__.call(null);
(statearr_3921[(6)] = c__3667__auto___4016);

return statearr_3921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto___4016,jobs,results,process,async))
);


var c__3667__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto__,jobs,results,process,async){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto__,jobs,results,process,async){
return (function (state_3959){
var state_val_3960 = (state_3959[(1)]);
if((state_val_3960 === (7))){
var inst_3955 = (state_3959[(2)]);
var state_3959__$1 = state_3959;
var statearr_3961_4025 = state_3959__$1;
(statearr_3961_4025[(2)] = inst_3955);

(statearr_3961_4025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3960 === (20))){
var state_3959__$1 = state_3959;
var statearr_3962_4026 = state_3959__$1;
(statearr_3962_4026[(2)] = null);

(statearr_3962_4026[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3960 === (1))){
var state_3959__$1 = state_3959;
var statearr_3963_4027 = state_3959__$1;
(statearr_3963_4027[(2)] = null);

(statearr_3963_4027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3960 === (4))){
var inst_3924 = (state_3959[(7)]);
var inst_3924__$1 = (state_3959[(2)]);
var inst_3925 = (inst_3924__$1 == null);
var state_3959__$1 = (function (){var statearr_3964 = state_3959;
(statearr_3964[(7)] = inst_3924__$1);

return statearr_3964;
})();
if(cljs.core.truth_(inst_3925)){
var statearr_3965_4028 = state_3959__$1;
(statearr_3965_4028[(1)] = (5));

} else {
var statearr_3966_4029 = state_3959__$1;
(statearr_3966_4029[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3960 === (15))){
var inst_3937 = (state_3959[(8)]);
var state_3959__$1 = state_3959;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3959__$1,(18),to,inst_3937);
} else {
if((state_val_3960 === (21))){
var inst_3950 = (state_3959[(2)]);
var state_3959__$1 = state_3959;
var statearr_3967_4030 = state_3959__$1;
(statearr_3967_4030[(2)] = inst_3950);

(statearr_3967_4030[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3960 === (13))){
var inst_3952 = (state_3959[(2)]);
var state_3959__$1 = (function (){var statearr_3968 = state_3959;
(statearr_3968[(9)] = inst_3952);

return statearr_3968;
})();
var statearr_3969_4031 = state_3959__$1;
(statearr_3969_4031[(2)] = null);

(statearr_3969_4031[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3960 === (6))){
var inst_3924 = (state_3959[(7)]);
var state_3959__$1 = state_3959;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3959__$1,(11),inst_3924);
} else {
if((state_val_3960 === (17))){
var inst_3945 = (state_3959[(2)]);
var state_3959__$1 = state_3959;
if(cljs.core.truth_(inst_3945)){
var statearr_3970_4032 = state_3959__$1;
(statearr_3970_4032[(1)] = (19));

} else {
var statearr_3971_4033 = state_3959__$1;
(statearr_3971_4033[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3960 === (3))){
var inst_3957 = (state_3959[(2)]);
var state_3959__$1 = state_3959;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3959__$1,inst_3957);
} else {
if((state_val_3960 === (12))){
var inst_3934 = (state_3959[(10)]);
var state_3959__$1 = state_3959;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3959__$1,(14),inst_3934);
} else {
if((state_val_3960 === (2))){
var state_3959__$1 = state_3959;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3959__$1,(4),results);
} else {
if((state_val_3960 === (19))){
var state_3959__$1 = state_3959;
var statearr_3972_4034 = state_3959__$1;
(statearr_3972_4034[(2)] = null);

(statearr_3972_4034[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3960 === (11))){
var inst_3934 = (state_3959[(2)]);
var state_3959__$1 = (function (){var statearr_3973 = state_3959;
(statearr_3973[(10)] = inst_3934);

return statearr_3973;
})();
var statearr_3974_4035 = state_3959__$1;
(statearr_3974_4035[(2)] = null);

(statearr_3974_4035[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3960 === (9))){
var state_3959__$1 = state_3959;
var statearr_3975_4036 = state_3959__$1;
(statearr_3975_4036[(2)] = null);

(statearr_3975_4036[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3960 === (5))){
var state_3959__$1 = state_3959;
if(cljs.core.truth_(close_QMARK_)){
var statearr_3976_4037 = state_3959__$1;
(statearr_3976_4037[(1)] = (8));

} else {
var statearr_3977_4038 = state_3959__$1;
(statearr_3977_4038[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3960 === (14))){
var inst_3937 = (state_3959[(8)]);
var inst_3939 = (state_3959[(11)]);
var inst_3937__$1 = (state_3959[(2)]);
var inst_3938 = (inst_3937__$1 == null);
var inst_3939__$1 = cljs.core.not.call(null,inst_3938);
var state_3959__$1 = (function (){var statearr_3978 = state_3959;
(statearr_3978[(8)] = inst_3937__$1);

(statearr_3978[(11)] = inst_3939__$1);

return statearr_3978;
})();
if(inst_3939__$1){
var statearr_3979_4039 = state_3959__$1;
(statearr_3979_4039[(1)] = (15));

} else {
var statearr_3980_4040 = state_3959__$1;
(statearr_3980_4040[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3960 === (16))){
var inst_3939 = (state_3959[(11)]);
var state_3959__$1 = state_3959;
var statearr_3981_4041 = state_3959__$1;
(statearr_3981_4041[(2)] = inst_3939);

(statearr_3981_4041[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3960 === (10))){
var inst_3931 = (state_3959[(2)]);
var state_3959__$1 = state_3959;
var statearr_3982_4042 = state_3959__$1;
(statearr_3982_4042[(2)] = inst_3931);

(statearr_3982_4042[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3960 === (18))){
var inst_3942 = (state_3959[(2)]);
var state_3959__$1 = state_3959;
var statearr_3983_4043 = state_3959__$1;
(statearr_3983_4043[(2)] = inst_3942);

(statearr_3983_4043[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3960 === (8))){
var inst_3928 = cljs.core.async.close_BANG_.call(null,to);
var state_3959__$1 = state_3959;
var statearr_3984_4044 = state_3959__$1;
(statearr_3984_4044[(2)] = inst_3928);

(statearr_3984_4044[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3667__auto__,jobs,results,process,async))
;
return ((function (switch__3579__auto__,c__3667__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____0 = (function (){
var statearr_3985 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_3985[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__);

(statearr_3985[(1)] = (1));

return statearr_3985;
});
var cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____1 = (function (state_3959){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_3959);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e3986){if((e3986 instanceof Object)){
var ex__3583__auto__ = e3986;
var statearr_3987_4045 = state_3959;
(statearr_3987_4045[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3959);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3986;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4046 = state_3959;
state_3959 = G__4046;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__ = function(state_3959){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____1.call(this,state_3959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__3580__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto__,jobs,results,process,async))
})();
var state__3669__auto__ = (function (){var statearr_3988 = f__3668__auto__.call(null);
(statearr_3988[(6)] = c__3667__auto__);

return statearr_3988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto__,jobs,results,process,async))
);

return c__3667__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__4048 = arguments.length;
switch (G__4048) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__4051 = arguments.length;
switch (G__4051) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__4054 = arguments.length;
switch (G__4054) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__3667__auto___4103 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto___4103,tc,fc){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto___4103,tc,fc){
return (function (state_4080){
var state_val_4081 = (state_4080[(1)]);
if((state_val_4081 === (7))){
var inst_4076 = (state_4080[(2)]);
var state_4080__$1 = state_4080;
var statearr_4082_4104 = state_4080__$1;
(statearr_4082_4104[(2)] = inst_4076);

(statearr_4082_4104[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4081 === (1))){
var state_4080__$1 = state_4080;
var statearr_4083_4105 = state_4080__$1;
(statearr_4083_4105[(2)] = null);

(statearr_4083_4105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4081 === (4))){
var inst_4057 = (state_4080[(7)]);
var inst_4057__$1 = (state_4080[(2)]);
var inst_4058 = (inst_4057__$1 == null);
var state_4080__$1 = (function (){var statearr_4084 = state_4080;
(statearr_4084[(7)] = inst_4057__$1);

return statearr_4084;
})();
if(cljs.core.truth_(inst_4058)){
var statearr_4085_4106 = state_4080__$1;
(statearr_4085_4106[(1)] = (5));

} else {
var statearr_4086_4107 = state_4080__$1;
(statearr_4086_4107[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4081 === (13))){
var state_4080__$1 = state_4080;
var statearr_4087_4108 = state_4080__$1;
(statearr_4087_4108[(2)] = null);

(statearr_4087_4108[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4081 === (6))){
var inst_4057 = (state_4080[(7)]);
var inst_4063 = p.call(null,inst_4057);
var state_4080__$1 = state_4080;
if(cljs.core.truth_(inst_4063)){
var statearr_4088_4109 = state_4080__$1;
(statearr_4088_4109[(1)] = (9));

} else {
var statearr_4089_4110 = state_4080__$1;
(statearr_4089_4110[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4081 === (3))){
var inst_4078 = (state_4080[(2)]);
var state_4080__$1 = state_4080;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4080__$1,inst_4078);
} else {
if((state_val_4081 === (12))){
var state_4080__$1 = state_4080;
var statearr_4090_4111 = state_4080__$1;
(statearr_4090_4111[(2)] = null);

(statearr_4090_4111[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4081 === (2))){
var state_4080__$1 = state_4080;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4080__$1,(4),ch);
} else {
if((state_val_4081 === (11))){
var inst_4057 = (state_4080[(7)]);
var inst_4067 = (state_4080[(2)]);
var state_4080__$1 = state_4080;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4080__$1,(8),inst_4067,inst_4057);
} else {
if((state_val_4081 === (9))){
var state_4080__$1 = state_4080;
var statearr_4091_4112 = state_4080__$1;
(statearr_4091_4112[(2)] = tc);

(statearr_4091_4112[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4081 === (5))){
var inst_4060 = cljs.core.async.close_BANG_.call(null,tc);
var inst_4061 = cljs.core.async.close_BANG_.call(null,fc);
var state_4080__$1 = (function (){var statearr_4092 = state_4080;
(statearr_4092[(8)] = inst_4060);

return statearr_4092;
})();
var statearr_4093_4113 = state_4080__$1;
(statearr_4093_4113[(2)] = inst_4061);

(statearr_4093_4113[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4081 === (14))){
var inst_4074 = (state_4080[(2)]);
var state_4080__$1 = state_4080;
var statearr_4094_4114 = state_4080__$1;
(statearr_4094_4114[(2)] = inst_4074);

(statearr_4094_4114[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4081 === (10))){
var state_4080__$1 = state_4080;
var statearr_4095_4115 = state_4080__$1;
(statearr_4095_4115[(2)] = fc);

(statearr_4095_4115[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4081 === (8))){
var inst_4069 = (state_4080[(2)]);
var state_4080__$1 = state_4080;
if(cljs.core.truth_(inst_4069)){
var statearr_4096_4116 = state_4080__$1;
(statearr_4096_4116[(1)] = (12));

} else {
var statearr_4097_4117 = state_4080__$1;
(statearr_4097_4117[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3667__auto___4103,tc,fc))
;
return ((function (switch__3579__auto__,c__3667__auto___4103,tc,fc){
return (function() {
var cljs$core$async$state_machine__3580__auto__ = null;
var cljs$core$async$state_machine__3580__auto____0 = (function (){
var statearr_4098 = [null,null,null,null,null,null,null,null,null];
(statearr_4098[(0)] = cljs$core$async$state_machine__3580__auto__);

(statearr_4098[(1)] = (1));

return statearr_4098;
});
var cljs$core$async$state_machine__3580__auto____1 = (function (state_4080){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_4080);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e4099){if((e4099 instanceof Object)){
var ex__3583__auto__ = e4099;
var statearr_4100_4118 = state_4080;
(statearr_4100_4118[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4080);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4099;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4119 = state_4080;
state_4080 = G__4119;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$state_machine__3580__auto__ = function(state_4080){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3580__auto____1.call(this,state_4080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3580__auto____0;
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3580__auto____1;
return cljs$core$async$state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto___4103,tc,fc))
})();
var state__3669__auto__ = (function (){var statearr_4101 = f__3668__auto__.call(null);
(statearr_4101[(6)] = c__3667__auto___4103);

return statearr_4101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto___4103,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__3667__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto__){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto__){
return (function (state_4140){
var state_val_4141 = (state_4140[(1)]);
if((state_val_4141 === (7))){
var inst_4136 = (state_4140[(2)]);
var state_4140__$1 = state_4140;
var statearr_4142_4160 = state_4140__$1;
(statearr_4142_4160[(2)] = inst_4136);

(statearr_4142_4160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4141 === (1))){
var inst_4120 = init;
var state_4140__$1 = (function (){var statearr_4143 = state_4140;
(statearr_4143[(7)] = inst_4120);

return statearr_4143;
})();
var statearr_4144_4161 = state_4140__$1;
(statearr_4144_4161[(2)] = null);

(statearr_4144_4161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4141 === (4))){
var inst_4123 = (state_4140[(8)]);
var inst_4123__$1 = (state_4140[(2)]);
var inst_4124 = (inst_4123__$1 == null);
var state_4140__$1 = (function (){var statearr_4145 = state_4140;
(statearr_4145[(8)] = inst_4123__$1);

return statearr_4145;
})();
if(cljs.core.truth_(inst_4124)){
var statearr_4146_4162 = state_4140__$1;
(statearr_4146_4162[(1)] = (5));

} else {
var statearr_4147_4163 = state_4140__$1;
(statearr_4147_4163[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4141 === (6))){
var inst_4123 = (state_4140[(8)]);
var inst_4120 = (state_4140[(7)]);
var inst_4127 = (state_4140[(9)]);
var inst_4127__$1 = f.call(null,inst_4120,inst_4123);
var inst_4128 = cljs.core.reduced_QMARK_.call(null,inst_4127__$1);
var state_4140__$1 = (function (){var statearr_4148 = state_4140;
(statearr_4148[(9)] = inst_4127__$1);

return statearr_4148;
})();
if(inst_4128){
var statearr_4149_4164 = state_4140__$1;
(statearr_4149_4164[(1)] = (8));

} else {
var statearr_4150_4165 = state_4140__$1;
(statearr_4150_4165[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4141 === (3))){
var inst_4138 = (state_4140[(2)]);
var state_4140__$1 = state_4140;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4140__$1,inst_4138);
} else {
if((state_val_4141 === (2))){
var state_4140__$1 = state_4140;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4140__$1,(4),ch);
} else {
if((state_val_4141 === (9))){
var inst_4127 = (state_4140[(9)]);
var inst_4120 = inst_4127;
var state_4140__$1 = (function (){var statearr_4151 = state_4140;
(statearr_4151[(7)] = inst_4120);

return statearr_4151;
})();
var statearr_4152_4166 = state_4140__$1;
(statearr_4152_4166[(2)] = null);

(statearr_4152_4166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4141 === (5))){
var inst_4120 = (state_4140[(7)]);
var state_4140__$1 = state_4140;
var statearr_4153_4167 = state_4140__$1;
(statearr_4153_4167[(2)] = inst_4120);

(statearr_4153_4167[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4141 === (10))){
var inst_4134 = (state_4140[(2)]);
var state_4140__$1 = state_4140;
var statearr_4154_4168 = state_4140__$1;
(statearr_4154_4168[(2)] = inst_4134);

(statearr_4154_4168[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4141 === (8))){
var inst_4127 = (state_4140[(9)]);
var inst_4130 = cljs.core.deref.call(null,inst_4127);
var state_4140__$1 = state_4140;
var statearr_4155_4169 = state_4140__$1;
(statearr_4155_4169[(2)] = inst_4130);

(statearr_4155_4169[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__3667__auto__))
;
return ((function (switch__3579__auto__,c__3667__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__3580__auto__ = null;
var cljs$core$async$reduce_$_state_machine__3580__auto____0 = (function (){
var statearr_4156 = [null,null,null,null,null,null,null,null,null,null];
(statearr_4156[(0)] = cljs$core$async$reduce_$_state_machine__3580__auto__);

(statearr_4156[(1)] = (1));

return statearr_4156;
});
var cljs$core$async$reduce_$_state_machine__3580__auto____1 = (function (state_4140){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_4140);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e4157){if((e4157 instanceof Object)){
var ex__3583__auto__ = e4157;
var statearr_4158_4170 = state_4140;
(statearr_4158_4170[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4140);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4157;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4171 = state_4140;
state_4140 = G__4171;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__3580__auto__ = function(state_4140){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__3580__auto____1.call(this,state_4140);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__3580__auto____0;
cljs$core$async$reduce_$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__3580__auto____1;
return cljs$core$async$reduce_$_state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto__))
})();
var state__3669__auto__ = (function (){var statearr_4159 = f__3668__auto__.call(null);
(statearr_4159[(6)] = c__3667__auto__);

return statearr_4159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto__))
);

return c__3667__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__3667__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto__,f__$1){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto__,f__$1){
return (function (state_4177){
var state_val_4178 = (state_4177[(1)]);
if((state_val_4178 === (1))){
var inst_4172 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_4177__$1 = state_4177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4177__$1,(2),inst_4172);
} else {
if((state_val_4178 === (2))){
var inst_4174 = (state_4177[(2)]);
var inst_4175 = f__$1.call(null,inst_4174);
var state_4177__$1 = state_4177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4177__$1,inst_4175);
} else {
return null;
}
}
});})(c__3667__auto__,f__$1))
;
return ((function (switch__3579__auto__,c__3667__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__3580__auto__ = null;
var cljs$core$async$transduce_$_state_machine__3580__auto____0 = (function (){
var statearr_4179 = [null,null,null,null,null,null,null];
(statearr_4179[(0)] = cljs$core$async$transduce_$_state_machine__3580__auto__);

(statearr_4179[(1)] = (1));

return statearr_4179;
});
var cljs$core$async$transduce_$_state_machine__3580__auto____1 = (function (state_4177){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_4177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e4180){if((e4180 instanceof Object)){
var ex__3583__auto__ = e4180;
var statearr_4181_4183 = state_4177;
(statearr_4181_4183[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4177);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4180;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4184 = state_4177;
state_4177 = G__4184;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__3580__auto__ = function(state_4177){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__3580__auto____1.call(this,state_4177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__3580__auto____0;
cljs$core$async$transduce_$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__3580__auto____1;
return cljs$core$async$transduce_$_state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto__,f__$1))
})();
var state__3669__auto__ = (function (){var statearr_4182 = f__3668__auto__.call(null);
(statearr_4182[(6)] = c__3667__auto__);

return statearr_4182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto__,f__$1))
);

return c__3667__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__4186 = arguments.length;
switch (G__4186) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__3667__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto__){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto__){
return (function (state_4211){
var state_val_4212 = (state_4211[(1)]);
if((state_val_4212 === (7))){
var inst_4193 = (state_4211[(2)]);
var state_4211__$1 = state_4211;
var statearr_4213_4234 = state_4211__$1;
(statearr_4213_4234[(2)] = inst_4193);

(statearr_4213_4234[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4212 === (1))){
var inst_4187 = cljs.core.seq.call(null,coll);
var inst_4188 = inst_4187;
var state_4211__$1 = (function (){var statearr_4214 = state_4211;
(statearr_4214[(7)] = inst_4188);

return statearr_4214;
})();
var statearr_4215_4235 = state_4211__$1;
(statearr_4215_4235[(2)] = null);

(statearr_4215_4235[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4212 === (4))){
var inst_4188 = (state_4211[(7)]);
var inst_4191 = cljs.core.first.call(null,inst_4188);
var state_4211__$1 = state_4211;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4211__$1,(7),ch,inst_4191);
} else {
if((state_val_4212 === (13))){
var inst_4205 = (state_4211[(2)]);
var state_4211__$1 = state_4211;
var statearr_4216_4236 = state_4211__$1;
(statearr_4216_4236[(2)] = inst_4205);

(statearr_4216_4236[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4212 === (6))){
var inst_4196 = (state_4211[(2)]);
var state_4211__$1 = state_4211;
if(cljs.core.truth_(inst_4196)){
var statearr_4217_4237 = state_4211__$1;
(statearr_4217_4237[(1)] = (8));

} else {
var statearr_4218_4238 = state_4211__$1;
(statearr_4218_4238[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4212 === (3))){
var inst_4209 = (state_4211[(2)]);
var state_4211__$1 = state_4211;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4211__$1,inst_4209);
} else {
if((state_val_4212 === (12))){
var state_4211__$1 = state_4211;
var statearr_4219_4239 = state_4211__$1;
(statearr_4219_4239[(2)] = null);

(statearr_4219_4239[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4212 === (2))){
var inst_4188 = (state_4211[(7)]);
var state_4211__$1 = state_4211;
if(cljs.core.truth_(inst_4188)){
var statearr_4220_4240 = state_4211__$1;
(statearr_4220_4240[(1)] = (4));

} else {
var statearr_4221_4241 = state_4211__$1;
(statearr_4221_4241[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4212 === (11))){
var inst_4202 = cljs.core.async.close_BANG_.call(null,ch);
var state_4211__$1 = state_4211;
var statearr_4222_4242 = state_4211__$1;
(statearr_4222_4242[(2)] = inst_4202);

(statearr_4222_4242[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4212 === (9))){
var state_4211__$1 = state_4211;
if(cljs.core.truth_(close_QMARK_)){
var statearr_4223_4243 = state_4211__$1;
(statearr_4223_4243[(1)] = (11));

} else {
var statearr_4224_4244 = state_4211__$1;
(statearr_4224_4244[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4212 === (5))){
var inst_4188 = (state_4211[(7)]);
var state_4211__$1 = state_4211;
var statearr_4225_4245 = state_4211__$1;
(statearr_4225_4245[(2)] = inst_4188);

(statearr_4225_4245[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4212 === (10))){
var inst_4207 = (state_4211[(2)]);
var state_4211__$1 = state_4211;
var statearr_4226_4246 = state_4211__$1;
(statearr_4226_4246[(2)] = inst_4207);

(statearr_4226_4246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4212 === (8))){
var inst_4188 = (state_4211[(7)]);
var inst_4198 = cljs.core.next.call(null,inst_4188);
var inst_4188__$1 = inst_4198;
var state_4211__$1 = (function (){var statearr_4227 = state_4211;
(statearr_4227[(7)] = inst_4188__$1);

return statearr_4227;
})();
var statearr_4228_4247 = state_4211__$1;
(statearr_4228_4247[(2)] = null);

(statearr_4228_4247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3667__auto__))
;
return ((function (switch__3579__auto__,c__3667__auto__){
return (function() {
var cljs$core$async$state_machine__3580__auto__ = null;
var cljs$core$async$state_machine__3580__auto____0 = (function (){
var statearr_4229 = [null,null,null,null,null,null,null,null];
(statearr_4229[(0)] = cljs$core$async$state_machine__3580__auto__);

(statearr_4229[(1)] = (1));

return statearr_4229;
});
var cljs$core$async$state_machine__3580__auto____1 = (function (state_4211){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_4211);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e4230){if((e4230 instanceof Object)){
var ex__3583__auto__ = e4230;
var statearr_4231_4248 = state_4211;
(statearr_4231_4248[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4211);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4230;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4249 = state_4211;
state_4211 = G__4249;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$state_machine__3580__auto__ = function(state_4211){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3580__auto____1.call(this,state_4211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3580__auto____0;
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3580__auto____1;
return cljs$core$async$state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto__))
})();
var state__3669__auto__ = (function (){var statearr_4232 = f__3668__auto__.call(null);
(statearr_4232[(6)] = c__3667__auto__);

return statearr_4232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto__))
);

return c__3667__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if(((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4229__auto__ = (((_ == null))?null:_);
var m__4230__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,_);
} else {
var m__4230__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4229__auto__ = (((m == null))?null:m);
var m__4230__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4230__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4229__auto__ = (((m == null))?null:m);
var m__4230__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,m,ch);
} else {
var m__4230__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4229__auto__ = (((m == null))?null:m);
var m__4230__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,m);
} else {
var m__4230__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async4250 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4250 = (function (ch,cs,meta4251){
this.ch = ch;
this.cs = cs;
this.meta4251 = meta4251;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async4250.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_4252,meta4251__$1){
var self__ = this;
var _4252__$1 = this;
return (new cljs.core.async.t_cljs$core$async4250(self__.ch,self__.cs,meta4251__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async4250.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_4252){
var self__ = this;
var _4252__$1 = this;
return self__.meta4251;
});})(cs))
;

cljs.core.async.t_cljs$core$async4250.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4250.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async4250.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4250.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async4250.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async4250.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async4250.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta4251","meta4251",1689178266,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async4250.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async4250.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4250";

cljs.core.async.t_cljs$core$async4250.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write.call(null,writer__4180__auto__,"cljs.core.async/t_cljs$core$async4250");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4250.
 */
cljs.core.async.__GT_t_cljs$core$async4250 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async4250(ch__$1,cs__$1,meta4251){
return (new cljs.core.async.t_cljs$core$async4250(ch__$1,cs__$1,meta4251));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async4250(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__3667__auto___4472 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto___4472,cs,m,dchan,dctr,done){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto___4472,cs,m,dchan,dctr,done){
return (function (state_4387){
var state_val_4388 = (state_4387[(1)]);
if((state_val_4388 === (7))){
var inst_4383 = (state_4387[(2)]);
var state_4387__$1 = state_4387;
var statearr_4389_4473 = state_4387__$1;
(statearr_4389_4473[(2)] = inst_4383);

(statearr_4389_4473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (20))){
var inst_4286 = (state_4387[(7)]);
var inst_4298 = cljs.core.first.call(null,inst_4286);
var inst_4299 = cljs.core.nth.call(null,inst_4298,(0),null);
var inst_4300 = cljs.core.nth.call(null,inst_4298,(1),null);
var state_4387__$1 = (function (){var statearr_4390 = state_4387;
(statearr_4390[(8)] = inst_4299);

return statearr_4390;
})();
if(cljs.core.truth_(inst_4300)){
var statearr_4391_4474 = state_4387__$1;
(statearr_4391_4474[(1)] = (22));

} else {
var statearr_4392_4475 = state_4387__$1;
(statearr_4392_4475[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (27))){
var inst_4328 = (state_4387[(9)]);
var inst_4335 = (state_4387[(10)]);
var inst_4330 = (state_4387[(11)]);
var inst_4255 = (state_4387[(12)]);
var inst_4335__$1 = cljs.core._nth.call(null,inst_4328,inst_4330);
var inst_4336 = cljs.core.async.put_BANG_.call(null,inst_4335__$1,inst_4255,done);
var state_4387__$1 = (function (){var statearr_4393 = state_4387;
(statearr_4393[(10)] = inst_4335__$1);

return statearr_4393;
})();
if(cljs.core.truth_(inst_4336)){
var statearr_4394_4476 = state_4387__$1;
(statearr_4394_4476[(1)] = (30));

} else {
var statearr_4395_4477 = state_4387__$1;
(statearr_4395_4477[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (1))){
var state_4387__$1 = state_4387;
var statearr_4396_4478 = state_4387__$1;
(statearr_4396_4478[(2)] = null);

(statearr_4396_4478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (24))){
var inst_4286 = (state_4387[(7)]);
var inst_4305 = (state_4387[(2)]);
var inst_4306 = cljs.core.next.call(null,inst_4286);
var inst_4264 = inst_4306;
var inst_4265 = null;
var inst_4266 = (0);
var inst_4267 = (0);
var state_4387__$1 = (function (){var statearr_4397 = state_4387;
(statearr_4397[(13)] = inst_4264);

(statearr_4397[(14)] = inst_4305);

(statearr_4397[(15)] = inst_4267);

(statearr_4397[(16)] = inst_4265);

(statearr_4397[(17)] = inst_4266);

return statearr_4397;
})();
var statearr_4398_4479 = state_4387__$1;
(statearr_4398_4479[(2)] = null);

(statearr_4398_4479[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (39))){
var state_4387__$1 = state_4387;
var statearr_4402_4480 = state_4387__$1;
(statearr_4402_4480[(2)] = null);

(statearr_4402_4480[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (4))){
var inst_4255 = (state_4387[(12)]);
var inst_4255__$1 = (state_4387[(2)]);
var inst_4256 = (inst_4255__$1 == null);
var state_4387__$1 = (function (){var statearr_4403 = state_4387;
(statearr_4403[(12)] = inst_4255__$1);

return statearr_4403;
})();
if(cljs.core.truth_(inst_4256)){
var statearr_4404_4481 = state_4387__$1;
(statearr_4404_4481[(1)] = (5));

} else {
var statearr_4405_4482 = state_4387__$1;
(statearr_4405_4482[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (15))){
var inst_4264 = (state_4387[(13)]);
var inst_4267 = (state_4387[(15)]);
var inst_4265 = (state_4387[(16)]);
var inst_4266 = (state_4387[(17)]);
var inst_4282 = (state_4387[(2)]);
var inst_4283 = (inst_4267 + (1));
var tmp4399 = inst_4264;
var tmp4400 = inst_4265;
var tmp4401 = inst_4266;
var inst_4264__$1 = tmp4399;
var inst_4265__$1 = tmp4400;
var inst_4266__$1 = tmp4401;
var inst_4267__$1 = inst_4283;
var state_4387__$1 = (function (){var statearr_4406 = state_4387;
(statearr_4406[(13)] = inst_4264__$1);

(statearr_4406[(15)] = inst_4267__$1);

(statearr_4406[(16)] = inst_4265__$1);

(statearr_4406[(17)] = inst_4266__$1);

(statearr_4406[(18)] = inst_4282);

return statearr_4406;
})();
var statearr_4407_4483 = state_4387__$1;
(statearr_4407_4483[(2)] = null);

(statearr_4407_4483[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (21))){
var inst_4309 = (state_4387[(2)]);
var state_4387__$1 = state_4387;
var statearr_4411_4484 = state_4387__$1;
(statearr_4411_4484[(2)] = inst_4309);

(statearr_4411_4484[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (31))){
var inst_4335 = (state_4387[(10)]);
var inst_4339 = done.call(null,null);
var inst_4340 = cljs.core.async.untap_STAR_.call(null,m,inst_4335);
var state_4387__$1 = (function (){var statearr_4412 = state_4387;
(statearr_4412[(19)] = inst_4339);

return statearr_4412;
})();
var statearr_4413_4485 = state_4387__$1;
(statearr_4413_4485[(2)] = inst_4340);

(statearr_4413_4485[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (32))){
var inst_4328 = (state_4387[(9)]);
var inst_4329 = (state_4387[(20)]);
var inst_4327 = (state_4387[(21)]);
var inst_4330 = (state_4387[(11)]);
var inst_4342 = (state_4387[(2)]);
var inst_4343 = (inst_4330 + (1));
var tmp4408 = inst_4328;
var tmp4409 = inst_4329;
var tmp4410 = inst_4327;
var inst_4327__$1 = tmp4410;
var inst_4328__$1 = tmp4408;
var inst_4329__$1 = tmp4409;
var inst_4330__$1 = inst_4343;
var state_4387__$1 = (function (){var statearr_4414 = state_4387;
(statearr_4414[(9)] = inst_4328__$1);

(statearr_4414[(20)] = inst_4329__$1);

(statearr_4414[(22)] = inst_4342);

(statearr_4414[(21)] = inst_4327__$1);

(statearr_4414[(11)] = inst_4330__$1);

return statearr_4414;
})();
var statearr_4415_4486 = state_4387__$1;
(statearr_4415_4486[(2)] = null);

(statearr_4415_4486[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (40))){
var inst_4355 = (state_4387[(23)]);
var inst_4359 = done.call(null,null);
var inst_4360 = cljs.core.async.untap_STAR_.call(null,m,inst_4355);
var state_4387__$1 = (function (){var statearr_4416 = state_4387;
(statearr_4416[(24)] = inst_4359);

return statearr_4416;
})();
var statearr_4417_4487 = state_4387__$1;
(statearr_4417_4487[(2)] = inst_4360);

(statearr_4417_4487[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (33))){
var inst_4346 = (state_4387[(25)]);
var inst_4348 = cljs.core.chunked_seq_QMARK_.call(null,inst_4346);
var state_4387__$1 = state_4387;
if(inst_4348){
var statearr_4418_4488 = state_4387__$1;
(statearr_4418_4488[(1)] = (36));

} else {
var statearr_4419_4489 = state_4387__$1;
(statearr_4419_4489[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (13))){
var inst_4276 = (state_4387[(26)]);
var inst_4279 = cljs.core.async.close_BANG_.call(null,inst_4276);
var state_4387__$1 = state_4387;
var statearr_4420_4490 = state_4387__$1;
(statearr_4420_4490[(2)] = inst_4279);

(statearr_4420_4490[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (22))){
var inst_4299 = (state_4387[(8)]);
var inst_4302 = cljs.core.async.close_BANG_.call(null,inst_4299);
var state_4387__$1 = state_4387;
var statearr_4421_4491 = state_4387__$1;
(statearr_4421_4491[(2)] = inst_4302);

(statearr_4421_4491[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (36))){
var inst_4346 = (state_4387[(25)]);
var inst_4350 = cljs.core.chunk_first.call(null,inst_4346);
var inst_4351 = cljs.core.chunk_rest.call(null,inst_4346);
var inst_4352 = cljs.core.count.call(null,inst_4350);
var inst_4327 = inst_4351;
var inst_4328 = inst_4350;
var inst_4329 = inst_4352;
var inst_4330 = (0);
var state_4387__$1 = (function (){var statearr_4422 = state_4387;
(statearr_4422[(9)] = inst_4328);

(statearr_4422[(20)] = inst_4329);

(statearr_4422[(21)] = inst_4327);

(statearr_4422[(11)] = inst_4330);

return statearr_4422;
})();
var statearr_4423_4492 = state_4387__$1;
(statearr_4423_4492[(2)] = null);

(statearr_4423_4492[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (41))){
var inst_4346 = (state_4387[(25)]);
var inst_4362 = (state_4387[(2)]);
var inst_4363 = cljs.core.next.call(null,inst_4346);
var inst_4327 = inst_4363;
var inst_4328 = null;
var inst_4329 = (0);
var inst_4330 = (0);
var state_4387__$1 = (function (){var statearr_4424 = state_4387;
(statearr_4424[(27)] = inst_4362);

(statearr_4424[(9)] = inst_4328);

(statearr_4424[(20)] = inst_4329);

(statearr_4424[(21)] = inst_4327);

(statearr_4424[(11)] = inst_4330);

return statearr_4424;
})();
var statearr_4425_4493 = state_4387__$1;
(statearr_4425_4493[(2)] = null);

(statearr_4425_4493[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (43))){
var state_4387__$1 = state_4387;
var statearr_4426_4494 = state_4387__$1;
(statearr_4426_4494[(2)] = null);

(statearr_4426_4494[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (29))){
var inst_4371 = (state_4387[(2)]);
var state_4387__$1 = state_4387;
var statearr_4427_4495 = state_4387__$1;
(statearr_4427_4495[(2)] = inst_4371);

(statearr_4427_4495[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (44))){
var inst_4380 = (state_4387[(2)]);
var state_4387__$1 = (function (){var statearr_4428 = state_4387;
(statearr_4428[(28)] = inst_4380);

return statearr_4428;
})();
var statearr_4429_4496 = state_4387__$1;
(statearr_4429_4496[(2)] = null);

(statearr_4429_4496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (6))){
var inst_4319 = (state_4387[(29)]);
var inst_4318 = cljs.core.deref.call(null,cs);
var inst_4319__$1 = cljs.core.keys.call(null,inst_4318);
var inst_4320 = cljs.core.count.call(null,inst_4319__$1);
var inst_4321 = cljs.core.reset_BANG_.call(null,dctr,inst_4320);
var inst_4326 = cljs.core.seq.call(null,inst_4319__$1);
var inst_4327 = inst_4326;
var inst_4328 = null;
var inst_4329 = (0);
var inst_4330 = (0);
var state_4387__$1 = (function (){var statearr_4430 = state_4387;
(statearr_4430[(9)] = inst_4328);

(statearr_4430[(29)] = inst_4319__$1);

(statearr_4430[(30)] = inst_4321);

(statearr_4430[(20)] = inst_4329);

(statearr_4430[(21)] = inst_4327);

(statearr_4430[(11)] = inst_4330);

return statearr_4430;
})();
var statearr_4431_4497 = state_4387__$1;
(statearr_4431_4497[(2)] = null);

(statearr_4431_4497[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (28))){
var inst_4346 = (state_4387[(25)]);
var inst_4327 = (state_4387[(21)]);
var inst_4346__$1 = cljs.core.seq.call(null,inst_4327);
var state_4387__$1 = (function (){var statearr_4432 = state_4387;
(statearr_4432[(25)] = inst_4346__$1);

return statearr_4432;
})();
if(inst_4346__$1){
var statearr_4433_4498 = state_4387__$1;
(statearr_4433_4498[(1)] = (33));

} else {
var statearr_4434_4499 = state_4387__$1;
(statearr_4434_4499[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (25))){
var inst_4329 = (state_4387[(20)]);
var inst_4330 = (state_4387[(11)]);
var inst_4332 = (inst_4330 < inst_4329);
var inst_4333 = inst_4332;
var state_4387__$1 = state_4387;
if(cljs.core.truth_(inst_4333)){
var statearr_4435_4500 = state_4387__$1;
(statearr_4435_4500[(1)] = (27));

} else {
var statearr_4436_4501 = state_4387__$1;
(statearr_4436_4501[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (34))){
var state_4387__$1 = state_4387;
var statearr_4437_4502 = state_4387__$1;
(statearr_4437_4502[(2)] = null);

(statearr_4437_4502[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (17))){
var state_4387__$1 = state_4387;
var statearr_4438_4503 = state_4387__$1;
(statearr_4438_4503[(2)] = null);

(statearr_4438_4503[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (3))){
var inst_4385 = (state_4387[(2)]);
var state_4387__$1 = state_4387;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4387__$1,inst_4385);
} else {
if((state_val_4388 === (12))){
var inst_4314 = (state_4387[(2)]);
var state_4387__$1 = state_4387;
var statearr_4439_4504 = state_4387__$1;
(statearr_4439_4504[(2)] = inst_4314);

(statearr_4439_4504[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (2))){
var state_4387__$1 = state_4387;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4387__$1,(4),ch);
} else {
if((state_val_4388 === (23))){
var state_4387__$1 = state_4387;
var statearr_4440_4505 = state_4387__$1;
(statearr_4440_4505[(2)] = null);

(statearr_4440_4505[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (35))){
var inst_4369 = (state_4387[(2)]);
var state_4387__$1 = state_4387;
var statearr_4441_4506 = state_4387__$1;
(statearr_4441_4506[(2)] = inst_4369);

(statearr_4441_4506[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (19))){
var inst_4286 = (state_4387[(7)]);
var inst_4290 = cljs.core.chunk_first.call(null,inst_4286);
var inst_4291 = cljs.core.chunk_rest.call(null,inst_4286);
var inst_4292 = cljs.core.count.call(null,inst_4290);
var inst_4264 = inst_4291;
var inst_4265 = inst_4290;
var inst_4266 = inst_4292;
var inst_4267 = (0);
var state_4387__$1 = (function (){var statearr_4442 = state_4387;
(statearr_4442[(13)] = inst_4264);

(statearr_4442[(15)] = inst_4267);

(statearr_4442[(16)] = inst_4265);

(statearr_4442[(17)] = inst_4266);

return statearr_4442;
})();
var statearr_4443_4507 = state_4387__$1;
(statearr_4443_4507[(2)] = null);

(statearr_4443_4507[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (11))){
var inst_4264 = (state_4387[(13)]);
var inst_4286 = (state_4387[(7)]);
var inst_4286__$1 = cljs.core.seq.call(null,inst_4264);
var state_4387__$1 = (function (){var statearr_4444 = state_4387;
(statearr_4444[(7)] = inst_4286__$1);

return statearr_4444;
})();
if(inst_4286__$1){
var statearr_4445_4508 = state_4387__$1;
(statearr_4445_4508[(1)] = (16));

} else {
var statearr_4446_4509 = state_4387__$1;
(statearr_4446_4509[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (9))){
var inst_4316 = (state_4387[(2)]);
var state_4387__$1 = state_4387;
var statearr_4447_4510 = state_4387__$1;
(statearr_4447_4510[(2)] = inst_4316);

(statearr_4447_4510[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (5))){
var inst_4262 = cljs.core.deref.call(null,cs);
var inst_4263 = cljs.core.seq.call(null,inst_4262);
var inst_4264 = inst_4263;
var inst_4265 = null;
var inst_4266 = (0);
var inst_4267 = (0);
var state_4387__$1 = (function (){var statearr_4448 = state_4387;
(statearr_4448[(13)] = inst_4264);

(statearr_4448[(15)] = inst_4267);

(statearr_4448[(16)] = inst_4265);

(statearr_4448[(17)] = inst_4266);

return statearr_4448;
})();
var statearr_4449_4511 = state_4387__$1;
(statearr_4449_4511[(2)] = null);

(statearr_4449_4511[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (14))){
var state_4387__$1 = state_4387;
var statearr_4450_4512 = state_4387__$1;
(statearr_4450_4512[(2)] = null);

(statearr_4450_4512[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (45))){
var inst_4377 = (state_4387[(2)]);
var state_4387__$1 = state_4387;
var statearr_4451_4513 = state_4387__$1;
(statearr_4451_4513[(2)] = inst_4377);

(statearr_4451_4513[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (26))){
var inst_4319 = (state_4387[(29)]);
var inst_4373 = (state_4387[(2)]);
var inst_4374 = cljs.core.seq.call(null,inst_4319);
var state_4387__$1 = (function (){var statearr_4452 = state_4387;
(statearr_4452[(31)] = inst_4373);

return statearr_4452;
})();
if(inst_4374){
var statearr_4453_4514 = state_4387__$1;
(statearr_4453_4514[(1)] = (42));

} else {
var statearr_4454_4515 = state_4387__$1;
(statearr_4454_4515[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (16))){
var inst_4286 = (state_4387[(7)]);
var inst_4288 = cljs.core.chunked_seq_QMARK_.call(null,inst_4286);
var state_4387__$1 = state_4387;
if(inst_4288){
var statearr_4455_4516 = state_4387__$1;
(statearr_4455_4516[(1)] = (19));

} else {
var statearr_4456_4517 = state_4387__$1;
(statearr_4456_4517[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (38))){
var inst_4366 = (state_4387[(2)]);
var state_4387__$1 = state_4387;
var statearr_4457_4518 = state_4387__$1;
(statearr_4457_4518[(2)] = inst_4366);

(statearr_4457_4518[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (30))){
var state_4387__$1 = state_4387;
var statearr_4458_4519 = state_4387__$1;
(statearr_4458_4519[(2)] = null);

(statearr_4458_4519[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (10))){
var inst_4267 = (state_4387[(15)]);
var inst_4265 = (state_4387[(16)]);
var inst_4275 = cljs.core._nth.call(null,inst_4265,inst_4267);
var inst_4276 = cljs.core.nth.call(null,inst_4275,(0),null);
var inst_4277 = cljs.core.nth.call(null,inst_4275,(1),null);
var state_4387__$1 = (function (){var statearr_4459 = state_4387;
(statearr_4459[(26)] = inst_4276);

return statearr_4459;
})();
if(cljs.core.truth_(inst_4277)){
var statearr_4460_4520 = state_4387__$1;
(statearr_4460_4520[(1)] = (13));

} else {
var statearr_4461_4521 = state_4387__$1;
(statearr_4461_4521[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (18))){
var inst_4312 = (state_4387[(2)]);
var state_4387__$1 = state_4387;
var statearr_4462_4522 = state_4387__$1;
(statearr_4462_4522[(2)] = inst_4312);

(statearr_4462_4522[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (42))){
var state_4387__$1 = state_4387;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4387__$1,(45),dchan);
} else {
if((state_val_4388 === (37))){
var inst_4346 = (state_4387[(25)]);
var inst_4255 = (state_4387[(12)]);
var inst_4355 = (state_4387[(23)]);
var inst_4355__$1 = cljs.core.first.call(null,inst_4346);
var inst_4356 = cljs.core.async.put_BANG_.call(null,inst_4355__$1,inst_4255,done);
var state_4387__$1 = (function (){var statearr_4463 = state_4387;
(statearr_4463[(23)] = inst_4355__$1);

return statearr_4463;
})();
if(cljs.core.truth_(inst_4356)){
var statearr_4464_4523 = state_4387__$1;
(statearr_4464_4523[(1)] = (39));

} else {
var statearr_4465_4524 = state_4387__$1;
(statearr_4465_4524[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4388 === (8))){
var inst_4267 = (state_4387[(15)]);
var inst_4266 = (state_4387[(17)]);
var inst_4269 = (inst_4267 < inst_4266);
var inst_4270 = inst_4269;
var state_4387__$1 = state_4387;
if(cljs.core.truth_(inst_4270)){
var statearr_4466_4525 = state_4387__$1;
(statearr_4466_4525[(1)] = (10));

} else {
var statearr_4467_4526 = state_4387__$1;
(statearr_4467_4526[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3667__auto___4472,cs,m,dchan,dctr,done))
;
return ((function (switch__3579__auto__,c__3667__auto___4472,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__3580__auto__ = null;
var cljs$core$async$mult_$_state_machine__3580__auto____0 = (function (){
var statearr_4468 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4468[(0)] = cljs$core$async$mult_$_state_machine__3580__auto__);

(statearr_4468[(1)] = (1));

return statearr_4468;
});
var cljs$core$async$mult_$_state_machine__3580__auto____1 = (function (state_4387){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_4387);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e4469){if((e4469 instanceof Object)){
var ex__3583__auto__ = e4469;
var statearr_4470_4527 = state_4387;
(statearr_4470_4527[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4387);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4469;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4528 = state_4387;
state_4387 = G__4528;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__3580__auto__ = function(state_4387){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__3580__auto____1.call(this,state_4387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__3580__auto____0;
cljs$core$async$mult_$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__3580__auto____1;
return cljs$core$async$mult_$_state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto___4472,cs,m,dchan,dctr,done))
})();
var state__3669__auto__ = (function (){var statearr_4471 = f__3668__auto__.call(null);
(statearr_4471[(6)] = c__3667__auto___4472);

return statearr_4471;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto___4472,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__4530 = arguments.length;
switch (G__4530) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4229__auto__ = (((m == null))?null:m);
var m__4230__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,m,ch);
} else {
var m__4230__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4229__auto__ = (((m == null))?null:m);
var m__4230__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,m,ch);
} else {
var m__4230__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4229__auto__ = (((m == null))?null:m);
var m__4230__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,m);
} else {
var m__4230__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4229__auto__ = (((m == null))?null:m);
var m__4230__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,m,state_map);
} else {
var m__4230__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4229__auto__ = (((m == null))?null:m);
var m__4230__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,m,mode);
} else {
var m__4230__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4520__auto__ = [];
var len__4517__auto___4542 = arguments.length;
var i__4518__auto___4543 = (0);
while(true){
if((i__4518__auto___4543 < len__4517__auto___4542)){
args__4520__auto__.push((arguments[i__4518__auto___4543]));

var G__4544 = (i__4518__auto___4543 + (1));
i__4518__auto___4543 = G__4544;
continue;
} else {
}
break;
}

var argseq__4521__auto__ = ((((3) < args__4520__auto__.length))?(new cljs.core.IndexedSeq(args__4520__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4521__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__4536){
var map__4537 = p__4536;
var map__4537__$1 = ((((!((map__4537 == null)))?(((((map__4537.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4537.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4537):map__4537);
var opts = map__4537__$1;
var statearr_4539_4545 = state;
(statearr_4539_4545[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__4537,map__4537__$1,opts){
return (function (val){
var statearr_4540_4546 = state;
(statearr_4540_4546[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__4537,map__4537__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_4541_4547 = state;
(statearr_4541_4547[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq4532){
var G__4533 = cljs.core.first.call(null,seq4532);
var seq4532__$1 = cljs.core.next.call(null,seq4532);
var G__4534 = cljs.core.first.call(null,seq4532__$1);
var seq4532__$2 = cljs.core.next.call(null,seq4532__$1);
var G__4535 = cljs.core.first.call(null,seq4532__$2);
var seq4532__$3 = cljs.core.next.call(null,seq4532__$2);
var self__4504__auto__ = this;
return self__4504__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4533,G__4534,G__4535,seq4532__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos)))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async4548 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4548 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta4549){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta4549 = meta4549;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async4548.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_4550,meta4549__$1){
var self__ = this;
var _4550__$1 = this;
return (new cljs.core.async.t_cljs$core$async4548(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta4549__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async4548.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_4550){
var self__ = this;
var _4550__$1 = this;
return self__.meta4549;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async4548.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4548.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async4548.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4548.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async4548.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async4548.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async4548.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async4548.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async4548.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta4549","meta4549",-233105207,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async4548.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async4548.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4548";

cljs.core.async.t_cljs$core$async4548.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write.call(null,writer__4180__auto__,"cljs.core.async/t_cljs$core$async4548");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4548.
 */
cljs.core.async.__GT_t_cljs$core$async4548 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async4548(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta4549){
return (new cljs.core.async.t_cljs$core$async4548(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta4549));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async4548(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__3667__auto___4712 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto___4712,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto___4712,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_4652){
var state_val_4653 = (state_4652[(1)]);
if((state_val_4653 === (7))){
var inst_4567 = (state_4652[(2)]);
var state_4652__$1 = state_4652;
var statearr_4654_4713 = state_4652__$1;
(statearr_4654_4713[(2)] = inst_4567);

(statearr_4654_4713[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (20))){
var inst_4579 = (state_4652[(7)]);
var state_4652__$1 = state_4652;
var statearr_4655_4714 = state_4652__$1;
(statearr_4655_4714[(2)] = inst_4579);

(statearr_4655_4714[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (27))){
var state_4652__$1 = state_4652;
var statearr_4656_4715 = state_4652__$1;
(statearr_4656_4715[(2)] = null);

(statearr_4656_4715[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (1))){
var inst_4554 = (state_4652[(8)]);
var inst_4554__$1 = calc_state.call(null);
var inst_4556 = (inst_4554__$1 == null);
var inst_4557 = cljs.core.not.call(null,inst_4556);
var state_4652__$1 = (function (){var statearr_4657 = state_4652;
(statearr_4657[(8)] = inst_4554__$1);

return statearr_4657;
})();
if(inst_4557){
var statearr_4658_4716 = state_4652__$1;
(statearr_4658_4716[(1)] = (2));

} else {
var statearr_4659_4717 = state_4652__$1;
(statearr_4659_4717[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (24))){
var inst_4612 = (state_4652[(9)]);
var inst_4626 = (state_4652[(10)]);
var inst_4603 = (state_4652[(11)]);
var inst_4626__$1 = inst_4603.call(null,inst_4612);
var state_4652__$1 = (function (){var statearr_4660 = state_4652;
(statearr_4660[(10)] = inst_4626__$1);

return statearr_4660;
})();
if(cljs.core.truth_(inst_4626__$1)){
var statearr_4661_4718 = state_4652__$1;
(statearr_4661_4718[(1)] = (29));

} else {
var statearr_4662_4719 = state_4652__$1;
(statearr_4662_4719[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (4))){
var inst_4570 = (state_4652[(2)]);
var state_4652__$1 = state_4652;
if(cljs.core.truth_(inst_4570)){
var statearr_4663_4720 = state_4652__$1;
(statearr_4663_4720[(1)] = (8));

} else {
var statearr_4664_4721 = state_4652__$1;
(statearr_4664_4721[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (15))){
var inst_4597 = (state_4652[(2)]);
var state_4652__$1 = state_4652;
if(cljs.core.truth_(inst_4597)){
var statearr_4665_4722 = state_4652__$1;
(statearr_4665_4722[(1)] = (19));

} else {
var statearr_4666_4723 = state_4652__$1;
(statearr_4666_4723[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (21))){
var inst_4602 = (state_4652[(12)]);
var inst_4602__$1 = (state_4652[(2)]);
var inst_4603 = cljs.core.get.call(null,inst_4602__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_4604 = cljs.core.get.call(null,inst_4602__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_4605 = cljs.core.get.call(null,inst_4602__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_4652__$1 = (function (){var statearr_4667 = state_4652;
(statearr_4667[(12)] = inst_4602__$1);

(statearr_4667[(13)] = inst_4604);

(statearr_4667[(11)] = inst_4603);

return statearr_4667;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_4652__$1,(22),inst_4605);
} else {
if((state_val_4653 === (31))){
var inst_4634 = (state_4652[(2)]);
var state_4652__$1 = state_4652;
if(cljs.core.truth_(inst_4634)){
var statearr_4668_4724 = state_4652__$1;
(statearr_4668_4724[(1)] = (32));

} else {
var statearr_4669_4725 = state_4652__$1;
(statearr_4669_4725[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (32))){
var inst_4611 = (state_4652[(14)]);
var state_4652__$1 = state_4652;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4652__$1,(35),out,inst_4611);
} else {
if((state_val_4653 === (33))){
var inst_4602 = (state_4652[(12)]);
var inst_4579 = inst_4602;
var state_4652__$1 = (function (){var statearr_4670 = state_4652;
(statearr_4670[(7)] = inst_4579);

return statearr_4670;
})();
var statearr_4671_4726 = state_4652__$1;
(statearr_4671_4726[(2)] = null);

(statearr_4671_4726[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (13))){
var inst_4579 = (state_4652[(7)]);
var inst_4586 = inst_4579.cljs$lang$protocol_mask$partition0$;
var inst_4587 = (inst_4586 & (64));
var inst_4588 = inst_4579.cljs$core$ISeq$;
var inst_4589 = (cljs.core.PROTOCOL_SENTINEL === inst_4588);
var inst_4590 = ((inst_4587) || (inst_4589));
var state_4652__$1 = state_4652;
if(cljs.core.truth_(inst_4590)){
var statearr_4672_4727 = state_4652__$1;
(statearr_4672_4727[(1)] = (16));

} else {
var statearr_4673_4728 = state_4652__$1;
(statearr_4673_4728[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (22))){
var inst_4611 = (state_4652[(14)]);
var inst_4612 = (state_4652[(9)]);
var inst_4610 = (state_4652[(2)]);
var inst_4611__$1 = cljs.core.nth.call(null,inst_4610,(0),null);
var inst_4612__$1 = cljs.core.nth.call(null,inst_4610,(1),null);
var inst_4613 = (inst_4611__$1 == null);
var inst_4614 = cljs.core._EQ_.call(null,inst_4612__$1,change);
var inst_4615 = ((inst_4613) || (inst_4614));
var state_4652__$1 = (function (){var statearr_4674 = state_4652;
(statearr_4674[(14)] = inst_4611__$1);

(statearr_4674[(9)] = inst_4612__$1);

return statearr_4674;
})();
if(cljs.core.truth_(inst_4615)){
var statearr_4675_4729 = state_4652__$1;
(statearr_4675_4729[(1)] = (23));

} else {
var statearr_4676_4730 = state_4652__$1;
(statearr_4676_4730[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (36))){
var inst_4602 = (state_4652[(12)]);
var inst_4579 = inst_4602;
var state_4652__$1 = (function (){var statearr_4677 = state_4652;
(statearr_4677[(7)] = inst_4579);

return statearr_4677;
})();
var statearr_4678_4731 = state_4652__$1;
(statearr_4678_4731[(2)] = null);

(statearr_4678_4731[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (29))){
var inst_4626 = (state_4652[(10)]);
var state_4652__$1 = state_4652;
var statearr_4679_4732 = state_4652__$1;
(statearr_4679_4732[(2)] = inst_4626);

(statearr_4679_4732[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (6))){
var state_4652__$1 = state_4652;
var statearr_4680_4733 = state_4652__$1;
(statearr_4680_4733[(2)] = false);

(statearr_4680_4733[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (28))){
var inst_4622 = (state_4652[(2)]);
var inst_4623 = calc_state.call(null);
var inst_4579 = inst_4623;
var state_4652__$1 = (function (){var statearr_4681 = state_4652;
(statearr_4681[(15)] = inst_4622);

(statearr_4681[(7)] = inst_4579);

return statearr_4681;
})();
var statearr_4682_4734 = state_4652__$1;
(statearr_4682_4734[(2)] = null);

(statearr_4682_4734[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (25))){
var inst_4648 = (state_4652[(2)]);
var state_4652__$1 = state_4652;
var statearr_4683_4735 = state_4652__$1;
(statearr_4683_4735[(2)] = inst_4648);

(statearr_4683_4735[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (34))){
var inst_4646 = (state_4652[(2)]);
var state_4652__$1 = state_4652;
var statearr_4684_4736 = state_4652__$1;
(statearr_4684_4736[(2)] = inst_4646);

(statearr_4684_4736[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (17))){
var state_4652__$1 = state_4652;
var statearr_4685_4737 = state_4652__$1;
(statearr_4685_4737[(2)] = false);

(statearr_4685_4737[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (3))){
var state_4652__$1 = state_4652;
var statearr_4686_4738 = state_4652__$1;
(statearr_4686_4738[(2)] = false);

(statearr_4686_4738[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (12))){
var inst_4650 = (state_4652[(2)]);
var state_4652__$1 = state_4652;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4652__$1,inst_4650);
} else {
if((state_val_4653 === (2))){
var inst_4554 = (state_4652[(8)]);
var inst_4559 = inst_4554.cljs$lang$protocol_mask$partition0$;
var inst_4560 = (inst_4559 & (64));
var inst_4561 = inst_4554.cljs$core$ISeq$;
var inst_4562 = (cljs.core.PROTOCOL_SENTINEL === inst_4561);
var inst_4563 = ((inst_4560) || (inst_4562));
var state_4652__$1 = state_4652;
if(cljs.core.truth_(inst_4563)){
var statearr_4687_4739 = state_4652__$1;
(statearr_4687_4739[(1)] = (5));

} else {
var statearr_4688_4740 = state_4652__$1;
(statearr_4688_4740[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (23))){
var inst_4611 = (state_4652[(14)]);
var inst_4617 = (inst_4611 == null);
var state_4652__$1 = state_4652;
if(cljs.core.truth_(inst_4617)){
var statearr_4689_4741 = state_4652__$1;
(statearr_4689_4741[(1)] = (26));

} else {
var statearr_4690_4742 = state_4652__$1;
(statearr_4690_4742[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (35))){
var inst_4637 = (state_4652[(2)]);
var state_4652__$1 = state_4652;
if(cljs.core.truth_(inst_4637)){
var statearr_4691_4743 = state_4652__$1;
(statearr_4691_4743[(1)] = (36));

} else {
var statearr_4692_4744 = state_4652__$1;
(statearr_4692_4744[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (19))){
var inst_4579 = (state_4652[(7)]);
var inst_4599 = cljs.core.apply.call(null,cljs.core.hash_map,inst_4579);
var state_4652__$1 = state_4652;
var statearr_4693_4745 = state_4652__$1;
(statearr_4693_4745[(2)] = inst_4599);

(statearr_4693_4745[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (11))){
var inst_4579 = (state_4652[(7)]);
var inst_4583 = (inst_4579 == null);
var inst_4584 = cljs.core.not.call(null,inst_4583);
var state_4652__$1 = state_4652;
if(inst_4584){
var statearr_4694_4746 = state_4652__$1;
(statearr_4694_4746[(1)] = (13));

} else {
var statearr_4695_4747 = state_4652__$1;
(statearr_4695_4747[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (9))){
var inst_4554 = (state_4652[(8)]);
var state_4652__$1 = state_4652;
var statearr_4696_4748 = state_4652__$1;
(statearr_4696_4748[(2)] = inst_4554);

(statearr_4696_4748[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (5))){
var state_4652__$1 = state_4652;
var statearr_4697_4749 = state_4652__$1;
(statearr_4697_4749[(2)] = true);

(statearr_4697_4749[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (14))){
var state_4652__$1 = state_4652;
var statearr_4698_4750 = state_4652__$1;
(statearr_4698_4750[(2)] = false);

(statearr_4698_4750[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (26))){
var inst_4612 = (state_4652[(9)]);
var inst_4619 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_4612);
var state_4652__$1 = state_4652;
var statearr_4699_4751 = state_4652__$1;
(statearr_4699_4751[(2)] = inst_4619);

(statearr_4699_4751[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (16))){
var state_4652__$1 = state_4652;
var statearr_4700_4752 = state_4652__$1;
(statearr_4700_4752[(2)] = true);

(statearr_4700_4752[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (38))){
var inst_4642 = (state_4652[(2)]);
var state_4652__$1 = state_4652;
var statearr_4701_4753 = state_4652__$1;
(statearr_4701_4753[(2)] = inst_4642);

(statearr_4701_4753[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (30))){
var inst_4604 = (state_4652[(13)]);
var inst_4612 = (state_4652[(9)]);
var inst_4603 = (state_4652[(11)]);
var inst_4629 = cljs.core.empty_QMARK_.call(null,inst_4603);
var inst_4630 = inst_4604.call(null,inst_4612);
var inst_4631 = cljs.core.not.call(null,inst_4630);
var inst_4632 = ((inst_4629) && (inst_4631));
var state_4652__$1 = state_4652;
var statearr_4702_4754 = state_4652__$1;
(statearr_4702_4754[(2)] = inst_4632);

(statearr_4702_4754[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (10))){
var inst_4554 = (state_4652[(8)]);
var inst_4575 = (state_4652[(2)]);
var inst_4576 = cljs.core.get.call(null,inst_4575,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_4577 = cljs.core.get.call(null,inst_4575,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_4578 = cljs.core.get.call(null,inst_4575,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_4579 = inst_4554;
var state_4652__$1 = (function (){var statearr_4703 = state_4652;
(statearr_4703[(16)] = inst_4576);

(statearr_4703[(17)] = inst_4577);

(statearr_4703[(18)] = inst_4578);

(statearr_4703[(7)] = inst_4579);

return statearr_4703;
})();
var statearr_4704_4755 = state_4652__$1;
(statearr_4704_4755[(2)] = null);

(statearr_4704_4755[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (18))){
var inst_4594 = (state_4652[(2)]);
var state_4652__$1 = state_4652;
var statearr_4705_4756 = state_4652__$1;
(statearr_4705_4756[(2)] = inst_4594);

(statearr_4705_4756[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (37))){
var state_4652__$1 = state_4652;
var statearr_4706_4757 = state_4652__$1;
(statearr_4706_4757[(2)] = null);

(statearr_4706_4757[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4653 === (8))){
var inst_4554 = (state_4652[(8)]);
var inst_4572 = cljs.core.apply.call(null,cljs.core.hash_map,inst_4554);
var state_4652__$1 = state_4652;
var statearr_4707_4758 = state_4652__$1;
(statearr_4707_4758[(2)] = inst_4572);

(statearr_4707_4758[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3667__auto___4712,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__3579__auto__,c__3667__auto___4712,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__3580__auto__ = null;
var cljs$core$async$mix_$_state_machine__3580__auto____0 = (function (){
var statearr_4708 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4708[(0)] = cljs$core$async$mix_$_state_machine__3580__auto__);

(statearr_4708[(1)] = (1));

return statearr_4708;
});
var cljs$core$async$mix_$_state_machine__3580__auto____1 = (function (state_4652){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_4652);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e4709){if((e4709 instanceof Object)){
var ex__3583__auto__ = e4709;
var statearr_4710_4759 = state_4652;
(statearr_4710_4759[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4652);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4709;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4760 = state_4652;
state_4652 = G__4760;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__3580__auto__ = function(state_4652){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__3580__auto____1.call(this,state_4652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__3580__auto____0;
cljs$core$async$mix_$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__3580__auto____1;
return cljs$core$async$mix_$_state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto___4712,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__3669__auto__ = (function (){var statearr_4711 = f__3668__auto__.call(null);
(statearr_4711[(6)] = c__3667__auto___4712);

return statearr_4711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto___4712,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4229__auto__ = (((p == null))?null:p);
var m__4230__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4230__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4229__auto__ = (((p == null))?null:p);
var m__4230__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,p,v,ch);
} else {
var m__4230__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__4762 = arguments.length;
switch (G__4762) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4229__auto__ = (((p == null))?null:p);
var m__4230__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,p);
} else {
var m__4230__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4229__auto__ = (((p == null))?null:p);
var m__4230__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,p,v);
} else {
var m__4230__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__4766 = arguments.length;
switch (G__4766) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__3936__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__3936__auto__)){
return or__3936__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__3936__auto__,mults){
return (function (p1__4764_SHARP_){
if(cljs.core.truth_(p1__4764_SHARP_.call(null,topic))){
return p1__4764_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__4764_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__3936__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async4767 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4767 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta4768){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta4768 = meta4768;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async4767.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_4769,meta4768__$1){
var self__ = this;
var _4769__$1 = this;
return (new cljs.core.async.t_cljs$core$async4767(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta4768__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async4767.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_4769){
var self__ = this;
var _4769__$1 = this;
return self__.meta4768;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async4767.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4767.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async4767.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4767.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async4767.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async4767.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async4767.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async4767.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta4768","meta4768",284366674,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async4767.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async4767.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4767";

cljs.core.async.t_cljs$core$async4767.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write.call(null,writer__4180__auto__,"cljs.core.async/t_cljs$core$async4767");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4767.
 */
cljs.core.async.__GT_t_cljs$core$async4767 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async4767(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta4768){
return (new cljs.core.async.t_cljs$core$async4767(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta4768));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async4767(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__3667__auto___4887 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto___4887,mults,ensure_mult,p){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto___4887,mults,ensure_mult,p){
return (function (state_4841){
var state_val_4842 = (state_4841[(1)]);
if((state_val_4842 === (7))){
var inst_4837 = (state_4841[(2)]);
var state_4841__$1 = state_4841;
var statearr_4843_4888 = state_4841__$1;
(statearr_4843_4888[(2)] = inst_4837);

(statearr_4843_4888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (20))){
var state_4841__$1 = state_4841;
var statearr_4844_4889 = state_4841__$1;
(statearr_4844_4889[(2)] = null);

(statearr_4844_4889[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (1))){
var state_4841__$1 = state_4841;
var statearr_4845_4890 = state_4841__$1;
(statearr_4845_4890[(2)] = null);

(statearr_4845_4890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (24))){
var inst_4820 = (state_4841[(7)]);
var inst_4829 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_4820);
var state_4841__$1 = state_4841;
var statearr_4846_4891 = state_4841__$1;
(statearr_4846_4891[(2)] = inst_4829);

(statearr_4846_4891[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (4))){
var inst_4772 = (state_4841[(8)]);
var inst_4772__$1 = (state_4841[(2)]);
var inst_4773 = (inst_4772__$1 == null);
var state_4841__$1 = (function (){var statearr_4847 = state_4841;
(statearr_4847[(8)] = inst_4772__$1);

return statearr_4847;
})();
if(cljs.core.truth_(inst_4773)){
var statearr_4848_4892 = state_4841__$1;
(statearr_4848_4892[(1)] = (5));

} else {
var statearr_4849_4893 = state_4841__$1;
(statearr_4849_4893[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (15))){
var inst_4814 = (state_4841[(2)]);
var state_4841__$1 = state_4841;
var statearr_4850_4894 = state_4841__$1;
(statearr_4850_4894[(2)] = inst_4814);

(statearr_4850_4894[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (21))){
var inst_4834 = (state_4841[(2)]);
var state_4841__$1 = (function (){var statearr_4851 = state_4841;
(statearr_4851[(9)] = inst_4834);

return statearr_4851;
})();
var statearr_4852_4895 = state_4841__$1;
(statearr_4852_4895[(2)] = null);

(statearr_4852_4895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (13))){
var inst_4796 = (state_4841[(10)]);
var inst_4798 = cljs.core.chunked_seq_QMARK_.call(null,inst_4796);
var state_4841__$1 = state_4841;
if(inst_4798){
var statearr_4853_4896 = state_4841__$1;
(statearr_4853_4896[(1)] = (16));

} else {
var statearr_4854_4897 = state_4841__$1;
(statearr_4854_4897[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (22))){
var inst_4826 = (state_4841[(2)]);
var state_4841__$1 = state_4841;
if(cljs.core.truth_(inst_4826)){
var statearr_4855_4898 = state_4841__$1;
(statearr_4855_4898[(1)] = (23));

} else {
var statearr_4856_4899 = state_4841__$1;
(statearr_4856_4899[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (6))){
var inst_4772 = (state_4841[(8)]);
var inst_4820 = (state_4841[(7)]);
var inst_4822 = (state_4841[(11)]);
var inst_4820__$1 = topic_fn.call(null,inst_4772);
var inst_4821 = cljs.core.deref.call(null,mults);
var inst_4822__$1 = cljs.core.get.call(null,inst_4821,inst_4820__$1);
var state_4841__$1 = (function (){var statearr_4857 = state_4841;
(statearr_4857[(7)] = inst_4820__$1);

(statearr_4857[(11)] = inst_4822__$1);

return statearr_4857;
})();
if(cljs.core.truth_(inst_4822__$1)){
var statearr_4858_4900 = state_4841__$1;
(statearr_4858_4900[(1)] = (19));

} else {
var statearr_4859_4901 = state_4841__$1;
(statearr_4859_4901[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (25))){
var inst_4831 = (state_4841[(2)]);
var state_4841__$1 = state_4841;
var statearr_4860_4902 = state_4841__$1;
(statearr_4860_4902[(2)] = inst_4831);

(statearr_4860_4902[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (17))){
var inst_4796 = (state_4841[(10)]);
var inst_4805 = cljs.core.first.call(null,inst_4796);
var inst_4806 = cljs.core.async.muxch_STAR_.call(null,inst_4805);
var inst_4807 = cljs.core.async.close_BANG_.call(null,inst_4806);
var inst_4808 = cljs.core.next.call(null,inst_4796);
var inst_4782 = inst_4808;
var inst_4783 = null;
var inst_4784 = (0);
var inst_4785 = (0);
var state_4841__$1 = (function (){var statearr_4861 = state_4841;
(statearr_4861[(12)] = inst_4782);

(statearr_4861[(13)] = inst_4785);

(statearr_4861[(14)] = inst_4783);

(statearr_4861[(15)] = inst_4807);

(statearr_4861[(16)] = inst_4784);

return statearr_4861;
})();
var statearr_4862_4903 = state_4841__$1;
(statearr_4862_4903[(2)] = null);

(statearr_4862_4903[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (3))){
var inst_4839 = (state_4841[(2)]);
var state_4841__$1 = state_4841;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4841__$1,inst_4839);
} else {
if((state_val_4842 === (12))){
var inst_4816 = (state_4841[(2)]);
var state_4841__$1 = state_4841;
var statearr_4863_4904 = state_4841__$1;
(statearr_4863_4904[(2)] = inst_4816);

(statearr_4863_4904[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (2))){
var state_4841__$1 = state_4841;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4841__$1,(4),ch);
} else {
if((state_val_4842 === (23))){
var state_4841__$1 = state_4841;
var statearr_4864_4905 = state_4841__$1;
(statearr_4864_4905[(2)] = null);

(statearr_4864_4905[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (19))){
var inst_4772 = (state_4841[(8)]);
var inst_4822 = (state_4841[(11)]);
var inst_4824 = cljs.core.async.muxch_STAR_.call(null,inst_4822);
var state_4841__$1 = state_4841;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4841__$1,(22),inst_4824,inst_4772);
} else {
if((state_val_4842 === (11))){
var inst_4782 = (state_4841[(12)]);
var inst_4796 = (state_4841[(10)]);
var inst_4796__$1 = cljs.core.seq.call(null,inst_4782);
var state_4841__$1 = (function (){var statearr_4865 = state_4841;
(statearr_4865[(10)] = inst_4796__$1);

return statearr_4865;
})();
if(inst_4796__$1){
var statearr_4866_4906 = state_4841__$1;
(statearr_4866_4906[(1)] = (13));

} else {
var statearr_4867_4907 = state_4841__$1;
(statearr_4867_4907[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (9))){
var inst_4818 = (state_4841[(2)]);
var state_4841__$1 = state_4841;
var statearr_4868_4908 = state_4841__$1;
(statearr_4868_4908[(2)] = inst_4818);

(statearr_4868_4908[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (5))){
var inst_4779 = cljs.core.deref.call(null,mults);
var inst_4780 = cljs.core.vals.call(null,inst_4779);
var inst_4781 = cljs.core.seq.call(null,inst_4780);
var inst_4782 = inst_4781;
var inst_4783 = null;
var inst_4784 = (0);
var inst_4785 = (0);
var state_4841__$1 = (function (){var statearr_4869 = state_4841;
(statearr_4869[(12)] = inst_4782);

(statearr_4869[(13)] = inst_4785);

(statearr_4869[(14)] = inst_4783);

(statearr_4869[(16)] = inst_4784);

return statearr_4869;
})();
var statearr_4870_4909 = state_4841__$1;
(statearr_4870_4909[(2)] = null);

(statearr_4870_4909[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (14))){
var state_4841__$1 = state_4841;
var statearr_4874_4910 = state_4841__$1;
(statearr_4874_4910[(2)] = null);

(statearr_4874_4910[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (16))){
var inst_4796 = (state_4841[(10)]);
var inst_4800 = cljs.core.chunk_first.call(null,inst_4796);
var inst_4801 = cljs.core.chunk_rest.call(null,inst_4796);
var inst_4802 = cljs.core.count.call(null,inst_4800);
var inst_4782 = inst_4801;
var inst_4783 = inst_4800;
var inst_4784 = inst_4802;
var inst_4785 = (0);
var state_4841__$1 = (function (){var statearr_4875 = state_4841;
(statearr_4875[(12)] = inst_4782);

(statearr_4875[(13)] = inst_4785);

(statearr_4875[(14)] = inst_4783);

(statearr_4875[(16)] = inst_4784);

return statearr_4875;
})();
var statearr_4876_4911 = state_4841__$1;
(statearr_4876_4911[(2)] = null);

(statearr_4876_4911[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (10))){
var inst_4782 = (state_4841[(12)]);
var inst_4785 = (state_4841[(13)]);
var inst_4783 = (state_4841[(14)]);
var inst_4784 = (state_4841[(16)]);
var inst_4790 = cljs.core._nth.call(null,inst_4783,inst_4785);
var inst_4791 = cljs.core.async.muxch_STAR_.call(null,inst_4790);
var inst_4792 = cljs.core.async.close_BANG_.call(null,inst_4791);
var inst_4793 = (inst_4785 + (1));
var tmp4871 = inst_4782;
var tmp4872 = inst_4783;
var tmp4873 = inst_4784;
var inst_4782__$1 = tmp4871;
var inst_4783__$1 = tmp4872;
var inst_4784__$1 = tmp4873;
var inst_4785__$1 = inst_4793;
var state_4841__$1 = (function (){var statearr_4877 = state_4841;
(statearr_4877[(12)] = inst_4782__$1);

(statearr_4877[(13)] = inst_4785__$1);

(statearr_4877[(17)] = inst_4792);

(statearr_4877[(14)] = inst_4783__$1);

(statearr_4877[(16)] = inst_4784__$1);

return statearr_4877;
})();
var statearr_4878_4912 = state_4841__$1;
(statearr_4878_4912[(2)] = null);

(statearr_4878_4912[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (18))){
var inst_4811 = (state_4841[(2)]);
var state_4841__$1 = state_4841;
var statearr_4879_4913 = state_4841__$1;
(statearr_4879_4913[(2)] = inst_4811);

(statearr_4879_4913[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4842 === (8))){
var inst_4785 = (state_4841[(13)]);
var inst_4784 = (state_4841[(16)]);
var inst_4787 = (inst_4785 < inst_4784);
var inst_4788 = inst_4787;
var state_4841__$1 = state_4841;
if(cljs.core.truth_(inst_4788)){
var statearr_4880_4914 = state_4841__$1;
(statearr_4880_4914[(1)] = (10));

} else {
var statearr_4881_4915 = state_4841__$1;
(statearr_4881_4915[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3667__auto___4887,mults,ensure_mult,p))
;
return ((function (switch__3579__auto__,c__3667__auto___4887,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__3580__auto__ = null;
var cljs$core$async$state_machine__3580__auto____0 = (function (){
var statearr_4882 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4882[(0)] = cljs$core$async$state_machine__3580__auto__);

(statearr_4882[(1)] = (1));

return statearr_4882;
});
var cljs$core$async$state_machine__3580__auto____1 = (function (state_4841){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_4841);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e4883){if((e4883 instanceof Object)){
var ex__3583__auto__ = e4883;
var statearr_4884_4916 = state_4841;
(statearr_4884_4916[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4841);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4883;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4917 = state_4841;
state_4841 = G__4917;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$state_machine__3580__auto__ = function(state_4841){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3580__auto____1.call(this,state_4841);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3580__auto____0;
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3580__auto____1;
return cljs$core$async$state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto___4887,mults,ensure_mult,p))
})();
var state__3669__auto__ = (function (){var statearr_4885 = f__3668__auto__.call(null);
(statearr_4885[(6)] = c__3667__auto___4887);

return statearr_4885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto___4887,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__4919 = arguments.length;
switch (G__4919) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__4922 = arguments.length;
switch (G__4922) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__4925 = arguments.length;
switch (G__4925) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__3667__auto___4992 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto___4992,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto___4992,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_4964){
var state_val_4965 = (state_4964[(1)]);
if((state_val_4965 === (7))){
var state_4964__$1 = state_4964;
var statearr_4966_4993 = state_4964__$1;
(statearr_4966_4993[(2)] = null);

(statearr_4966_4993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4965 === (1))){
var state_4964__$1 = state_4964;
var statearr_4967_4994 = state_4964__$1;
(statearr_4967_4994[(2)] = null);

(statearr_4967_4994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4965 === (4))){
var inst_4928 = (state_4964[(7)]);
var inst_4930 = (inst_4928 < cnt);
var state_4964__$1 = state_4964;
if(cljs.core.truth_(inst_4930)){
var statearr_4968_4995 = state_4964__$1;
(statearr_4968_4995[(1)] = (6));

} else {
var statearr_4969_4996 = state_4964__$1;
(statearr_4969_4996[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4965 === (15))){
var inst_4960 = (state_4964[(2)]);
var state_4964__$1 = state_4964;
var statearr_4970_4997 = state_4964__$1;
(statearr_4970_4997[(2)] = inst_4960);

(statearr_4970_4997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4965 === (13))){
var inst_4953 = cljs.core.async.close_BANG_.call(null,out);
var state_4964__$1 = state_4964;
var statearr_4971_4998 = state_4964__$1;
(statearr_4971_4998[(2)] = inst_4953);

(statearr_4971_4998[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4965 === (6))){
var state_4964__$1 = state_4964;
var statearr_4972_4999 = state_4964__$1;
(statearr_4972_4999[(2)] = null);

(statearr_4972_4999[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4965 === (3))){
var inst_4962 = (state_4964[(2)]);
var state_4964__$1 = state_4964;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4964__$1,inst_4962);
} else {
if((state_val_4965 === (12))){
var inst_4950 = (state_4964[(8)]);
var inst_4950__$1 = (state_4964[(2)]);
var inst_4951 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_4950__$1);
var state_4964__$1 = (function (){var statearr_4973 = state_4964;
(statearr_4973[(8)] = inst_4950__$1);

return statearr_4973;
})();
if(cljs.core.truth_(inst_4951)){
var statearr_4974_5000 = state_4964__$1;
(statearr_4974_5000[(1)] = (13));

} else {
var statearr_4975_5001 = state_4964__$1;
(statearr_4975_5001[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4965 === (2))){
var inst_4927 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_4928 = (0);
var state_4964__$1 = (function (){var statearr_4976 = state_4964;
(statearr_4976[(7)] = inst_4928);

(statearr_4976[(9)] = inst_4927);

return statearr_4976;
})();
var statearr_4977_5002 = state_4964__$1;
(statearr_4977_5002[(2)] = null);

(statearr_4977_5002[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4965 === (11))){
var inst_4928 = (state_4964[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_4964,(10),Object,null,(9));
var inst_4937 = chs__$1.call(null,inst_4928);
var inst_4938 = done.call(null,inst_4928);
var inst_4939 = cljs.core.async.take_BANG_.call(null,inst_4937,inst_4938);
var state_4964__$1 = state_4964;
var statearr_4978_5003 = state_4964__$1;
(statearr_4978_5003[(2)] = inst_4939);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4964__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4965 === (9))){
var inst_4928 = (state_4964[(7)]);
var inst_4941 = (state_4964[(2)]);
var inst_4942 = (inst_4928 + (1));
var inst_4928__$1 = inst_4942;
var state_4964__$1 = (function (){var statearr_4979 = state_4964;
(statearr_4979[(10)] = inst_4941);

(statearr_4979[(7)] = inst_4928__$1);

return statearr_4979;
})();
var statearr_4980_5004 = state_4964__$1;
(statearr_4980_5004[(2)] = null);

(statearr_4980_5004[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4965 === (5))){
var inst_4948 = (state_4964[(2)]);
var state_4964__$1 = (function (){var statearr_4981 = state_4964;
(statearr_4981[(11)] = inst_4948);

return statearr_4981;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4964__$1,(12),dchan);
} else {
if((state_val_4965 === (14))){
var inst_4950 = (state_4964[(8)]);
var inst_4955 = cljs.core.apply.call(null,f,inst_4950);
var state_4964__$1 = state_4964;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4964__$1,(16),out,inst_4955);
} else {
if((state_val_4965 === (16))){
var inst_4957 = (state_4964[(2)]);
var state_4964__$1 = (function (){var statearr_4982 = state_4964;
(statearr_4982[(12)] = inst_4957);

return statearr_4982;
})();
var statearr_4983_5005 = state_4964__$1;
(statearr_4983_5005[(2)] = null);

(statearr_4983_5005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4965 === (10))){
var inst_4932 = (state_4964[(2)]);
var inst_4933 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_4964__$1 = (function (){var statearr_4984 = state_4964;
(statearr_4984[(13)] = inst_4932);

return statearr_4984;
})();
var statearr_4985_5006 = state_4964__$1;
(statearr_4985_5006[(2)] = inst_4933);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4964__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4965 === (8))){
var inst_4946 = (state_4964[(2)]);
var state_4964__$1 = state_4964;
var statearr_4986_5007 = state_4964__$1;
(statearr_4986_5007[(2)] = inst_4946);

(statearr_4986_5007[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3667__auto___4992,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__3579__auto__,c__3667__auto___4992,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__3580__auto__ = null;
var cljs$core$async$state_machine__3580__auto____0 = (function (){
var statearr_4987 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4987[(0)] = cljs$core$async$state_machine__3580__auto__);

(statearr_4987[(1)] = (1));

return statearr_4987;
});
var cljs$core$async$state_machine__3580__auto____1 = (function (state_4964){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_4964);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e4988){if((e4988 instanceof Object)){
var ex__3583__auto__ = e4988;
var statearr_4989_5008 = state_4964;
(statearr_4989_5008[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4964);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4988;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5009 = state_4964;
state_4964 = G__5009;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$state_machine__3580__auto__ = function(state_4964){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3580__auto____1.call(this,state_4964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3580__auto____0;
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3580__auto____1;
return cljs$core$async$state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto___4992,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__3669__auto__ = (function (){var statearr_4990 = f__3668__auto__.call(null);
(statearr_4990[(6)] = c__3667__auto___4992);

return statearr_4990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto___4992,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__5012 = arguments.length;
switch (G__5012) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__3667__auto___5066 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto___5066,out){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto___5066,out){
return (function (state_5044){
var state_val_5045 = (state_5044[(1)]);
if((state_val_5045 === (7))){
var inst_5023 = (state_5044[(7)]);
var inst_5024 = (state_5044[(8)]);
var inst_5023__$1 = (state_5044[(2)]);
var inst_5024__$1 = cljs.core.nth.call(null,inst_5023__$1,(0),null);
var inst_5025 = cljs.core.nth.call(null,inst_5023__$1,(1),null);
var inst_5026 = (inst_5024__$1 == null);
var state_5044__$1 = (function (){var statearr_5046 = state_5044;
(statearr_5046[(7)] = inst_5023__$1);

(statearr_5046[(8)] = inst_5024__$1);

(statearr_5046[(9)] = inst_5025);

return statearr_5046;
})();
if(cljs.core.truth_(inst_5026)){
var statearr_5047_5067 = state_5044__$1;
(statearr_5047_5067[(1)] = (8));

} else {
var statearr_5048_5068 = state_5044__$1;
(statearr_5048_5068[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5045 === (1))){
var inst_5013 = cljs.core.vec.call(null,chs);
var inst_5014 = inst_5013;
var state_5044__$1 = (function (){var statearr_5049 = state_5044;
(statearr_5049[(10)] = inst_5014);

return statearr_5049;
})();
var statearr_5050_5069 = state_5044__$1;
(statearr_5050_5069[(2)] = null);

(statearr_5050_5069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5045 === (4))){
var inst_5014 = (state_5044[(10)]);
var state_5044__$1 = state_5044;
return cljs.core.async.ioc_alts_BANG_.call(null,state_5044__$1,(7),inst_5014);
} else {
if((state_val_5045 === (6))){
var inst_5040 = (state_5044[(2)]);
var state_5044__$1 = state_5044;
var statearr_5051_5070 = state_5044__$1;
(statearr_5051_5070[(2)] = inst_5040);

(statearr_5051_5070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5045 === (3))){
var inst_5042 = (state_5044[(2)]);
var state_5044__$1 = state_5044;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5044__$1,inst_5042);
} else {
if((state_val_5045 === (2))){
var inst_5014 = (state_5044[(10)]);
var inst_5016 = cljs.core.count.call(null,inst_5014);
var inst_5017 = (inst_5016 > (0));
var state_5044__$1 = state_5044;
if(cljs.core.truth_(inst_5017)){
var statearr_5053_5071 = state_5044__$1;
(statearr_5053_5071[(1)] = (4));

} else {
var statearr_5054_5072 = state_5044__$1;
(statearr_5054_5072[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5045 === (11))){
var inst_5014 = (state_5044[(10)]);
var inst_5033 = (state_5044[(2)]);
var tmp5052 = inst_5014;
var inst_5014__$1 = tmp5052;
var state_5044__$1 = (function (){var statearr_5055 = state_5044;
(statearr_5055[(10)] = inst_5014__$1);

(statearr_5055[(11)] = inst_5033);

return statearr_5055;
})();
var statearr_5056_5073 = state_5044__$1;
(statearr_5056_5073[(2)] = null);

(statearr_5056_5073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5045 === (9))){
var inst_5024 = (state_5044[(8)]);
var state_5044__$1 = state_5044;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5044__$1,(11),out,inst_5024);
} else {
if((state_val_5045 === (5))){
var inst_5038 = cljs.core.async.close_BANG_.call(null,out);
var state_5044__$1 = state_5044;
var statearr_5057_5074 = state_5044__$1;
(statearr_5057_5074[(2)] = inst_5038);

(statearr_5057_5074[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5045 === (10))){
var inst_5036 = (state_5044[(2)]);
var state_5044__$1 = state_5044;
var statearr_5058_5075 = state_5044__$1;
(statearr_5058_5075[(2)] = inst_5036);

(statearr_5058_5075[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5045 === (8))){
var inst_5023 = (state_5044[(7)]);
var inst_5014 = (state_5044[(10)]);
var inst_5024 = (state_5044[(8)]);
var inst_5025 = (state_5044[(9)]);
var inst_5028 = (function (){var cs = inst_5014;
var vec__5019 = inst_5023;
var v = inst_5024;
var c = inst_5025;
return ((function (cs,vec__5019,v,c,inst_5023,inst_5014,inst_5024,inst_5025,state_val_5045,c__3667__auto___5066,out){
return (function (p1__5010_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__5010_SHARP_);
});
;})(cs,vec__5019,v,c,inst_5023,inst_5014,inst_5024,inst_5025,state_val_5045,c__3667__auto___5066,out))
})();
var inst_5029 = cljs.core.filterv.call(null,inst_5028,inst_5014);
var inst_5014__$1 = inst_5029;
var state_5044__$1 = (function (){var statearr_5059 = state_5044;
(statearr_5059[(10)] = inst_5014__$1);

return statearr_5059;
})();
var statearr_5060_5076 = state_5044__$1;
(statearr_5060_5076[(2)] = null);

(statearr_5060_5076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__3667__auto___5066,out))
;
return ((function (switch__3579__auto__,c__3667__auto___5066,out){
return (function() {
var cljs$core$async$state_machine__3580__auto__ = null;
var cljs$core$async$state_machine__3580__auto____0 = (function (){
var statearr_5061 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_5061[(0)] = cljs$core$async$state_machine__3580__auto__);

(statearr_5061[(1)] = (1));

return statearr_5061;
});
var cljs$core$async$state_machine__3580__auto____1 = (function (state_5044){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_5044);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e5062){if((e5062 instanceof Object)){
var ex__3583__auto__ = e5062;
var statearr_5063_5077 = state_5044;
(statearr_5063_5077[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5044);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e5062;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5078 = state_5044;
state_5044 = G__5078;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$state_machine__3580__auto__ = function(state_5044){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3580__auto____1.call(this,state_5044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3580__auto____0;
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3580__auto____1;
return cljs$core$async$state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto___5066,out))
})();
var state__3669__auto__ = (function (){var statearr_5064 = f__3668__auto__.call(null);
(statearr_5064[(6)] = c__3667__auto___5066);

return statearr_5064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto___5066,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__5080 = arguments.length;
switch (G__5080) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__3667__auto___5125 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto___5125,out){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto___5125,out){
return (function (state_5104){
var state_val_5105 = (state_5104[(1)]);
if((state_val_5105 === (7))){
var inst_5086 = (state_5104[(7)]);
var inst_5086__$1 = (state_5104[(2)]);
var inst_5087 = (inst_5086__$1 == null);
var inst_5088 = cljs.core.not.call(null,inst_5087);
var state_5104__$1 = (function (){var statearr_5106 = state_5104;
(statearr_5106[(7)] = inst_5086__$1);

return statearr_5106;
})();
if(inst_5088){
var statearr_5107_5126 = state_5104__$1;
(statearr_5107_5126[(1)] = (8));

} else {
var statearr_5108_5127 = state_5104__$1;
(statearr_5108_5127[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5105 === (1))){
var inst_5081 = (0);
var state_5104__$1 = (function (){var statearr_5109 = state_5104;
(statearr_5109[(8)] = inst_5081);

return statearr_5109;
})();
var statearr_5110_5128 = state_5104__$1;
(statearr_5110_5128[(2)] = null);

(statearr_5110_5128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5105 === (4))){
var state_5104__$1 = state_5104;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5104__$1,(7),ch);
} else {
if((state_val_5105 === (6))){
var inst_5099 = (state_5104[(2)]);
var state_5104__$1 = state_5104;
var statearr_5111_5129 = state_5104__$1;
(statearr_5111_5129[(2)] = inst_5099);

(statearr_5111_5129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5105 === (3))){
var inst_5101 = (state_5104[(2)]);
var inst_5102 = cljs.core.async.close_BANG_.call(null,out);
var state_5104__$1 = (function (){var statearr_5112 = state_5104;
(statearr_5112[(9)] = inst_5101);

return statearr_5112;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5104__$1,inst_5102);
} else {
if((state_val_5105 === (2))){
var inst_5081 = (state_5104[(8)]);
var inst_5083 = (inst_5081 < n);
var state_5104__$1 = state_5104;
if(cljs.core.truth_(inst_5083)){
var statearr_5113_5130 = state_5104__$1;
(statearr_5113_5130[(1)] = (4));

} else {
var statearr_5114_5131 = state_5104__$1;
(statearr_5114_5131[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5105 === (11))){
var inst_5081 = (state_5104[(8)]);
var inst_5091 = (state_5104[(2)]);
var inst_5092 = (inst_5081 + (1));
var inst_5081__$1 = inst_5092;
var state_5104__$1 = (function (){var statearr_5115 = state_5104;
(statearr_5115[(10)] = inst_5091);

(statearr_5115[(8)] = inst_5081__$1);

return statearr_5115;
})();
var statearr_5116_5132 = state_5104__$1;
(statearr_5116_5132[(2)] = null);

(statearr_5116_5132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5105 === (9))){
var state_5104__$1 = state_5104;
var statearr_5117_5133 = state_5104__$1;
(statearr_5117_5133[(2)] = null);

(statearr_5117_5133[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5105 === (5))){
var state_5104__$1 = state_5104;
var statearr_5118_5134 = state_5104__$1;
(statearr_5118_5134[(2)] = null);

(statearr_5118_5134[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5105 === (10))){
var inst_5096 = (state_5104[(2)]);
var state_5104__$1 = state_5104;
var statearr_5119_5135 = state_5104__$1;
(statearr_5119_5135[(2)] = inst_5096);

(statearr_5119_5135[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5105 === (8))){
var inst_5086 = (state_5104[(7)]);
var state_5104__$1 = state_5104;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5104__$1,(11),out,inst_5086);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__3667__auto___5125,out))
;
return ((function (switch__3579__auto__,c__3667__auto___5125,out){
return (function() {
var cljs$core$async$state_machine__3580__auto__ = null;
var cljs$core$async$state_machine__3580__auto____0 = (function (){
var statearr_5120 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_5120[(0)] = cljs$core$async$state_machine__3580__auto__);

(statearr_5120[(1)] = (1));

return statearr_5120;
});
var cljs$core$async$state_machine__3580__auto____1 = (function (state_5104){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_5104);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e5121){if((e5121 instanceof Object)){
var ex__3583__auto__ = e5121;
var statearr_5122_5136 = state_5104;
(statearr_5122_5136[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5104);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e5121;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5137 = state_5104;
state_5104 = G__5137;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$state_machine__3580__auto__ = function(state_5104){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3580__auto____1.call(this,state_5104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3580__auto____0;
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3580__auto____1;
return cljs$core$async$state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto___5125,out))
})();
var state__3669__auto__ = (function (){var statearr_5123 = f__3668__auto__.call(null);
(statearr_5123[(6)] = c__3667__auto___5125);

return statearr_5123;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto___5125,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async5139 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async5139 = (function (f,ch,meta5140){
this.f = f;
this.ch = ch;
this.meta5140 = meta5140;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async5139.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_5141,meta5140__$1){
var self__ = this;
var _5141__$1 = this;
return (new cljs.core.async.t_cljs$core$async5139(self__.f,self__.ch,meta5140__$1));
});

cljs.core.async.t_cljs$core$async5139.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_5141){
var self__ = this;
var _5141__$1 = this;
return self__.meta5140;
});

cljs.core.async.t_cljs$core$async5139.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async5139.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async5139.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async5139.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async5139.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async5142 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async5142 = (function (f,ch,meta5140,_,fn1,meta5143){
this.f = f;
this.ch = ch;
this.meta5140 = meta5140;
this._ = _;
this.fn1 = fn1;
this.meta5143 = meta5143;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async5142.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_5144,meta5143__$1){
var self__ = this;
var _5144__$1 = this;
return (new cljs.core.async.t_cljs$core$async5142(self__.f,self__.ch,self__.meta5140,self__._,self__.fn1,meta5143__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async5142.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_5144){
var self__ = this;
var _5144__$1 = this;
return self__.meta5143;
});})(___$1))
;

cljs.core.async.t_cljs$core$async5142.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async5142.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async5142.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async5142.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__5138_SHARP_){
return f1.call(null,(((p1__5138_SHARP_ == null))?null:self__.f.call(null,p1__5138_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async5142.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta5140","meta5140",-129636612,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async5139","cljs.core.async/t_cljs$core$async5139",333097554,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta5143","meta5143",884777769,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async5142.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async5142.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async5142";

cljs.core.async.t_cljs$core$async5142.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write.call(null,writer__4180__auto__,"cljs.core.async/t_cljs$core$async5142");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async5142.
 */
cljs.core.async.__GT_t_cljs$core$async5142 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async5142(f__$1,ch__$1,meta5140__$1,___$2,fn1__$1,meta5143){
return (new cljs.core.async.t_cljs$core$async5142(f__$1,ch__$1,meta5140__$1,___$2,fn1__$1,meta5143));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async5142(self__.f,self__.ch,self__.meta5140,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__3925__auto__ = ret;
if(cljs.core.truth_(and__3925__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__3925__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async5139.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async5139.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async5139.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta5140","meta5140",-129636612,null)], null);
});

cljs.core.async.t_cljs$core$async5139.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async5139.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async5139";

cljs.core.async.t_cljs$core$async5139.cljs$lang$ctorPrWriter = (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write.call(null,writer__4180__auto__,"cljs.core.async/t_cljs$core$async5139");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async5139.
 */
cljs.core.async.__GT_t_cljs$core$async5139 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async5139(f__$1,ch__$1,meta5140){
return (new cljs.core.async.t_cljs$core$async5139(f__$1,ch__$1,meta5140));
});

}

return (new cljs.core.async.t_cljs$core$async5139(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async5145 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async5145 = (function (f,ch,meta5146){
this.f = f;
this.ch = ch;
this.meta5146 = meta5146;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async5145.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_5147,meta5146__$1){
var self__ = this;
var _5147__$1 = this;
return (new cljs.core.async.t_cljs$core$async5145(self__.f,self__.ch,meta5146__$1));
});

cljs.core.async.t_cljs$core$async5145.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_5147){
var self__ = this;
var _5147__$1 = this;
return self__.meta5146;
});

cljs.core.async.t_cljs$core$async5145.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async5145.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async5145.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async5145.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async5145.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async5145.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async5145.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta5146","meta5146",-59024146,null)], null);
});

cljs.core.async.t_cljs$core$async5145.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async5145.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async5145";

cljs.core.async.t_cljs$core$async5145.cljs$lang$ctorPrWriter = (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write.call(null,writer__4180__auto__,"cljs.core.async/t_cljs$core$async5145");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async5145.
 */
cljs.core.async.__GT_t_cljs$core$async5145 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async5145(f__$1,ch__$1,meta5146){
return (new cljs.core.async.t_cljs$core$async5145(f__$1,ch__$1,meta5146));
});

}

return (new cljs.core.async.t_cljs$core$async5145(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async5148 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async5148 = (function (p,ch,meta5149){
this.p = p;
this.ch = ch;
this.meta5149 = meta5149;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async5148.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_5150,meta5149__$1){
var self__ = this;
var _5150__$1 = this;
return (new cljs.core.async.t_cljs$core$async5148(self__.p,self__.ch,meta5149__$1));
});

cljs.core.async.t_cljs$core$async5148.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_5150){
var self__ = this;
var _5150__$1 = this;
return self__.meta5149;
});

cljs.core.async.t_cljs$core$async5148.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async5148.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async5148.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async5148.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async5148.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async5148.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async5148.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async5148.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta5149","meta5149",159593226,null)], null);
});

cljs.core.async.t_cljs$core$async5148.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async5148.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async5148";

cljs.core.async.t_cljs$core$async5148.cljs$lang$ctorPrWriter = (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write.call(null,writer__4180__auto__,"cljs.core.async/t_cljs$core$async5148");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async5148.
 */
cljs.core.async.__GT_t_cljs$core$async5148 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async5148(p__$1,ch__$1,meta5149){
return (new cljs.core.async.t_cljs$core$async5148(p__$1,ch__$1,meta5149));
});

}

return (new cljs.core.async.t_cljs$core$async5148(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__5152 = arguments.length;
switch (G__5152) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__3667__auto___5192 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto___5192,out){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto___5192,out){
return (function (state_5173){
var state_val_5174 = (state_5173[(1)]);
if((state_val_5174 === (7))){
var inst_5169 = (state_5173[(2)]);
var state_5173__$1 = state_5173;
var statearr_5175_5193 = state_5173__$1;
(statearr_5175_5193[(2)] = inst_5169);

(statearr_5175_5193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5174 === (1))){
var state_5173__$1 = state_5173;
var statearr_5176_5194 = state_5173__$1;
(statearr_5176_5194[(2)] = null);

(statearr_5176_5194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5174 === (4))){
var inst_5155 = (state_5173[(7)]);
var inst_5155__$1 = (state_5173[(2)]);
var inst_5156 = (inst_5155__$1 == null);
var state_5173__$1 = (function (){var statearr_5177 = state_5173;
(statearr_5177[(7)] = inst_5155__$1);

return statearr_5177;
})();
if(cljs.core.truth_(inst_5156)){
var statearr_5178_5195 = state_5173__$1;
(statearr_5178_5195[(1)] = (5));

} else {
var statearr_5179_5196 = state_5173__$1;
(statearr_5179_5196[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5174 === (6))){
var inst_5155 = (state_5173[(7)]);
var inst_5160 = p.call(null,inst_5155);
var state_5173__$1 = state_5173;
if(cljs.core.truth_(inst_5160)){
var statearr_5180_5197 = state_5173__$1;
(statearr_5180_5197[(1)] = (8));

} else {
var statearr_5181_5198 = state_5173__$1;
(statearr_5181_5198[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5174 === (3))){
var inst_5171 = (state_5173[(2)]);
var state_5173__$1 = state_5173;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5173__$1,inst_5171);
} else {
if((state_val_5174 === (2))){
var state_5173__$1 = state_5173;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5173__$1,(4),ch);
} else {
if((state_val_5174 === (11))){
var inst_5163 = (state_5173[(2)]);
var state_5173__$1 = state_5173;
var statearr_5182_5199 = state_5173__$1;
(statearr_5182_5199[(2)] = inst_5163);

(statearr_5182_5199[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5174 === (9))){
var state_5173__$1 = state_5173;
var statearr_5183_5200 = state_5173__$1;
(statearr_5183_5200[(2)] = null);

(statearr_5183_5200[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5174 === (5))){
var inst_5158 = cljs.core.async.close_BANG_.call(null,out);
var state_5173__$1 = state_5173;
var statearr_5184_5201 = state_5173__$1;
(statearr_5184_5201[(2)] = inst_5158);

(statearr_5184_5201[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5174 === (10))){
var inst_5166 = (state_5173[(2)]);
var state_5173__$1 = (function (){var statearr_5185 = state_5173;
(statearr_5185[(8)] = inst_5166);

return statearr_5185;
})();
var statearr_5186_5202 = state_5173__$1;
(statearr_5186_5202[(2)] = null);

(statearr_5186_5202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5174 === (8))){
var inst_5155 = (state_5173[(7)]);
var state_5173__$1 = state_5173;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5173__$1,(11),out,inst_5155);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__3667__auto___5192,out))
;
return ((function (switch__3579__auto__,c__3667__auto___5192,out){
return (function() {
var cljs$core$async$state_machine__3580__auto__ = null;
var cljs$core$async$state_machine__3580__auto____0 = (function (){
var statearr_5187 = [null,null,null,null,null,null,null,null,null];
(statearr_5187[(0)] = cljs$core$async$state_machine__3580__auto__);

(statearr_5187[(1)] = (1));

return statearr_5187;
});
var cljs$core$async$state_machine__3580__auto____1 = (function (state_5173){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_5173);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e5188){if((e5188 instanceof Object)){
var ex__3583__auto__ = e5188;
var statearr_5189_5203 = state_5173;
(statearr_5189_5203[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5173);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e5188;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5204 = state_5173;
state_5173 = G__5204;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$state_machine__3580__auto__ = function(state_5173){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3580__auto____1.call(this,state_5173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3580__auto____0;
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3580__auto____1;
return cljs$core$async$state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto___5192,out))
})();
var state__3669__auto__ = (function (){var statearr_5190 = f__3668__auto__.call(null);
(statearr_5190[(6)] = c__3667__auto___5192);

return statearr_5190;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto___5192,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__5206 = arguments.length;
switch (G__5206) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__3667__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto__){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto__){
return (function (state_5269){
var state_val_5270 = (state_5269[(1)]);
if((state_val_5270 === (7))){
var inst_5265 = (state_5269[(2)]);
var state_5269__$1 = state_5269;
var statearr_5271_5309 = state_5269__$1;
(statearr_5271_5309[(2)] = inst_5265);

(statearr_5271_5309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5270 === (20))){
var inst_5235 = (state_5269[(7)]);
var inst_5246 = (state_5269[(2)]);
var inst_5247 = cljs.core.next.call(null,inst_5235);
var inst_5221 = inst_5247;
var inst_5222 = null;
var inst_5223 = (0);
var inst_5224 = (0);
var state_5269__$1 = (function (){var statearr_5272 = state_5269;
(statearr_5272[(8)] = inst_5222);

(statearr_5272[(9)] = inst_5221);

(statearr_5272[(10)] = inst_5224);

(statearr_5272[(11)] = inst_5223);

(statearr_5272[(12)] = inst_5246);

return statearr_5272;
})();
var statearr_5273_5310 = state_5269__$1;
(statearr_5273_5310[(2)] = null);

(statearr_5273_5310[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5270 === (1))){
var state_5269__$1 = state_5269;
var statearr_5274_5311 = state_5269__$1;
(statearr_5274_5311[(2)] = null);

(statearr_5274_5311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5270 === (4))){
var inst_5210 = (state_5269[(13)]);
var inst_5210__$1 = (state_5269[(2)]);
var inst_5211 = (inst_5210__$1 == null);
var state_5269__$1 = (function (){var statearr_5275 = state_5269;
(statearr_5275[(13)] = inst_5210__$1);

return statearr_5275;
})();
if(cljs.core.truth_(inst_5211)){
var statearr_5276_5312 = state_5269__$1;
(statearr_5276_5312[(1)] = (5));

} else {
var statearr_5277_5313 = state_5269__$1;
(statearr_5277_5313[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5270 === (15))){
var state_5269__$1 = state_5269;
var statearr_5281_5314 = state_5269__$1;
(statearr_5281_5314[(2)] = null);

(statearr_5281_5314[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5270 === (21))){
var state_5269__$1 = state_5269;
var statearr_5282_5315 = state_5269__$1;
(statearr_5282_5315[(2)] = null);

(statearr_5282_5315[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5270 === (13))){
var inst_5222 = (state_5269[(8)]);
var inst_5221 = (state_5269[(9)]);
var inst_5224 = (state_5269[(10)]);
var inst_5223 = (state_5269[(11)]);
var inst_5231 = (state_5269[(2)]);
var inst_5232 = (inst_5224 + (1));
var tmp5278 = inst_5222;
var tmp5279 = inst_5221;
var tmp5280 = inst_5223;
var inst_5221__$1 = tmp5279;
var inst_5222__$1 = tmp5278;
var inst_5223__$1 = tmp5280;
var inst_5224__$1 = inst_5232;
var state_5269__$1 = (function (){var statearr_5283 = state_5269;
(statearr_5283[(8)] = inst_5222__$1);

(statearr_5283[(9)] = inst_5221__$1);

(statearr_5283[(10)] = inst_5224__$1);

(statearr_5283[(11)] = inst_5223__$1);

(statearr_5283[(14)] = inst_5231);

return statearr_5283;
})();
var statearr_5284_5316 = state_5269__$1;
(statearr_5284_5316[(2)] = null);

(statearr_5284_5316[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5270 === (22))){
var state_5269__$1 = state_5269;
var statearr_5285_5317 = state_5269__$1;
(statearr_5285_5317[(2)] = null);

(statearr_5285_5317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5270 === (6))){
var inst_5210 = (state_5269[(13)]);
var inst_5219 = f.call(null,inst_5210);
var inst_5220 = cljs.core.seq.call(null,inst_5219);
var inst_5221 = inst_5220;
var inst_5222 = null;
var inst_5223 = (0);
var inst_5224 = (0);
var state_5269__$1 = (function (){var statearr_5286 = state_5269;
(statearr_5286[(8)] = inst_5222);

(statearr_5286[(9)] = inst_5221);

(statearr_5286[(10)] = inst_5224);

(statearr_5286[(11)] = inst_5223);

return statearr_5286;
})();
var statearr_5287_5318 = state_5269__$1;
(statearr_5287_5318[(2)] = null);

(statearr_5287_5318[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5270 === (17))){
var inst_5235 = (state_5269[(7)]);
var inst_5239 = cljs.core.chunk_first.call(null,inst_5235);
var inst_5240 = cljs.core.chunk_rest.call(null,inst_5235);
var inst_5241 = cljs.core.count.call(null,inst_5239);
var inst_5221 = inst_5240;
var inst_5222 = inst_5239;
var inst_5223 = inst_5241;
var inst_5224 = (0);
var state_5269__$1 = (function (){var statearr_5288 = state_5269;
(statearr_5288[(8)] = inst_5222);

(statearr_5288[(9)] = inst_5221);

(statearr_5288[(10)] = inst_5224);

(statearr_5288[(11)] = inst_5223);

return statearr_5288;
})();
var statearr_5289_5319 = state_5269__$1;
(statearr_5289_5319[(2)] = null);

(statearr_5289_5319[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5270 === (3))){
var inst_5267 = (state_5269[(2)]);
var state_5269__$1 = state_5269;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5269__$1,inst_5267);
} else {
if((state_val_5270 === (12))){
var inst_5255 = (state_5269[(2)]);
var state_5269__$1 = state_5269;
var statearr_5290_5320 = state_5269__$1;
(statearr_5290_5320[(2)] = inst_5255);

(statearr_5290_5320[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5270 === (2))){
var state_5269__$1 = state_5269;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5269__$1,(4),in$);
} else {
if((state_val_5270 === (23))){
var inst_5263 = (state_5269[(2)]);
var state_5269__$1 = state_5269;
var statearr_5291_5321 = state_5269__$1;
(statearr_5291_5321[(2)] = inst_5263);

(statearr_5291_5321[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5270 === (19))){
var inst_5250 = (state_5269[(2)]);
var state_5269__$1 = state_5269;
var statearr_5292_5322 = state_5269__$1;
(statearr_5292_5322[(2)] = inst_5250);

(statearr_5292_5322[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5270 === (11))){
var inst_5221 = (state_5269[(9)]);
var inst_5235 = (state_5269[(7)]);
var inst_5235__$1 = cljs.core.seq.call(null,inst_5221);
var state_5269__$1 = (function (){var statearr_5293 = state_5269;
(statearr_5293[(7)] = inst_5235__$1);

return statearr_5293;
})();
if(inst_5235__$1){
var statearr_5294_5323 = state_5269__$1;
(statearr_5294_5323[(1)] = (14));

} else {
var statearr_5295_5324 = state_5269__$1;
(statearr_5295_5324[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5270 === (9))){
var inst_5257 = (state_5269[(2)]);
var inst_5258 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_5269__$1 = (function (){var statearr_5296 = state_5269;
(statearr_5296[(15)] = inst_5257);

return statearr_5296;
})();
if(cljs.core.truth_(inst_5258)){
var statearr_5297_5325 = state_5269__$1;
(statearr_5297_5325[(1)] = (21));

} else {
var statearr_5298_5326 = state_5269__$1;
(statearr_5298_5326[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5270 === (5))){
var inst_5213 = cljs.core.async.close_BANG_.call(null,out);
var state_5269__$1 = state_5269;
var statearr_5299_5327 = state_5269__$1;
(statearr_5299_5327[(2)] = inst_5213);

(statearr_5299_5327[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5270 === (14))){
var inst_5235 = (state_5269[(7)]);
var inst_5237 = cljs.core.chunked_seq_QMARK_.call(null,inst_5235);
var state_5269__$1 = state_5269;
if(inst_5237){
var statearr_5300_5328 = state_5269__$1;
(statearr_5300_5328[(1)] = (17));

} else {
var statearr_5301_5329 = state_5269__$1;
(statearr_5301_5329[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5270 === (16))){
var inst_5253 = (state_5269[(2)]);
var state_5269__$1 = state_5269;
var statearr_5302_5330 = state_5269__$1;
(statearr_5302_5330[(2)] = inst_5253);

(statearr_5302_5330[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5270 === (10))){
var inst_5222 = (state_5269[(8)]);
var inst_5224 = (state_5269[(10)]);
var inst_5229 = cljs.core._nth.call(null,inst_5222,inst_5224);
var state_5269__$1 = state_5269;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5269__$1,(13),out,inst_5229);
} else {
if((state_val_5270 === (18))){
var inst_5235 = (state_5269[(7)]);
var inst_5244 = cljs.core.first.call(null,inst_5235);
var state_5269__$1 = state_5269;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5269__$1,(20),out,inst_5244);
} else {
if((state_val_5270 === (8))){
var inst_5224 = (state_5269[(10)]);
var inst_5223 = (state_5269[(11)]);
var inst_5226 = (inst_5224 < inst_5223);
var inst_5227 = inst_5226;
var state_5269__$1 = state_5269;
if(cljs.core.truth_(inst_5227)){
var statearr_5303_5331 = state_5269__$1;
(statearr_5303_5331[(1)] = (10));

} else {
var statearr_5304_5332 = state_5269__$1;
(statearr_5304_5332[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3667__auto__))
;
return ((function (switch__3579__auto__,c__3667__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__3580__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__3580__auto____0 = (function (){
var statearr_5305 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_5305[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__3580__auto__);

(statearr_5305[(1)] = (1));

return statearr_5305;
});
var cljs$core$async$mapcat_STAR__$_state_machine__3580__auto____1 = (function (state_5269){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_5269);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e5306){if((e5306 instanceof Object)){
var ex__3583__auto__ = e5306;
var statearr_5307_5333 = state_5269;
(statearr_5307_5333[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5269);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e5306;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5334 = state_5269;
state_5269 = G__5334;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__3580__auto__ = function(state_5269){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__3580__auto____1.call(this,state_5269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__3580__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__3580__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto__))
})();
var state__3669__auto__ = (function (){var statearr_5308 = f__3668__auto__.call(null);
(statearr_5308[(6)] = c__3667__auto__);

return statearr_5308;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto__))
);

return c__3667__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__5336 = arguments.length;
switch (G__5336) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__5339 = arguments.length;
switch (G__5339) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__5342 = arguments.length;
switch (G__5342) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__3667__auto___5389 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto___5389,out){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto___5389,out){
return (function (state_5366){
var state_val_5367 = (state_5366[(1)]);
if((state_val_5367 === (7))){
var inst_5361 = (state_5366[(2)]);
var state_5366__$1 = state_5366;
var statearr_5368_5390 = state_5366__$1;
(statearr_5368_5390[(2)] = inst_5361);

(statearr_5368_5390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5367 === (1))){
var inst_5343 = null;
var state_5366__$1 = (function (){var statearr_5369 = state_5366;
(statearr_5369[(7)] = inst_5343);

return statearr_5369;
})();
var statearr_5370_5391 = state_5366__$1;
(statearr_5370_5391[(2)] = null);

(statearr_5370_5391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5367 === (4))){
var inst_5346 = (state_5366[(8)]);
var inst_5346__$1 = (state_5366[(2)]);
var inst_5347 = (inst_5346__$1 == null);
var inst_5348 = cljs.core.not.call(null,inst_5347);
var state_5366__$1 = (function (){var statearr_5371 = state_5366;
(statearr_5371[(8)] = inst_5346__$1);

return statearr_5371;
})();
if(inst_5348){
var statearr_5372_5392 = state_5366__$1;
(statearr_5372_5392[(1)] = (5));

} else {
var statearr_5373_5393 = state_5366__$1;
(statearr_5373_5393[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5367 === (6))){
var state_5366__$1 = state_5366;
var statearr_5374_5394 = state_5366__$1;
(statearr_5374_5394[(2)] = null);

(statearr_5374_5394[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5367 === (3))){
var inst_5363 = (state_5366[(2)]);
var inst_5364 = cljs.core.async.close_BANG_.call(null,out);
var state_5366__$1 = (function (){var statearr_5375 = state_5366;
(statearr_5375[(9)] = inst_5363);

return statearr_5375;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5366__$1,inst_5364);
} else {
if((state_val_5367 === (2))){
var state_5366__$1 = state_5366;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5366__$1,(4),ch);
} else {
if((state_val_5367 === (11))){
var inst_5346 = (state_5366[(8)]);
var inst_5355 = (state_5366[(2)]);
var inst_5343 = inst_5346;
var state_5366__$1 = (function (){var statearr_5376 = state_5366;
(statearr_5376[(7)] = inst_5343);

(statearr_5376[(10)] = inst_5355);

return statearr_5376;
})();
var statearr_5377_5395 = state_5366__$1;
(statearr_5377_5395[(2)] = null);

(statearr_5377_5395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5367 === (9))){
var inst_5346 = (state_5366[(8)]);
var state_5366__$1 = state_5366;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5366__$1,(11),out,inst_5346);
} else {
if((state_val_5367 === (5))){
var inst_5346 = (state_5366[(8)]);
var inst_5343 = (state_5366[(7)]);
var inst_5350 = cljs.core._EQ_.call(null,inst_5346,inst_5343);
var state_5366__$1 = state_5366;
if(inst_5350){
var statearr_5379_5396 = state_5366__$1;
(statearr_5379_5396[(1)] = (8));

} else {
var statearr_5380_5397 = state_5366__$1;
(statearr_5380_5397[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5367 === (10))){
var inst_5358 = (state_5366[(2)]);
var state_5366__$1 = state_5366;
var statearr_5381_5398 = state_5366__$1;
(statearr_5381_5398[(2)] = inst_5358);

(statearr_5381_5398[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5367 === (8))){
var inst_5343 = (state_5366[(7)]);
var tmp5378 = inst_5343;
var inst_5343__$1 = tmp5378;
var state_5366__$1 = (function (){var statearr_5382 = state_5366;
(statearr_5382[(7)] = inst_5343__$1);

return statearr_5382;
})();
var statearr_5383_5399 = state_5366__$1;
(statearr_5383_5399[(2)] = null);

(statearr_5383_5399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__3667__auto___5389,out))
;
return ((function (switch__3579__auto__,c__3667__auto___5389,out){
return (function() {
var cljs$core$async$state_machine__3580__auto__ = null;
var cljs$core$async$state_machine__3580__auto____0 = (function (){
var statearr_5384 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_5384[(0)] = cljs$core$async$state_machine__3580__auto__);

(statearr_5384[(1)] = (1));

return statearr_5384;
});
var cljs$core$async$state_machine__3580__auto____1 = (function (state_5366){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_5366);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e5385){if((e5385 instanceof Object)){
var ex__3583__auto__ = e5385;
var statearr_5386_5400 = state_5366;
(statearr_5386_5400[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5366);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e5385;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5401 = state_5366;
state_5366 = G__5401;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$state_machine__3580__auto__ = function(state_5366){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3580__auto____1.call(this,state_5366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3580__auto____0;
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3580__auto____1;
return cljs$core$async$state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto___5389,out))
})();
var state__3669__auto__ = (function (){var statearr_5387 = f__3668__auto__.call(null);
(statearr_5387[(6)] = c__3667__auto___5389);

return statearr_5387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto___5389,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__5403 = arguments.length;
switch (G__5403) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__3667__auto___5469 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto___5469,out){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto___5469,out){
return (function (state_5441){
var state_val_5442 = (state_5441[(1)]);
if((state_val_5442 === (7))){
var inst_5437 = (state_5441[(2)]);
var state_5441__$1 = state_5441;
var statearr_5443_5470 = state_5441__$1;
(statearr_5443_5470[(2)] = inst_5437);

(statearr_5443_5470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5442 === (1))){
var inst_5404 = (new Array(n));
var inst_5405 = inst_5404;
var inst_5406 = (0);
var state_5441__$1 = (function (){var statearr_5444 = state_5441;
(statearr_5444[(7)] = inst_5405);

(statearr_5444[(8)] = inst_5406);

return statearr_5444;
})();
var statearr_5445_5471 = state_5441__$1;
(statearr_5445_5471[(2)] = null);

(statearr_5445_5471[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5442 === (4))){
var inst_5409 = (state_5441[(9)]);
var inst_5409__$1 = (state_5441[(2)]);
var inst_5410 = (inst_5409__$1 == null);
var inst_5411 = cljs.core.not.call(null,inst_5410);
var state_5441__$1 = (function (){var statearr_5446 = state_5441;
(statearr_5446[(9)] = inst_5409__$1);

return statearr_5446;
})();
if(inst_5411){
var statearr_5447_5472 = state_5441__$1;
(statearr_5447_5472[(1)] = (5));

} else {
var statearr_5448_5473 = state_5441__$1;
(statearr_5448_5473[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5442 === (15))){
var inst_5431 = (state_5441[(2)]);
var state_5441__$1 = state_5441;
var statearr_5449_5474 = state_5441__$1;
(statearr_5449_5474[(2)] = inst_5431);

(statearr_5449_5474[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5442 === (13))){
var state_5441__$1 = state_5441;
var statearr_5450_5475 = state_5441__$1;
(statearr_5450_5475[(2)] = null);

(statearr_5450_5475[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5442 === (6))){
var inst_5406 = (state_5441[(8)]);
var inst_5427 = (inst_5406 > (0));
var state_5441__$1 = state_5441;
if(cljs.core.truth_(inst_5427)){
var statearr_5451_5476 = state_5441__$1;
(statearr_5451_5476[(1)] = (12));

} else {
var statearr_5452_5477 = state_5441__$1;
(statearr_5452_5477[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5442 === (3))){
var inst_5439 = (state_5441[(2)]);
var state_5441__$1 = state_5441;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5441__$1,inst_5439);
} else {
if((state_val_5442 === (12))){
var inst_5405 = (state_5441[(7)]);
var inst_5429 = cljs.core.vec.call(null,inst_5405);
var state_5441__$1 = state_5441;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5441__$1,(15),out,inst_5429);
} else {
if((state_val_5442 === (2))){
var state_5441__$1 = state_5441;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5441__$1,(4),ch);
} else {
if((state_val_5442 === (11))){
var inst_5421 = (state_5441[(2)]);
var inst_5422 = (new Array(n));
var inst_5405 = inst_5422;
var inst_5406 = (0);
var state_5441__$1 = (function (){var statearr_5453 = state_5441;
(statearr_5453[(7)] = inst_5405);

(statearr_5453[(10)] = inst_5421);

(statearr_5453[(8)] = inst_5406);

return statearr_5453;
})();
var statearr_5454_5478 = state_5441__$1;
(statearr_5454_5478[(2)] = null);

(statearr_5454_5478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5442 === (9))){
var inst_5405 = (state_5441[(7)]);
var inst_5419 = cljs.core.vec.call(null,inst_5405);
var state_5441__$1 = state_5441;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5441__$1,(11),out,inst_5419);
} else {
if((state_val_5442 === (5))){
var inst_5405 = (state_5441[(7)]);
var inst_5414 = (state_5441[(11)]);
var inst_5409 = (state_5441[(9)]);
var inst_5406 = (state_5441[(8)]);
var inst_5413 = (inst_5405[inst_5406] = inst_5409);
var inst_5414__$1 = (inst_5406 + (1));
var inst_5415 = (inst_5414__$1 < n);
var state_5441__$1 = (function (){var statearr_5455 = state_5441;
(statearr_5455[(12)] = inst_5413);

(statearr_5455[(11)] = inst_5414__$1);

return statearr_5455;
})();
if(cljs.core.truth_(inst_5415)){
var statearr_5456_5479 = state_5441__$1;
(statearr_5456_5479[(1)] = (8));

} else {
var statearr_5457_5480 = state_5441__$1;
(statearr_5457_5480[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5442 === (14))){
var inst_5434 = (state_5441[(2)]);
var inst_5435 = cljs.core.async.close_BANG_.call(null,out);
var state_5441__$1 = (function (){var statearr_5459 = state_5441;
(statearr_5459[(13)] = inst_5434);

return statearr_5459;
})();
var statearr_5460_5481 = state_5441__$1;
(statearr_5460_5481[(2)] = inst_5435);

(statearr_5460_5481[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5442 === (10))){
var inst_5425 = (state_5441[(2)]);
var state_5441__$1 = state_5441;
var statearr_5461_5482 = state_5441__$1;
(statearr_5461_5482[(2)] = inst_5425);

(statearr_5461_5482[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5442 === (8))){
var inst_5405 = (state_5441[(7)]);
var inst_5414 = (state_5441[(11)]);
var tmp5458 = inst_5405;
var inst_5405__$1 = tmp5458;
var inst_5406 = inst_5414;
var state_5441__$1 = (function (){var statearr_5462 = state_5441;
(statearr_5462[(7)] = inst_5405__$1);

(statearr_5462[(8)] = inst_5406);

return statearr_5462;
})();
var statearr_5463_5483 = state_5441__$1;
(statearr_5463_5483[(2)] = null);

(statearr_5463_5483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3667__auto___5469,out))
;
return ((function (switch__3579__auto__,c__3667__auto___5469,out){
return (function() {
var cljs$core$async$state_machine__3580__auto__ = null;
var cljs$core$async$state_machine__3580__auto____0 = (function (){
var statearr_5464 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_5464[(0)] = cljs$core$async$state_machine__3580__auto__);

(statearr_5464[(1)] = (1));

return statearr_5464;
});
var cljs$core$async$state_machine__3580__auto____1 = (function (state_5441){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_5441);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e5465){if((e5465 instanceof Object)){
var ex__3583__auto__ = e5465;
var statearr_5466_5484 = state_5441;
(statearr_5466_5484[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5441);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e5465;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5485 = state_5441;
state_5441 = G__5485;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$state_machine__3580__auto__ = function(state_5441){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3580__auto____1.call(this,state_5441);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3580__auto____0;
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3580__auto____1;
return cljs$core$async$state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto___5469,out))
})();
var state__3669__auto__ = (function (){var statearr_5467 = f__3668__auto__.call(null);
(statearr_5467[(6)] = c__3667__auto___5469);

return statearr_5467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto___5469,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__5487 = arguments.length;
switch (G__5487) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__3667__auto___5557 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto___5557,out){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto___5557,out){
return (function (state_5529){
var state_val_5530 = (state_5529[(1)]);
if((state_val_5530 === (7))){
var inst_5525 = (state_5529[(2)]);
var state_5529__$1 = state_5529;
var statearr_5531_5558 = state_5529__$1;
(statearr_5531_5558[(2)] = inst_5525);

(statearr_5531_5558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5530 === (1))){
var inst_5488 = [];
var inst_5489 = inst_5488;
var inst_5490 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_5529__$1 = (function (){var statearr_5532 = state_5529;
(statearr_5532[(7)] = inst_5490);

(statearr_5532[(8)] = inst_5489);

return statearr_5532;
})();
var statearr_5533_5559 = state_5529__$1;
(statearr_5533_5559[(2)] = null);

(statearr_5533_5559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5530 === (4))){
var inst_5493 = (state_5529[(9)]);
var inst_5493__$1 = (state_5529[(2)]);
var inst_5494 = (inst_5493__$1 == null);
var inst_5495 = cljs.core.not.call(null,inst_5494);
var state_5529__$1 = (function (){var statearr_5534 = state_5529;
(statearr_5534[(9)] = inst_5493__$1);

return statearr_5534;
})();
if(inst_5495){
var statearr_5535_5560 = state_5529__$1;
(statearr_5535_5560[(1)] = (5));

} else {
var statearr_5536_5561 = state_5529__$1;
(statearr_5536_5561[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5530 === (15))){
var inst_5519 = (state_5529[(2)]);
var state_5529__$1 = state_5529;
var statearr_5537_5562 = state_5529__$1;
(statearr_5537_5562[(2)] = inst_5519);

(statearr_5537_5562[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5530 === (13))){
var state_5529__$1 = state_5529;
var statearr_5538_5563 = state_5529__$1;
(statearr_5538_5563[(2)] = null);

(statearr_5538_5563[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5530 === (6))){
var inst_5489 = (state_5529[(8)]);
var inst_5514 = inst_5489.length;
var inst_5515 = (inst_5514 > (0));
var state_5529__$1 = state_5529;
if(cljs.core.truth_(inst_5515)){
var statearr_5539_5564 = state_5529__$1;
(statearr_5539_5564[(1)] = (12));

} else {
var statearr_5540_5565 = state_5529__$1;
(statearr_5540_5565[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5530 === (3))){
var inst_5527 = (state_5529[(2)]);
var state_5529__$1 = state_5529;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5529__$1,inst_5527);
} else {
if((state_val_5530 === (12))){
var inst_5489 = (state_5529[(8)]);
var inst_5517 = cljs.core.vec.call(null,inst_5489);
var state_5529__$1 = state_5529;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5529__$1,(15),out,inst_5517);
} else {
if((state_val_5530 === (2))){
var state_5529__$1 = state_5529;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5529__$1,(4),ch);
} else {
if((state_val_5530 === (11))){
var inst_5497 = (state_5529[(10)]);
var inst_5493 = (state_5529[(9)]);
var inst_5507 = (state_5529[(2)]);
var inst_5508 = [];
var inst_5509 = inst_5508.push(inst_5493);
var inst_5489 = inst_5508;
var inst_5490 = inst_5497;
var state_5529__$1 = (function (){var statearr_5541 = state_5529;
(statearr_5541[(7)] = inst_5490);

(statearr_5541[(11)] = inst_5507);

(statearr_5541[(8)] = inst_5489);

(statearr_5541[(12)] = inst_5509);

return statearr_5541;
})();
var statearr_5542_5566 = state_5529__$1;
(statearr_5542_5566[(2)] = null);

(statearr_5542_5566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5530 === (9))){
var inst_5489 = (state_5529[(8)]);
var inst_5505 = cljs.core.vec.call(null,inst_5489);
var state_5529__$1 = state_5529;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5529__$1,(11),out,inst_5505);
} else {
if((state_val_5530 === (5))){
var inst_5490 = (state_5529[(7)]);
var inst_5497 = (state_5529[(10)]);
var inst_5493 = (state_5529[(9)]);
var inst_5497__$1 = f.call(null,inst_5493);
var inst_5498 = cljs.core._EQ_.call(null,inst_5497__$1,inst_5490);
var inst_5499 = cljs.core.keyword_identical_QMARK_.call(null,inst_5490,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_5500 = ((inst_5498) || (inst_5499));
var state_5529__$1 = (function (){var statearr_5543 = state_5529;
(statearr_5543[(10)] = inst_5497__$1);

return statearr_5543;
})();
if(cljs.core.truth_(inst_5500)){
var statearr_5544_5567 = state_5529__$1;
(statearr_5544_5567[(1)] = (8));

} else {
var statearr_5545_5568 = state_5529__$1;
(statearr_5545_5568[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5530 === (14))){
var inst_5522 = (state_5529[(2)]);
var inst_5523 = cljs.core.async.close_BANG_.call(null,out);
var state_5529__$1 = (function (){var statearr_5547 = state_5529;
(statearr_5547[(13)] = inst_5522);

return statearr_5547;
})();
var statearr_5548_5569 = state_5529__$1;
(statearr_5548_5569[(2)] = inst_5523);

(statearr_5548_5569[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5530 === (10))){
var inst_5512 = (state_5529[(2)]);
var state_5529__$1 = state_5529;
var statearr_5549_5570 = state_5529__$1;
(statearr_5549_5570[(2)] = inst_5512);

(statearr_5549_5570[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5530 === (8))){
var inst_5497 = (state_5529[(10)]);
var inst_5489 = (state_5529[(8)]);
var inst_5493 = (state_5529[(9)]);
var inst_5502 = inst_5489.push(inst_5493);
var tmp5546 = inst_5489;
var inst_5489__$1 = tmp5546;
var inst_5490 = inst_5497;
var state_5529__$1 = (function (){var statearr_5550 = state_5529;
(statearr_5550[(7)] = inst_5490);

(statearr_5550[(8)] = inst_5489__$1);

(statearr_5550[(14)] = inst_5502);

return statearr_5550;
})();
var statearr_5551_5571 = state_5529__$1;
(statearr_5551_5571[(2)] = null);

(statearr_5551_5571[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3667__auto___5557,out))
;
return ((function (switch__3579__auto__,c__3667__auto___5557,out){
return (function() {
var cljs$core$async$state_machine__3580__auto__ = null;
var cljs$core$async$state_machine__3580__auto____0 = (function (){
var statearr_5552 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_5552[(0)] = cljs$core$async$state_machine__3580__auto__);

(statearr_5552[(1)] = (1));

return statearr_5552;
});
var cljs$core$async$state_machine__3580__auto____1 = (function (state_5529){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_5529);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e5553){if((e5553 instanceof Object)){
var ex__3583__auto__ = e5553;
var statearr_5554_5572 = state_5529;
(statearr_5554_5572[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5529);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e5553;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5573 = state_5529;
state_5529 = G__5573;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
cljs$core$async$state_machine__3580__auto__ = function(state_5529){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3580__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3580__auto____1.call(this,state_5529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3580__auto____0;
cljs$core$async$state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3580__auto____1;
return cljs$core$async$state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto___5557,out))
})();
var state__3669__auto__ = (function (){var statearr_5555 = f__3668__auto__.call(null);
(statearr_5555[(6)] = c__3667__auto___5557);

return statearr_5555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto___5557,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1538054228666
