// Compiled by ClojureScript 1.10.312 {}
goog.provide('csi.core');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.match');
goog.require('cognitect.transit');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
csi.core.Pid = (function (id,pname,__meta,__extmap,__hash){
this.id = id;
this.pname = pname;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
csi.core.Pid.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4190__auto__,k__4191__auto__){
var self__ = this;
var this__4190__auto____$1 = this;
return this__4190__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4191__auto__,null);
});

csi.core.Pid.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4192__auto__,k7035,else__4193__auto__){
var self__ = this;
var this__4192__auto____$1 = this;
var G__7039 = k7035;
var G__7039__$1 = (((G__7039 instanceof cljs.core.Keyword))?G__7039.fqn:null);
switch (G__7039__$1) {
case "id":
return self__.id;

break;
case "pname":
return self__.pname;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k7035,else__4193__auto__);

}
});

csi.core.Pid.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4204__auto__,writer__4205__auto__,opts__4206__auto__){
var self__ = this;
var this__4204__auto____$1 = this;
var pr_pair__4207__auto__ = ((function (this__4204__auto____$1){
return (function (keyval__4208__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4205__auto__,cljs.core.pr_writer,""," ","",opts__4206__auto__,keyval__4208__auto__);
});})(this__4204__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4205__auto__,pr_pair__4207__auto__,"#csi.core.Pid{",", ","}",opts__4206__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pname","pname",175120060),self__.pname],null))], null),self__.__extmap));
});

csi.core.Pid.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__7034){
var self__ = this;
var G__7034__$1 = this;
return (new cljs.core.RecordIter((0),G__7034__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"pname","pname",175120060)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

csi.core.Pid.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4188__auto__){
var self__ = this;
var this__4188__auto____$1 = this;
return self__.__meta;
});

csi.core.Pid.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4185__auto__){
var self__ = this;
var this__4185__auto____$1 = this;
return (new csi.core.Pid(self__.id,self__.pname,self__.__meta,self__.__extmap,self__.__hash));
});

csi.core.Pid.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4194__auto__){
var self__ = this;
var this__4194__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

csi.core.Pid.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4186__auto__){
var self__ = this;
var this__4186__auto____$1 = this;
var h__4048__auto__ = self__.__hash;
if(!((h__4048__auto__ == null))){
return h__4048__auto__;
} else {
var h__4048__auto____$1 = ((function (h__4048__auto__,this__4186__auto____$1){
return (function (coll__4187__auto__){
return (648413407 ^ cljs.core.hash_unordered_coll.call(null,coll__4187__auto__));
});})(h__4048__auto__,this__4186__auto____$1))
.call(null,this__4186__auto____$1);
self__.__hash = h__4048__auto____$1;

return h__4048__auto____$1;
}
});

csi.core.Pid.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this7036,other7037){
var self__ = this;
var this7036__$1 = this;
return ((!((other7037 == null))) && ((this7036__$1.constructor === other7037.constructor)) && (cljs.core._EQ_.call(null,this7036__$1.id,other7037.id)) && (cljs.core._EQ_.call(null,this7036__$1.pname,other7037.pname)) && (cljs.core._EQ_.call(null,this7036__$1.__extmap,other7037.__extmap)));
});

csi.core.Pid.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4199__auto__,k__4200__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"pname","pname",175120060),null], null), null),k__4200__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4199__auto____$1),self__.__meta),k__4200__auto__);
} else {
return (new csi.core.Pid(self__.id,self__.pname,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4200__auto__)),null));
}
});

csi.core.Pid.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4197__auto__,k__4198__auto__,G__7034){
var self__ = this;
var this__4197__auto____$1 = this;
var pred__7040 = cljs.core.keyword_identical_QMARK_;
var expr__7041 = k__4198__auto__;
if(cljs.core.truth_(pred__7040.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__7041))){
return (new csi.core.Pid(G__7034,self__.pname,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__7040.call(null,new cljs.core.Keyword(null,"pname","pname",175120060),expr__7041))){
return (new csi.core.Pid(self__.id,G__7034,self__.__meta,self__.__extmap,null));
} else {
return (new csi.core.Pid(self__.id,self__.pname,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4198__auto__,G__7034),null));
}
}
});

csi.core.Pid.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4202__auto__){
var self__ = this;
var this__4202__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pname","pname",175120060),self__.pname,null))], null),self__.__extmap));
});

csi.core.Pid.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4189__auto__,G__7034){
var self__ = this;
var this__4189__auto____$1 = this;
return (new csi.core.Pid(self__.id,self__.pname,G__7034,self__.__extmap,self__.__hash));
});

csi.core.Pid.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4195__auto__,entry__4196__auto__){
var self__ = this;
var this__4195__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4196__auto__)){
return this__4195__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4196__auto__,(0)),cljs.core._nth.call(null,entry__4196__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4195__auto____$1,entry__4196__auto__);
}
});

csi.core.Pid.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"pname","pname",1815651587,null)], null);
});

csi.core.Pid.cljs$lang$type = true;

csi.core.Pid.cljs$lang$ctorPrSeq = (function (this__4226__auto__){
return (new cljs.core.List(null,"csi.core/Pid",null,(1),null));
});

csi.core.Pid.cljs$lang$ctorPrWriter = (function (this__4226__auto__,writer__4227__auto__){
return cljs.core._write.call(null,writer__4227__auto__,"csi.core/Pid");
});

/**
 * Positional factory function for csi.core/Pid.
 */
csi.core.__GT_Pid = (function csi$core$__GT_Pid(id,pname){
return (new csi.core.Pid(id,pname,null,null,null));
});

/**
 * Factory function for csi.core/Pid, taking a map of keywords to field values.
 */
csi.core.map__GT_Pid = (function csi$core$map__GT_Pid(G__7038){
return (new csi.core.Pid(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__7038),new cljs.core.Keyword(null,"pname","pname",175120060).cljs$core$IFn$_invoke$arity$1(G__7038),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__7038,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"pname","pname",175120060))),null));
});


/**
 * @interface
 */
csi.core.IErlangMBox = function(){};

csi.core.close_BANG_ = (function csi$core$close_BANG_(_){
if(((!((_ == null))) && (!((_.csi$core$IErlangMBox$close_BANG_$arity$1 == null))))){
return _.csi$core$IErlangMBox$close_BANG_$arity$1(_);
} else {
var x__4229__auto__ = (((_ == null))?null:_);
var m__4230__auto__ = (csi.core.close_BANG_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,_);
} else {
var m__4230__auto____$1 = (csi.core.close_BANG_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"IErlangMBox.close!",_);
}
}
}
});

csi.core.cast_BANG_ = (function csi$core$cast_BANG_(_,func,args){
if(((!((_ == null))) && (!((_.csi$core$IErlangMBox$cast_BANG_$arity$3 == null))))){
return _.csi$core$IErlangMBox$cast_BANG_$arity$3(_,func,args);
} else {
var x__4229__auto__ = (((_ == null))?null:_);
var m__4230__auto__ = (csi.core.cast_BANG_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,_,func,args);
} else {
var m__4230__auto____$1 = (csi.core.cast_BANG_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,_,func,args);
} else {
throw cljs.core.missing_protocol.call(null,"IErlangMBox.cast!",_);
}
}
}
});

csi.core.call_BANG_ = (function csi$core$call_BANG_(var_args){
var G__7045 = arguments.length;
switch (G__7045) {
case 3:
return csi.core.call_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return csi.core.call_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

csi.core.call_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (_,func,params){
if(((!((_ == null))) && (!((_.csi$core$IErlangMBox$call_BANG_$arity$3 == null))))){
return _.csi$core$IErlangMBox$call_BANG_$arity$3(_,func,params);
} else {
var x__4229__auto__ = (((_ == null))?null:_);
var m__4230__auto__ = (csi.core.call_BANG_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,_,func,params);
} else {
var m__4230__auto____$1 = (csi.core.call_BANG_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,_,func,params);
} else {
throw cljs.core.missing_protocol.call(null,"IErlangMBox.call!",_);
}
}
}
});

csi.core.call_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (_,func,params,timeout){
if(((!((_ == null))) && (!((_.csi$core$IErlangMBox$call_BANG_$arity$4 == null))))){
return _.csi$core$IErlangMBox$call_BANG_$arity$4(_,func,params,timeout);
} else {
var x__4229__auto__ = (((_ == null))?null:_);
var m__4230__auto__ = (csi.core.call_BANG_[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,_,func,params,timeout);
} else {
var m__4230__auto____$1 = (csi.core.call_BANG_["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,_,func,params,timeout);
} else {
throw cljs.core.missing_protocol.call(null,"IErlangMBox.call!",_);
}
}
}
});

csi.core.call_BANG_.cljs$lang$maxFixedArity = 4;


csi.core.self = (function csi$core$self(_){
if(((!((_ == null))) && (!((_.csi$core$IErlangMBox$self$arity$1 == null))))){
return _.csi$core$IErlangMBox$self$arity$1(_);
} else {
var x__4229__auto__ = (((_ == null))?null:_);
var m__4230__auto__ = (csi.core.self[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,_);
} else {
var m__4230__auto____$1 = (csi.core.self["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"IErlangMBox.self",_);
}
}
}
});

csi.core.exit_reason = (function csi$core$exit_reason(_){
if(((!((_ == null))) && (!((_.csi$core$IErlangMBox$exit_reason$arity$1 == null))))){
return _.csi$core$IErlangMBox$exit_reason$arity$1(_);
} else {
var x__4229__auto__ = (((_ == null))?null:_);
var m__4230__auto__ = (csi.core.exit_reason[goog.typeOf(x__4229__auto__)]);
if(!((m__4230__auto__ == null))){
return m__4230__auto__.call(null,_);
} else {
var m__4230__auto____$1 = (csi.core.exit_reason["_"]);
if(!((m__4230__auto____$1 == null))){
return m__4230__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"IErlangMBox.exit-reason",_);
}
}
}
});

csi.core.transit_reader = cognitect.transit.reader.call(null,new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"handlers","handlers",79528781),new cljs.core.PersistentArrayMap(null, 1, ["pid",(function (p__7047){
var map__7048 = p__7047;
var map__7048__$1 = ((((!((map__7048 == null)))?(((((map__7048.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7048.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7048):map__7048);
var id = cljs.core.get.call(null,map__7048__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var pname = cljs.core.get.call(null,map__7048__$1,new cljs.core.Keyword(null,"pname","pname",175120060));
return csi.core.__GT_Pid.call(null,id,pname);
})], null)], null));
csi.core.transit_writer = cognitect.transit.writer.call(null,new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"handlers","handlers",79528781),cljs.core.PersistentArrayMap.createAsIfByAssoc([csi.core.Pid,cognitect.transit.write_handler.call(null,cljs.core.constantly.call(null,"pid"),(function (p__7050){
var map__7051 = p__7050;
var map__7051__$1 = ((((!((map__7051 == null)))?(((((map__7051.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7051.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7051):map__7051);
var id = cljs.core.get.call(null,map__7051__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var pname = cljs.core.get.call(null,map__7051__$1,new cljs.core.Keyword(null,"pname","pname",175120060));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"pname","pname",175120060),pname], null);
}))])], null));
csi.core.make_ws = (function csi$core$make_ws(url){
var result = cljs.core.async.chan.call(null);
var in$ = cljs.core.async.chan.call(null);
var out = cljs.core.async.chan.call(null);
var ws = (new WebSocket(url));
ws.addEventListener("open",((function (result,in$,out,ws){
return (function (event){
console.debug("websocket :: on open",event);

var c__3667__auto___7084 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto___7084,result,in$,out,ws){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto___7084,result,in$,out,ws){
return (function (state_7067){
var state_val_7068 = (state_7067[(1)]);
if((state_val_7068 === (1))){
var state_7067__$1 = state_7067;
var statearr_7069_7085 = state_7067__$1;
(statearr_7069_7085[(2)] = null);

(statearr_7069_7085[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7068 === (2))){
var state_7067__$1 = state_7067;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7067__$1,(4),in$);
} else {
if((state_val_7068 === (3))){
var inst_7065 = (state_7067[(2)]);
var state_7067__$1 = state_7067;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_7067__$1,inst_7065);
} else {
if((state_val_7068 === (4))){
var inst_7055 = (state_7067[(7)]);
var inst_7055__$1 = (state_7067[(2)]);
var state_7067__$1 = (function (){var statearr_7070 = state_7067;
(statearr_7070[(7)] = inst_7055__$1);

return statearr_7070;
})();
if(cljs.core.truth_(inst_7055__$1)){
var statearr_7071_7086 = state_7067__$1;
(statearr_7071_7086[(1)] = (5));

} else {
var statearr_7072_7087 = state_7067__$1;
(statearr_7072_7087[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7068 === (5))){
var inst_7055 = (state_7067[(7)]);
var inst_7057 = console.debug("ws-channel :: 'in' message, sending to WebSocket",inst_7055);
var inst_7058 = cognitect.transit.write.call(null,csi.core.transit_writer,inst_7055);
var inst_7059 = ws.send(inst_7058);
var state_7067__$1 = (function (){var statearr_7073 = state_7067;
(statearr_7073[(8)] = inst_7057);

(statearr_7073[(9)] = inst_7059);

return statearr_7073;
})();
var statearr_7074_7088 = state_7067__$1;
(statearr_7074_7088[(2)] = null);

(statearr_7074_7088[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7068 === (6))){
var state_7067__$1 = state_7067;
var statearr_7075_7089 = state_7067__$1;
(statearr_7075_7089[(2)] = null);

(statearr_7075_7089[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7068 === (7))){
var inst_7063 = (state_7067[(2)]);
var state_7067__$1 = state_7067;
var statearr_7076_7090 = state_7067__$1;
(statearr_7076_7090[(2)] = inst_7063);

(statearr_7076_7090[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__3667__auto___7084,result,in$,out,ws))
;
return ((function (switch__3579__auto__,c__3667__auto___7084,result,in$,out,ws){
return (function() {
var csi$core$make_ws_$_state_machine__3580__auto__ = null;
var csi$core$make_ws_$_state_machine__3580__auto____0 = (function (){
var statearr_7077 = [null,null,null,null,null,null,null,null,null,null];
(statearr_7077[(0)] = csi$core$make_ws_$_state_machine__3580__auto__);

(statearr_7077[(1)] = (1));

return statearr_7077;
});
var csi$core$make_ws_$_state_machine__3580__auto____1 = (function (state_7067){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_7067);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e7078){if((e7078 instanceof Object)){
var ex__3583__auto__ = e7078;
var statearr_7079_7091 = state_7067;
(statearr_7079_7091[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_7067);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e7078;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__7092 = state_7067;
state_7067 = G__7092;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
csi$core$make_ws_$_state_machine__3580__auto__ = function(state_7067){
switch(arguments.length){
case 0:
return csi$core$make_ws_$_state_machine__3580__auto____0.call(this);
case 1:
return csi$core$make_ws_$_state_machine__3580__auto____1.call(this,state_7067);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
csi$core$make_ws_$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = csi$core$make_ws_$_state_machine__3580__auto____0;
csi$core$make_ws_$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = csi$core$make_ws_$_state_machine__3580__auto____1;
return csi$core$make_ws_$_state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto___7084,result,in$,out,ws))
})();
var state__3669__auto__ = (function (){var statearr_7080 = f__3668__auto__.call(null);
(statearr_7080[(6)] = c__3667__auto___7084);

return statearr_7080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto___7084,result,in$,out,ws))
);


return cljs.core.async.put_BANG_.call(null,result,(function (){
if((typeof csi !== 'undefined') && (typeof csi.core !== 'undefined') && (typeof csi.core.t_csi$core7081 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
csi.core.t_csi$core7081 = (function (url,result,in$,out,ws,event,meta7082){
this.url = url;
this.result = result;
this.in$ = in$;
this.out = out;
this.ws = ws;
this.event = event;
this.meta7082 = meta7082;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
csi.core.t_csi$core7081.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (result,in$,out,ws){
return (function (_7083,meta7082__$1){
var self__ = this;
var _7083__$1 = this;
return (new csi.core.t_csi$core7081(self__.url,self__.result,self__.in$,self__.out,self__.ws,self__.event,meta7082__$1));
});})(result,in$,out,ws))
;

csi.core.t_csi$core7081.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (result,in$,out,ws){
return (function (_7083){
var self__ = this;
var _7083__$1 = this;
return self__.meta7082;
});})(result,in$,out,ws))
;

csi.core.t_csi$core7081.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

csi.core.t_csi$core7081.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = ((function (result,in$,out,ws){
return (function (_){
var self__ = this;
var ___$1 = this;
console.debug("ws-channel :: close requested, closing WebSocket");

return self__.ws.close();
});})(result,in$,out,ws))
;

csi.core.t_csi$core7081.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = ((function (result,in$,out,ws){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core._EQ_.call(null,self__.ws.readyState,(3));
});})(result,in$,out,ws))
;

csi.core.t_csi$core7081.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

csi.core.t_csi$core7081.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = ((function (result,in$,out,ws){
return (function (_,handler){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.out,handler);
});})(result,in$,out,ws))
;

csi.core.t_csi$core7081.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

csi.core.t_csi$core7081.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = ((function (result,in$,out,ws){
return (function (_,val,handler){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.in$,val,handler);
});})(result,in$,out,ws))
;

csi.core.t_csi$core7081.getBasis = ((function (result,in$,out,ws){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"in","in",109346662,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"ws","ws",1727372970,null),new cljs.core.Symbol(null,"event","event",1941966969,null),new cljs.core.Symbol(null,"meta7082","meta7082",-1981531705,null)], null);
});})(result,in$,out,ws))
;

csi.core.t_csi$core7081.cljs$lang$type = true;

csi.core.t_csi$core7081.cljs$lang$ctorStr = "csi.core/t_csi$core7081";

csi.core.t_csi$core7081.cljs$lang$ctorPrWriter = ((function (result,in$,out,ws){
return (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write.call(null,writer__4180__auto__,"csi.core/t_csi$core7081");
});})(result,in$,out,ws))
;

/**
 * Positional factory function for csi.core/t_csi$core7081.
 */
csi.core.__GT_t_csi$core7081 = ((function (result,in$,out,ws){
return (function csi$core$make_ws_$___GT_t_csi$core7081(url__$1,result__$1,in$__$1,out__$1,ws__$1,event__$1,meta7082){
return (new csi.core.t_csi$core7081(url__$1,result__$1,in$__$1,out__$1,ws__$1,event__$1,meta7082));
});})(result,in$,out,ws))
;

}

return (new csi.core.t_csi$core7081(url,result,in$,out,ws,event,cljs.core.PersistentArrayMap.EMPTY));
})()
);
});})(result,in$,out,ws))
);

ws.addEventListener("close",((function (result,in$,out,ws){
return (function (event){
console.debug("websocket :: on close, closing channels",event);

cljs.core.async.close_BANG_.call(null,in$);

return cljs.core.async.close_BANG_.call(null,out);
});})(result,in$,out,ws))
);

ws.addEventListener("message",((function (result,in$,out,ws){
return (function (message){
console.debug("websocket :: on message",message);

return cljs.core.async.put_BANG_.call(null,out,cognitect.transit.read.call(null,csi.core.transit_reader,message.data));
});})(result,in$,out,ws))
);

return result;
});
csi.core.make_mbox = (function csi$core$make_mbox(pid,ws){
var out = cljs.core.async.chan.call(null);
var exit_reason = cljs.core.atom.call(null,null);
var counter = cljs.core.atom.call(null,(0));
var returns = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var terminate_BANG_ = ((function (out,exit_reason,counter,returns){
return (function (reason){
if(cljs.core.truth_(cljs.core.deref.call(null,exit_reason))){
} else {
cljs.core.reset_BANG_.call(null,exit_reason,reason);
}

cljs.core.async.close_BANG_.call(null,out);

var seq__7093 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,returns)));
var chunk__7094 = null;
var count__7095 = (0);
var i__7096 = (0);
while(true){
if((i__7096 < count__7095)){
var return$ = cljs.core._nth.call(null,chunk__7094,i__7096);
cljs.core.async.close_BANG_.call(null,return$);


var G__7379 = seq__7093;
var G__7380 = chunk__7094;
var G__7381 = count__7095;
var G__7382 = (i__7096 + (1));
seq__7093 = G__7379;
chunk__7094 = G__7380;
count__7095 = G__7381;
i__7096 = G__7382;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__7093);
if(temp__4657__auto__){
var seq__7093__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7093__$1)){
var c__4337__auto__ = cljs.core.chunk_first.call(null,seq__7093__$1);
var G__7383 = cljs.core.chunk_rest.call(null,seq__7093__$1);
var G__7384 = c__4337__auto__;
var G__7385 = cljs.core.count.call(null,c__4337__auto__);
var G__7386 = (0);
seq__7093 = G__7383;
chunk__7094 = G__7384;
count__7095 = G__7385;
i__7096 = G__7386;
continue;
} else {
var return$ = cljs.core.first.call(null,seq__7093__$1);
cljs.core.async.close_BANG_.call(null,return$);


var G__7387 = cljs.core.next.call(null,seq__7093__$1);
var G__7388 = null;
var G__7389 = (0);
var G__7390 = (0);
seq__7093 = G__7387;
chunk__7094 = G__7388;
count__7095 = G__7389;
i__7096 = G__7390;
continue;
}
} else {
return null;
}
}
break;
}
});})(out,exit_reason,counter,returns))
;
var c__3667__auto___7391 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto___7391,out,exit_reason,counter,returns,terminate_BANG_){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto___7391,out,exit_reason,counter,returns,terminate_BANG_){
return (function (state_7253){
var state_val_7254 = (state_7253[(1)]);
if((state_val_7254 === (7))){
var inst_7249 = (state_7253[(2)]);
var state_7253__$1 = state_7253;
var statearr_7255_7392 = state_7253__$1;
(statearr_7255_7392[(2)] = inst_7249);

(statearr_7255_7392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (59))){
var inst_7109 = (state_7253[(7)]);
var inst_7232 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_7109)].join('');
var inst_7233 = (new Error(inst_7232));
var inst_7234 = (function(){throw inst_7233})();
var state_7253__$1 = state_7253;
var statearr_7256_7393 = state_7253__$1;
(statearr_7256_7393[(2)] = inst_7234);

(statearr_7256_7393[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (20))){
var inst_7109 = (state_7253[(7)]);
var inst_7134 = cljs.core.nth.call(null,inst_7109,(1));
var inst_7135 = ["mbox :: message, payload=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_7134)].join('');
var inst_7136 = console.debug(inst_7135);
var state_7253__$1 = (function (){var statearr_7257 = state_7253;
(statearr_7257[(8)] = inst_7136);

return statearr_7257;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_7253__$1,(23),out,inst_7134);
} else {
if((state_val_7254 === (58))){
var inst_7227 = (state_7253[(2)]);
var state_7253__$1 = state_7253;
var statearr_7258_7394 = state_7253__$1;
(statearr_7258_7394[(2)] = inst_7227);

(statearr_7258_7394[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (60))){
var state_7253__$1 = state_7253;
var statearr_7259_7395 = state_7253__$1;
(statearr_7259_7395[(2)] = null);

(statearr_7259_7395[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (27))){
var inst_7109 = (state_7253[(7)]);
var inst_7147 = cljs.core.nth.call(null,inst_7109,(0));
var inst_7148 = cljs.core.keyword_identical_QMARK_.call(null,inst_7147,new cljs.core.Keyword("otplike.csi.core","return","otplike.csi.core/return",-1827025081));
var state_7253__$1 = state_7253;
if(inst_7148){
var statearr_7260_7396 = state_7253__$1;
(statearr_7260_7396[(1)] = (30));

} else {
var statearr_7261_7397 = state_7253__$1;
(statearr_7261_7397[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (1))){
var state_7253__$1 = state_7253;
var statearr_7262_7398 = state_7253__$1;
(statearr_7262_7398[(2)] = null);

(statearr_7262_7398[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (24))){
var inst_7109 = (state_7253[(7)]);
var inst_7142 = cljs.core.vector_QMARK_.call(null,inst_7109);
var inst_7143 = cljs.core.count.call(null,inst_7109);
var inst_7144 = (inst_7143 === 3);
var inst_7145 = ((inst_7142) && (inst_7144));
var state_7253__$1 = state_7253;
if(cljs.core.truth_(inst_7145)){
var statearr_7263_7399 = state_7253__$1;
(statearr_7263_7399[(1)] = (27));

} else {
var statearr_7264_7400 = state_7253__$1;
(statearr_7264_7400[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (55))){
var inst_7210 = (state_7253[(9)]);
var inst_7214 = (state_7253[(2)]);
var inst_7215 = cljs.core.async.close_BANG_.call(null,inst_7210);
var state_7253__$1 = (function (){var statearr_7265 = state_7253;
(statearr_7265[(10)] = inst_7214);

return statearr_7265;
})();
var statearr_7266_7401 = state_7253__$1;
(statearr_7266_7401[(2)] = inst_7215);

(statearr_7266_7401[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (39))){
var inst_7172 = (state_7253[(2)]);
var state_7253__$1 = state_7253;
var statearr_7267_7402 = state_7253__$1;
(statearr_7267_7402[(2)] = inst_7172);

(statearr_7267_7402[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (46))){
var inst_7109 = (state_7253[(7)]);
var inst_7202 = cljs.core.nth.call(null,inst_7109,(0));
var inst_7203 = cljs.core.keyword_identical_QMARK_.call(null,inst_7202,new cljs.core.Keyword("otplike.csi.core","return","otplike.csi.core/return",-1827025081));
var state_7253__$1 = state_7253;
if(inst_7203){
var statearr_7268_7403 = state_7253__$1;
(statearr_7268_7403[(1)] = (49));

} else {
var statearr_7269_7404 = state_7253__$1;
(statearr_7269_7404[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (4))){
var inst_7109 = (state_7253[(7)]);
var inst_7109__$1 = (state_7253[(2)]);
var inst_7110 = (inst_7109__$1 === null);
var state_7253__$1 = (function (){var statearr_7270 = state_7253;
(statearr_7270[(7)] = inst_7109__$1);

return statearr_7270;
})();
if(cljs.core.truth_(inst_7110)){
var statearr_7271_7405 = state_7253__$1;
(statearr_7271_7405[(1)] = (5));

} else {
var statearr_7272_7406 = state_7253__$1;
(statearr_7272_7406[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (54))){
var inst_7218 = (state_7253[(2)]);
var state_7253__$1 = (function (){var statearr_7273 = state_7253;
(statearr_7273[(11)] = inst_7218);

return statearr_7273;
})();
var statearr_7274_7407 = state_7253__$1;
(statearr_7274_7407[(2)] = null);

(statearr_7274_7407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (15))){
var state_7253__$1 = state_7253;
var statearr_7275_7408 = state_7253__$1;
(statearr_7275_7408[(1)] = (17));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (48))){
var inst_7239 = (state_7253[(2)]);
var state_7253__$1 = state_7253;
var statearr_7277_7409 = state_7253__$1;
(statearr_7277_7409[(2)] = inst_7239);

(statearr_7277_7409[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (50))){
var state_7253__$1 = state_7253;
var statearr_7278_7410 = state_7253__$1;
(statearr_7278_7410[(1)] = (56));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (21))){
var state_7253__$1 = state_7253;
var statearr_7280_7411 = state_7253__$1;
(statearr_7280_7411[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (31))){
var state_7253__$1 = state_7253;
var statearr_7282_7412 = state_7253__$1;
(statearr_7282_7412[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (32))){
var inst_7174 = (state_7253[(2)]);
var state_7253__$1 = state_7253;
var statearr_7284_7413 = state_7253__$1;
(statearr_7284_7413[(2)] = inst_7174);

(statearr_7284_7413[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (40))){
var inst_7109 = (state_7253[(7)]);
var inst_7177 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_7109)].join('');
var inst_7178 = (new Error(inst_7177));
var inst_7179 = (function(){throw inst_7178})();
var state_7253__$1 = state_7253;
var statearr_7285_7414 = state_7253__$1;
(statearr_7285_7414[(2)] = inst_7179);

(statearr_7285_7414[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (56))){
var inst_7109 = (state_7253[(7)]);
var inst_7222 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_7109)].join('');
var inst_7223 = (new Error(inst_7222));
var inst_7224 = (function(){throw inst_7223})();
var state_7253__$1 = state_7253;
var statearr_7286_7415 = state_7253__$1;
(statearr_7286_7415[(2)] = inst_7224);

(statearr_7286_7415[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (33))){
var inst_7155 = (state_7253[(12)]);
var inst_7151 = (state_7253[(13)]);
var inst_7150 = (state_7253[(14)]);
var inst_7157 = cljs.core.swap_BANG_.call(null,returns,cljs.core.dissoc,inst_7151);
var state_7253__$1 = (function (){var statearr_7287 = state_7253;
(statearr_7287[(15)] = inst_7157);

return statearr_7287;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_7253__$1,(36),inst_7155,inst_7150);
} else {
if((state_val_7254 === (13))){
var inst_7244 = (state_7253[(2)]);
var state_7253__$1 = state_7253;
var statearr_7288_7416 = state_7253__$1;
(statearr_7288_7416[(2)] = inst_7244);

(statearr_7288_7416[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (22))){
var inst_7189 = (state_7253[(2)]);
var state_7253__$1 = state_7253;
var statearr_7289_7417 = state_7253__$1;
(statearr_7289_7417[(2)] = inst_7189);

(statearr_7289_7417[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (36))){
var inst_7155 = (state_7253[(12)]);
var inst_7159 = (state_7253[(2)]);
var inst_7160 = cljs.core.async.close_BANG_.call(null,inst_7155);
var state_7253__$1 = (function (){var statearr_7290 = state_7253;
(statearr_7290[(16)] = inst_7159);

return statearr_7290;
})();
var statearr_7291_7418 = state_7253__$1;
(statearr_7291_7418[(2)] = inst_7160);

(statearr_7291_7418[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (41))){
var state_7253__$1 = state_7253;
var statearr_7292_7419 = state_7253__$1;
(statearr_7292_7419[(2)] = null);

(statearr_7292_7419[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (43))){
var inst_7109 = (state_7253[(7)]);
var inst_7197 = cljs.core.vector_QMARK_.call(null,inst_7109);
var inst_7198 = cljs.core.count.call(null,inst_7109);
var inst_7199 = (inst_7198 === 3);
var inst_7200 = ((inst_7197) && (inst_7199));
var state_7253__$1 = state_7253;
if(cljs.core.truth_(inst_7200)){
var statearr_7293_7420 = state_7253__$1;
(statearr_7293_7420[(1)] = (46));

} else {
var statearr_7294_7421 = state_7253__$1;
(statearr_7294_7421[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (61))){
var inst_7237 = (state_7253[(2)]);
var state_7253__$1 = state_7253;
var statearr_7295_7422 = state_7253__$1;
(statearr_7295_7422[(2)] = inst_7237);

(statearr_7295_7422[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (29))){
var inst_7184 = (state_7253[(2)]);
var state_7253__$1 = state_7253;
var statearr_7296_7423 = state_7253__$1;
(statearr_7296_7423[(2)] = inst_7184);

(statearr_7296_7423[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (44))){
var state_7253__$1 = state_7253;
var statearr_7297_7424 = state_7253__$1;
(statearr_7297_7424[(2)] = null);

(statearr_7297_7424[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (6))){
var state_7253__$1 = state_7253;
var statearr_7298_7425 = state_7253__$1;
(statearr_7298_7425[(1)] = (8));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (28))){
var state_7253__$1 = state_7253;
var statearr_7300_7426 = state_7253__$1;
(statearr_7300_7426[(1)] = (40));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (51))){
var inst_7229 = (state_7253[(2)]);
var state_7253__$1 = state_7253;
var statearr_7302_7427 = state_7253__$1;
(statearr_7302_7427[(2)] = inst_7229);

(statearr_7302_7427[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (25))){
var state_7253__$1 = state_7253;
var statearr_7303_7428 = state_7253__$1;
(statearr_7303_7428[(2)] = null);

(statearr_7303_7428[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (34))){
var state_7253__$1 = state_7253;
var statearr_7304_7429 = state_7253__$1;
(statearr_7304_7429[(2)] = null);

(statearr_7304_7429[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (17))){
var inst_7109 = (state_7253[(7)]);
var inst_7131 = cljs.core.nth.call(null,inst_7109,(0));
var inst_7132 = cljs.core.keyword_identical_QMARK_.call(null,inst_7131,new cljs.core.Keyword("otplike.csi.core","message","otplike.csi.core/message",-337368482));
var state_7253__$1 = state_7253;
if(inst_7132){
var statearr_7305_7430 = state_7253__$1;
(statearr_7305_7430[(1)] = (20));

} else {
var statearr_7306_7431 = state_7253__$1;
(statearr_7306_7431[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (3))){
var inst_7251 = (state_7253[(2)]);
var state_7253__$1 = state_7253;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_7253__$1,inst_7251);
} else {
if((state_val_7254 === (12))){
var state_7253__$1 = state_7253;
var statearr_7307_7432 = state_7253__$1;
(statearr_7307_7432[(1)] = (43));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (2))){
var state_7253__$1 = state_7253;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7253__$1,(4),ws);
} else {
if((state_val_7254 === (23))){
var inst_7138 = (state_7253[(2)]);
var state_7253__$1 = (function (){var statearr_7309 = state_7253;
(statearr_7309[(17)] = inst_7138);

return statearr_7309;
})();
var statearr_7310_7433 = state_7253__$1;
(statearr_7310_7433[(2)] = null);

(statearr_7310_7433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (47))){
var state_7253__$1 = state_7253;
var statearr_7311_7434 = state_7253__$1;
(statearr_7311_7434[(1)] = (59));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (35))){
var inst_7163 = (state_7253[(2)]);
var state_7253__$1 = (function (){var statearr_7313 = state_7253;
(statearr_7313[(18)] = inst_7163);

return statearr_7313;
})();
var statearr_7314_7435 = state_7253__$1;
(statearr_7314_7435[(2)] = null);

(statearr_7314_7435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (19))){
var inst_7192 = (state_7253[(2)]);
var state_7253__$1 = state_7253;
var statearr_7315_7436 = state_7253__$1;
(statearr_7315_7436[(2)] = inst_7192);

(statearr_7315_7436[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (57))){
var state_7253__$1 = state_7253;
var statearr_7316_7437 = state_7253__$1;
(statearr_7316_7437[(2)] = null);

(statearr_7316_7437[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (11))){
var inst_7109 = (state_7253[(7)]);
var inst_7122 = cljs.core.nth.call(null,inst_7109,(0));
var inst_7123 = cljs.core.keyword_identical_QMARK_.call(null,inst_7122,new cljs.core.Keyword("otplike.csi.core","exit","otplike.csi.core/exit",420540614));
var state_7253__$1 = state_7253;
if(inst_7123){
var statearr_7317_7438 = state_7253__$1;
(statearr_7317_7438[(1)] = (14));

} else {
var statearr_7318_7439 = state_7253__$1;
(statearr_7318_7439[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (9))){
var state_7253__$1 = state_7253;
var statearr_7319_7440 = state_7253__$1;
(statearr_7319_7440[(2)] = null);

(statearr_7319_7440[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (5))){
var inst_7112 = ["mbox :: disconnect"].join('');
var inst_7113 = console.debug(inst_7112);
var inst_7114 = terminate_BANG_.call(null,new cljs.core.Keyword(null,"disconnected","disconnected",-1908014586));
var state_7253__$1 = (function (){var statearr_7320 = state_7253;
(statearr_7320[(19)] = inst_7113);

return statearr_7320;
})();
var statearr_7321_7441 = state_7253__$1;
(statearr_7321_7441[(2)] = inst_7114);

(statearr_7321_7441[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (14))){
var inst_7109 = (state_7253[(7)]);
var inst_7125 = cljs.core.nth.call(null,inst_7109,(1));
var inst_7126 = ["mbox :: exit, reason=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_7125)].join('');
var inst_7127 = console.debug(inst_7126);
var inst_7128 = terminate_BANG_.call(null,inst_7125);
var state_7253__$1 = (function (){var statearr_7322 = state_7253;
(statearr_7322[(20)] = inst_7127);

return statearr_7322;
})();
var statearr_7323_7442 = state_7253__$1;
(statearr_7323_7442[(2)] = inst_7128);

(statearr_7323_7442[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (45))){
var inst_7242 = (state_7253[(2)]);
var state_7253__$1 = state_7253;
var statearr_7324_7443 = state_7253__$1;
(statearr_7324_7443[(2)] = inst_7242);

(statearr_7324_7443[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (53))){
var state_7253__$1 = state_7253;
var statearr_7325_7444 = state_7253__$1;
(statearr_7325_7444[(2)] = null);

(statearr_7325_7444[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (26))){
var inst_7187 = (state_7253[(2)]);
var state_7253__$1 = state_7253;
var statearr_7326_7445 = state_7253__$1;
(statearr_7326_7445[(2)] = inst_7187);

(statearr_7326_7445[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (16))){
var inst_7194 = (state_7253[(2)]);
var state_7253__$1 = state_7253;
var statearr_7327_7446 = state_7253__$1;
(statearr_7327_7446[(2)] = inst_7194);

(statearr_7327_7446[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (38))){
var state_7253__$1 = state_7253;
var statearr_7328_7447 = state_7253__$1;
(statearr_7328_7447[(2)] = null);

(statearr_7328_7447[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (30))){
var inst_7109 = (state_7253[(7)]);
var inst_7155 = (state_7253[(12)]);
var inst_7151 = (state_7253[(13)]);
var inst_7150 = (state_7253[(14)]);
var inst_7150__$1 = cljs.core.nth.call(null,inst_7109,(1));
var inst_7151__$1 = cljs.core.nth.call(null,inst_7109,(2));
var inst_7152 = ["mbox :: return, correlation=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_7151__$1),", value=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_7150__$1)].join('');
var inst_7153 = console.debug(inst_7152);
var inst_7154 = cljs.core.deref.call(null,returns);
var inst_7155__$1 = cljs.core.get.call(null,inst_7154,inst_7151__$1);
var state_7253__$1 = (function (){var statearr_7329 = state_7253;
(statearr_7329[(12)] = inst_7155__$1);

(statearr_7329[(13)] = inst_7151__$1);

(statearr_7329[(14)] = inst_7150__$1);

(statearr_7329[(21)] = inst_7153);

return statearr_7329;
})();
if(cljs.core.truth_(inst_7155__$1)){
var statearr_7330_7448 = state_7253__$1;
(statearr_7330_7448[(1)] = (33));

} else {
var statearr_7331_7449 = state_7253__$1;
(statearr_7331_7449[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (10))){
var inst_7247 = (state_7253[(2)]);
var state_7253__$1 = state_7253;
var statearr_7332_7450 = state_7253__$1;
(statearr_7332_7450[(2)] = inst_7247);

(statearr_7332_7450[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (18))){
var state_7253__$1 = state_7253;
var statearr_7333_7451 = state_7253__$1;
(statearr_7333_7451[(2)] = null);

(statearr_7333_7451[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (52))){
var inst_7206 = (state_7253[(22)]);
var inst_7210 = (state_7253[(9)]);
var inst_7205 = (state_7253[(23)]);
var inst_7212 = cljs.core.swap_BANG_.call(null,returns,cljs.core.dissoc,inst_7206);
var state_7253__$1 = (function (){var statearr_7334 = state_7253;
(statearr_7334[(24)] = inst_7212);

return statearr_7334;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_7253__$1,(55),inst_7210,inst_7205);
} else {
if((state_val_7254 === (42))){
var inst_7182 = (state_7253[(2)]);
var state_7253__$1 = state_7253;
var statearr_7335_7452 = state_7253__$1;
(statearr_7335_7452[(2)] = inst_7182);

(statearr_7335_7452[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (37))){
var inst_7109 = (state_7253[(7)]);
var inst_7167 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_7109)].join('');
var inst_7168 = (new Error(inst_7167));
var inst_7169 = (function(){throw inst_7168})();
var state_7253__$1 = state_7253;
var statearr_7336_7453 = state_7253__$1;
(statearr_7336_7453[(2)] = inst_7169);

(statearr_7336_7453[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (8))){
var inst_7109 = (state_7253[(7)]);
var inst_7117 = cljs.core.vector_QMARK_.call(null,inst_7109);
var inst_7118 = cljs.core.count.call(null,inst_7109);
var inst_7119 = (inst_7118 === 2);
var inst_7120 = ((inst_7117) && (inst_7119));
var state_7253__$1 = state_7253;
if(cljs.core.truth_(inst_7120)){
var statearr_7337_7454 = state_7253__$1;
(statearr_7337_7454[(1)] = (11));

} else {
var statearr_7338_7455 = state_7253__$1;
(statearr_7338_7455[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7254 === (49))){
var inst_7109 = (state_7253[(7)]);
var inst_7206 = (state_7253[(22)]);
var inst_7210 = (state_7253[(9)]);
var inst_7205 = (state_7253[(23)]);
var inst_7205__$1 = cljs.core.nth.call(null,inst_7109,(1));
var inst_7206__$1 = cljs.core.nth.call(null,inst_7109,(2));
var inst_7207 = ["mbox :: return, correlation=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_7206__$1),", value=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_7205__$1)].join('');
var inst_7208 = console.debug(inst_7207);
var inst_7209 = cljs.core.deref.call(null,returns);
var inst_7210__$1 = cljs.core.get.call(null,inst_7209,inst_7206__$1);
var state_7253__$1 = (function (){var statearr_7339 = state_7253;
(statearr_7339[(22)] = inst_7206__$1);

(statearr_7339[(9)] = inst_7210__$1);

(statearr_7339[(25)] = inst_7208);

(statearr_7339[(23)] = inst_7205__$1);

return statearr_7339;
})();
if(cljs.core.truth_(inst_7210__$1)){
var statearr_7340_7456 = state_7253__$1;
(statearr_7340_7456[(1)] = (52));

} else {
var statearr_7341_7457 = state_7253__$1;
(statearr_7341_7457[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3667__auto___7391,out,exit_reason,counter,returns,terminate_BANG_))
;
return ((function (switch__3579__auto__,c__3667__auto___7391,out,exit_reason,counter,returns,terminate_BANG_){
return (function() {
var csi$core$make_mbox_$_state_machine__3580__auto__ = null;
var csi$core$make_mbox_$_state_machine__3580__auto____0 = (function (){
var statearr_7342 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_7342[(0)] = csi$core$make_mbox_$_state_machine__3580__auto__);

(statearr_7342[(1)] = (1));

return statearr_7342;
});
var csi$core$make_mbox_$_state_machine__3580__auto____1 = (function (state_7253){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_7253);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e7343){if((e7343 instanceof Object)){
var ex__3583__auto__ = e7343;
var statearr_7344_7458 = state_7253;
(statearr_7344_7458[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_7253);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e7343;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__7459 = state_7253;
state_7253 = G__7459;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
csi$core$make_mbox_$_state_machine__3580__auto__ = function(state_7253){
switch(arguments.length){
case 0:
return csi$core$make_mbox_$_state_machine__3580__auto____0.call(this);
case 1:
return csi$core$make_mbox_$_state_machine__3580__auto____1.call(this,state_7253);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
csi$core$make_mbox_$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = csi$core$make_mbox_$_state_machine__3580__auto____0;
csi$core$make_mbox_$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = csi$core$make_mbox_$_state_machine__3580__auto____1;
return csi$core$make_mbox_$_state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto___7391,out,exit_reason,counter,returns,terminate_BANG_))
})();
var state__3669__auto__ = (function (){var statearr_7345 = f__3668__auto__.call(null);
(statearr_7345[(6)] = c__3667__auto___7391);

return statearr_7345;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto___7391,out,exit_reason,counter,returns,terminate_BANG_))
);


if((typeof csi !== 'undefined') && (typeof csi.core !== 'undefined') && (typeof csi.core.t_csi$core7346 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {csi.core.IErlangMBox}
 * @implements {cljs.core.IWithMeta}
*/
csi.core.t_csi$core7346 = (function (pid,ws,out,exit_reason,counter,returns,terminate_BANG_,meta7347){
this.pid = pid;
this.ws = ws;
this.out = out;
this.exit_reason = exit_reason;
this.counter = counter;
this.returns = returns;
this.terminate_BANG_ = terminate_BANG_;
this.meta7347 = meta7347;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
csi.core.t_csi$core7346.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (out,exit_reason,counter,returns,terminate_BANG_){
return (function (_7348,meta7347__$1){
var self__ = this;
var _7348__$1 = this;
return (new csi.core.t_csi$core7346(self__.pid,self__.ws,self__.out,self__.exit_reason,self__.counter,self__.returns,self__.terminate_BANG_,meta7347__$1));
});})(out,exit_reason,counter,returns,terminate_BANG_))
;

csi.core.t_csi$core7346.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (out,exit_reason,counter,returns,terminate_BANG_){
return (function (_7348){
var self__ = this;
var _7348__$1 = this;
return self__.meta7347;
});})(out,exit_reason,counter,returns,terminate_BANG_))
;

csi.core.t_csi$core7346.prototype.csi$core$IErlangMBox$ = cljs.core.PROTOCOL_SENTINEL;

csi.core.t_csi$core7346.prototype.csi$core$IErlangMBox$close_BANG_$arity$1 = ((function (out,exit_reason,counter,returns,terminate_BANG_){
return (function (_){
var self__ = this;
var ___$1 = this;
console.debug("mbox :: close requested, closing ws-channel");

cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ws);

return null;
});})(out,exit_reason,counter,returns,terminate_BANG_))
;

csi.core.t_csi$core7346.prototype.csi$core$IErlangMBox$cast_BANG_$arity$3 = ((function (out,exit_reason,counter,returns,terminate_BANG_){
return (function (_,func,args){
var self__ = this;
var ___$1 = this;
cljs.core.async.put_BANG_.call(null,self__.ws,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("otplike.csi.core","cast","otplike.csi.core/cast",-1694441655),func,args], null));

return null;
});})(out,exit_reason,counter,returns,terminate_BANG_))
;

csi.core.t_csi$core7346.prototype.csi$core$IErlangMBox$call_BANG_$arity$3 = ((function (out,exit_reason,counter,returns,terminate_BANG_){
return (function (this$,func,args){
var self__ = this;
var this$__$1 = this;
return csi.core.call_BANG_.call(null,this$__$1,func,args,(5000));
});})(out,exit_reason,counter,returns,terminate_BANG_))
;

csi.core.t_csi$core7346.prototype.csi$core$IErlangMBox$call_BANG_$arity$4 = ((function (out,exit_reason,counter,returns,terminate_BANG_){
return (function (this$,func,args,timeout){
var self__ = this;
var this$__$1 = this;
var correlation = cljs.core.swap_BANG_.call(null,self__.counter,cljs.core.inc);
var return$ = cljs.core.async.chan.call(null);
cljs.core.swap_BANG_.call(null,self__.returns,cljs.core.assoc,correlation,return$);

var c__3667__auto___7460 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto___7460,correlation,return$,this$__$1,out,exit_reason,counter,returns,terminate_BANG_){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto___7460,correlation,return$,this$__$1,out,exit_reason,counter,returns,terminate_BANG_){
return (function (state_7367){
var state_val_7368 = (state_7367[(1)]);
if((state_val_7368 === (1))){
var inst_7349 = cljs.core.async.timeout.call(null,timeout);
var state_7367__$1 = state_7367;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7367__$1,(2),inst_7349);
} else {
if((state_val_7368 === (2))){
var inst_7351 = (state_7367[(2)]);
var inst_7352 = cljs.core.deref.call(null,self__.returns);
var inst_7353 = cljs.core.get.call(null,inst_7352,correlation);
var state_7367__$1 = (function (){var statearr_7369 = state_7367;
(statearr_7369[(7)] = inst_7351);

return statearr_7369;
})();
if(cljs.core.truth_(inst_7353)){
var statearr_7370_7461 = state_7367__$1;
(statearr_7370_7461[(1)] = (3));

} else {
var statearr_7371_7462 = state_7367__$1;
(statearr_7371_7462[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7368 === (3))){
var inst_7355 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_7356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_7357 = [func,args];
var inst_7358 = (new cljs.core.PersistentVector(null,2,(5),inst_7356,inst_7357,null));
var inst_7359 = [new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_7358,timeout];
var inst_7360 = (new cljs.core.PersistentVector(null,3,(5),inst_7355,inst_7359,null));
var inst_7361 = self__.terminate_BANG_.call(null,inst_7360);
var inst_7362 = csi.core.close_BANG_.call(null,this$__$1);
var state_7367__$1 = (function (){var statearr_7372 = state_7367;
(statearr_7372[(8)] = inst_7361);

return statearr_7372;
})();
var statearr_7373_7463 = state_7367__$1;
(statearr_7373_7463[(2)] = inst_7362);

(statearr_7373_7463[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7368 === (4))){
var state_7367__$1 = state_7367;
var statearr_7374_7464 = state_7367__$1;
(statearr_7374_7464[(2)] = null);

(statearr_7374_7464[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7368 === (5))){
var inst_7365 = (state_7367[(2)]);
var state_7367__$1 = state_7367;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_7367__$1,inst_7365);
} else {
return null;
}
}
}
}
}
});})(c__3667__auto___7460,correlation,return$,this$__$1,out,exit_reason,counter,returns,terminate_BANG_))
;
return ((function (switch__3579__auto__,c__3667__auto___7460,correlation,return$,this$__$1,out,exit_reason,counter,returns,terminate_BANG_){
return (function() {
var csi$core$make_mbox_$_state_machine__3580__auto__ = null;
var csi$core$make_mbox_$_state_machine__3580__auto____0 = (function (){
var statearr_7375 = [null,null,null,null,null,null,null,null,null];
(statearr_7375[(0)] = csi$core$make_mbox_$_state_machine__3580__auto__);

(statearr_7375[(1)] = (1));

return statearr_7375;
});
var csi$core$make_mbox_$_state_machine__3580__auto____1 = (function (state_7367){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_7367);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e7376){if((e7376 instanceof Object)){
var ex__3583__auto__ = e7376;
var statearr_7377_7465 = state_7367;
(statearr_7377_7465[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_7367);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e7376;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__7466 = state_7367;
state_7367 = G__7466;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
csi$core$make_mbox_$_state_machine__3580__auto__ = function(state_7367){
switch(arguments.length){
case 0:
return csi$core$make_mbox_$_state_machine__3580__auto____0.call(this);
case 1:
return csi$core$make_mbox_$_state_machine__3580__auto____1.call(this,state_7367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
csi$core$make_mbox_$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = csi$core$make_mbox_$_state_machine__3580__auto____0;
csi$core$make_mbox_$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = csi$core$make_mbox_$_state_machine__3580__auto____1;
return csi$core$make_mbox_$_state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto___7460,correlation,return$,this$__$1,out,exit_reason,counter,returns,terminate_BANG_))
})();
var state__3669__auto__ = (function (){var statearr_7378 = f__3668__auto__.call(null);
(statearr_7378[(6)] = c__3667__auto___7460);

return statearr_7378;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto___7460,correlation,return$,this$__$1,out,exit_reason,counter,returns,terminate_BANG_))
);


cljs.core.async.put_BANG_.call(null,self__.ws,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("otplike.csi.core","call","otplike.csi.core/call",-452421594),func,args,correlation], null));

return return$;
});})(out,exit_reason,counter,returns,terminate_BANG_))
;

csi.core.t_csi$core7346.prototype.csi$core$IErlangMBox$self$arity$1 = ((function (out,exit_reason,counter,returns,terminate_BANG_){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.pid;
});})(out,exit_reason,counter,returns,terminate_BANG_))
;

csi.core.t_csi$core7346.prototype.csi$core$IErlangMBox$exit_reason$arity$1 = ((function (out,exit_reason,counter,returns,terminate_BANG_){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.exit_reason);
});})(out,exit_reason,counter,returns,terminate_BANG_))
;

csi.core.t_csi$core7346.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

csi.core.t_csi$core7346.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = ((function (out,exit_reason,counter,returns,terminate_BANG_){
return (function (_,handler){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.out,handler);
});})(out,exit_reason,counter,returns,terminate_BANG_))
;

csi.core.t_csi$core7346.getBasis = ((function (out,exit_reason,counter,returns,terminate_BANG_){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pid","pid",-1636048071,null),new cljs.core.Symbol(null,"ws","ws",1727372970,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"exit-reason","exit-reason",-1766999710,null),new cljs.core.Symbol(null,"counter","counter",-1850427592,null),new cljs.core.Symbol(null,"returns","returns",1025078949,null),new cljs.core.Symbol(null,"terminate!","terminate!",1667550856,null),new cljs.core.Symbol(null,"meta7347","meta7347",-489796959,null)], null);
});})(out,exit_reason,counter,returns,terminate_BANG_))
;

csi.core.t_csi$core7346.cljs$lang$type = true;

csi.core.t_csi$core7346.cljs$lang$ctorStr = "csi.core/t_csi$core7346";

csi.core.t_csi$core7346.cljs$lang$ctorPrWriter = ((function (out,exit_reason,counter,returns,terminate_BANG_){
return (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write.call(null,writer__4180__auto__,"csi.core/t_csi$core7346");
});})(out,exit_reason,counter,returns,terminate_BANG_))
;

/**
 * Positional factory function for csi.core/t_csi$core7346.
 */
csi.core.__GT_t_csi$core7346 = ((function (out,exit_reason,counter,returns,terminate_BANG_){
return (function csi$core$make_mbox_$___GT_t_csi$core7346(pid__$1,ws__$1,out__$1,exit_reason__$1,counter__$1,returns__$1,terminate_BANG___$1,meta7347){
return (new csi.core.t_csi$core7346(pid__$1,ws__$1,out__$1,exit_reason__$1,counter__$1,returns__$1,terminate_BANG___$1,meta7347));
});})(out,exit_reason,counter,returns,terminate_BANG_))
;

}

return (new csi.core.t_csi$core7346(pid,ws,out,exit_reason,counter,returns,terminate_BANG_,cljs.core.PersistentArrayMap.EMPTY));
});
csi.core.mbox = (function csi$core$mbox(url){
console.debug("handshake :: create mbox with url=",url);

var c__3667__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3667__auto__){
return (function (){
var f__3668__auto__ = (function (){var switch__3579__auto__ = ((function (c__3667__auto__){
return (function (state_7553){
var state_val_7554 = (state_7553[(1)]);
if((state_val_7554 === (7))){
var inst_7476 = (state_7553[(7)]);
var inst_7504 = (function(){throw inst_7476})();
var state_7553__$1 = state_7553;
var statearr_7555_7612 = state_7553__$1;
(statearr_7555_7612[(2)] = inst_7504);

(statearr_7555_7612[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (20))){
var inst_7498 = (state_7553[(2)]);
var state_7553__$1 = state_7553;
var statearr_7556_7613 = state_7553__$1;
(statearr_7556_7613[(2)] = inst_7498);

(statearr_7556_7613[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (27))){
var inst_7518 = (function(){throw cljs.core.match.backtrack})();
var state_7553__$1 = state_7553;
var statearr_7557_7614 = state_7553__$1;
(statearr_7557_7614[(2)] = inst_7518);

(statearr_7557_7614[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (1))){
var inst_7467 = csi.core.make_ws.call(null,url);
var state_7553__$1 = state_7553;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7553__$1,(2),inst_7467);
} else {
if((state_val_7554 === (24))){
var inst_7549 = (state_7553[(2)]);
var state_7553__$1 = state_7553;
var statearr_7558_7615 = state_7553__$1;
(statearr_7558_7615[(2)] = inst_7549);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_7553__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (39))){
var inst_7547 = (state_7553[(2)]);
var state_7553__$1 = state_7553;
var statearr_7559_7616 = state_7553__$1;
(statearr_7559_7616[(2)] = inst_7547);

(statearr_7559_7616[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (4))){
var inst_7551 = (state_7553[(2)]);
var state_7553__$1 = state_7553;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_7553__$1,inst_7551);
} else {
if((state_val_7554 === (15))){
var inst_7492 = console.warn("handshake :: unexpected connection close");
var state_7553__$1 = (function (){var statearr_7560 = state_7553;
(statearr_7560[(8)] = inst_7492);

return statearr_7560;
})();
var statearr_7561_7617 = state_7553__$1;
(statearr_7561_7617[(2)] = null);

(statearr_7561_7617[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (21))){
var inst_7475 = (state_7553[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_7553,(5),Error,null,(4));
var inst_7510 = cljs.core.vector_QMARK_.call(null,inst_7475);
var inst_7511 = cljs.core.count.call(null,inst_7475);
var inst_7512 = (inst_7511 === 2);
var inst_7513 = ((inst_7510) && (inst_7512));
var state_7553__$1 = state_7553;
if(cljs.core.truth_(inst_7513)){
var statearr_7562_7618 = state_7553__$1;
(statearr_7562_7618[(1)] = (22));

} else {
var statearr_7563_7619 = state_7553__$1;
(statearr_7563_7619[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (31))){
var inst_7469 = (state_7553[(10)]);
var inst_7475 = (state_7553[(9)]);
var inst_7529 = cljs.core.nth.call(null,inst_7475,(1));
var inst_7530 = console.debug("handshake :: counterparty self",inst_7529);
var inst_7531 = csi.core.make_mbox.call(null,inst_7529,inst_7469);
var state_7553__$1 = (function (){var statearr_7564 = state_7553;
(statearr_7564[(11)] = inst_7530);

return statearr_7564;
})();
var statearr_7565_7620 = state_7553__$1;
(statearr_7565_7620[(2)] = inst_7531);

(statearr_7565_7620[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (32))){
var state_7553__$1 = state_7553;
var statearr_7566_7621 = state_7553__$1;
(statearr_7566_7621[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (33))){
var inst_7539 = (state_7553[(2)]);
var state_7553__$1 = state_7553;
var statearr_7568_7622 = state_7553__$1;
(statearr_7568_7622[(2)] = inst_7539);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_7553__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (13))){
var inst_7486 = (state_7553[(2)]);
var state_7553__$1 = state_7553;
var statearr_7569_7623 = state_7553__$1;
(statearr_7569_7623[(2)] = inst_7486);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_7553__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (22))){
var state_7553__$1 = state_7553;
var statearr_7570_7624 = state_7553__$1;
(statearr_7570_7624[(2)] = null);

(statearr_7570_7624[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (36))){
var inst_7537 = (state_7553[(2)]);
var state_7553__$1 = state_7553;
var statearr_7571_7625 = state_7553__$1;
(statearr_7571_7625[(2)] = inst_7537);

(statearr_7571_7625[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (29))){
var inst_7522 = (state_7553[(2)]);
var state_7553__$1 = state_7553;
var statearr_7572_7626 = state_7553__$1;
(statearr_7572_7626[(2)] = inst_7522);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_7553__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (6))){
var state_7553__$1 = state_7553;
var statearr_7573_7627 = state_7553__$1;
(statearr_7573_7627[(2)] = null);

(statearr_7573_7627[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (28))){
var inst_7515 = (state_7553[(12)]);
var inst_7520 = (function(){throw inst_7515})();
var state_7553__$1 = state_7553;
var statearr_7574_7628 = state_7553__$1;
(statearr_7574_7628[(2)] = inst_7520);

(statearr_7574_7628[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (25))){
var inst_7541 = (state_7553[(2)]);
var state_7553__$1 = state_7553;
var statearr_7575_7629 = state_7553__$1;
(statearr_7575_7629[(2)] = inst_7541);

(statearr_7575_7629[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (34))){
var inst_7534 = (function(){throw cljs.core.match.backtrack})();
var state_7553__$1 = state_7553;
var statearr_7576_7630 = state_7553__$1;
(statearr_7576_7630[(2)] = inst_7534);

(statearr_7576_7630[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (17))){
var inst_7500 = (state_7553[(2)]);
var state_7553__$1 = state_7553;
var statearr_7577_7631 = state_7553__$1;
(statearr_7577_7631[(2)] = inst_7500);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_7553__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (3))){
var inst_7475 = (state_7553[(2)]);
var state_7553__$1 = (function (){var statearr_7578 = state_7553;
(statearr_7578[(9)] = inst_7475);

return statearr_7578;
})();
var statearr_7579_7632 = state_7553__$1;
(statearr_7579_7632[(2)] = null);

(statearr_7579_7632[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (12))){
var inst_7479 = (state_7553[(13)]);
var inst_7484 = (function(){throw inst_7479})();
var state_7553__$1 = state_7553;
var statearr_7580_7633 = state_7553__$1;
(statearr_7580_7633[(2)] = inst_7484);

(statearr_7580_7633[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (2))){
var inst_7469 = (state_7553[(10)]);
var inst_7469__$1 = (state_7553[(2)]);
var state_7553__$1 = (function (){var statearr_7581 = state_7553;
(statearr_7581[(10)] = inst_7469__$1);

return statearr_7581;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7553__$1,(3),inst_7469__$1);
} else {
if((state_val_7554 === (23))){
var state_7553__$1 = state_7553;
var statearr_7582_7634 = state_7553__$1;
(statearr_7582_7634[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (35))){
var state_7553__$1 = state_7553;
var statearr_7584_7635 = state_7553__$1;
(statearr_7584_7635[(2)] = null);

(statearr_7584_7635[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (19))){
var state_7553__$1 = state_7553;
var statearr_7585_7636 = state_7553__$1;
(statearr_7585_7636[(2)] = null);

(statearr_7585_7636[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (11))){
var inst_7475 = (state_7553[(9)]);
var inst_7482 = console.warn("handshake :: unexpected message",inst_7475);
var state_7553__$1 = (function (){var statearr_7586 = state_7553;
(statearr_7586[(14)] = inst_7482);

return statearr_7586;
})();
var statearr_7587_7637 = state_7553__$1;
(statearr_7587_7637[(2)] = null);

(statearr_7587_7637[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (9))){
var inst_7502 = (state_7553[(2)]);
var state_7553__$1 = state_7553;
var statearr_7588_7638 = state_7553__$1;
(statearr_7588_7638[(2)] = inst_7502);

(statearr_7588_7638[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (5))){
var inst_7476 = (state_7553[(7)]);
var inst_7476__$1 = (state_7553[(2)]);
var inst_7477 = (inst_7476__$1 === cljs.core.match.backtrack);
var state_7553__$1 = (function (){var statearr_7589 = state_7553;
(statearr_7589[(7)] = inst_7476__$1);

return statearr_7589;
})();
if(cljs.core.truth_(inst_7477)){
var statearr_7590_7639 = state_7553__$1;
(statearr_7590_7639[(1)] = (6));

} else {
var statearr_7591_7640 = state_7553__$1;
(statearr_7591_7640[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (14))){
var inst_7475 = (state_7553[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_7553,(10),Error,null,(9));
var inst_7490 = (inst_7475 === null);
var state_7553__$1 = state_7553;
if(cljs.core.truth_(inst_7490)){
var statearr_7592_7641 = state_7553__$1;
(statearr_7592_7641[(1)] = (15));

} else {
var statearr_7593_7642 = state_7553__$1;
(statearr_7593_7642[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (26))){
var inst_7515 = (state_7553[(12)]);
var inst_7515__$1 = (state_7553[(2)]);
var inst_7516 = (inst_7515__$1 === cljs.core.match.backtrack);
var state_7553__$1 = (function (){var statearr_7594 = state_7553;
(statearr_7594[(12)] = inst_7515__$1);

return statearr_7594;
})();
if(cljs.core.truth_(inst_7516)){
var statearr_7595_7643 = state_7553__$1;
(statearr_7595_7643[(1)] = (27));

} else {
var statearr_7596_7644 = state_7553__$1;
(statearr_7596_7644[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (16))){
var state_7553__$1 = state_7553;
var statearr_7597_7645 = state_7553__$1;
(statearr_7597_7645[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (38))){
var state_7553__$1 = state_7553;
var statearr_7599_7646 = state_7553__$1;
(statearr_7599_7646[(2)] = null);

(statearr_7599_7646[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (30))){
var inst_7475 = (state_7553[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_7553,(26),Error,null,(25));
var inst_7526 = cljs.core.nth.call(null,inst_7475,(0));
var inst_7527 = cljs.core.keyword_identical_QMARK_.call(null,inst_7526,new cljs.core.Keyword("otplike.csi.core","self","otplike.csi.core/self",-1612922051));
var state_7553__$1 = state_7553;
if(inst_7527){
var statearr_7600_7647 = state_7553__$1;
(statearr_7600_7647[(1)] = (31));

} else {
var statearr_7601_7648 = state_7553__$1;
(statearr_7601_7648[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (10))){
var inst_7479 = (state_7553[(13)]);
var inst_7479__$1 = (state_7553[(2)]);
var inst_7480 = (inst_7479__$1 === cljs.core.match.backtrack);
var state_7553__$1 = (function (){var statearr_7602 = state_7553;
(statearr_7602[(13)] = inst_7479__$1);

return statearr_7602;
})();
if(cljs.core.truth_(inst_7480)){
var statearr_7603_7649 = state_7553__$1;
(statearr_7603_7649[(1)] = (11));

} else {
var statearr_7604_7650 = state_7553__$1;
(statearr_7604_7650[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (18))){
var inst_7495 = (function(){throw cljs.core.match.backtrack})();
var state_7553__$1 = state_7553;
var statearr_7605_7651 = state_7553__$1;
(statearr_7605_7651[(2)] = inst_7495);

(statearr_7605_7651[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (37))){
var inst_7544 = (function(){throw cljs.core.match.backtrack})();
var state_7553__$1 = state_7553;
var statearr_7606_7652 = state_7553__$1;
(statearr_7606_7652[(2)] = inst_7544);

(statearr_7606_7652[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7554 === (8))){
var inst_7506 = (state_7553[(2)]);
var state_7553__$1 = state_7553;
var statearr_7607_7653 = state_7553__$1;
(statearr_7607_7653[(2)] = inst_7506);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_7553__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3667__auto__))
;
return ((function (switch__3579__auto__,c__3667__auto__){
return (function() {
var csi$core$mbox_$_state_machine__3580__auto__ = null;
var csi$core$mbox_$_state_machine__3580__auto____0 = (function (){
var statearr_7608 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_7608[(0)] = csi$core$mbox_$_state_machine__3580__auto__);

(statearr_7608[(1)] = (1));

return statearr_7608;
});
var csi$core$mbox_$_state_machine__3580__auto____1 = (function (state_7553){
while(true){
var ret_value__3581__auto__ = (function (){try{while(true){
var result__3582__auto__ = switch__3579__auto__.call(null,state_7553);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3582__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3582__auto__;
}
break;
}
}catch (e7609){if((e7609 instanceof Object)){
var ex__3583__auto__ = e7609;
var statearr_7610_7654 = state_7553;
(statearr_7610_7654[(5)] = ex__3583__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_7553);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e7609;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3581__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__7655 = state_7553;
state_7553 = G__7655;
continue;
} else {
return ret_value__3581__auto__;
}
break;
}
});
csi$core$mbox_$_state_machine__3580__auto__ = function(state_7553){
switch(arguments.length){
case 0:
return csi$core$mbox_$_state_machine__3580__auto____0.call(this);
case 1:
return csi$core$mbox_$_state_machine__3580__auto____1.call(this,state_7553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
csi$core$mbox_$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$0 = csi$core$mbox_$_state_machine__3580__auto____0;
csi$core$mbox_$_state_machine__3580__auto__.cljs$core$IFn$_invoke$arity$1 = csi$core$mbox_$_state_machine__3580__auto____1;
return csi$core$mbox_$_state_machine__3580__auto__;
})()
;})(switch__3579__auto__,c__3667__auto__))
})();
var state__3669__auto__ = (function (){var statearr_7611 = f__3668__auto__.call(null);
(statearr_7611[(6)] = c__3667__auto__);

return statearr_7611;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3669__auto__);
});})(c__3667__auto__))
);

return c__3667__auto__;
});

//# sourceMappingURL=core.js.map?rel=1538054230141
