// Compiled by ClojureScript 1.10.312 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR_8626 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));

try{try{var seq__8627 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__8628 = null;
var count__8629 = (0);
var i__8630 = (0);
while(true){
if((i__8630 < count__8629)){
var vec__8631 = cljs.core._nth.call(null,chunk__8628,i__8630);
var effect_key = cljs.core.nth.call(null,vec__8631,(0),null);
var effect_value = cljs.core.nth.call(null,vec__8631,(1),null);
var temp__4655__auto___8647 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__4655__auto___8647)){
var effect_fn_8648 = temp__4655__auto___8647;
effect_fn_8648.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__8649 = seq__8627;
var G__8650 = chunk__8628;
var G__8651 = count__8629;
var G__8652 = (i__8630 + (1));
seq__8627 = G__8649;
chunk__8628 = G__8650;
count__8629 = G__8651;
i__8630 = G__8652;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__8627);
if(temp__4657__auto__){
var seq__8627__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8627__$1)){
var c__4337__auto__ = cljs.core.chunk_first.call(null,seq__8627__$1);
var G__8653 = cljs.core.chunk_rest.call(null,seq__8627__$1);
var G__8654 = c__4337__auto__;
var G__8655 = cljs.core.count.call(null,c__4337__auto__);
var G__8656 = (0);
seq__8627 = G__8653;
chunk__8628 = G__8654;
count__8629 = G__8655;
i__8630 = G__8656;
continue;
} else {
var vec__8634 = cljs.core.first.call(null,seq__8627__$1);
var effect_key = cljs.core.nth.call(null,vec__8634,(0),null);
var effect_value = cljs.core.nth.call(null,vec__8634,(1),null);
var temp__4655__auto___8657 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__4655__auto___8657)){
var effect_fn_8658 = temp__4655__auto___8657;
effect_fn_8658.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__8659 = cljs.core.next.call(null,seq__8627__$1);
var G__8660 = null;
var G__8661 = (0);
var G__8662 = (0);
seq__8627 = G__8659;
chunk__8628 = G__8660;
count__8629 = G__8661;
i__8630 = G__8662;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__2237__auto___8663 = re_frame.interop.now.call(null);
var duration__2238__auto___8664 = (end__2237__auto___8663 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.call(null,re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__2238__auto___8664,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null)));

re_frame.trace.run_tracing_callbacks_BANG_.call(null,end__2237__auto___8663);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_8626;
}} else {
var seq__8637 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__8638 = null;
var count__8639 = (0);
var i__8640 = (0);
while(true){
if((i__8640 < count__8639)){
var vec__8641 = cljs.core._nth.call(null,chunk__8638,i__8640);
var effect_key = cljs.core.nth.call(null,vec__8641,(0),null);
var effect_value = cljs.core.nth.call(null,vec__8641,(1),null);
var temp__4655__auto___8665 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__4655__auto___8665)){
var effect_fn_8666 = temp__4655__auto___8665;
effect_fn_8666.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__8667 = seq__8637;
var G__8668 = chunk__8638;
var G__8669 = count__8639;
var G__8670 = (i__8640 + (1));
seq__8637 = G__8667;
chunk__8638 = G__8668;
count__8639 = G__8669;
i__8640 = G__8670;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__8637);
if(temp__4657__auto__){
var seq__8637__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8637__$1)){
var c__4337__auto__ = cljs.core.chunk_first.call(null,seq__8637__$1);
var G__8671 = cljs.core.chunk_rest.call(null,seq__8637__$1);
var G__8672 = c__4337__auto__;
var G__8673 = cljs.core.count.call(null,c__4337__auto__);
var G__8674 = (0);
seq__8637 = G__8671;
chunk__8638 = G__8672;
count__8639 = G__8673;
i__8640 = G__8674;
continue;
} else {
var vec__8644 = cljs.core.first.call(null,seq__8637__$1);
var effect_key = cljs.core.nth.call(null,vec__8644,(0),null);
var effect_value = cljs.core.nth.call(null,vec__8644,(1),null);
var temp__4655__auto___8675 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__4655__auto___8675)){
var effect_fn_8676 = temp__4655__auto___8675;
effect_fn_8676.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__8677 = cljs.core.next.call(null,seq__8637__$1);
var G__8678 = null;
var G__8679 = (0);
var G__8680 = (0);
seq__8637 = G__8677;
chunk__8638 = G__8678;
count__8639 = G__8679;
i__8640 = G__8680;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__8681 = cljs.core.seq.call(null,value);
var chunk__8682 = null;
var count__8683 = (0);
var i__8684 = (0);
while(true){
if((i__8684 < count__8683)){
var map__8685 = cljs.core._nth.call(null,chunk__8682,i__8684);
var map__8685__$1 = ((((!((map__8685 == null)))?(((((map__8685.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8685.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8685):map__8685);
var effect = map__8685__$1;
var ms = cljs.core.get.call(null,map__8685__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__8685__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__8681,chunk__8682,count__8683,i__8684,map__8685,map__8685__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__8681,chunk__8682,count__8683,i__8684,map__8685,map__8685__$1,effect,ms,dispatch))
,ms);
}


var G__8689 = seq__8681;
var G__8690 = chunk__8682;
var G__8691 = count__8683;
var G__8692 = (i__8684 + (1));
seq__8681 = G__8689;
chunk__8682 = G__8690;
count__8683 = G__8691;
i__8684 = G__8692;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__8681);
if(temp__4657__auto__){
var seq__8681__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8681__$1)){
var c__4337__auto__ = cljs.core.chunk_first.call(null,seq__8681__$1);
var G__8693 = cljs.core.chunk_rest.call(null,seq__8681__$1);
var G__8694 = c__4337__auto__;
var G__8695 = cljs.core.count.call(null,c__4337__auto__);
var G__8696 = (0);
seq__8681 = G__8693;
chunk__8682 = G__8694;
count__8683 = G__8695;
i__8684 = G__8696;
continue;
} else {
var map__8687 = cljs.core.first.call(null,seq__8681__$1);
var map__8687__$1 = ((((!((map__8687 == null)))?(((((map__8687.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8687.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8687):map__8687);
var effect = map__8687__$1;
var ms = cljs.core.get.call(null,map__8687__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__8687__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__8681,chunk__8682,count__8683,i__8684,map__8687,map__8687__$1,effect,ms,dispatch,seq__8681__$1,temp__4657__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__8681,chunk__8682,count__8683,i__8684,map__8687,map__8687__$1,effect,ms,dispatch,seq__8681__$1,temp__4657__auto__))
,ms);
}


var G__8697 = cljs.core.next.call(null,seq__8681__$1);
var G__8698 = null;
var G__8699 = (0);
var G__8700 = (0);
seq__8681 = G__8697;
chunk__8682 = G__8698;
count__8683 = G__8699;
i__8684 = G__8700;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
var seq__8701 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__8702 = null;
var count__8703 = (0);
var i__8704 = (0);
while(true){
if((i__8704 < count__8703)){
var event = cljs.core._nth.call(null,chunk__8702,i__8704);
re_frame.router.dispatch.call(null,event);


var G__8705 = seq__8701;
var G__8706 = chunk__8702;
var G__8707 = count__8703;
var G__8708 = (i__8704 + (1));
seq__8701 = G__8705;
chunk__8702 = G__8706;
count__8703 = G__8707;
i__8704 = G__8708;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__8701);
if(temp__4657__auto__){
var seq__8701__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8701__$1)){
var c__4337__auto__ = cljs.core.chunk_first.call(null,seq__8701__$1);
var G__8709 = cljs.core.chunk_rest.call(null,seq__8701__$1);
var G__8710 = c__4337__auto__;
var G__8711 = cljs.core.count.call(null,c__4337__auto__);
var G__8712 = (0);
seq__8701 = G__8709;
chunk__8702 = G__8710;
count__8703 = G__8711;
i__8704 = G__8712;
continue;
} else {
var event = cljs.core.first.call(null,seq__8701__$1);
re_frame.router.dispatch.call(null,event);


var G__8713 = cljs.core.next.call(null,seq__8701__$1);
var G__8714 = null;
var G__8715 = (0);
var G__8716 = (0);
seq__8701 = G__8713;
chunk__8702 = G__8714;
count__8703 = G__8715;
i__8704 = G__8716;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__8717 = cljs.core.seq.call(null,value);
var chunk__8718 = null;
var count__8719 = (0);
var i__8720 = (0);
while(true){
if((i__8720 < count__8719)){
var event = cljs.core._nth.call(null,chunk__8718,i__8720);
clear_event.call(null,event);


var G__8721 = seq__8717;
var G__8722 = chunk__8718;
var G__8723 = count__8719;
var G__8724 = (i__8720 + (1));
seq__8717 = G__8721;
chunk__8718 = G__8722;
count__8719 = G__8723;
i__8720 = G__8724;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__8717);
if(temp__4657__auto__){
var seq__8717__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8717__$1)){
var c__4337__auto__ = cljs.core.chunk_first.call(null,seq__8717__$1);
var G__8725 = cljs.core.chunk_rest.call(null,seq__8717__$1);
var G__8726 = c__4337__auto__;
var G__8727 = cljs.core.count.call(null,c__4337__auto__);
var G__8728 = (0);
seq__8717 = G__8725;
chunk__8718 = G__8726;
count__8719 = G__8727;
i__8720 = G__8728;
continue;
} else {
var event = cljs.core.first.call(null,seq__8717__$1);
clear_event.call(null,event);


var G__8729 = cljs.core.next.call(null,seq__8717__$1);
var G__8730 = null;
var G__8731 = (0);
var G__8732 = (0);
seq__8717 = G__8729;
chunk__8718 = G__8730;
count__8719 = G__8731;
i__8720 = G__8732;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if(!((cljs.core.deref.call(null,re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=fx.js.map?rel=1538054230799
