// Compiled by ClojureScript 1.10.312 {}
goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.call(null,(0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_.call(null,re_frame.trace.id,(0));
});

/** @define {boolean} */
goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.call(null,(0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.call(null,re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/Day8/re-frame-trace#installation.");
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.call(null,re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.call(null,re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__2259){
var map__2260 = p__2259;
var map__2260__$1 = ((((!((map__2260 == null)))?(((((map__2260.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2260.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2260):map__2260);
var operation = cljs.core.get.call(null,map__2260__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.call(null,map__2260__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.call(null,map__2260__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.call(null,map__2260__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id.call(null),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__3936__auto__ = child_of;
if(cljs.core.truth_(or__3936__auto__)){
return or__3936__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now.call(null)], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce.call(null,(function re_frame$trace$tracing_cb_debounced(){
var seq__2262_2274 = cljs.core.seq.call(null,cljs.core.deref.call(null,re_frame.trace.trace_cbs));
var chunk__2263_2275 = null;
var count__2264_2276 = (0);
var i__2265_2277 = (0);
while(true){
if((i__2265_2277 < count__2264_2276)){
var vec__2266_2278 = cljs.core._nth.call(null,chunk__2263_2275,i__2265_2277);
var k_2279 = cljs.core.nth.call(null,vec__2266_2278,(0),null);
var cb_2280 = cljs.core.nth.call(null,vec__2266_2278,(1),null);
try{cb_2280.call(null,cljs.core.deref.call(null,re_frame.trace.traces));
}catch (e2269){var e_2281 = e2269;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k_2279,"while storing",cljs.core.deref.call(null,re_frame.trace.traces),e_2281);
}

var G__2282 = seq__2262_2274;
var G__2283 = chunk__2263_2275;
var G__2284 = count__2264_2276;
var G__2285 = (i__2265_2277 + (1));
seq__2262_2274 = G__2282;
chunk__2263_2275 = G__2283;
count__2264_2276 = G__2284;
i__2265_2277 = G__2285;
continue;
} else {
var temp__4657__auto___2286 = cljs.core.seq.call(null,seq__2262_2274);
if(temp__4657__auto___2286){
var seq__2262_2287__$1 = temp__4657__auto___2286;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2262_2287__$1)){
var c__4337__auto___2288 = cljs.core.chunk_first.call(null,seq__2262_2287__$1);
var G__2289 = cljs.core.chunk_rest.call(null,seq__2262_2287__$1);
var G__2290 = c__4337__auto___2288;
var G__2291 = cljs.core.count.call(null,c__4337__auto___2288);
var G__2292 = (0);
seq__2262_2274 = G__2289;
chunk__2263_2275 = G__2290;
count__2264_2276 = G__2291;
i__2265_2277 = G__2292;
continue;
} else {
var vec__2270_2293 = cljs.core.first.call(null,seq__2262_2287__$1);
var k_2294 = cljs.core.nth.call(null,vec__2270_2293,(0),null);
var cb_2295 = cljs.core.nth.call(null,vec__2270_2293,(1),null);
try{cb_2295.call(null,cljs.core.deref.call(null,re_frame.trace.traces));
}catch (e2273){var e_2296 = e2273;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k_2294,"while storing",cljs.core.deref.call(null,re_frame.trace.traces),e_2296);
}

var G__2297 = cljs.core.next.call(null,seq__2262_2287__$1);
var G__2298 = null;
var G__2299 = (0);
var G__2300 = (0);
seq__2262_2274 = G__2297;
chunk__2263_2275 = G__2298;
count__2264_2276 = G__2299;
i__2265_2277 = G__2300;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_.call(null,re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref.call(null,re_frame.trace.next_delivery) - (10)) < now)){
re_frame.trace.schedule_debounce.call(null);

return cljs.core.reset_BANG_.call(null,re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=trace.js.map?rel=1538054226614
