(ns sv.ha.failover.heartbeat.gcloud.datastore
  (:require [sv.gcloud.datastore.client :as dc]
            [clojure.edn :as edn]))

(defn create-state-fn [client config]
  (let [entity-key (select-keys
                    config
                    [:ds/kind
                     :ds/name])]
    (fn
      ([]
       (when-let [value (:value
                         (dc/lookup-entity
                          client
                          entity-key))]
         (edn/read-string value)))
      ([new-value]
       (dc/transact-entity
        client
        entity-key
        (fn [entity]
          (assoc
           entity
           :value (pr-str new-value))))
       true))))
