/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Font;
import com.kitfox.svg.FontFace;
import com.kitfox.svg.MissingGlyph;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.ShapeElement;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class Tspan
extends ShapeElement {
    float[] x = null;
    float[] y = null;
    float[] dx = null;
    float[] dy = null;
    float[] rotate = null;
    private String text = "";
    float cursorX;
    float cursorY;

    public float getCursorX() {
        return this.cursorX;
    }

    public float getCursorY() {
        return this.cursorY;
    }

    public void setCursorX(float cursorX) {
        this.cursorX = cursorX;
    }

    public void setCursorY(float cursorY) {
        this.cursorY = cursorY;
    }

    @Override
    public void loaderAddText(SVGLoaderHelper helper, String text) {
        this.text = this.text + text;
    }

    @Override
    protected void build() throws SVGException {
        super.build();
        StyleAttribute sty = new StyleAttribute();
        if (this.getPres(sty.setName("x"))) {
            this.x = sty.getFloatList();
        }
        if (this.getPres(sty.setName("y"))) {
            this.y = sty.getFloatList();
        }
        if (this.getPres(sty.setName("dx"))) {
            this.dx = sty.getFloatList();
        }
        if (this.getPres(sty.setName("dy"))) {
            this.dy = sty.getFloatList();
        }
        if (this.getPres(sty.setName("rotate"))) {
            this.rotate = sty.getFloatList();
            for (int i = 0; i < this.rotate.length; ++i) {
                this.rotate[i] = (float)Math.toRadians(this.rotate[i]);
            }
        }
    }

    public void addShape(GeneralPath addShape) throws SVGException {
        Font font;
        if (this.x != null) {
            this.cursorX = this.x[0];
            this.cursorY = this.y[0];
        } else if (this.dx != null) {
            this.cursorX += this.dx[0];
            this.cursorY += this.dy[0];
        }
        StyleAttribute sty = new StyleAttribute();
        String fontFamily = null;
        if (this.getStyle(sty.setName("font-family"))) {
            fontFamily = sty.getStringValue();
        }
        float fontSize = 12.0f;
        if (this.getStyle(sty.setName("font-size"))) {
            fontSize = sty.getFloatValueWithUnits();
        }
        if ((font = this.diagram.getUniverse().getFont(fontFamily)) == null) {
            this.addShapeSysFont(addShape, font, fontFamily, fontSize);
            return;
        }
        FontFace fontFace = font.getFontFace();
        int ascent = fontFace.getAscent();
        float fontScale = fontSize / (float)ascent;
        AffineTransform xform = new AffineTransform();
        this.strokeWidthScalar = 1.0f / fontScale;
        int posPtr = 1;
        for (int i = 0; i < this.text.length(); ++i) {
            String unicode;
            MissingGlyph glyph;
            Shape path;
            xform.setToIdentity();
            xform.setToTranslation(this.cursorX, this.cursorY);
            xform.scale(fontScale, fontScale);
            if (this.rotate != null) {
                xform.rotate(this.rotate[posPtr]);
            }
            if ((path = (glyph = font.getGlyph(unicode = this.text.substring(i, i + 1))).getPath()) != null) {
                path = xform.createTransformedShape(path);
                addShape.append(path, false);
            }
            if (this.x != null && posPtr < this.x.length) {
                this.cursorX = this.x[posPtr];
                this.cursorY = this.y[posPtr++];
            } else if (this.dx != null && posPtr < this.dx.length) {
                this.cursorX += this.dx[posPtr];
                this.cursorY += this.dy[posPtr++];
            }
            this.cursorX += fontScale * (float)glyph.getHorizAdvX();
        }
        this.strokeWidthScalar = 1.0f;
    }

    private void addShapeSysFont(GeneralPath addShape, Font font, String fontFamily, float fontSize) {
        java.awt.Font sysFont = new java.awt.Font(fontFamily, 0, (int)fontSize);
        FontRenderContext frc = new FontRenderContext(null, true, true);
        GlyphVector textVector = sysFont.createGlyphVector(frc, this.text);
        AffineTransform xform = new AffineTransform();
        int posPtr = 1;
        for (int i = 0; i < this.text.length(); ++i) {
            xform.setToIdentity();
            xform.setToTranslation(this.cursorX, this.cursorY);
            if (this.rotate != null) {
                xform.rotate(this.rotate[Math.min(i, this.rotate.length - 1)]);
            }
            String unicode = this.text.substring(i, i + 1);
            Shape glyphOutline = textVector.getGlyphOutline(i);
            GlyphMetrics glyphMetrics = textVector.getGlyphMetrics(i);
            glyphOutline = xform.createTransformedShape(glyphOutline);
            addShape.append(glyphOutline, false);
            if (this.x != null && posPtr < this.x.length) {
                this.cursorX = this.x[posPtr];
                this.cursorY = this.y[posPtr++];
                continue;
            }
            if (this.dx == null || posPtr >= this.dx.length) continue;
            this.cursorX += this.dx[posPtr];
            this.cursorY += this.dy[posPtr++];
        }
    }

    @Override
    public void render(Graphics2D g) throws SVGException {
        Font font;
        if (this.x != null) {
            this.cursorX = this.x[0];
            this.cursorY = this.y[0];
        } else if (this.dx != null) {
            this.cursorX += this.dx[0];
            this.cursorY += this.dy[0];
        }
        StyleAttribute sty = new StyleAttribute();
        String fontFamily = null;
        if (this.getPres(sty.setName("font-family"))) {
            fontFamily = sty.getStringValue();
        }
        float fontSize = 12.0f;
        if (this.getPres(sty.setName("font-size"))) {
            fontSize = sty.getFloatValueWithUnits();
        }
        if ((font = this.diagram.getUniverse().getFont(fontFamily)) == null) {
            System.err.println("Could not load font");
            java.awt.Font sysFont = new java.awt.Font(fontFamily, 0, (int)fontSize);
            this.renderSysFont(g, sysFont);
            return;
        }
        FontFace fontFace = font.getFontFace();
        int ascent = fontFace.getAscent();
        float fontScale = fontSize / (float)ascent;
        AffineTransform oldXform = g.getTransform();
        AffineTransform xform = new AffineTransform();
        this.strokeWidthScalar = 1.0f / fontScale;
        int posPtr = 1;
        for (int i = 0; i < this.text.length(); ++i) {
            xform.setToTranslation(this.cursorX, this.cursorY);
            xform.scale(fontScale, fontScale);
            g.transform(xform);
            String unicode = this.text.substring(i, i + 1);
            MissingGlyph glyph = font.getGlyph(unicode);
            Shape path = glyph.getPath();
            if (path != null) {
                this.renderShape(g, path);
            } else {
                glyph.render(g);
            }
            if (this.x != null && posPtr < this.x.length) {
                this.cursorX = this.x[posPtr];
                this.cursorY = this.y[posPtr++];
            } else if (this.dx != null && posPtr < this.dx.length) {
                this.cursorX += this.dx[posPtr];
                this.cursorY += this.dy[posPtr++];
            }
            this.cursorX += fontScale * (float)glyph.getHorizAdvX();
            g.setTransform(oldXform);
        }
        this.strokeWidthScalar = 1.0f;
    }

    protected void renderSysFont(Graphics2D g, java.awt.Font font) throws SVGException {
        boolean posPtr = true;
        FontRenderContext frc = g.getFontRenderContext();
        Shape textShape = font.createGlyphVector(frc, this.text).getOutline(this.cursorX, this.cursorY);
        this.renderShape(g, textShape);
        Rectangle2D rect = font.getStringBounds(this.text, frc);
        this.cursorX += (float)rect.getWidth();
    }

    @Override
    public Shape getShape() {
        return null;
    }

    @Override
    public Rectangle2D getBoundingBox() {
        return null;
    }

    @Override
    public boolean updateTime(double curTime) throws SVGException {
        return false;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }
}

