/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.xml;

import com.kitfox.svg.xml.Base64Util;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends FilterInputStream {
    int buf;
    int bufSize;
    boolean drain = false;

    public Base64InputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        if (this.drain && this.bufSize == 0) {
            return -1;
        }
        if (this.bufSize == 0) {
            int i;
            int chunk = this.in.read();
            if (chunk == -1) {
                this.drain = true;
                return -1;
            }
            for (i = 0; i < 3; ++i) {
                int value = this.in.read();
                if (value == -1) {
                    throw new IOException("Early termination of base64 stream");
                }
                chunk = chunk << 8 | value & 0xFF;
            }
            if ((chunk & 0xFFFF) == 15677) {
                this.bufSize = 1;
                this.drain = true;
            } else if ((chunk & 0xFF) == 61) {
                this.bufSize = 2;
                this.drain = true;
            } else {
                this.bufSize = 3;
            }
            for (i = 0; i < this.bufSize + 1; ++i) {
                this.buf = this.buf << 6 | Base64Util.decodeByte(chunk >> 24 & 0xFF);
                chunk <<= 8;
            }
        }
        return this.buf >> --this.bufSize * 8 & 0xFF;
    }
}

