(ns symmetry.lib.log
  (:require [clojure.tools.logging :as log]
            [clojure.java.io :as io]
            [clj-logging-config.log4j :refer [set-loggers!]]))

(def ^:private init-lock* (Object.))

(defn- appender [f]
  (org.apache.log4j.FileAppender.
   (org.apache.log4j.PatternLayout. "%d{ISO8601} %-5p %c | %m%n")
   f
   true))

(defn init! [name]
  (let [syskey (str name "--logging-configured")]
    (locking init-lock*
      (if (= (System/getProperty syskey) "true")
        (println "logging already configured")
        (let [log-file (format "log/%s.log" name)
              f (io/file log-file)]
          (.mkdirs (.getParentFile f))
          (set-loggers! :config {:level :info}
                        :root {:level :info
                               :out (appender log-file)})
          (System/setProperty syskey "true")
          (println "logging to" log-file))))))

(defmacro trace [& args] `(log/trace ~@args))
(defmacro debug [& args] `(log/debug ~@args))
(defmacro info [& args] `(log/info ~@args))
(defmacro warn [& args] `(log/warn ~@args))
(defmacro error [& args] `(log/error ~@args))
(defmacro fatal [& args] `(log/fatal ~@args))

(defn mark []
  (info (apply str (repeat 80 "-"))))

(comment

  (init! "test")
  (info "hello")

  )
