(ns symmetry.lib.core
  (:require [fipp.edn :as fipp]))

(defn pps
  "Returns pretty-printed string of argument."
  [x]
  (with-out-str
    (fipp/pprint x)))

(def ^{:doc "Returns true if argument is a byte-array."}
  byte-array?
  (let [check (type (byte-array []))]
    (fn [arg] (instance? check arg))))

(defmacro and-let [bindings & body]
  (when-not (vector? bindings)
    (throw (IllegalArgumentException.
            "and-let requires binding vector as first form")))
  (when-not (even? (count bindings))
    (throw (IllegalArgumentException.
            "and-let requires an even number of forms in binding vector")))
  (if (empty? bindings)
    `(do ~@body)
    `(when-let [~(first bindings) ~(second bindings)]
       (and-let ~(vec (drop 2 bindings)) ~@body))))

(defn find-first [f coll]
  (first (drop-while (complement f) coll)))

(defn first-not-nil [coll]
  (find-first identity coll))

(defn doseqf [f s]
  (doseq [x s] (f x)))

(defn dissoc-in [m p]
  (if (get-in m p)
    (update-in m
               (drop-last p)
               dissoc (last p))
    m))

(defmacro neither [& exprs]
  `(and ~@(map (fn [expr] `(not ~expr))
               exprs)))
