(ns symmetry.lib.dev.nrepl-server
  (:require [symmetry.lib.log :as log]
            [clojure.tools.nrepl.server]
            [cider.nrepl]
            [clojure.string]))

(defn -main [& [app-name]]
  (let [app-name (or app-name (-> (System/getProperty "user.dir")
                                  (clojure.string/split #"/")
                                  (last)
                                  (.trim)))]
    (log/init! app-name)
    (println "starting nREPL server...")
    (let [m (clojure.tools.nrepl.server/start-server
             :handler cider.nrepl/cider-nrepl-handler)
          p (:port m)]
      (spit ".nrepl-port" (str p))
      (println (str "nrepl server running on port " p ".")))))
