(ns leiningen.new.synergy-microservice
  (:require [leiningen.new.templates :refer [project-name renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "synergy-microservice"))

(defn synergy-microservice
  "FIXME: write documentation"
  [name]
  (let [data {:name name
              :user "user"  ; do not change - workaround for lein issue
              :dev "dev"    ; do not change - workaround for lein issue
              :sanitized (name-to-path name)
              :project-name (project-name name)}]
    (main/info "Generating fresh 'lein new' synergy-microservice project.")
    (->files data
             ["README.md" (render "README.md" data)]
             ["project.clj" (render "project.clj" data)]
             [".gitignore" (render ".gitignore" data)]

             ["src/{{sanitized}}/main.clj" (render "main.clj" data)]
             ["src/{{sanitized}}/commands.clj" (render "commands.clj" data)]
             ["src/{{sanitized}}/components/.gitkeep" (render "gitkeep" data)]
             ["src/{{sanitized}}/data/system_map.clj" (render "data/system_map.clj" data)]

             ["test/{{sanitized}}/core_test.clj" (render "test/core_test.clj" data)]

             ["resources/config.edn" (render "resources/config.edn" data)]

             ["dev/dev.clj" (render "dev/dev.clj" data)]
             ["dev/user.clj" (render "dev/user.clj" data)]
             )))
