(ns {{name}}.data.system-map
  (:require [ai.hackthorn.synergy.components.api :as api]
            [ai.hackthorn.synergy.components.server :as server]
            [taoensso.timbre :refer (log trace debug info warn error fatal)]
            [yada.yada :as yada]
            [yada.swagger :as swagger]
            [schema.core :as s]
            [com.stuartsierra.component :as component])
  (:import (com.stuartsierra.component Lifecycle)))

;; Sample component
(s/defrecord Database
  []
  Lifecycle
  (start [component]
    (info "DB component starting api")
    (assoc component :test "TEST WORKS!"))

  (stop [component]
    (info "DB component stopping")
    component)

  )

(defn create-new-db
  []
  (component/using (map->Database {}) []))

;; user-defined route builder here
;; TODO: modify the routes here as required
;; Note the root path is lost when merged with the standard routes

(defn user-routes [component]
  ["" [["/users" (yada/yada (str "Hello, users!" (:test (:db component))))]
       ["/developers" (yada/yada "Hello, developers!")]]])

;; TODO: modify this as required to define components, and their dependencies
(def system-map-data
  [:server (server/create-new-server)
   :db (create-new-db)
   :api (api/create-new-api [:db] user-routes)])
