# synergy-microservice-template

A Leiningen template for a Synergy microservice.

## Synergy Microservice

The template will generate a project which aims to glue together a number of libraries and good practices to simplify microservice creation using Clojure:

* Component - support for lightweight DI pattern, and component lifecycle management
* Aero - configuration handling
* Timbre - native Clojure logging
* Yada - resources definition
* Bidi - route definition
* Schema - for data shape definition and validation
* the reloaded workflow, by Stuart Sierra

## Features:

* Component-based application architecture
* reloaded workflow
* dev profile, including helper functions, e.g. (dev)
* conventions for source, e.g. ai.hackthorn.synergy.components directory  
* logging, i.e. all log output goes to STDOUT; use Timbre or println.
* configuration from a resource file - all environments to use the same configuration file, using Aero's #profile
* support for Docker

## Logging

As it is intended that each microservice produced using this template will run in a container - Docker to start with - log output will be to the console, in order to be collected by fluentd and forwarded to Elasticsearch (and/or other data stores/messaging services).

## Docker support

The intention is that you will use the Leiningen uberimage plugin, so the only explicit Docker support you'll find is in the form of the uberimage configuration section in project.clj. 

By default, the Docker container will be based on a the Java Alpine image, a minimal image which is a good deal smaller than a similar Ubuntu based image.

### Plugin requirements  

To install the uberimage plugin, you'll need to amend your ~/.lein/profiles.clj file to include the plugin:  

```
{:user {:plugins [[com.palletops/uberimage "0.4.1"]]}}
```

(The Github project for the plugin: https://github.com/palletops/lein-uberimage. See this for more information on usage and configuration of the plugin.)

### Building and running the Dockerized service

Running `lein uberimage` will invoke `lein uberjar` first - the template ensures you have a suitable main namespace, and provides a main function too, in main.clj.  

If there are no compilation errors, uberimage will create a Docker image based on the uberjar, with the tag defined in the uberimage section of project.clj.  

On successful completion of `lein uberimage`, you will be able to run an instance of the image, e.g.  

```docker run -p 8080:8080 <project name>```  

This will run up the service, which is by default on port 8080, and expose the service on port 8080.  Log output will appear on the console - terminate the running application with CTRL+C.  

## Reloaded workflow  

This workflow is well covered in http://thinkrelevance.com/blog/2013/06/04/clojure-workflow-reloaded.

In practical terms, projects generated from this template support the concept of reloadable systems, whereby you can start a system, make changes and quickly reload the changes, without restarting the REPL.  This enables rapid development cycles.

The dev.clj file contains the key functions to enable the typical workflow.

When you start a REPL, invoke the (dev) function. This creates the system.

Invoke (go) to start the system.

## Building

To build the project:  

```lein uberjar```

To install to the local Maven repository:  

```lein install```  

## Deployment  

The template can be be deployed to clojars.org, using:  

```lein deploy clojars```

See https://hackthorn.atlassian.net/wiki/display/SYNDEV/Clojars for more details on the Clojars account.

### GPG keys

Before you can deploy to Clojars, you need to install the GPG keys locally.  

Make sure you have gpg installed - https://www.gnupg.org/download/.  

From the command line, cd to the gpg-keys directory in this project.  

Next:  
```
gpg --import clojars_key.asc
 
gpg --import clojars_secret_key.asc 

gpg --list-keys```

The final command should show the key you just imported, which corresponds to the key in the :signing section of project.clj.  

## Usage

```lein new synergy-microservice <name>```

You can use fully qualified names, e.g. ai.hackthorn.synergy.servicename.

## TODO
* handle secrets using external file  
* install Alembic to handle the case where a new dependency is required, but would require a REPL restart  
* install Amazonica libraries for AWS development
* include components directory