(ns {{name}}.data.system-map
  (:require [ai.hackthorn.synergy.components.api :as api]
            [ai.hackthorn.synergy.components.server :as server]
            [taoensso.timbre :refer (log trace debug info warn error fatal)]
            [yada.yada :as yada]
            [schema.core :as s]
            [{{name}}.components.db :refer [create-new-db]]))

;; user-defined route builder
;; Note the root path is lost when merged with the standard routes

(defn user-routes [component]

  ;; TODO: modify the routes here as required

  ["" [["/users" (yada/yada (str "Hello, users!" (:test (:db component))))]
       ["/developers" (yada/yada "Hello, developers!")]]])

(def system-map-data

  ;; TODO: modify this as required to define components, and their dependencies

  [:server (server/create-new-server)
   :db (create-new-db)
   :api (api/create-new-api [:db] user-routes)])
