(ns {{name}}.main
  (:require [ai.hackthorn.synergy.data.system-data :refer [the-system]]
    [ai.hackthorn.synergy.system :refer [kill-service go configure-system-map]]
    [aleph.netty :as netty]
    [{{name}}.data.system-map :refer [system-map-data]]
    [{{name}}.commands])
  (:gen-class))

(defn -main
  []
  (.addShutdownHook (Runtime/getRuntime) (Thread. kill-service))
  (go (configure-system-map system-map-data :dev))
  (netty/wait-for-close (get-in @the-system [:system :server :server])))