// Compiled by ClojureScript 1.9.542 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__41174__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__41174__auto__){
return or__41174__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__41174__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, ["svgpan.SvgPan",null,"far.out",null,"cljs.nodejs",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__41174__auto__)){
return or__41174__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__51214_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__51214_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__51219 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__51220 = null;
var count__51221 = (0);
var i__51222 = (0);
while(true){
if((i__51222 < count__51221)){
var n = cljs.core._nth.call(null,chunk__51220,i__51222);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__51223 = seq__51219;
var G__51224 = chunk__51220;
var G__51225 = count__51221;
var G__51226 = (i__51222 + (1));
seq__51219 = G__51223;
chunk__51220 = G__51224;
count__51221 = G__51225;
i__51222 = G__51226;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__51219);
if(temp__4657__auto__){
var seq__51219__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__51219__$1)){
var c__41993__auto__ = cljs.core.chunk_first.call(null,seq__51219__$1);
var G__51227 = cljs.core.chunk_rest.call(null,seq__51219__$1);
var G__51228 = c__41993__auto__;
var G__51229 = cljs.core.count.call(null,c__41993__auto__);
var G__51230 = (0);
seq__51219 = G__51227;
chunk__51220 = G__51228;
count__51221 = G__51229;
i__51222 = G__51230;
continue;
} else {
var n = cljs.core.first.call(null,seq__51219__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__51231 = cljs.core.next.call(null,seq__51219__$1);
var G__51232 = null;
var G__51233 = (0);
var G__51234 = (0);
seq__51219 = G__51231;
chunk__51220 = G__51232;
count__51221 = G__51233;
i__51222 = G__51234;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__51285_51296 = cljs.core.seq.call(null,deps);
var chunk__51286_51297 = null;
var count__51287_51298 = (0);
var i__51288_51299 = (0);
while(true){
if((i__51288_51299 < count__51287_51298)){
var dep_51300 = cljs.core._nth.call(null,chunk__51286_51297,i__51288_51299);
topo_sort_helper_STAR_.call(null,dep_51300,(depth + (1)),state);

var G__51301 = seq__51285_51296;
var G__51302 = chunk__51286_51297;
var G__51303 = count__51287_51298;
var G__51304 = (i__51288_51299 + (1));
seq__51285_51296 = G__51301;
chunk__51286_51297 = G__51302;
count__51287_51298 = G__51303;
i__51288_51299 = G__51304;
continue;
} else {
var temp__4657__auto___51305 = cljs.core.seq.call(null,seq__51285_51296);
if(temp__4657__auto___51305){
var seq__51285_51306__$1 = temp__4657__auto___51305;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__51285_51306__$1)){
var c__41993__auto___51307 = cljs.core.chunk_first.call(null,seq__51285_51306__$1);
var G__51308 = cljs.core.chunk_rest.call(null,seq__51285_51306__$1);
var G__51309 = c__41993__auto___51307;
var G__51310 = cljs.core.count.call(null,c__41993__auto___51307);
var G__51311 = (0);
seq__51285_51296 = G__51308;
chunk__51286_51297 = G__51309;
count__51287_51298 = G__51310;
i__51288_51299 = G__51311;
continue;
} else {
var dep_51312 = cljs.core.first.call(null,seq__51285_51306__$1);
topo_sort_helper_STAR_.call(null,dep_51312,(depth + (1)),state);

var G__51313 = cljs.core.next.call(null,seq__51285_51306__$1);
var G__51314 = null;
var G__51315 = (0);
var G__51316 = (0);
seq__51285_51296 = G__51313;
chunk__51286_51297 = G__51314;
count__51287_51298 = G__51315;
i__51288_51299 = G__51316;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__51289){
var vec__51293 = p__51289;
var seq__51294 = cljs.core.seq.call(null,vec__51293);
var first__51295 = cljs.core.first.call(null,seq__51294);
var seq__51294__$1 = cljs.core.next.call(null,seq__51294);
var x = first__51295;
var xs = seq__51294__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__51293,seq__51294,first__51295,seq__51294__$1,x,xs,get_deps__$1){
return (function (p1__51235_SHARP_){
return clojure.set.difference.call(null,p1__51235_SHARP_,x);
});})(vec__51293,seq__51294,first__51295,seq__51294__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__51329 = cljs.core.seq.call(null,provides);
var chunk__51330 = null;
var count__51331 = (0);
var i__51332 = (0);
while(true){
if((i__51332 < count__51331)){
var prov = cljs.core._nth.call(null,chunk__51330,i__51332);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__51333_51341 = cljs.core.seq.call(null,requires);
var chunk__51334_51342 = null;
var count__51335_51343 = (0);
var i__51336_51344 = (0);
while(true){
if((i__51336_51344 < count__51335_51343)){
var req_51345 = cljs.core._nth.call(null,chunk__51334_51342,i__51336_51344);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_51345,prov);

var G__51346 = seq__51333_51341;
var G__51347 = chunk__51334_51342;
var G__51348 = count__51335_51343;
var G__51349 = (i__51336_51344 + (1));
seq__51333_51341 = G__51346;
chunk__51334_51342 = G__51347;
count__51335_51343 = G__51348;
i__51336_51344 = G__51349;
continue;
} else {
var temp__4657__auto___51350 = cljs.core.seq.call(null,seq__51333_51341);
if(temp__4657__auto___51350){
var seq__51333_51351__$1 = temp__4657__auto___51350;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__51333_51351__$1)){
var c__41993__auto___51352 = cljs.core.chunk_first.call(null,seq__51333_51351__$1);
var G__51353 = cljs.core.chunk_rest.call(null,seq__51333_51351__$1);
var G__51354 = c__41993__auto___51352;
var G__51355 = cljs.core.count.call(null,c__41993__auto___51352);
var G__51356 = (0);
seq__51333_51341 = G__51353;
chunk__51334_51342 = G__51354;
count__51335_51343 = G__51355;
i__51336_51344 = G__51356;
continue;
} else {
var req_51357 = cljs.core.first.call(null,seq__51333_51351__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_51357,prov);

var G__51358 = cljs.core.next.call(null,seq__51333_51351__$1);
var G__51359 = null;
var G__51360 = (0);
var G__51361 = (0);
seq__51333_51341 = G__51358;
chunk__51334_51342 = G__51359;
count__51335_51343 = G__51360;
i__51336_51344 = G__51361;
continue;
}
} else {
}
}
break;
}

var G__51362 = seq__51329;
var G__51363 = chunk__51330;
var G__51364 = count__51331;
var G__51365 = (i__51332 + (1));
seq__51329 = G__51362;
chunk__51330 = G__51363;
count__51331 = G__51364;
i__51332 = G__51365;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__51329);
if(temp__4657__auto__){
var seq__51329__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__51329__$1)){
var c__41993__auto__ = cljs.core.chunk_first.call(null,seq__51329__$1);
var G__51366 = cljs.core.chunk_rest.call(null,seq__51329__$1);
var G__51367 = c__41993__auto__;
var G__51368 = cljs.core.count.call(null,c__41993__auto__);
var G__51369 = (0);
seq__51329 = G__51366;
chunk__51330 = G__51367;
count__51331 = G__51368;
i__51332 = G__51369;
continue;
} else {
var prov = cljs.core.first.call(null,seq__51329__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__51337_51370 = cljs.core.seq.call(null,requires);
var chunk__51338_51371 = null;
var count__51339_51372 = (0);
var i__51340_51373 = (0);
while(true){
if((i__51340_51373 < count__51339_51372)){
var req_51374 = cljs.core._nth.call(null,chunk__51338_51371,i__51340_51373);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_51374,prov);

var G__51375 = seq__51337_51370;
var G__51376 = chunk__51338_51371;
var G__51377 = count__51339_51372;
var G__51378 = (i__51340_51373 + (1));
seq__51337_51370 = G__51375;
chunk__51338_51371 = G__51376;
count__51339_51372 = G__51377;
i__51340_51373 = G__51378;
continue;
} else {
var temp__4657__auto___51379__$1 = cljs.core.seq.call(null,seq__51337_51370);
if(temp__4657__auto___51379__$1){
var seq__51337_51380__$1 = temp__4657__auto___51379__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__51337_51380__$1)){
var c__41993__auto___51381 = cljs.core.chunk_first.call(null,seq__51337_51380__$1);
var G__51382 = cljs.core.chunk_rest.call(null,seq__51337_51380__$1);
var G__51383 = c__41993__auto___51381;
var G__51384 = cljs.core.count.call(null,c__41993__auto___51381);
var G__51385 = (0);
seq__51337_51370 = G__51382;
chunk__51338_51371 = G__51383;
count__51339_51372 = G__51384;
i__51340_51373 = G__51385;
continue;
} else {
var req_51386 = cljs.core.first.call(null,seq__51337_51380__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_51386,prov);

var G__51387 = cljs.core.next.call(null,seq__51337_51380__$1);
var G__51388 = null;
var G__51389 = (0);
var G__51390 = (0);
seq__51337_51370 = G__51387;
chunk__51338_51371 = G__51388;
count__51339_51372 = G__51389;
i__51340_51373 = G__51390;
continue;
}
} else {
}
}
break;
}

var G__51391 = cljs.core.next.call(null,seq__51329__$1);
var G__51392 = null;
var G__51393 = (0);
var G__51394 = (0);
seq__51329 = G__51391;
chunk__51330 = G__51392;
count__51331 = G__51393;
i__51332 = G__51394;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__51399_51403 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__51400_51404 = null;
var count__51401_51405 = (0);
var i__51402_51406 = (0);
while(true){
if((i__51402_51406 < count__51401_51405)){
var ns_51407 = cljs.core._nth.call(null,chunk__51400_51404,i__51402_51406);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_51407);

var G__51408 = seq__51399_51403;
var G__51409 = chunk__51400_51404;
var G__51410 = count__51401_51405;
var G__51411 = (i__51402_51406 + (1));
seq__51399_51403 = G__51408;
chunk__51400_51404 = G__51409;
count__51401_51405 = G__51410;
i__51402_51406 = G__51411;
continue;
} else {
var temp__4657__auto___51412 = cljs.core.seq.call(null,seq__51399_51403);
if(temp__4657__auto___51412){
var seq__51399_51413__$1 = temp__4657__auto___51412;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__51399_51413__$1)){
var c__41993__auto___51414 = cljs.core.chunk_first.call(null,seq__51399_51413__$1);
var G__51415 = cljs.core.chunk_rest.call(null,seq__51399_51413__$1);
var G__51416 = c__41993__auto___51414;
var G__51417 = cljs.core.count.call(null,c__41993__auto___51414);
var G__51418 = (0);
seq__51399_51403 = G__51415;
chunk__51400_51404 = G__51416;
count__51401_51405 = G__51417;
i__51402_51406 = G__51418;
continue;
} else {
var ns_51419 = cljs.core.first.call(null,seq__51399_51413__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_51419);

var G__51420 = cljs.core.next.call(null,seq__51399_51413__$1);
var G__51421 = null;
var G__51422 = (0);
var G__51423 = (0);
seq__51399_51403 = G__51420;
chunk__51400_51404 = G__51421;
count__51401_51405 = G__51422;
i__51402_51406 = G__51423;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__41174__auto__ = goog.require__;
if(cljs.core.truth_(or__41174__auto__)){
return or__41174__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__51424__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__51424 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__51425__i = 0, G__51425__a = new Array(arguments.length -  0);
while (G__51425__i < G__51425__a.length) {G__51425__a[G__51425__i] = arguments[G__51425__i + 0]; ++G__51425__i;}
  args = new cljs.core.IndexedSeq(G__51425__a,0,null);
} 
return G__51424__delegate.call(this,args);};
G__51424.cljs$lang$maxFixedArity = 0;
G__51424.cljs$lang$applyTo = (function (arglist__51426){
var args = cljs.core.seq(arglist__51426);
return G__51424__delegate(args);
});
G__51424.cljs$core$IFn$_invoke$arity$variadic = G__51424__delegate;
return G__51424;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred))
);

return deferred.addErrback(((function (deferred){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred))
);
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__51427 = cljs.core._EQ_;
var expr__51428 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__51427.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__51428))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__51427,expr__51428){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__51427,expr__51428))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__51427,expr__51428){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e51430){if((e51430 instanceof Error)){
var e = e51430;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e51430;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__51427,expr__51428))
} else {
if(cljs.core.truth_(pred__51427.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__51428))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__51427.call(null,new cljs.core.Keyword(null,"react-native","react-native",-1543085138),expr__51428))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__51427.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__51428))){
return ((function (pred__51427,expr__51428){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e51431){if((e51431 instanceof Error)){
var e = e51431;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e51431;

}
}})());
});
;})(pred__51427,expr__51428))
} else {
return ((function (pred__51427,expr__51428){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__51427,expr__51428))
}
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__51432,callback){
var map__51435 = p__51432;
var map__51435__$1 = ((((!((map__51435 == null)))?((((map__51435.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51435.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51435):map__51435);
var file_msg = map__51435__$1;
var request_url = cljs.core.get.call(null,map__51435__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Attempting to load "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__51435,map__51435__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Successfully loaded "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__51435,map__51435__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__46724__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto__){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto__){
return (function (state_51459){
var state_val_51460 = (state_51459[(1)]);
if((state_val_51460 === (7))){
var inst_51455 = (state_51459[(2)]);
var state_51459__$1 = state_51459;
var statearr_51461_51481 = state_51459__$1;
(statearr_51461_51481[(2)] = inst_51455);

(statearr_51461_51481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51460 === (1))){
var state_51459__$1 = state_51459;
var statearr_51462_51482 = state_51459__$1;
(statearr_51462_51482[(2)] = null);

(statearr_51462_51482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51460 === (4))){
var inst_51439 = (state_51459[(7)]);
var inst_51439__$1 = (state_51459[(2)]);
var state_51459__$1 = (function (){var statearr_51463 = state_51459;
(statearr_51463[(7)] = inst_51439__$1);

return statearr_51463;
})();
if(cljs.core.truth_(inst_51439__$1)){
var statearr_51464_51483 = state_51459__$1;
(statearr_51464_51483[(1)] = (5));

} else {
var statearr_51465_51484 = state_51459__$1;
(statearr_51465_51484[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51460 === (6))){
var state_51459__$1 = state_51459;
var statearr_51466_51485 = state_51459__$1;
(statearr_51466_51485[(2)] = null);

(statearr_51466_51485[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51460 === (3))){
var inst_51457 = (state_51459[(2)]);
var state_51459__$1 = state_51459;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51459__$1,inst_51457);
} else {
if((state_val_51460 === (2))){
var state_51459__$1 = state_51459;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51459__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_51460 === (11))){
var inst_51451 = (state_51459[(2)]);
var state_51459__$1 = (function (){var statearr_51467 = state_51459;
(statearr_51467[(8)] = inst_51451);

return statearr_51467;
})();
var statearr_51468_51486 = state_51459__$1;
(statearr_51468_51486[(2)] = null);

(statearr_51468_51486[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51460 === (9))){
var inst_51443 = (state_51459[(9)]);
var inst_51445 = (state_51459[(10)]);
var inst_51447 = inst_51445.call(null,inst_51443);
var state_51459__$1 = state_51459;
var statearr_51469_51487 = state_51459__$1;
(statearr_51469_51487[(2)] = inst_51447);

(statearr_51469_51487[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51460 === (5))){
var inst_51439 = (state_51459[(7)]);
var inst_51441 = figwheel.client.file_reloading.blocking_load.call(null,inst_51439);
var state_51459__$1 = state_51459;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51459__$1,(8),inst_51441);
} else {
if((state_val_51460 === (10))){
var inst_51443 = (state_51459[(9)]);
var inst_51449 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_51443);
var state_51459__$1 = state_51459;
var statearr_51470_51488 = state_51459__$1;
(statearr_51470_51488[(2)] = inst_51449);

(statearr_51470_51488[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51460 === (8))){
var inst_51445 = (state_51459[(10)]);
var inst_51439 = (state_51459[(7)]);
var inst_51443 = (state_51459[(2)]);
var inst_51444 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_51445__$1 = cljs.core.get.call(null,inst_51444,inst_51439);
var state_51459__$1 = (function (){var statearr_51471 = state_51459;
(statearr_51471[(9)] = inst_51443);

(statearr_51471[(10)] = inst_51445__$1);

return statearr_51471;
})();
if(cljs.core.truth_(inst_51445__$1)){
var statearr_51472_51489 = state_51459__$1;
(statearr_51472_51489[(1)] = (9));

} else {
var statearr_51473_51490 = state_51459__$1;
(statearr_51473_51490[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto__))
;
return ((function (switch__46612__auto__,c__46724__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__46613__auto__ = null;
var figwheel$client$file_reloading$state_machine__46613__auto____0 = (function (){
var statearr_51477 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_51477[(0)] = figwheel$client$file_reloading$state_machine__46613__auto__);

(statearr_51477[(1)] = (1));

return statearr_51477;
});
var figwheel$client$file_reloading$state_machine__46613__auto____1 = (function (state_51459){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_51459);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e51478){if((e51478 instanceof Object)){
var ex__46616__auto__ = e51478;
var statearr_51479_51491 = state_51459;
(statearr_51479_51491[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51459);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51478;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51492 = state_51459;
state_51459 = G__51492;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__46613__auto__ = function(state_51459){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__46613__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__46613__auto____1.call(this,state_51459);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__46613__auto____0;
figwheel$client$file_reloading$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__46613__auto____1;
return figwheel$client$file_reloading$state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto__))
})();
var state__46726__auto__ = (function (){var statearr_51480 = f__46725__auto__.call(null);
(statearr_51480[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto__);

return statearr_51480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto__))
);

return c__46724__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__51493,callback){
var map__51496 = p__51493;
var map__51496__$1 = ((((!((map__51496 == null)))?((((map__51496.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51496.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51496):map__51496);
var file_msg = map__51496__$1;
var namespace = cljs.core.get.call(null,map__51496__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__51496,map__51496__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__51496,map__51496__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__51498){
var map__51501 = p__51498;
var map__51501__$1 = ((((!((map__51501 == null)))?((((map__51501.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51501.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51501):map__51501);
var file_msg = map__51501__$1;
var namespace = cljs.core.get.call(null,map__51501__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__51503){
var map__51506 = p__51503;
var map__51506__$1 = ((((!((map__51506 == null)))?((((map__51506.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51506.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51506):map__51506);
var file_msg = map__51506__$1;
var namespace = cljs.core.get.call(null,map__51506__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__41162__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__41162__auto__){
var or__41174__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__41174__auto__)){
return or__41174__auto__;
} else {
var or__41174__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__41174__auto____$1)){
return or__41174__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__41162__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__51508,callback){
var map__51511 = p__51508;
var map__51511__$1 = ((((!((map__51511 == null)))?((((map__51511.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51511.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51511):map__51511);
var file_msg = map__51511__$1;
var request_url = cljs.core.get.call(null,map__51511__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__51511__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not trying to load file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__46724__auto___51615 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto___51615,out){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto___51615,out){
return (function (state_51597){
var state_val_51598 = (state_51597[(1)]);
if((state_val_51598 === (1))){
var inst_51571 = cljs.core.seq.call(null,files);
var inst_51572 = cljs.core.first.call(null,inst_51571);
var inst_51573 = cljs.core.next.call(null,inst_51571);
var inst_51574 = files;
var state_51597__$1 = (function (){var statearr_51599 = state_51597;
(statearr_51599[(7)] = inst_51573);

(statearr_51599[(8)] = inst_51572);

(statearr_51599[(9)] = inst_51574);

return statearr_51599;
})();
var statearr_51600_51616 = state_51597__$1;
(statearr_51600_51616[(2)] = null);

(statearr_51600_51616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51598 === (2))){
var inst_51580 = (state_51597[(10)]);
var inst_51574 = (state_51597[(9)]);
var inst_51579 = cljs.core.seq.call(null,inst_51574);
var inst_51580__$1 = cljs.core.first.call(null,inst_51579);
var inst_51581 = cljs.core.next.call(null,inst_51579);
var inst_51582 = (inst_51580__$1 == null);
var inst_51583 = cljs.core.not.call(null,inst_51582);
var state_51597__$1 = (function (){var statearr_51601 = state_51597;
(statearr_51601[(11)] = inst_51581);

(statearr_51601[(10)] = inst_51580__$1);

return statearr_51601;
})();
if(inst_51583){
var statearr_51602_51617 = state_51597__$1;
(statearr_51602_51617[(1)] = (4));

} else {
var statearr_51603_51618 = state_51597__$1;
(statearr_51603_51618[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51598 === (3))){
var inst_51595 = (state_51597[(2)]);
var state_51597__$1 = state_51597;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51597__$1,inst_51595);
} else {
if((state_val_51598 === (4))){
var inst_51580 = (state_51597[(10)]);
var inst_51585 = figwheel.client.file_reloading.reload_js_file.call(null,inst_51580);
var state_51597__$1 = state_51597;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51597__$1,(7),inst_51585);
} else {
if((state_val_51598 === (5))){
var inst_51591 = cljs.core.async.close_BANG_.call(null,out);
var state_51597__$1 = state_51597;
var statearr_51604_51619 = state_51597__$1;
(statearr_51604_51619[(2)] = inst_51591);

(statearr_51604_51619[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51598 === (6))){
var inst_51593 = (state_51597[(2)]);
var state_51597__$1 = state_51597;
var statearr_51605_51620 = state_51597__$1;
(statearr_51605_51620[(2)] = inst_51593);

(statearr_51605_51620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51598 === (7))){
var inst_51581 = (state_51597[(11)]);
var inst_51587 = (state_51597[(2)]);
var inst_51588 = cljs.core.async.put_BANG_.call(null,out,inst_51587);
var inst_51574 = inst_51581;
var state_51597__$1 = (function (){var statearr_51606 = state_51597;
(statearr_51606[(12)] = inst_51588);

(statearr_51606[(9)] = inst_51574);

return statearr_51606;
})();
var statearr_51607_51621 = state_51597__$1;
(statearr_51607_51621[(2)] = null);

(statearr_51607_51621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__46724__auto___51615,out))
;
return ((function (switch__46612__auto__,c__46724__auto___51615,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__46613__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__46613__auto____0 = (function (){
var statearr_51611 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51611[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__46613__auto__);

(statearr_51611[(1)] = (1));

return statearr_51611;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__46613__auto____1 = (function (state_51597){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_51597);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e51612){if((e51612 instanceof Object)){
var ex__46616__auto__ = e51612;
var statearr_51613_51622 = state_51597;
(statearr_51613_51622[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51597);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51612;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51623 = state_51597;
state_51597 = G__51623;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__46613__auto__ = function(state_51597){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__46613__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__46613__auto____1.call(this,state_51597);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__46613__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__46613__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto___51615,out))
})();
var state__46726__auto__ = (function (){var statearr_51614 = f__46725__auto__.call(null);
(statearr_51614[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___51615);

return statearr_51614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto___51615,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__51624,opts){
var map__51628 = p__51624;
var map__51628__$1 = ((((!((map__51628 == null)))?((((map__51628.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51628.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51628):map__51628);
var eval_body = cljs.core.get.call(null,map__51628__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__51628__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__41162__auto__ = eval_body;
if(cljs.core.truth_(and__41162__auto__)){
return typeof eval_body === 'string';
} else {
return and__41162__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Evaling file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e51630){var e = e51630;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Unable to evaluate "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__51631_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__51631_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__51640){
var vec__51641 = p__51640;
var k = cljs.core.nth.call(null,vec__51641,(0),null);
var v = cljs.core.nth.call(null,vec__51641,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__51644){
var vec__51645 = p__51644;
var k = cljs.core.nth.call(null,vec__51645,(0),null);
var v = cljs.core.nth.call(null,vec__51645,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__51651,p__51652){
var map__51900 = p__51651;
var map__51900__$1 = ((((!((map__51900 == null)))?((((map__51900.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51900.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51900):map__51900);
var opts = map__51900__$1;
var before_jsload = cljs.core.get.call(null,map__51900__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__51900__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__51900__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__51901 = p__51652;
var map__51901__$1 = ((((!((map__51901 == null)))?((((map__51901.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51901.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51901):map__51901);
var msg = map__51901__$1;
var files = cljs.core.get.call(null,map__51901__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__51901__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__51901__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__46724__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_52055){
var state_val_52056 = (state_52055[(1)]);
if((state_val_52056 === (7))){
var inst_51916 = (state_52055[(7)]);
var inst_51915 = (state_52055[(8)]);
var inst_51917 = (state_52055[(9)]);
var inst_51918 = (state_52055[(10)]);
var inst_51923 = cljs.core._nth.call(null,inst_51916,inst_51918);
var inst_51924 = figwheel.client.file_reloading.eval_body.call(null,inst_51923,opts);
var inst_51925 = (inst_51918 + (1));
var tmp52057 = inst_51916;
var tmp52058 = inst_51915;
var tmp52059 = inst_51917;
var inst_51915__$1 = tmp52058;
var inst_51916__$1 = tmp52057;
var inst_51917__$1 = tmp52059;
var inst_51918__$1 = inst_51925;
var state_52055__$1 = (function (){var statearr_52060 = state_52055;
(statearr_52060[(7)] = inst_51916__$1);

(statearr_52060[(8)] = inst_51915__$1);

(statearr_52060[(9)] = inst_51917__$1);

(statearr_52060[(11)] = inst_51924);

(statearr_52060[(10)] = inst_51918__$1);

return statearr_52060;
})();
var statearr_52061_52147 = state_52055__$1;
(statearr_52061_52147[(2)] = null);

(statearr_52061_52147[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (20))){
var inst_51958 = (state_52055[(12)]);
var inst_51966 = figwheel.client.file_reloading.sort_files.call(null,inst_51958);
var state_52055__$1 = state_52055;
var statearr_52062_52148 = state_52055__$1;
(statearr_52062_52148[(2)] = inst_51966);

(statearr_52062_52148[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (27))){
var state_52055__$1 = state_52055;
var statearr_52063_52149 = state_52055__$1;
(statearr_52063_52149[(2)] = null);

(statearr_52063_52149[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (1))){
var inst_51907 = (state_52055[(13)]);
var inst_51904 = before_jsload.call(null,files);
var inst_51905 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_51906 = (function (){return ((function (inst_51907,inst_51904,inst_51905,state_val_52056,c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__51648_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__51648_SHARP_);
});
;})(inst_51907,inst_51904,inst_51905,state_val_52056,c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_51907__$1 = cljs.core.filter.call(null,inst_51906,files);
var inst_51908 = cljs.core.not_empty.call(null,inst_51907__$1);
var state_52055__$1 = (function (){var statearr_52064 = state_52055;
(statearr_52064[(14)] = inst_51904);

(statearr_52064[(13)] = inst_51907__$1);

(statearr_52064[(15)] = inst_51905);

return statearr_52064;
})();
if(cljs.core.truth_(inst_51908)){
var statearr_52065_52150 = state_52055__$1;
(statearr_52065_52150[(1)] = (2));

} else {
var statearr_52066_52151 = state_52055__$1;
(statearr_52066_52151[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (24))){
var state_52055__$1 = state_52055;
var statearr_52067_52152 = state_52055__$1;
(statearr_52067_52152[(2)] = null);

(statearr_52067_52152[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (39))){
var inst_52008 = (state_52055[(16)]);
var state_52055__$1 = state_52055;
var statearr_52068_52153 = state_52055__$1;
(statearr_52068_52153[(2)] = inst_52008);

(statearr_52068_52153[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (46))){
var inst_52050 = (state_52055[(2)]);
var state_52055__$1 = state_52055;
var statearr_52069_52154 = state_52055__$1;
(statearr_52069_52154[(2)] = inst_52050);

(statearr_52069_52154[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (4))){
var inst_51952 = (state_52055[(2)]);
var inst_51953 = cljs.core.List.EMPTY;
var inst_51954 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_51953);
var inst_51955 = (function (){return ((function (inst_51952,inst_51953,inst_51954,state_val_52056,c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__51649_SHARP_){
var and__41162__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__51649_SHARP_);
if(cljs.core.truth_(and__41162__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__51649_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__51649_SHARP_)));
} else {
return and__41162__auto__;
}
});
;})(inst_51952,inst_51953,inst_51954,state_val_52056,c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_51956 = cljs.core.filter.call(null,inst_51955,files);
var inst_51957 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_51958 = cljs.core.concat.call(null,inst_51956,inst_51957);
var state_52055__$1 = (function (){var statearr_52070 = state_52055;
(statearr_52070[(12)] = inst_51958);

(statearr_52070[(17)] = inst_51954);

(statearr_52070[(18)] = inst_51952);

return statearr_52070;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_52071_52155 = state_52055__$1;
(statearr_52071_52155[(1)] = (16));

} else {
var statearr_52072_52156 = state_52055__$1;
(statearr_52072_52156[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (15))){
var inst_51942 = (state_52055[(2)]);
var state_52055__$1 = state_52055;
var statearr_52073_52157 = state_52055__$1;
(statearr_52073_52157[(2)] = inst_51942);

(statearr_52073_52157[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (21))){
var inst_51968 = (state_52055[(19)]);
var inst_51968__$1 = (state_52055[(2)]);
var inst_51969 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_51968__$1);
var state_52055__$1 = (function (){var statearr_52074 = state_52055;
(statearr_52074[(19)] = inst_51968__$1);

return statearr_52074;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52055__$1,(22),inst_51969);
} else {
if((state_val_52056 === (31))){
var inst_52053 = (state_52055[(2)]);
var state_52055__$1 = state_52055;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52055__$1,inst_52053);
} else {
if((state_val_52056 === (32))){
var inst_52008 = (state_52055[(16)]);
var inst_52013 = inst_52008.cljs$lang$protocol_mask$partition0$;
var inst_52014 = (inst_52013 & (64));
var inst_52015 = inst_52008.cljs$core$ISeq$;
var inst_52016 = (cljs.core.PROTOCOL_SENTINEL === inst_52015);
var inst_52017 = (inst_52014) || (inst_52016);
var state_52055__$1 = state_52055;
if(cljs.core.truth_(inst_52017)){
var statearr_52075_52158 = state_52055__$1;
(statearr_52075_52158[(1)] = (35));

} else {
var statearr_52076_52159 = state_52055__$1;
(statearr_52076_52159[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (40))){
var inst_52030 = (state_52055[(20)]);
var inst_52029 = (state_52055[(2)]);
var inst_52030__$1 = cljs.core.get.call(null,inst_52029,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_52031 = cljs.core.get.call(null,inst_52029,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_52032 = cljs.core.not_empty.call(null,inst_52030__$1);
var state_52055__$1 = (function (){var statearr_52077 = state_52055;
(statearr_52077[(21)] = inst_52031);

(statearr_52077[(20)] = inst_52030__$1);

return statearr_52077;
})();
if(cljs.core.truth_(inst_52032)){
var statearr_52078_52160 = state_52055__$1;
(statearr_52078_52160[(1)] = (41));

} else {
var statearr_52079_52161 = state_52055__$1;
(statearr_52079_52161[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (33))){
var state_52055__$1 = state_52055;
var statearr_52080_52162 = state_52055__$1;
(statearr_52080_52162[(2)] = false);

(statearr_52080_52162[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (13))){
var inst_51928 = (state_52055[(22)]);
var inst_51932 = cljs.core.chunk_first.call(null,inst_51928);
var inst_51933 = cljs.core.chunk_rest.call(null,inst_51928);
var inst_51934 = cljs.core.count.call(null,inst_51932);
var inst_51915 = inst_51933;
var inst_51916 = inst_51932;
var inst_51917 = inst_51934;
var inst_51918 = (0);
var state_52055__$1 = (function (){var statearr_52081 = state_52055;
(statearr_52081[(7)] = inst_51916);

(statearr_52081[(8)] = inst_51915);

(statearr_52081[(9)] = inst_51917);

(statearr_52081[(10)] = inst_51918);

return statearr_52081;
})();
var statearr_52082_52163 = state_52055__$1;
(statearr_52082_52163[(2)] = null);

(statearr_52082_52163[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (22))){
var inst_51971 = (state_52055[(23)]);
var inst_51968 = (state_52055[(19)]);
var inst_51976 = (state_52055[(24)]);
var inst_51972 = (state_52055[(25)]);
var inst_51971__$1 = (state_52055[(2)]);
var inst_51972__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_51971__$1);
var inst_51973 = (function (){var all_files = inst_51968;
var res_SINGLEQUOTE_ = inst_51971__$1;
var res = inst_51972__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_51971,inst_51968,inst_51976,inst_51972,inst_51971__$1,inst_51972__$1,state_val_52056,c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__51650_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__51650_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_51971,inst_51968,inst_51976,inst_51972,inst_51971__$1,inst_51972__$1,state_val_52056,c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_51974 = cljs.core.filter.call(null,inst_51973,inst_51971__$1);
var inst_51975 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_51976__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_51975);
var inst_51977 = cljs.core.not_empty.call(null,inst_51976__$1);
var state_52055__$1 = (function (){var statearr_52083 = state_52055;
(statearr_52083[(26)] = inst_51974);

(statearr_52083[(23)] = inst_51971__$1);

(statearr_52083[(24)] = inst_51976__$1);

(statearr_52083[(25)] = inst_51972__$1);

return statearr_52083;
})();
if(cljs.core.truth_(inst_51977)){
var statearr_52084_52164 = state_52055__$1;
(statearr_52084_52164[(1)] = (23));

} else {
var statearr_52085_52165 = state_52055__$1;
(statearr_52085_52165[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (36))){
var state_52055__$1 = state_52055;
var statearr_52086_52166 = state_52055__$1;
(statearr_52086_52166[(2)] = false);

(statearr_52086_52166[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (41))){
var inst_52030 = (state_52055[(20)]);
var inst_52034 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_52035 = cljs.core.map.call(null,inst_52034,inst_52030);
var inst_52036 = cljs.core.pr_str.call(null,inst_52035);
var inst_52037 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("figwheel-no-load meta-data: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_52036)].join('');
var inst_52038 = figwheel.client.utils.log.call(null,inst_52037);
var state_52055__$1 = state_52055;
var statearr_52087_52167 = state_52055__$1;
(statearr_52087_52167[(2)] = inst_52038);

(statearr_52087_52167[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (43))){
var inst_52031 = (state_52055[(21)]);
var inst_52041 = (state_52055[(2)]);
var inst_52042 = cljs.core.not_empty.call(null,inst_52031);
var state_52055__$1 = (function (){var statearr_52088 = state_52055;
(statearr_52088[(27)] = inst_52041);

return statearr_52088;
})();
if(cljs.core.truth_(inst_52042)){
var statearr_52089_52168 = state_52055__$1;
(statearr_52089_52168[(1)] = (44));

} else {
var statearr_52090_52169 = state_52055__$1;
(statearr_52090_52169[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (29))){
var inst_52008 = (state_52055[(16)]);
var inst_51974 = (state_52055[(26)]);
var inst_51971 = (state_52055[(23)]);
var inst_51968 = (state_52055[(19)]);
var inst_51976 = (state_52055[(24)]);
var inst_51972 = (state_52055[(25)]);
var inst_52004 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_52007 = (function (){var all_files = inst_51968;
var res_SINGLEQUOTE_ = inst_51971;
var res = inst_51972;
var files_not_loaded = inst_51974;
var dependencies_that_loaded = inst_51976;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_52008,inst_51974,inst_51971,inst_51968,inst_51976,inst_51972,inst_52004,state_val_52056,c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__52006){
var map__52091 = p__52006;
var map__52091__$1 = ((((!((map__52091 == null)))?((((map__52091.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52091.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52091):map__52091);
var namespace = cljs.core.get.call(null,map__52091__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_52008,inst_51974,inst_51971,inst_51968,inst_51976,inst_51972,inst_52004,state_val_52056,c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_52008__$1 = cljs.core.group_by.call(null,inst_52007,inst_51974);
var inst_52010 = (inst_52008__$1 == null);
var inst_52011 = cljs.core.not.call(null,inst_52010);
var state_52055__$1 = (function (){var statearr_52093 = state_52055;
(statearr_52093[(16)] = inst_52008__$1);

(statearr_52093[(28)] = inst_52004);

return statearr_52093;
})();
if(inst_52011){
var statearr_52094_52170 = state_52055__$1;
(statearr_52094_52170[(1)] = (32));

} else {
var statearr_52095_52171 = state_52055__$1;
(statearr_52095_52171[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (44))){
var inst_52031 = (state_52055[(21)]);
var inst_52044 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_52031);
var inst_52045 = cljs.core.pr_str.call(null,inst_52044);
var inst_52046 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("not required: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_52045)].join('');
var inst_52047 = figwheel.client.utils.log.call(null,inst_52046);
var state_52055__$1 = state_52055;
var statearr_52096_52172 = state_52055__$1;
(statearr_52096_52172[(2)] = inst_52047);

(statearr_52096_52172[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (6))){
var inst_51949 = (state_52055[(2)]);
var state_52055__$1 = state_52055;
var statearr_52097_52173 = state_52055__$1;
(statearr_52097_52173[(2)] = inst_51949);

(statearr_52097_52173[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (28))){
var inst_51974 = (state_52055[(26)]);
var inst_52001 = (state_52055[(2)]);
var inst_52002 = cljs.core.not_empty.call(null,inst_51974);
var state_52055__$1 = (function (){var statearr_52098 = state_52055;
(statearr_52098[(29)] = inst_52001);

return statearr_52098;
})();
if(cljs.core.truth_(inst_52002)){
var statearr_52099_52174 = state_52055__$1;
(statearr_52099_52174[(1)] = (29));

} else {
var statearr_52100_52175 = state_52055__$1;
(statearr_52100_52175[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (25))){
var inst_51972 = (state_52055[(25)]);
var inst_51988 = (state_52055[(2)]);
var inst_51989 = cljs.core.not_empty.call(null,inst_51972);
var state_52055__$1 = (function (){var statearr_52101 = state_52055;
(statearr_52101[(30)] = inst_51988);

return statearr_52101;
})();
if(cljs.core.truth_(inst_51989)){
var statearr_52102_52176 = state_52055__$1;
(statearr_52102_52176[(1)] = (26));

} else {
var statearr_52103_52177 = state_52055__$1;
(statearr_52103_52177[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (34))){
var inst_52024 = (state_52055[(2)]);
var state_52055__$1 = state_52055;
if(cljs.core.truth_(inst_52024)){
var statearr_52104_52178 = state_52055__$1;
(statearr_52104_52178[(1)] = (38));

} else {
var statearr_52105_52179 = state_52055__$1;
(statearr_52105_52179[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (17))){
var state_52055__$1 = state_52055;
var statearr_52106_52180 = state_52055__$1;
(statearr_52106_52180[(2)] = recompile_dependents);

(statearr_52106_52180[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (3))){
var state_52055__$1 = state_52055;
var statearr_52107_52181 = state_52055__$1;
(statearr_52107_52181[(2)] = null);

(statearr_52107_52181[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (12))){
var inst_51945 = (state_52055[(2)]);
var state_52055__$1 = state_52055;
var statearr_52108_52182 = state_52055__$1;
(statearr_52108_52182[(2)] = inst_51945);

(statearr_52108_52182[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (2))){
var inst_51907 = (state_52055[(13)]);
var inst_51914 = cljs.core.seq.call(null,inst_51907);
var inst_51915 = inst_51914;
var inst_51916 = null;
var inst_51917 = (0);
var inst_51918 = (0);
var state_52055__$1 = (function (){var statearr_52109 = state_52055;
(statearr_52109[(7)] = inst_51916);

(statearr_52109[(8)] = inst_51915);

(statearr_52109[(9)] = inst_51917);

(statearr_52109[(10)] = inst_51918);

return statearr_52109;
})();
var statearr_52110_52183 = state_52055__$1;
(statearr_52110_52183[(2)] = null);

(statearr_52110_52183[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (23))){
var inst_51974 = (state_52055[(26)]);
var inst_51971 = (state_52055[(23)]);
var inst_51968 = (state_52055[(19)]);
var inst_51976 = (state_52055[(24)]);
var inst_51972 = (state_52055[(25)]);
var inst_51979 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_51981 = (function (){var all_files = inst_51968;
var res_SINGLEQUOTE_ = inst_51971;
var res = inst_51972;
var files_not_loaded = inst_51974;
var dependencies_that_loaded = inst_51976;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_51974,inst_51971,inst_51968,inst_51976,inst_51972,inst_51979,state_val_52056,c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__51980){
var map__52111 = p__51980;
var map__52111__$1 = ((((!((map__52111 == null)))?((((map__52111.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52111.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52111):map__52111);
var request_url = cljs.core.get.call(null,map__52111__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_51974,inst_51971,inst_51968,inst_51976,inst_51972,inst_51979,state_val_52056,c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_51982 = cljs.core.reverse.call(null,inst_51976);
var inst_51983 = cljs.core.map.call(null,inst_51981,inst_51982);
var inst_51984 = cljs.core.pr_str.call(null,inst_51983);
var inst_51985 = figwheel.client.utils.log.call(null,inst_51984);
var state_52055__$1 = (function (){var statearr_52113 = state_52055;
(statearr_52113[(31)] = inst_51979);

return statearr_52113;
})();
var statearr_52114_52184 = state_52055__$1;
(statearr_52114_52184[(2)] = inst_51985);

(statearr_52114_52184[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (35))){
var state_52055__$1 = state_52055;
var statearr_52115_52185 = state_52055__$1;
(statearr_52115_52185[(2)] = true);

(statearr_52115_52185[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (19))){
var inst_51958 = (state_52055[(12)]);
var inst_51964 = figwheel.client.file_reloading.expand_files.call(null,inst_51958);
var state_52055__$1 = state_52055;
var statearr_52116_52186 = state_52055__$1;
(statearr_52116_52186[(2)] = inst_51964);

(statearr_52116_52186[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (11))){
var state_52055__$1 = state_52055;
var statearr_52117_52187 = state_52055__$1;
(statearr_52117_52187[(2)] = null);

(statearr_52117_52187[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (9))){
var inst_51947 = (state_52055[(2)]);
var state_52055__$1 = state_52055;
var statearr_52118_52188 = state_52055__$1;
(statearr_52118_52188[(2)] = inst_51947);

(statearr_52118_52188[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (5))){
var inst_51917 = (state_52055[(9)]);
var inst_51918 = (state_52055[(10)]);
var inst_51920 = (inst_51918 < inst_51917);
var inst_51921 = inst_51920;
var state_52055__$1 = state_52055;
if(cljs.core.truth_(inst_51921)){
var statearr_52119_52189 = state_52055__$1;
(statearr_52119_52189[(1)] = (7));

} else {
var statearr_52120_52190 = state_52055__$1;
(statearr_52120_52190[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (14))){
var inst_51928 = (state_52055[(22)]);
var inst_51937 = cljs.core.first.call(null,inst_51928);
var inst_51938 = figwheel.client.file_reloading.eval_body.call(null,inst_51937,opts);
var inst_51939 = cljs.core.next.call(null,inst_51928);
var inst_51915 = inst_51939;
var inst_51916 = null;
var inst_51917 = (0);
var inst_51918 = (0);
var state_52055__$1 = (function (){var statearr_52121 = state_52055;
(statearr_52121[(32)] = inst_51938);

(statearr_52121[(7)] = inst_51916);

(statearr_52121[(8)] = inst_51915);

(statearr_52121[(9)] = inst_51917);

(statearr_52121[(10)] = inst_51918);

return statearr_52121;
})();
var statearr_52122_52191 = state_52055__$1;
(statearr_52122_52191[(2)] = null);

(statearr_52122_52191[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (45))){
var state_52055__$1 = state_52055;
var statearr_52123_52192 = state_52055__$1;
(statearr_52123_52192[(2)] = null);

(statearr_52123_52192[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (26))){
var inst_51974 = (state_52055[(26)]);
var inst_51971 = (state_52055[(23)]);
var inst_51968 = (state_52055[(19)]);
var inst_51976 = (state_52055[(24)]);
var inst_51972 = (state_52055[(25)]);
var inst_51991 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_51993 = (function (){var all_files = inst_51968;
var res_SINGLEQUOTE_ = inst_51971;
var res = inst_51972;
var files_not_loaded = inst_51974;
var dependencies_that_loaded = inst_51976;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_51974,inst_51971,inst_51968,inst_51976,inst_51972,inst_51991,state_val_52056,c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__51992){
var map__52124 = p__51992;
var map__52124__$1 = ((((!((map__52124 == null)))?((((map__52124.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52124.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52124):map__52124);
var namespace = cljs.core.get.call(null,map__52124__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__52124__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_51974,inst_51971,inst_51968,inst_51976,inst_51972,inst_51991,state_val_52056,c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_51994 = cljs.core.map.call(null,inst_51993,inst_51972);
var inst_51995 = cljs.core.pr_str.call(null,inst_51994);
var inst_51996 = figwheel.client.utils.log.call(null,inst_51995);
var inst_51997 = (function (){var all_files = inst_51968;
var res_SINGLEQUOTE_ = inst_51971;
var res = inst_51972;
var files_not_loaded = inst_51974;
var dependencies_that_loaded = inst_51976;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_51974,inst_51971,inst_51968,inst_51976,inst_51972,inst_51991,inst_51993,inst_51994,inst_51995,inst_51996,state_val_52056,c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_51974,inst_51971,inst_51968,inst_51976,inst_51972,inst_51991,inst_51993,inst_51994,inst_51995,inst_51996,state_val_52056,c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_51998 = setTimeout(inst_51997,(10));
var state_52055__$1 = (function (){var statearr_52126 = state_52055;
(statearr_52126[(33)] = inst_51991);

(statearr_52126[(34)] = inst_51996);

return statearr_52126;
})();
var statearr_52127_52193 = state_52055__$1;
(statearr_52127_52193[(2)] = inst_51998);

(statearr_52127_52193[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (16))){
var state_52055__$1 = state_52055;
var statearr_52128_52194 = state_52055__$1;
(statearr_52128_52194[(2)] = reload_dependents);

(statearr_52128_52194[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (38))){
var inst_52008 = (state_52055[(16)]);
var inst_52026 = cljs.core.apply.call(null,cljs.core.hash_map,inst_52008);
var state_52055__$1 = state_52055;
var statearr_52129_52195 = state_52055__$1;
(statearr_52129_52195[(2)] = inst_52026);

(statearr_52129_52195[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (30))){
var state_52055__$1 = state_52055;
var statearr_52130_52196 = state_52055__$1;
(statearr_52130_52196[(2)] = null);

(statearr_52130_52196[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (10))){
var inst_51928 = (state_52055[(22)]);
var inst_51930 = cljs.core.chunked_seq_QMARK_.call(null,inst_51928);
var state_52055__$1 = state_52055;
if(inst_51930){
var statearr_52131_52197 = state_52055__$1;
(statearr_52131_52197[(1)] = (13));

} else {
var statearr_52132_52198 = state_52055__$1;
(statearr_52132_52198[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (18))){
var inst_51962 = (state_52055[(2)]);
var state_52055__$1 = state_52055;
if(cljs.core.truth_(inst_51962)){
var statearr_52133_52199 = state_52055__$1;
(statearr_52133_52199[(1)] = (19));

} else {
var statearr_52134_52200 = state_52055__$1;
(statearr_52134_52200[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (42))){
var state_52055__$1 = state_52055;
var statearr_52135_52201 = state_52055__$1;
(statearr_52135_52201[(2)] = null);

(statearr_52135_52201[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (37))){
var inst_52021 = (state_52055[(2)]);
var state_52055__$1 = state_52055;
var statearr_52136_52202 = state_52055__$1;
(statearr_52136_52202[(2)] = inst_52021);

(statearr_52136_52202[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52056 === (8))){
var inst_51928 = (state_52055[(22)]);
var inst_51915 = (state_52055[(8)]);
var inst_51928__$1 = cljs.core.seq.call(null,inst_51915);
var state_52055__$1 = (function (){var statearr_52137 = state_52055;
(statearr_52137[(22)] = inst_51928__$1);

return statearr_52137;
})();
if(inst_51928__$1){
var statearr_52138_52203 = state_52055__$1;
(statearr_52138_52203[(1)] = (10));

} else {
var statearr_52139_52204 = state_52055__$1;
(statearr_52139_52204[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__46612__auto__,c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__46613__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__46613__auto____0 = (function (){
var statearr_52143 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52143[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__46613__auto__);

(statearr_52143[(1)] = (1));

return statearr_52143;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__46613__auto____1 = (function (state_52055){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_52055);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e52144){if((e52144 instanceof Object)){
var ex__46616__auto__ = e52144;
var statearr_52145_52205 = state_52055;
(statearr_52145_52205[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52055);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52144;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52206 = state_52055;
state_52055 = G__52206;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__46613__auto__ = function(state_52055){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__46613__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__46613__auto____1.call(this,state_52055);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__46613__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__46613__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__46726__auto__ = (function (){var statearr_52146 = f__46725__auto__.call(null);
(statearr_52146[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto__);

return statearr_52146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto__,map__51900,map__51900__$1,opts,before_jsload,on_jsload,reload_dependents,map__51901,map__51901__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__46724__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),cljs.core.str.cljs$core$IFn$_invoke$arity$1("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__52209,link){
var map__52212 = p__52209;
var map__52212__$1 = ((((!((map__52212 == null)))?((((map__52212.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52212.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52212):map__52212);
var file = cljs.core.get.call(null,map__52212__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__52212,map__52212__$1,file){
return (function (p1__52207_SHARP_,p2__52208_SHARP_){
if(cljs.core._EQ_.call(null,p1__52207_SHARP_,p2__52208_SHARP_)){
return p1__52207_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__52212,map__52212__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__52218){
var map__52219 = p__52218;
var map__52219__$1 = ((((!((map__52219 == null)))?((((map__52219.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52219.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52219):map__52219);
var match_length = cljs.core.get.call(null,map__52219__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__52219__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__52214_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__52214_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__52221_SHARP_,p2__52222_SHARP_){
return cljs.core.assoc.call(null,p1__52221_SHARP_,cljs.core.get.call(null,p2__52222_SHARP_,key),p2__52222_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__4655__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4655__auto__)){
var link = temp__4655__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__4655__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__4655__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_52223 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_52223);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_52223);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__52224,p__52225){
var map__52230 = p__52224;
var map__52230__$1 = ((((!((map__52230 == null)))?((((map__52230.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52230.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52230):map__52230);
var on_cssload = cljs.core.get.call(null,map__52230__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__52231 = p__52225;
var map__52231__$1 = ((((!((map__52231 == null)))?((((map__52231.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52231.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52231):map__52231);
var files_msg = map__52231__$1;
var files = cljs.core.get.call(null,map__52231__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__4657__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__4657__auto__)){
var f_datas = temp__4657__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1495428392003