;; Copyright © technosophist
;;
;; This Source Code Form is subject to the terms of the Mozilla Public
;; License, v. 2.0. If a copy of the MPL was not distributed with this
;; file, You can obtain one at http://mozilla.org/MPL/2.0/.
;;
;; This Source Code Form is "Incompatible With Secondary Licenses", as
;; defined by the Mozilla Public License, v. 2.0.
(ns hooks.systems.thoughtfull.decoder)

(defmacro defdecoder
  [name & args]
  (let [[docstring? & args] (if (string? (first args))
                              args
                              (cons nil args))
        [open decode done?] args
        close (if (= (count args) 4)
                (nth args 3)
                nil)]
    `(def ~(vary-meta name
             merge
             {:arglists ''([source])}
             (when docstring? {:doc docstring?}))
       (systems.thoughtfull.decoder/make ~open ~decode ~done? ~close))))
