(ns systems.thoughtfull.desiderata
  (:refer-clojure :exclude [defrecord]))

(defn- parse-opts
  [opts+specs]
  (loop [[k v & s :as specs] opts+specs
         defaults nil
         opts []]
    (if (and (seq specs) (keyword? k))
      (if (= (name k) "defaults")
        (recur s v opts)
        (recur s defaults (conj opts k v)))
      [defaults opts specs])))

(defn- parse-initializer
  [name specs]
  (loop [[s & ss :as specs] specs
         not-initializer []]
    (if (seq specs)
      (if (and (list? s) (= (first s) name))
        [s (into not-initializer ss)]
        (recur ss (conj not-initializer s)))
      [nil not-initializer])))

(defmacro defrecord
  [name & args]
  (let [[docstring & args] (cond->> args (not (string? (first args))) (cons nil))
        [fields & args] args
        [defaults opts specs] (parse-opts args)
        [initializer specs] (parse-initializer name specs)
        [init-params & init-body] (or (next initializer) `[[this#] this#])
        pfactory (symbol (format "->%s" name))
        factory (symbol (format "map->%s" name))]
    `(let [defaults# (fn [] ~defaults)
           record# (clojure.core/defrecord ~name ~fields ~@opts ~@specs)
           pfactory# ~pfactory
           factory# ~factory
           initializer# (fn [this#]
                          (let [{:keys [~@fields]} this#
                                ~init-params [this#]
                                this# (do ~@init-body)]
                            (when-not (instance? record# this#)
                              (throw (java.lang.IllegalStateException.
                                       (str "Initializer should return instance of " '~name))))
                            this#))]
       ^{:clj-kondo/ignore [:redefined-var]}
       (defn ~pfactory
         {:doc (str (:doc (meta (var ~pfactory)))
                 (when-let [docstring# ~docstring]
                   (format "\n\n  %s" docstring#)))}
         [~@fields]
         (let [defaults# (defaults#)
               extra-keys# (into #{} (remove ~(into #{} (map keyword) fields)) (keys defaults#))]
           (initializer# (merge (pfactory# ~@fields) (select-keys defaults# extra-keys#)))))
       ^{:clj-kondo/ignore [:redefined-var]}
       (defn ~factory
         {:doc (str (:doc (meta (var ~factory)))
                 (when-let [docstring# ~docstring]
                   (format "\n\n  %s" docstring#)))
          :arglists '([& {:keys [~@fields]}])}
         [& {:as args#}]
         (initializer# (factory# (merge (defaults#) args#))))
       record#)))
