(defproject szew/essbase "0.1.0"

  :description "Consume various files produced by Essbase."
  :url "https://bitbucket.org/spottr/szew-essbase"

  :license {:name "MIT Public License"
            :distribution :repo
            :comments "LICENSE file in project root directory."}

  :dependencies [[org.clojure/clojure "1.8.0"]
                 ;; Basic szew/io library.
                 [szew/io "0.2.4" :exclusions [orc.clojure/clojure]]
                 ;; Proper CSV handling, combat proven.
                 [clojure-csv/clojure-csv "2.0.2"]
                 ;; Date and Time manipulation.
                 [clj-time "0.13.0"]
                 ;; Proper names and stuff.
                 [camel-snake-kebab "0.4.0"]
                 ]

  :profiles {:dev {:dependencies [[criterium "0.4.4"]
                                  [eftest "0.3.1"]]
                   :plugins [[lein-codox "0.10.0"]
                             [lein-eftest "0.3.1"]]
                   :source-paths ["dev/src"]}
             :1.9 {:dependencies [[org.clojure/clojure "1.9.0-alpha17"]]}
             :uberjar {:aot :all}}

  :global-vars {*warn-on-reflection* false
                *assert* false}

  :aot :all

  :jar-name "szew-essbase.jar"
  :uberjar-name "szew-essbase-fat.jar"

  :codox {;:metadata {:doc/format :markdown}
          :project {:name "szew/essbase"}
          :namespaces [#"^szew\.essbase.*$"]
          ;; that was fun:
          :source-uri ~(str "https://bitbucket.org/spottr/szew-essbase/src/"
                            "" ; 0.1.0
                            "9d31ee363f9ca733533acd879b5aa2415ecf3b34" ; init
                            "/{filepath}#{basename}-{line}")}

  )
