(defproject szew/essbase "0.2.0"

  :description "Consume various files produced by Essbase."
  :url "https://bitbucket.org/spottr/szew-essbase"

  :license {:name "MIT Public License"
            :distribution :repo
            :comments "LICENSE file in project root directory."}

  :dependencies [[org.clojure/clojure "1.10.1"]
                 ;; Basic szew/io library.
                 [szew/io "0.3.6" :exclusions [orc.clojure/clojure]]
                 ;; Proper CSV handling, combat proven.
                 [clojure-csv/clojure-csv "2.0.2"]
                 ;; Date and Time manipulation.
                 [clj-time "0.15.1"]
                 ;; Proper names and stuff.
                 [camel-snake-kebab "0.4.0"]]

  :profiles {:dev {:dependencies [[criterium "0.4.5"]
                                  [orchestra "2019.02.06-1"]
                                  [org.clojure/test.check "0.9.0"]
                                  [eftest "0.5.8"]]
                   :plugins [[lein-codox "0.10.6"]
                             [jonase/eastwood "0.3.5"]]
                   :source-paths ["dev/src"]
                   :eastwood {:exclude-linters [:def-in-def :deprecations]
                              :debug [:time]}
                   ;:jvm-opts ["--illegal-access=debug"]
                   ;:jvm-opts ["--illegal-access=deny"]
                   }
             :1.9 {:dependencies [[org.clojure/clojure "1.9.0"]]}
             :uberjar {:aot :all}}

  :global-vars {*warn-on-reflection* false
                *assert* false}

  :aot :all

  :jar-name "szew-essbase.jar"
  :uberjar-name "szew-essbase-fat.jar"

  :codox {;:metadata {:doc/format :markdown}
          :project {:name "szew/essbase"}
          :namespaces [#"^szew\.essbase\.\w+$"]
          ;; that was fun:
          :source-uri
          ~(str "https://bitbucket.org/spottr/szew-essbase/src/"
                "2b34fa91e7735dd5c2622ad662017dedca963df7" ; 0.2.0
                "/{filepath}#{basename}-{line}")}

  )
