(defproject szew/essbase "0.3.2"

  :description "Consume various files produced by Essbase."
  :url "https://bitbucket.org/spottr/szew-essbase"

  :license {:name "MIT Public License"
            :distribution :repo
            :comments "LICENSE file in project root directory."}

  :dependencies [[org.clojure/clojure "1.10.1"]
                 ;; Basic szew/io library.
                 [szew/io "0.4.0" :exclusions [orc.clojure/clojure]]
                 ;; Proper CSV handling, combat proven.
                 [clojure-csv/clojure-csv "2.0.2"]
                 ;; Date and Time manipulation.
                 [clj-time "0.15.2"]
                 ;; Proper names and stuff.
                 [camel-snake-kebab "0.4.1"]]

  :profiles {:dev {:dependencies [[criterium "0.4.5"]
                                  [orchestra "2019.02.06-1"]
                                  [org.clojure/test.check "1.0.0"]
                                  [eftest "0.5.9"]]
                   :plugins [[lein-codox "0.10.6"]
                             [jonase/eastwood "0.3.5"]]
                   :source-paths ["dev/src"]
                   :eastwood {:exclude-linters [:def-in-def :deprecations]
                              :debug [:time]}
                   ;:jvm-opts ["--illegal-access=debug"]
                   ;:jvm-opts ["--illegal-access=warn"]
                   ;:jvm-opts ["--illegal-access=deny"]
                   }
             :1.9 {:dependencies [[org.clojure/clojure "1.9.0"]]}
             :1.10.2 {:dependencies [[org.clojure/clojure "1.10.2-alpha1"]]}
             :uberjar {:aot :all}}

  :global-vars {*warn-on-reflection* true
                *assert* false}

  :aot :all

  :codox {;:metadata {:doc/format :markdown}
          :project {:name "szew/essbase"}
          :namespaces [#"^szew\.essbase\.\w+$"]
          ;; that was fun:
          :source-uri
          ~(str "https://bitbucket.org/spottr/szew-essbase/src/"
                "ed7e1b1e3815c6b7451ef4934297db3ee555882a" ; 0.3.1
                "/{filepath}#{basename}-{line}")})
