(defproject szew/fi "0.3.1"


  :description "Index and compare file trees."
  :url "https://bitbucket.org/spottr/szew-fi"

  :license {:name "MIT Public License"
            :distribution :repo
            :comments "LICENSE file in project root directory."}

  :dependencies [[org.clojure/clojure "1.9.0"]
                 [org.clojure/core.async "0.4.474"]
                 ;; Szew stuff
                 [szew/io "0.3.1" :exclusions [orc.clojure/clojure]]
                 [szew/h2 "0.2.0"
                  :exclusions [org.clojure/clojure
                               com.h2database/h2]]
                 [szew/repl "0.2.0"]
                 ;; Integrant
                 [integrant "0.6.3"]
                 ;; diff report writer
                 [hiccup "1.0.5"]
                 ;; diffing is a solved problem
                 [com.googlecode.java-diff-utils/diffutils "1.3.0"]
                 ;; Logging infrastructure!
                 [ch.qos.logback/logback-classic "1.2.3"]
                 [ch.qos.logback/logback-core "1.2.3"]
                 [org.slf4j/slf4j-api "1.7.25"]
                 [org.slf4j/log4j-over-slf4j "1.7.25"]
                 [org.clojure/tools.logging "0.4.1"]
                 ;; Environment variables in Clojure
                 [environ "1.1.0"]
                 ;; SQL stuffs
                 [org.clojure/java.jdbc "0.7.8"]
                 [com.h2database/h2 "1.4.197"]
                 [com.layerware/hugsql "0.4.9"]]

  :profiles {:dev {:dependencies [[criterium "0.4.4"]]
                   :plugins [[lein-codox "0.10.3"]]
                   :source-paths ["dev"]}
             :1.10 {:dependencies [[org.clojure/clojure "1.10.0-alpha7"]]}
             :uberjar {:aot :all}}

  ;:global-vars {*warn-on-reflection* false
  ;              *assert* true}

  :aot [clojure.tools.logging.impl ;; aot or die!!!11
        szew.fi]

  :main szew.repl

  :codox {:project {:name "szew/fi"}
          :namespaces [#"^szew\.fi.*$"]
          ;; that was fun:
          :source-uri
          ~(str "https://bitbucket.org/spottr/szew-fi/src/"
                "8f94449ae9d6179bf835adfdb38bf990d3a459f7" ;; 0.3.1
                "/{filepath}#{basename}-{line}")}

  :jar-exclusions [#"logback-test\.xml"]

  :jvm-opts [])

