(defproject szew/h2 "0.3.0"

  :description "Clojure wrapper for H2 database."
  :url "https://bitbucket.org/spottr/szew-h2"

  :license {:name "MIT Public License"
            :distribution :repo
            :comments "LICENSE file in project root directory."}

  :dependencies [[org.clojure/clojure "1.10.1"]
                 ;; Embedded database engine, BETA, last stable = 1.3.176
                 [com.h2database/h2 "1.4.199"]]

  :profiles {:dev {:dependencies [[criterium "0.4.5"]
                                  ;; The must: database interop
                                  [org.clojure/java.jdbc "0.7.9"]
                                  ;; Next gen database interop
                                  [seancorfield/next.jdbc "1.0.0"]
                                  [orchestra "2019.02.06-1"]]
                   :plugins [[lein-codox "0.10.6"]]
                   :source-paths ["dev"]}
             :1.9 {:dependencies [[org.clojure/clojure "1.9.0"]]}
             :uberjar {:aot :all
                       :dependencies [[criterium "0.4.5"]
                                      ;; The must: database interop
                                      [org.clojure/java.jdbc "0.7.9"]
                                      ;; Next gen database interop
                                      [seancorfield/next.jdbc "1.0.0"]
                                      [orchestra "2019.02.06-1"]]}}

  :global-vars {;*warn-on-reflection* true
                ;*assert* true
                }

  :aot [szew.h2
        szew.h2.util]

  :codox {;:metadata {:doc/format :markdown}
          :project {:name "szew/h2"}
          :namespaces [#"^(szew\.h2|szew\.h2\.[jun].+)$"]
          ;; that was fun:
          :source-uri ~(str "https://bitbucket.org/spottr/szew-h2/src/"
                            "f950691947641ed54096bc100c1674b6afbd8a4d" ;; 0.3.0
                            "/{filepath}#{basename}-{line}")}
  )

