(defproject szew/h2 "0.3.3"

  :description "Clojure wrapper for H2 database."
  :url "https://bitbucket.org/spottr/szew-h2"

  :license {:name "MIT Public License"
            :distribution :repo
            :comments "LICENSE file in project root directory."}

  :dependencies []

  :profiles {:dev      {:dependencies [[criterium "0.4.6"]
                                       [orchestra "2021.01.01-1"]]
                        :eftest {:thread-count 2}
                        :plugins [[lein-codox "0.10.6"]]
                        :source-paths ["dev"]}
             :provided {:dependencies [[org.clojure/clojure "1.10.3"]
                                       ;; last stable = 1.3.176
                                       [com.h2database/h2 "2.0.202"]
                                       ;; The must: database interop
                                       [org.clojure/java.jdbc "0.7.12"]
                                       ;; Next gen database interop
                                       [seancorfield/next.jdbc "1.2.659"]]}
             :1.11     {:dependencies [[org.clojure/clojure "1.11.0-alpha3"]]}
             :uberjar  {:aot :all}}

  :global-vars {;*warn-on-reflection* true
                ;*assert* true
                }

  :aot [szew.h2
        szew.h2.util
        szew.h2.server]

  :codox {;:metadata {:doc/format :markdown}
          :project {:name "szew/h2"}
          :namespaces [#"^(szew\.h2|szew\.h2\.(?:java|next|serv|util).*)$"]
          :source-uri ~(str "https://bitbucket.org/spottr/szew-h2/src/"
                            "83ec80b560744f67a144b3486564c9bad4db8c39" ;; 0.3.3
                            "/{filepath}#{basename}-{line}")}
  )

