(defproject szew/io "0.3.2"

  :description "File to data and back."
  :url "https://bitbucket.org/spottr/szew-io"

  :license {:name "MIT Public License"
            :distribution :repo
            :comments "LICENSE file in project root directory."}

  :dependencies [[org.clojure/clojure "1.10.0"]
                 ;; Proper CSV handling, combat proven:
                 [clojure-csv/clojure-csv "2.0.2"]
                 ;; There is no life without XML
                 [org.clojure/data.xml "0.0.8"]
                 ;; Zippers, mainly because XML
                 [org.clojure/data.zip "0.1.2"]
                 ;; Literally headrs.
                 [camel-snake-kebab "0.4.0"]]

  :profiles {:dev {:dependencies [[criterium "0.4.4"]
                                  [org.clojure/test.check "0.9.0"]]
                   :plugins [[lein-codox "0.10.3"]]
                   :source-paths ["dev"]}
             :1.9 {:dependencies [[org.clojure/clojure "1.9.0"]]}
             :uberjar {:aot :all}}

  :global-vars {;*warn-on-reflection* true
                *assert* true}

  :aot [szew.io]

  :jar-name "szew-io.jar"
  :uberjar-name "szew-io-fat.jar"

  :codox {;:metadata {:doc/format :markdown}
          :project {:name "szew/io"}
          :namespaces [#"^szew\.io.*$"]
          ;; that was fun:
          :source-uri ~(str "https://bitbucket.org/spottr/szew-io/src/"
                            ;"12202edb265b456b8c20b596178c86ec3bc448d0" ;; 0.1.0
                            ;"f11505239cb0c3ae2d6ef40b94402146791c1995" ;; 0.1.1
                            ;"9ec02eabbe0910ad0ad0a7a13519b8cc3a4b0dac" ;; 0.1.2
                            ;"73c3ada37095c3a04acea7e69f21275288055d3c" ;; 0.2.0
                            ;"2e89f63d37ff08c17d89f3d4701e1f7f384dd10a" ;; 0.2.1
                            ;"1ede9a1d37ae52e3a3888bb73991bc5bd75013cc" ;; 0.2.2
                            ;"36991b75342e86f0fdf1cddf39e34d8afbb6e3ed" ;; 0.2.3
                            ;"7db63f9a41a9e44547d7619393fac8d4e2dd25d7" ;; 0.2.4
                            ;"2e70ddaf373aabb99b6bae211a66c276bb6e50d8" ;; 0.2.5
                            ;"001017c727fdbde5a4ac99ffe78a8b79cb862995" ;; 0.3.0
                            "ac3e6efe5630ebb82ad71c4567988a84bf4c98b7" ;; 0.3.1
                            "/{filepath}#{basename}-{line}")})
