(defproject szew/io "0.4.0"

  :description "File to data and back."
  :url "https://bitbucket.org/spottr/szew-io"

  :license {:name "MIT Public License"
            :distribution :repo
            :comments "LICENSE file in project root directory."}

  :dependencies [[org.clojure/clojure "1.10.1"]
                 ;; Proper CSV handling, combat proven:
                 [clojure-csv/clojure-csv "2.0.2"]
                 ;; There is no life without XML
                 [org.clojure/data.xml "0.0.8"]
                 ;; Zippers, mainly because XML
                 [org.clojure/data.zip "1.0.0"]
                 ;; Literally headrs.
                 [camel-snake-kebab "0.4.1"]]

  :profiles {:dev {:dependencies [[criterium "0.4.5"]
                                  [org.clojure/test.check "1.0.0"]
                                  [eftest "0.5.9"]
                                  [orchestra "2019.02.06-1"]]
                   :plugins [[lein-codox "0.10.6"]]
                   :source-paths ["dev"]
                   ;; opts for Java 9+ and data.xml
                   ;:jvm-opts ["--illegal-access=debug"]
                   ;:jvm-opts ["--illegal-access=warn"]
                   ;:jvm-opts ["--illegal-access=deny"]
                   }
             :1.9 {:dependencies [[org.clojure/clojure "1.9.0"]]}
             :1.10.2 {:dependencies [[org.clojure/clojure "1.10.2-alpha1"]]}
             :uberjar {:aot :all}}

  :global-vars {*warn-on-reflection* true
                *assert* true}

  :aot :all

  :codox {:project {:name "szew/io"}
          :namespaces [#"^szew\.io.*$"]
          ;; tons of fun right here:
          :source-uri ~(str "https://bitbucket.org/spottr/szew-io/src/"
                            "883566502cefbb4e39b95fdfa5bcb3bf41ee944a" ;; 0.3.6
                            "/{filepath}#{basename}-{line}")})
