(defproject szew/io "0.5.3"

  :description "File to data and back."
  :url "https://bitbucket.org/spottr/szew-io"

  :license {:name "MIT Public License"
            :distribution :repo
            :comments "LICENSE file in project root directory."}

  :dependencies [[org.clojure/clojure "1.10.1"]
                 ;; Proper CSV handling, combat proven:
                 [clojure-csv/clojure-csv "2.0.2"]
                 ;; There is no life without XML
                 [org.clojure/data.xml "0.0.8"]
                 ;; Zippers, mainly because XML
                 [org.clojure/data.zip "1.0.0"]
                 ;; Literally headrs.
                 [camel-snake-kebab "0.4.2"]]

  :profiles {:dev {:dependencies [[criterium "0.4.6"]
                                  [org.clojure/test.check "1.1.0"]
                                  [eftest "0.5.9"]
                                  [orchestra "2020.09.18-1"]
                                  [hashp "0.2.0"]]
                   :plugins [[lein-codox "0.10.7"]]
                   :source-paths ["dev"]
                   ;; opts for Java 9+ and data.xml
                   ;:jvm-opts ["--illegal-access=debug"]
                   ;:jvm-opts ["--illegal-access=deny"]
                   :jvm-opts ["--illegal-access=warn"] ;; codox
                   }
             ;:test {:jvm-opts ["--illegal-access=deny"]}
             :1.9 {:dependencies [[org.clojure/clojure "1.9.0"]]
                   :jvm-opts ["--illegal-access=warn"]}
             :1.10.2 {:dependencies [[org.clojure/clojure "1.10.2-rc1"]]
                      :jvm-opts ["--illegal-access=deny"]}
             :uberjar {:aot :all}}

  :global-vars {*warn-on-reflection* true
                *assert* true}

  :aot :all

  :codox {:project {:name "szew/io"}
          :namespaces [#"^szew\.io.*$"]
          :doc-files ["CHANGELOG.md"]
          ;; tons of fun right here:
          :source-uri ~(str "https://bitbucket.org/spottr/szew-io/src/"
                            "be929a1f71c9107ada79150dda94e9bfe4605581" ;; 0.5.2
                            "/{filepath}#{basename}-{line}")})
