# szew/repl

Simple Clojure REPL seeder.

[![szew/repl](https://clojars.org/szew/repl/latest-version.svg)](https://clojars.org/szew/repl)

[API Codox][1]

## Why

I've been dogfooding my private Clo*j*ure toolbox (named `szew`) since 2012.

Splitting out and releasing non-proprietary parts.

## Usage

Seed a very basic **R**ead-**E**val-**P**rint-**L**oop:

1. Call `szew.repl/-main` with paths to Clo*j*ure files.
2. Main will `load-file` them in order. (Hint: `(in-ns 'user)` maybe?)
3. You get into a REPL in the end. In `'user`.
4. You can exit with `(exit)`.

There's only one namespace here, `szew.repl`. It has some helpers.

Running `(repl-me!)` propagates current namespace with `clojure.core`,
`clojure.repl` and `szew.repl`. By default it happens in `user`.

If exception happens process gets stopped and you get a REPL. You can try
to reload all files with `(!!)` or pick up from the failed one via `(!?)`.

Running `(?)` shows you all aliased namespaces, while `(? 'alias)` is similar
to `(dir alias)`.

You can get some of that from `(help)`.

Logging based on *logback*, see `get-log-level!` and `set-log-level!`.

Your scripts are in `scripts`, Exception in `script-errors`.

With `(nuke-ns!)` you can quickly `ns-unmap` a bunch of things.

## Alternative Usage

Uberjar packed with goodies, with `:main szew.repl`. Then just:

```bash
rlwrap java -jar uberjar.jar path/script1.clj path/script2.clj
```

And find yourself at that friendly `user=>`.

## Env

Environment variables are used for some features.

### nREPL

Starting single standalone nREPL server within `-main` is done with:

```bash
export NREPL_ON = please

export NREPL_BIND = localhost      [default: 127.0.0.1]

export NREPL_PORT = 45678          [default: 55555]
```

### Logging

No default is set for root logger.

```bash
export LOG_LEVEL = WARN            [default: INFO]
```

## License

Copyright © 2012-2018 Sławek Gwizdowski

MIT License, text can be found in the LICENSE file.

[1]: http://spottr.bitbucket.io/szew-repl/latest/

