# --- Created by Slick DDL
# To stop Slick DDL generation, remove this comment and start using Evolutions

# --- !Ups

create table "files" ("id" BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,"projectId" BIGINT NOT NULL,"path" VARCHAR NOT NULL,"mimeType" VARCHAR,"deleted" BOOLEAN NOT NULL,"exists" BOOLEAN NOT NULL,"isDirectory" BOOLEAN NOT NULL,"parent" BIGINT);
create unique index "project_path" on "files" ("projectId","path");
create table "logins" ("user" VARCHAR NOT NULL,"key" VARCHAR NOT NULL,"timeout" DATE);
create table "openFiles" ("session" BIGINT NOT NULL,"file" BIGINT NOT NULL);
alter table "openFiles" add constraint "pk_openFile" primary key("session","file");
create table "rights" ("project" BIGINT NOT NULL,"user" VARCHAR NOT NULL,"policy" INTEGER NOT NULL);
alter table "rights" add constraint "pk_right" primary key("project","user");
create table "projects" ("id" BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,"name" VARCHAR NOT NULL,"owner" VARCHAR NOT NULL,"description" VARCHAR);
create unique index "idx_owner_project" on "projects" ("owner","name");
create table "revisions" ("fileId" BIGINT NOT NULL,"id" BIGINT NOT NULL,"content" VARCHAR NOT NULL);
create unique index "file_revision" on "revisions" ("fileId","id");
create table "sessions" ("id" BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,"name" VARCHAR NOT NULL,"color" VARCHAR NOT NULL,"project" BIGINT NOT NULL,"activeFile" BIGINT,"active" BOOLEAN NOT NULL);
create table "users" ("name" VARCHAR NOT NULL PRIMARY KEY,"email" VARCHAR NOT NULL,"password" VARCHAR NOT NULL);
alter table "files" add constraint "fk_fileInfos_parent" foreign key("parent") references "files"("id") on update CASCADE on delete CASCADE;
alter table "files" add constraint "fk_fileInfos_project" foreign key("projectId") references "projects"("id") on update CASCADE on delete CASCADE;
alter table "logins" add constraint "fk_login_user" foreign key("user") references "users"("name") on update CASCADE on delete CASCADE;
alter table "openFiles" add constraint "fk_openFile_file" foreign key("file") references "files"("id") on update CASCADE on delete CASCADE;
alter table "openFiles" add constraint "fk_openFile_session" foreign key("session") references "sessions"("id") on update CASCADE on delete CASCADE;
alter table "rights" add constraint "fk_right_user" foreign key("user") references "users"("name") on update CASCADE on delete CASCADE;
alter table "rights" add constraint "fk_right_project" foreign key("project") references "projects"("id") on update CASCADE on delete CASCADE;
alter table "projects" add constraint "fk_project_user" foreign key("owner") references "users"("name") on update CASCADE on delete CASCADE;
alter table "revisions" add constraint "fk_revision_file" foreign key("fileId") references "files"("id") on update CASCADE on delete CASCADE;
alter table "sessions" add constraint "fk_session_user" foreign key("name") references "users"("name") on update CASCADE on delete CASCADE;
alter table "sessions" add constraint "fk_session_project" foreign key("project") references "projects"("id") on update CASCADE on delete CASCADE;
alter table "sessions" add constraint "fk_session_file" foreign key("activeFile") references "files"("id") on update SET NULL on delete SET NULL;

# --- !Downs

alter table "files" drop constraint "fk_fileInfos_parent";
alter table "files" drop constraint "fk_fileInfos_project";
alter table "logins" drop constraint "fk_login_user";
alter table "openFiles" drop constraint "fk_openFile_file";
alter table "openFiles" drop constraint "fk_openFile_session";
alter table "rights" drop constraint "fk_right_user";
alter table "rights" drop constraint "fk_right_project";
alter table "projects" drop constraint "fk_project_user";
alter table "revisions" drop constraint "fk_revision_file";
alter table "sessions" drop constraint "fk_session_user";
alter table "sessions" drop constraint "fk_session_project";
alter table "sessions" drop constraint "fk_session_file";
drop table "files";
drop table "logins";
alter table "openFiles" drop constraint "pk_openFile";
drop table "openFiles";
alter table "rights" drop constraint "pk_right";
drop table "rights";
drop table "projects";
drop table "revisions";
drop table "sessions";
drop table "users";

