
/* @directive directives:editor
*/


(function() {

  define(['routes', 'codemirror', 'modes/isabelle'], function(routes) {
    CodeMirror.commands.autocomplete = function(cm) {
      return CodeMirror.showHint(cm, 'anyword');
    };
    return function() {
      return {
        restrict: 'E',
        transclude: true,
        template: '<textarea></textarea>',
        replace: true,
        scope: {
          document: '&',
          tabSize: '&',
          lineNumbers: '&',
          readOnly: '&',
          fontSize: '&',
          font: '&',
          annotations: '&'
        },
        link: function(scope, iElem, iAttrs, controller) {
          var cm;
          window.countMe = (window.countMe || 0) + 1;
          cm = CodeMirror.fromTextArea(iElem[0], {
            undoDepth: 0,
            indentWithTabs: false,
            tabSize: 2,
            gutters: ['CodeMirror-foldgutter', 'CodeMirror-linenumbers', 'progress-gutter'],
            foldGutter: true,
            fixedGutter: false,
            viewportMargin: 20,
            extraKeys: {
              'Shift-Ctrl-C': 'toggleComment'
            }
          });
          scope.$watch('lineNumbers()', function(n, o) {
            cm.setOption('lineNumbers', n);
            return cm.refresh();
          });
          scope.$watch('readOnly()', function(n, o) {
            return cm.setOption('readOnly', n || false);
          });
          scope.$watch('font()', function(n, o) {
            cm.getWrapperElement().style.fontFamily = n;
            return cm.refresh();
          });
          scope.$watch('fontSize()', function(n, o) {
            cm.getWrapperElement().style.fontSize = n + 'pt';
            return cm.refresh();
          });
          scope.$watch('tabSize()', function(n, o) {
            return cm.setOption('tabSize', n || 2);
          });
          scope.$watch('annotations()', function(n, o) {});
          return scope.$watch('document()', function(n, o) {
            if (n != null) {
              return cm.swapDoc(n);
            } else {
              return cm.swapDoc(CodeMirror.Doc(""));
            }
          });
        }
      };
    };
  });

}).call(this);
