
/* @directive directives:tabs
*/


(function() {

  define(function() {
    return function() {
      return {
        restrict: 'E',
        transclude: true,
        scope: {},
        controller: function($scope, $element) {
          var tabs;
          tabs = $scope.tabs = [];
          $scope.select = function(tab) {
            angular.forEach(tabs, function(tab) {
              return tab.selected = false;
            });
            return tab.selected = true;
          };
          $scope.close = function(tab) {
            if (tab.close != null) {
              tab.close();
            }
            return tabs.splice(tabs.indexOf(tab), 1);
          };
          return this.addTab = function(tab) {
            if (tabs.length === 0) {
              $scope.select(tab);
            }
            return tabs.push(tab);
          };
        },
        template: '<div class="tabs">' + '<ul class="headers">' + '<li ng-repeat="tab in tabs" ng-class="{active:tab.selected}" ng-click="select(tab)">' + '{{tab.title}} <span class="icon" ng-click="close(tab)">&#xE089;</span>' + '</li>' + '</ul>' + '<div class="content" ng-transclude></div>' + '</div>',
        replace: true
      };
    };
  });

}).call(this);
