(ns tailrecursion.hoplon.compiler.parse
  (:require
    [clojure.pprint     :refer [pprint]]
    [clojure.string     :as string]
    [clojure.zip        :as zip]
    )
  )

(defn tag
  [n]
  (if (seq? n) (first n) n))

(defn attr
  [n]
  (if (map? (second n)) (second n)))

(defn children
  [n]
  (when (seq? n)
    (let [[tag & [attr & kids :as tail]] %]
      (if (map? attr) kids tail))))

(defn branch?
  [n]
  (or (seq n) (symbol? n)))

(defn make-node
  [n kids]
  (let [a (->> n attr list (remove nil?))
        n (concat (list (tag n)) a kids)] 
    (if (< 1 (count n)) n (first n)))) 

(defn node-zip
  [root]
  (zip/zipper branch? children make-node root))

(defn parse
  [html]
  (loop [src html, out (node-zip 'root)]
    (if-let [text (re-find #"^[^<]+" src)]
      (recur (subs src (count text)) (zip/append-child out text))
      (if-let [start (re-find #"^<")])
      )
    )
  )

