(ns tailrecursion.hoplon.svg
  (:refer-clojure :exclude [symbol filter mask set]))

(defn make-svg-ctor [tag]
  (let [xmlns "http://www.w3.org/2000/svg"]
    (fn [& args]
      (apply (.createElementNS js/document xmlns tag) args))))

(def a                   (make-svg-ctor "svg:a"))
(def altGlyph            (make-svg-ctor "svg:altGlyph"))
(def altGlyphDef         (make-svg-ctor "svg:altGlyphDef"))
(def altGlyphItem        (make-svg-ctor "svg:altGlyphItem"))
(def animate             (make-svg-ctor "svg:animate"))
(def animateColor        (make-svg-ctor "svg:animateColor"))
(def animateMotion       (make-svg-ctor "svg:animateMotion"))
(def animateTransform    (make-svg-ctor "svg:animateTransform"))
(def circle              (make-svg-ctor "svg:circle"))
(def clipPath            (make-svg-ctor "svg:clipPath"))
(def color-profile       (make-svg-ctor "svg:color-profile"))
(def cursor              (make-svg-ctor "svg:cursor"))
(def defs                (make-svg-ctor "svg:defs"))
(def desc                (make-svg-ctor "svg:desc"))
(def ellipse             (make-svg-ctor "svg:ellipse"))
(def feBlend             (make-svg-ctor "svg:feBlend"))
(def feColorMatrix       (make-svg-ctor "svg:feColorMatrix"))
(def feComponentTransfer (make-svg-ctor "svg:feComponentTransfer"))
(def feComposite         (make-svg-ctor "svg:feComposite"))
(def feConvolveMatrix    (make-svg-ctor "svg:feConvolveMatrix"))
(def feDiffuseLighting   (make-svg-ctor "svg:feDiffuseLighting"))
(def feDisplacementMap   (make-svg-ctor "svg:feDisplacementMap"))
(def feDistantLight      (make-svg-ctor "svg:feDistantLight"))
(def feFlood             (make-svg-ctor "svg:feFlood"))
(def feFuncA             (make-svg-ctor "svg:feFuncA"))
(def feFuncB             (make-svg-ctor "svg:feFuncB"))
(def feFuncG             (make-svg-ctor "svg:feFuncG"))
(def feFuncR             (make-svg-ctor "svg:feFuncR"))
(def feGaussianBlur      (make-svg-ctor "svg:feGaussianBlur"))
(def feImage             (make-svg-ctor "svg:feImage"))
(def feMerge             (make-svg-ctor "svg:feMerge"))
(def feMergeNode         (make-svg-ctor "svg:feMergeNode"))
(def feMorphology        (make-svg-ctor "svg:feMorphology"))
(def feOffset            (make-svg-ctor "svg:feOffset"))
(def fePointLight        (make-svg-ctor "svg:fePointLight"))
(def feSpecularLighting  (make-svg-ctor "svg:feSpecularLighting"))
(def feSpotLight         (make-svg-ctor "svg:feSpotLight"))
(def feTile              (make-svg-ctor "svg:feTile"))
(def feTurbulence        (make-svg-ctor "svg:feTurbulence"))
(def filter              (make-svg-ctor "svg:filter"))
(def font                (make-svg-ctor "svg:font"))
(def font-face           (make-svg-ctor "svg:font-face"))
(def font-face-format    (make-svg-ctor "svg:font-face-format"))
(def font-face-name      (make-svg-ctor "svg:font-face-name"))
(def font-face-src       (make-svg-ctor "svg:font-face-src"))
(def font-face-uri       (make-svg-ctor "svg:font-face-uri"))
(def foreignObject       (make-svg-ctor "svg:foreignObject"))
(def g                   (make-svg-ctor "svg:g"))
(def glyph               (make-svg-ctor "svg:glyph"))
(def glyphRef            (make-svg-ctor "svg:glyphRef"))
(def hkern               (make-svg-ctor "svg:hkern"))
(def image               (make-svg-ctor "svg:image"))
(def line                (make-svg-ctor "svg:line"))
(def linearGradient      (make-svg-ctor "svg:linearGradient"))
(def marker              (make-svg-ctor "svg:marker"))
(def mask                (make-svg-ctor "svg:mask"))
(def metadata            (make-svg-ctor "svg:metadata"))
(def missing-glyph       (make-svg-ctor "svg:missing-glyph"))
(def mpath               (make-svg-ctor "svg:mpath"))
(def path                (make-svg-ctor "svg:path"))
(def pattern             (make-svg-ctor "svg:pattern"))
(def polygon             (make-svg-ctor "svg:polygon"))
(def polyline            (make-svg-ctor "svg:polyline"))
(def radialGradient      (make-svg-ctor "svg:radialGradient"))
(def rect                (make-svg-ctor "svg:rect"))
(def script              (make-svg-ctor "svg:script"))
(def set                 (make-svg-ctor "svg:set"))
(def stop                (make-svg-ctor "svg:stop"))
(def style               (make-svg-ctor "svg:style"))
(def svg                 (make-svg-ctor "svg:svg"))
(def switch              (make-svg-ctor "svg:switch"))
(def symbol              (make-svg-ctor "svg:symbol"))
(def text                (make-svg-ctor "svg:text"))
(def textPath            (make-svg-ctor "svg:textPath"))
(def title               (make-svg-ctor "svg:title"))
(def tref                (make-svg-ctor "svg:tref"))
(def tspan               (make-svg-ctor "svg:tspan"))
(def use                 (make-svg-ctor "svg:use"))
(def view                (make-svg-ctor "svg:view"))
(def vkern               (make-svg-ctor "svg:vkern"))
