(ns tandem.http.charset
  "Character set constants."
  (:import org.jboss.netty.util.CharsetUtil))

(def ^{:doc "ISO Latin Alphabet No. 1, as known as ISO-LATIN-1"}
  ^:static
  iso-8859-1 CharsetUtil/ISO_8859_1)

(def ^{:doc "7-bit ASCII, as known as ISO646-US or the Basic Latin block of the Unicode character set"}
  ^:static
  us-ascii CharsetUtil/US_ASCII)

(def ^{:doc "16-bit UTF (UCS Transformation Format) whose byte order is identified by an optional byte-order mark"}
  ^:static
  utf-16 CharsetUtil/UTF_16)

(def ^{:doc "16-bit UTF (UCS Transformation Format) whose byte order is big-endian"}
  ^:static
  utf-16be CharsetUtil/UTF_16BE)

(def ^{:doc "16-bit UTF (UCS Transformation Format) whose byte order is little-endian"}
  ^:static
  utf-16le CharsetUtil/UTF_16LE)

(def ^{:doc "8-bit UTF (UCS Transformation Format) (default)"}
  ^:static
  utf-8 CharsetUtil/UTF_8)

  