(ns tandem.auth

  "Some functions to assist with authentication and security."
  
  (:import org.mindrot.jbcrypt.BCrypt))

(defn salt [] (BCrypt/gensalt))

(defn encrypt
  "Encrypt a password using BCrypt."
  [password]
  (BCrypt/hashpw password (salt)))

(defn check
  "Compare the given plaintext password against the BCrypt-encrypted hash and
  see if they match."
  [candidate encrypted]
  (BCrypt/checkpw candidate encrypted))