(ns tandem.misc
  (:require [tandem.settings :as settings])
  (:import com.eaio.uuid.UUID))

(defn assoc-if
  "Only associate the key/value pairs with the map if they don't have nil
  values."
  ([map key value]
     (if value
       (assoc map key value)
       map))
  ([map key value & kvs]
     (let [ret (assoc-if map key value)]
       (if kvs
         (recur ret (first kvs) (second kvs) (nnext kvs))
         ret))))

(defmacro rescue
  "Wraps the code in a try catch block and returns the given value (or nil, if
  no value is provided) if an exception is thrown.  Based on the Ruby construct."
  [form & [value]]
  `(try
     ~form
     (catch Throwable t#
       ~value)))

(defn uuid
  "Generate a UUID."
  []
  (str (UUID.)))

