(ns modular.cylon-oauth-example.calendar-cals
  (:require [cylon.oauth.client :refer (http-request-form)] )
  (:import (java.net URLEncoder)))

(defn calendars [access-token]
  (let [r (http-request-form :get "https://www.googleapis.com/calendar/v3/users/me/calendarList"

                                                nil
                                                {"Authorization" (str "Bearer " access-token)})]

    (if-not (get-in r [:body "error"])
      (->> (get (:body r) "items")
          (map #(vector
                (get % "summary")
                (get % "id")) )
          )
      (println (get-in r [:body "error"])))))

(defn get-calendar [summary access-token]
  (last (first (filter (fn [[n id]]
                    (when (= summary (clojure.string/lower-case n))
                      id)) (calendars access-token)))))


;; GET https://www.googleapis.com/calendar/v3/calendars/3poq2tucglrg4h5lul044dluns%40group.calendar.google.com/events?timeMin=2015-02-02T06:30:00%2B01%3A00&alwaysIncludeEmail=true&timeMax=2015-02-05T06%3A30%3A00%2B01%3A00&key={YOUR_API_KEY}

(defn cal-events [access-token id start end]
  (let [
        start (URLEncoder/encode start)
        end (URLEncoder/encode end)
        r (http-request-form :get (format "https://www.googleapis.com/calendar/v3/calendars/%s/events?timeMin=%s&timeMax=%s" id start end)

                                                nil
                                                {"Authorization" (str "Bearer " access-token)})]

    (if-not (get-in r [:body "error"])
      (->> (get (:body r) "items")
           (map #(assoc {}
                  :name (get % "summary")
                  :start (get-in % ["start" "dateTime"])
                  :end (get-in % ["end" "dateTime"])))
          )
      (println (get-in r [:body "error"])))))
