(ns modular.cylon-oauth-example.calendar-middleware
  (:require [modular.cylon-oauth-example.calendar-cals :as call-cald]
            [cylon.session :refer (session respond-with-new-session! assoc-session-data! respond-close-session!)]
            [modular.cylon-oauth-example.protocols :refer (EmployeeStore get-e put-e all update-e)]
            [modular.cylon-oauth-example.auth-calls :as auth-calls]
            [cylon.util :refer (absolute-uri)])

  )

(defn required-calendar-exists? [h calendar-name employees-store]
  (fn [req]
    (if (:calendar (get-e employees-store (:cylon/email req)))
      (h req)
      (if-let [calendar-id (call-cald/get-calendar calendar-name  (:cylon/access-token req))]
        (do
          (update-e employees-store (:cylon/email req) {:calendar calendar-id})
          (h req))
        {:status 401 :body (str "You seem to not have a calendar with name:" calendar-name)}
        ))))


(defn connect-active-users-data [h oauth-client session-store employees-store]
  (fn [req]
    (when-not (:buscador/connected-employees (session session-store req))
     (assoc-session-data! session-store req {:buscador/connected-employees
                                             (->>
                                              (all employees-store)
                                              (map (fn [{:keys [id token refresh-token] :as employee}]
                                                     (println employee)
                                                     (let [res (auth-calls/me token)]
                                                       (if (= res "authError")
                                                         (update-e employees-store id {:token (auth-calls/get-refresh-token oauth-client refresh-token)})
                                                         employee)))))}))
    (h req)))
