(defproject tangrammer/apit "0.1.1"
  :description "A clojure webapp project"
  :url "http://github.com/tangrammer/apit"

  :exclusions [com.stuartsierra/component]

  :dependencies
  [
   [hiccup "1.0.5"]
   [com.stuartsierra/component "0.2.2"]
   [juxt.modular/bidi "0.6.1" :exclusions [org.clojure/clojure]]
   [juxt.modular/clostache "0.6.0"]

   [juxt.modular/bootstrap "0.2.0" :exclusions [cylon]]

   [juxt.modular/http-kit "0.5.3"]
   [juxt.modular/maker "0.5.0"]
   [juxt.modular/wire-up "0.5.0"]

   [tangrammer/co-dependency "0.1.5"]
   [org.clojure/clojure "1.7.0-alpha4"]
   [org.clojure/tools.logging "0.2.6"]
   [org.clojure/tools.reader "0.8.9"]
   [org.slf4j/jcl-over-slf4j "1.7.2"]
   [org.slf4j/jul-to-slf4j "1.7.2"]
   [org.slf4j/log4j-over-slf4j "1.7.2"]
   [org.webjars/bootstrap "3.3.0"]
   [org.webjars/jquery "2.1.0"]
   [prismatic/plumbing "0.2.2"]
   [prismatic/schema "0.3.3"]
   [ch.qos.logback/logback-classic "1.0.7" :exclusions [org.slf4j/slf4j-api]]
   [tangrammer/cylon "0.5.0" :exclusions [com.stuartsierra/component org.clojure/clojure malcolmsparks/co-dependency]]
   [liberator "0.11.0"  :exclusions [org.clojure/tools.logging org.clojure/tools.trace]]
   ;; email
   [com.draines/postal "1.11.1"]


   [garden "1.1.5" :exclusions [org.clojure/clojure org.clojure/clojurescript]]
   [hiccup "1.0.5"]


   [com.google.appengine/appengine-api-1.0-sdk "1.9.15"]
   [ring/ring-json "0.3.1"]]

  :plugins [[lein-ring "0.9.1"]]

  :ring {:handler modular.cylon-oauth-example.main/app
         :init modular.cylon-oauth-example.main/init
         :destroy modular.cylon-oauth-example.main/destroy}
  :aot :all
  :repl-options {:init-ns user
                 :welcome (println "Type (dev) to start")}


  :profiles {:ring
             {:open-browser? false, :stacktraces? false, :auto-reload? false}
             :dev {:dependencies [[org.clojure/tools.namespace "0.2.5"]
                                  [com.google.appengine/appengine-api-1.0-sdk "1.9.15"]
                                  [com.google.appengine/appengine-testing "1.9.15"]
                                  [com.google.appengine/appengine-api-stubs "1.9.15"]
                                  [com.google.appengine/appengine-api-labs "1.9.15"]
                                  ]
                   :source-paths ["dev"]}})
