(ns leiningen.new.tatar
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "tatar"))

(defn tatar
  "FIXME: write documentation"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' tatar project.")
    (->files data
             ["src/clj/{{sanitized}}/core.clj" (render "core.clj" data)]
             ["src/cljs/{{sanitized}}/common/events.clj" (render "events.clj" data)]
             ["src/cljs/{{sanitized}}/common/subs.clj" (render "subs.clj" data)]
             ["src/cljs/{{sanitized}}/home/events.clj" (render "events.clj" data)]
             ["src/cljs/{{sanitized}}/home/subs.clj" (render "subs.clj" data)]
             ["src/cljs/{{sanitized}}/home/views.clj" (render "views.clj" data)]
             ["src/cljs/{{sanitized}}/navigation/events.clj" (render "events.clj" data)]
             ["src/cljs/{{sanitized}}/navigation/subs.clj" (render "subs.clj" data)]
             ["src/cljs/{{sanitized}}/navigation/views.clj" (render "views.clj" data)]
             ["src/cljs/{{sanitized}}/core.clj" (render "core.clj" data)]
             ["src/cljs/{{sanitized}}/db.clj" (render "db.clj" data)]
             ["src/cljs/{{sanitized}}/routes.clj" (render "routes.clj" data)]
             ["project.clj" (render "project.clj" data)]
)))
