(ns leiningen.new.tatar
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "tatar"))

(defn tatar
  "FIXME: write documentation"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' tatar project. haha")
    (->files data
             ["src/clj/{{sanitized}}/core.clj" (render "src/clj/tatar/core.clj" data)]
             ["src/cljs/{{sanitized}}/common/events.cljs" (render "src/cljs/tatar/common/events.cljs" data)]
             ["src/cljs/{{sanitized}}/common/subs.cljs" (render "src/cljs/tatar/common/subs.cljs" data)]
             ["src/cljs/{{sanitized}}/home/events.cljs" (render "src/cljs/tatar/home/events.cljs" data)]
             ["src/cljs/{{sanitized}}/home/subs.cljs" (render "src/cljs/tatar/home/subs.cljs" data)]
             ["src/cljs/{{sanitized}}/home/views.cljs" (render "src/cljs/tatar/home/views.cljs" data)]
             ["src/cljs/{{sanitized}}/navigation/events.cljs" (render "src/cljs/tatar/navigation/events.cljs" data)]
             ["src/cljs/{{sanitized}}/navigation/subs.cljs" (render "src/cljs/tatar/navigation/subs.cljs" data)]
             ["src/cljs/{{sanitized}}/navigation/views.cljs" (render "src/cljs/tatar/navigation/views.cljs" data)]
             ["src/cljs/{{sanitized}}/core.cljs" (render "src/cljs/tatar/core.cljs" data)]
             ["src/cljs/{{sanitized}}/db.cljs" (render "src/cljs/tatar/db.cljs" data)]
             ["src/cljs/{{sanitized}}/routes.cljs" (render "src/cljs/tatar/routes.cljs" data)]
             ["project.clj" (render "project.clj" data)]
             ["resources/public/index.html" (render "resources/public/index.html")]
)))
