(ns leiningen.new.tatar
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "tatar"))

(defn tatar
  "FIXME: write documentation"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' tatar project.")
    (->files data
             ["src/clj/{{sanitized}}/core.clj" (render "src/app_name/core.clj" data)]
             ["src/cljs/{{sanitized}}/common/events.cljs" (render "events.cljs" data)]
             ["src/cljs/{{sanitized}}/common/subs.cljs" (render "subs.cljs" data)]
             ["src/cljs/{{sanitized}}/home/events.cljs" (render "events.cljs" data)]
             ["src/cljs/{{sanitized}}/home/subs.cljs" (render "subs.cljs" data)]
             ["src/cljs/{{sanitized}}/home/views.cljs" (render "views.cljs" data)]
             ["src/cljs/{{sanitized}}/navigation/events.cljs" (render "events.cljs" data)]
             ["src/cljs/{{sanitized}}/navigation/subs.cljs" (render "subs.cljs" data)]
             ["src/cljs/{{sanitized}}/navigation/views.cljs" (render "views.cljs" data)]
             ["src/cljs/{{sanitized}}/core.cljs" (render "core.cljs" data)]
             ["src/cljs/{{sanitized}}/db.cljs" (render "db.cljs" data)]
             ["src/cljs/{{sanitized}}/routes.cljs" (render "routes.cljs" data)]
             ["project.clj" (render "project.clj" data)]
)))
