// Compiled by ClojureScript 1.10.520 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR__orig_val__22077 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__22078 = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__22078;

try{try{var seq__22079 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__22080 = null;
var count__22081 = (0);
var i__22082 = (0);
while(true){
if((i__22082 < count__22081)){
var vec__22089 = cljs.core._nth.call(null,chunk__22080,i__22082);
var effect_key = cljs.core.nth.call(null,vec__22089,(0),null);
var effect_value = cljs.core.nth.call(null,vec__22089,(1),null);
var temp__5718__auto___22111 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5718__auto___22111)){
var effect_fn_22112 = temp__5718__auto___22111;
effect_fn_22112.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__22113 = seq__22079;
var G__22114 = chunk__22080;
var G__22115 = count__22081;
var G__22116 = (i__22082 + (1));
seq__22079 = G__22113;
chunk__22080 = G__22114;
count__22081 = G__22115;
i__22082 = G__22116;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__22079);
if(temp__5720__auto__){
var seq__22079__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22079__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__22079__$1);
var G__22117 = cljs.core.chunk_rest.call(null,seq__22079__$1);
var G__22118 = c__4550__auto__;
var G__22119 = cljs.core.count.call(null,c__4550__auto__);
var G__22120 = (0);
seq__22079 = G__22117;
chunk__22080 = G__22118;
count__22081 = G__22119;
i__22082 = G__22120;
continue;
} else {
var vec__22092 = cljs.core.first.call(null,seq__22079__$1);
var effect_key = cljs.core.nth.call(null,vec__22092,(0),null);
var effect_value = cljs.core.nth.call(null,vec__22092,(1),null);
var temp__5718__auto___22121 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5718__auto___22121)){
var effect_fn_22122 = temp__5718__auto___22121;
effect_fn_22122.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__22123 = cljs.core.next.call(null,seq__22079__$1);
var G__22124 = null;
var G__22125 = (0);
var G__22126 = (0);
seq__22079 = G__22123;
chunk__22080 = G__22124;
count__22081 = G__22125;
i__22082 = G__22126;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__21899__auto___22127 = re_frame.interop.now.call(null);
var duration__21900__auto___22128 = (end__21899__auto___22127 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.call(null,re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__21900__auto___22128,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null)));

re_frame.trace.run_tracing_callbacks_BANG_.call(null,end__21899__auto___22127);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__22077;
}} else {
var seq__22095 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__22096 = null;
var count__22097 = (0);
var i__22098 = (0);
while(true){
if((i__22098 < count__22097)){
var vec__22105 = cljs.core._nth.call(null,chunk__22096,i__22098);
var effect_key = cljs.core.nth.call(null,vec__22105,(0),null);
var effect_value = cljs.core.nth.call(null,vec__22105,(1),null);
var temp__5718__auto___22129 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5718__auto___22129)){
var effect_fn_22130 = temp__5718__auto___22129;
effect_fn_22130.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__22131 = seq__22095;
var G__22132 = chunk__22096;
var G__22133 = count__22097;
var G__22134 = (i__22098 + (1));
seq__22095 = G__22131;
chunk__22096 = G__22132;
count__22097 = G__22133;
i__22098 = G__22134;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__22095);
if(temp__5720__auto__){
var seq__22095__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22095__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__22095__$1);
var G__22135 = cljs.core.chunk_rest.call(null,seq__22095__$1);
var G__22136 = c__4550__auto__;
var G__22137 = cljs.core.count.call(null,c__4550__auto__);
var G__22138 = (0);
seq__22095 = G__22135;
chunk__22096 = G__22136;
count__22097 = G__22137;
i__22098 = G__22138;
continue;
} else {
var vec__22108 = cljs.core.first.call(null,seq__22095__$1);
var effect_key = cljs.core.nth.call(null,vec__22108,(0),null);
var effect_value = cljs.core.nth.call(null,vec__22108,(1),null);
var temp__5718__auto___22139 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5718__auto___22139)){
var effect_fn_22140 = temp__5718__auto___22139;
effect_fn_22140.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__22141 = cljs.core.next.call(null,seq__22095__$1);
var G__22142 = null;
var G__22143 = (0);
var G__22144 = (0);
seq__22095 = G__22141;
chunk__22096 = G__22142;
count__22097 = G__22143;
i__22098 = G__22144;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__22145 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__22146 = null;
var count__22147 = (0);
var i__22148 = (0);
while(true){
if((i__22148 < count__22147)){
var map__22153 = cljs.core._nth.call(null,chunk__22146,i__22148);
var map__22153__$1 = (((((!((map__22153 == null))))?(((((map__22153.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22153.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22153):map__22153);
var effect = map__22153__$1;
var ms = cljs.core.get.call(null,map__22153__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__22153__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__22145,chunk__22146,count__22147,i__22148,map__22153,map__22153__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__22145,chunk__22146,count__22147,i__22148,map__22153,map__22153__$1,effect,ms,dispatch))
,ms);
}


var G__22157 = seq__22145;
var G__22158 = chunk__22146;
var G__22159 = count__22147;
var G__22160 = (i__22148 + (1));
seq__22145 = G__22157;
chunk__22146 = G__22158;
count__22147 = G__22159;
i__22148 = G__22160;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__22145);
if(temp__5720__auto__){
var seq__22145__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22145__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__22145__$1);
var G__22161 = cljs.core.chunk_rest.call(null,seq__22145__$1);
var G__22162 = c__4550__auto__;
var G__22163 = cljs.core.count.call(null,c__4550__auto__);
var G__22164 = (0);
seq__22145 = G__22161;
chunk__22146 = G__22162;
count__22147 = G__22163;
i__22148 = G__22164;
continue;
} else {
var map__22155 = cljs.core.first.call(null,seq__22145__$1);
var map__22155__$1 = (((((!((map__22155 == null))))?(((((map__22155.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22155.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22155):map__22155);
var effect = map__22155__$1;
var ms = cljs.core.get.call(null,map__22155__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__22155__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__22145,chunk__22146,count__22147,i__22148,map__22155,map__22155__$1,effect,ms,dispatch,seq__22145__$1,temp__5720__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__22145,chunk__22146,count__22147,i__22148,map__22155,map__22155__$1,effect,ms,dispatch,seq__22145__$1,temp__5720__auto__))
,ms);
}


var G__22165 = cljs.core.next.call(null,seq__22145__$1);
var G__22166 = null;
var G__22167 = (0);
var G__22168 = (0);
seq__22145 = G__22165;
chunk__22146 = G__22166;
count__22147 = G__22167;
i__22148 = G__22168;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_.call(null,value)))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_.call(null,value)))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value);
} else {
var seq__22169 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__22170 = null;
var count__22171 = (0);
var i__22172 = (0);
while(true){
if((i__22172 < count__22171)){
var event = cljs.core._nth.call(null,chunk__22170,i__22172);
re_frame.router.dispatch.call(null,event);


var G__22173 = seq__22169;
var G__22174 = chunk__22170;
var G__22175 = count__22171;
var G__22176 = (i__22172 + (1));
seq__22169 = G__22173;
chunk__22170 = G__22174;
count__22171 = G__22175;
i__22172 = G__22176;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__22169);
if(temp__5720__auto__){
var seq__22169__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22169__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__22169__$1);
var G__22177 = cljs.core.chunk_rest.call(null,seq__22169__$1);
var G__22178 = c__4550__auto__;
var G__22179 = cljs.core.count.call(null,c__4550__auto__);
var G__22180 = (0);
seq__22169 = G__22177;
chunk__22170 = G__22178;
count__22171 = G__22179;
i__22172 = G__22180;
continue;
} else {
var event = cljs.core.first.call(null,seq__22169__$1);
re_frame.router.dispatch.call(null,event);


var G__22181 = cljs.core.next.call(null,seq__22169__$1);
var G__22182 = null;
var G__22183 = (0);
var G__22184 = (0);
seq__22169 = G__22181;
chunk__22170 = G__22182;
count__22171 = G__22183;
i__22172 = G__22184;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__22185 = cljs.core.seq.call(null,value);
var chunk__22186 = null;
var count__22187 = (0);
var i__22188 = (0);
while(true){
if((i__22188 < count__22187)){
var event = cljs.core._nth.call(null,chunk__22186,i__22188);
clear_event.call(null,event);


var G__22189 = seq__22185;
var G__22190 = chunk__22186;
var G__22191 = count__22187;
var G__22192 = (i__22188 + (1));
seq__22185 = G__22189;
chunk__22186 = G__22190;
count__22187 = G__22191;
i__22188 = G__22192;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__22185);
if(temp__5720__auto__){
var seq__22185__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22185__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__22185__$1);
var G__22193 = cljs.core.chunk_rest.call(null,seq__22185__$1);
var G__22194 = c__4550__auto__;
var G__22195 = cljs.core.count.call(null,c__4550__auto__);
var G__22196 = (0);
seq__22185 = G__22193;
chunk__22186 = G__22194;
count__22187 = G__22195;
i__22188 = G__22196;
continue;
} else {
var event = cljs.core.first.call(null,seq__22185__$1);
clear_event.call(null,event);


var G__22197 = cljs.core.next.call(null,seq__22185__$1);
var G__22198 = null;
var G__22199 = (0);
var G__22200 = (0);
seq__22185 = G__22197;
chunk__22186 = G__22198;
count__22187 = G__22199;
i__22188 = G__22200;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref.call(null,re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=fx.js.map?rel=1571863642605
