// Compiled by ClojureScript 1.10.238 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.16";
figwheel.client.js_stringify = ((((typeof JSON !== 'undefined') && (!((JSON.stringify == null)))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e28537){if((e28537 instanceof Error)){
var e = e28537;
return "Error: Unable to stringify";
} else {
throw e28537;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__28540 = arguments.length;
switch (G__28540) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__28538_SHARP_){
if(typeof p1__28538_SHARP_ === 'string'){
return p1__28538_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__28538_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__4502__auto__ = [];
var len__4499__auto___28543 = arguments.length;
var i__4500__auto___28544 = (0);
while(true){
if((i__4500__auto___28544 < len__4499__auto___28543)){
args__4502__auto__.push((arguments[i__4500__auto___28544]));

var G__28545 = (i__4500__auto___28544 + (1));
i__4500__auto___28544 = G__28545;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((0) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4503__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq28542){
var self__4487__auto__ = this;
return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28542));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__4502__auto__ = [];
var len__4499__auto___28547 = arguments.length;
var i__4500__auto___28548 = (0);
while(true){
if((i__4500__auto___28548 < len__4499__auto___28547)){
args__4502__auto__.push((arguments[i__4500__auto___28548]));

var G__28549 = (i__4500__auto___28548 + (1));
i__4500__auto___28548 = G__28549;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((0) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4503__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq28546){
var self__4487__auto__ = this;
return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28546));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__28550){
var map__28551 = p__28550;
var map__28551__$1 = ((((!((map__28551 == null)))?(((((map__28551.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28551.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28551):map__28551);
var message = cljs.core.get.call(null,map__28551__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__28551__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__3922__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__3911__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__3911__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__3911__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return ((cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts))));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__23309__auto___28630 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto___28630,ch){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto___28630,ch){
return (function (state_28602){
var state_val_28603 = (state_28602[(1)]);
if((state_val_28603 === (7))){
var inst_28598 = (state_28602[(2)]);
var state_28602__$1 = state_28602;
var statearr_28604_28631 = state_28602__$1;
(statearr_28604_28631[(2)] = inst_28598);

(statearr_28604_28631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28603 === (1))){
var state_28602__$1 = state_28602;
var statearr_28605_28632 = state_28602__$1;
(statearr_28605_28632[(2)] = null);

(statearr_28605_28632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28603 === (4))){
var inst_28555 = (state_28602[(7)]);
var inst_28555__$1 = (state_28602[(2)]);
var state_28602__$1 = (function (){var statearr_28606 = state_28602;
(statearr_28606[(7)] = inst_28555__$1);

return statearr_28606;
})();
if(cljs.core.truth_(inst_28555__$1)){
var statearr_28607_28633 = state_28602__$1;
(statearr_28607_28633[(1)] = (5));

} else {
var statearr_28608_28634 = state_28602__$1;
(statearr_28608_28634[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28603 === (15))){
var inst_28562 = (state_28602[(8)]);
var inst_28577 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_28562);
var inst_28578 = cljs.core.first.call(null,inst_28577);
var inst_28579 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_28578);
var inst_28580 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28579)].join('');
var inst_28581 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_28580);
var state_28602__$1 = state_28602;
var statearr_28609_28635 = state_28602__$1;
(statearr_28609_28635[(2)] = inst_28581);

(statearr_28609_28635[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28603 === (13))){
var inst_28586 = (state_28602[(2)]);
var state_28602__$1 = state_28602;
var statearr_28610_28636 = state_28602__$1;
(statearr_28610_28636[(2)] = inst_28586);

(statearr_28610_28636[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28603 === (6))){
var state_28602__$1 = state_28602;
var statearr_28611_28637 = state_28602__$1;
(statearr_28611_28637[(2)] = null);

(statearr_28611_28637[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28603 === (17))){
var inst_28584 = (state_28602[(2)]);
var state_28602__$1 = state_28602;
var statearr_28612_28638 = state_28602__$1;
(statearr_28612_28638[(2)] = inst_28584);

(statearr_28612_28638[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28603 === (3))){
var inst_28600 = (state_28602[(2)]);
var state_28602__$1 = state_28602;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28602__$1,inst_28600);
} else {
if((state_val_28603 === (12))){
var inst_28561 = (state_28602[(9)]);
var inst_28575 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_28561,opts);
var state_28602__$1 = state_28602;
if(cljs.core.truth_(inst_28575)){
var statearr_28613_28639 = state_28602__$1;
(statearr_28613_28639[(1)] = (15));

} else {
var statearr_28614_28640 = state_28602__$1;
(statearr_28614_28640[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28603 === (2))){
var state_28602__$1 = state_28602;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28602__$1,(4),ch);
} else {
if((state_val_28603 === (11))){
var inst_28562 = (state_28602[(8)]);
var inst_28567 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28568 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_28562);
var inst_28569 = cljs.core.async.timeout.call(null,(1000));
var inst_28570 = [inst_28568,inst_28569];
var inst_28571 = (new cljs.core.PersistentVector(null,2,(5),inst_28567,inst_28570,null));
var state_28602__$1 = state_28602;
return cljs.core.async.ioc_alts_BANG_.call(null,state_28602__$1,(14),inst_28571);
} else {
if((state_val_28603 === (9))){
var inst_28562 = (state_28602[(8)]);
var inst_28588 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_28589 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_28562);
var inst_28590 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_28589);
var inst_28591 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28590)].join('');
var inst_28592 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_28591);
var state_28602__$1 = (function (){var statearr_28615 = state_28602;
(statearr_28615[(10)] = inst_28588);

return statearr_28615;
})();
var statearr_28616_28641 = state_28602__$1;
(statearr_28616_28641[(2)] = inst_28592);

(statearr_28616_28641[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28603 === (5))){
var inst_28555 = (state_28602[(7)]);
var inst_28557 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_28558 = (new cljs.core.PersistentArrayMap(null,2,inst_28557,null));
var inst_28559 = (new cljs.core.PersistentHashSet(null,inst_28558,null));
var inst_28560 = figwheel.client.focus_msgs.call(null,inst_28559,inst_28555);
var inst_28561 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_28560);
var inst_28562 = cljs.core.first.call(null,inst_28560);
var inst_28563 = figwheel.client.autoload_QMARK_.call(null);
var state_28602__$1 = (function (){var statearr_28617 = state_28602;
(statearr_28617[(9)] = inst_28561);

(statearr_28617[(8)] = inst_28562);

return statearr_28617;
})();
if(cljs.core.truth_(inst_28563)){
var statearr_28618_28642 = state_28602__$1;
(statearr_28618_28642[(1)] = (8));

} else {
var statearr_28619_28643 = state_28602__$1;
(statearr_28619_28643[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28603 === (14))){
var inst_28573 = (state_28602[(2)]);
var state_28602__$1 = state_28602;
var statearr_28620_28644 = state_28602__$1;
(statearr_28620_28644[(2)] = inst_28573);

(statearr_28620_28644[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28603 === (16))){
var state_28602__$1 = state_28602;
var statearr_28621_28645 = state_28602__$1;
(statearr_28621_28645[(2)] = null);

(statearr_28621_28645[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28603 === (10))){
var inst_28594 = (state_28602[(2)]);
var state_28602__$1 = (function (){var statearr_28622 = state_28602;
(statearr_28622[(11)] = inst_28594);

return statearr_28622;
})();
var statearr_28623_28646 = state_28602__$1;
(statearr_28623_28646[(2)] = null);

(statearr_28623_28646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28603 === (8))){
var inst_28561 = (state_28602[(9)]);
var inst_28565 = figwheel.client.reload_file_state_QMARK_.call(null,inst_28561,opts);
var state_28602__$1 = state_28602;
if(cljs.core.truth_(inst_28565)){
var statearr_28624_28647 = state_28602__$1;
(statearr_28624_28647[(1)] = (11));

} else {
var statearr_28625_28648 = state_28602__$1;
(statearr_28625_28648[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto___28630,ch))
;
return ((function (switch__23144__auto__,c__23309__auto___28630,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__23145__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__23145__auto____0 = (function (){
var statearr_28626 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28626[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__23145__auto__);

(statearr_28626[(1)] = (1));

return statearr_28626;
});
var figwheel$client$file_reloader_plugin_$_state_machine__23145__auto____1 = (function (state_28602){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_28602);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e28627){if((e28627 instanceof Object)){
var ex__23148__auto__ = e28627;
var statearr_28628_28649 = state_28602;
(statearr_28628_28649[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28602);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28627;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28650 = state_28602;
state_28602 = G__28650;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__23145__auto__ = function(state_28602){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__23145__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__23145__auto____1.call(this,state_28602);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__23145__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__23145__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto___28630,ch))
})();
var state__23311__auto__ = (function (){var statearr_28629 = f__23310__auto__.call(null);
(statearr_28629[(6)] = c__23309__auto___28630);

return statearr_28629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto___28630,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__28651_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__28651_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_28655 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_28655){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var sb = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_28653 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_28654 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_28653,_STAR_print_fn_STAR_28654,sb,base_path_28655){
return (function (x){
return sb.append(x);
});})(_STAR_print_newline_STAR_28653,_STAR_print_fn_STAR_28654,sb,base_path_28655))
;

try{var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"out","out",-910545517),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb)].join(''),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_28654;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_28653;
}}catch (e28652){if((e28652 instanceof Error)){
var e = e28652;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_28655], null));
} else {
var e = e28652;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});})(base_path_28655))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__28656){
var map__28657 = p__28656;
var map__28657__$1 = ((((!((map__28657 == null)))?(((((map__28657.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28657.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28657):map__28657);
var opts = map__28657__$1;
var build_id = cljs.core.get.call(null,map__28657__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__28657,map__28657__$1,opts,build_id){
return (function (p__28659){
var vec__28660 = p__28659;
var seq__28661 = cljs.core.seq.call(null,vec__28660);
var first__28662 = cljs.core.first.call(null,seq__28661);
var seq__28661__$1 = cljs.core.next.call(null,seq__28661);
var map__28663 = first__28662;
var map__28663__$1 = ((((!((map__28663 == null)))?(((((map__28663.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28663.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28663):map__28663);
var msg = map__28663__$1;
var msg_name = cljs.core.get.call(null,map__28663__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__28661__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__28660,seq__28661,first__28662,seq__28661__$1,map__28663,map__28663__$1,msg,msg_name,_,map__28657,map__28657__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__28660,seq__28661,first__28662,seq__28661__$1,map__28663,map__28663__$1,msg,msg_name,_,map__28657,map__28657__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__28657,map__28657__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__28665){
var vec__28666 = p__28665;
var seq__28667 = cljs.core.seq.call(null,vec__28666);
var first__28668 = cljs.core.first.call(null,seq__28667);
var seq__28667__$1 = cljs.core.next.call(null,seq__28667);
var map__28669 = first__28668;
var map__28669__$1 = ((((!((map__28669 == null)))?(((((map__28669.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28669.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28669):map__28669);
var msg = map__28669__$1;
var msg_name = cljs.core.get.call(null,map__28669__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__28667__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__28671){
var map__28672 = p__28671;
var map__28672__$1 = ((((!((map__28672 == null)))?(((((map__28672.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28672.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28672):map__28672);
var on_compile_warning = cljs.core.get.call(null,map__28672__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__28672__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__28672,map__28672__$1,on_compile_warning,on_compile_fail){
return (function (p__28674){
var vec__28675 = p__28674;
var seq__28676 = cljs.core.seq.call(null,vec__28675);
var first__28677 = cljs.core.first.call(null,seq__28676);
var seq__28676__$1 = cljs.core.next.call(null,seq__28676);
var map__28678 = first__28677;
var map__28678__$1 = ((((!((map__28678 == null)))?(((((map__28678.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28678.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28678):map__28678);
var msg = map__28678__$1;
var msg_name = cljs.core.get.call(null,map__28678__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__28676__$1;
var pred__28680 = cljs.core._EQ_;
var expr__28681 = msg_name;
if(cljs.core.truth_(pred__28680.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__28681))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__28680.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__28681))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__28672,map__28672__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__23309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto__,msg_hist,msg_names,msg){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto__,msg_hist,msg_names,msg){
return (function (state_28770){
var state_val_28771 = (state_28770[(1)]);
if((state_val_28771 === (7))){
var inst_28690 = (state_28770[(2)]);
var state_28770__$1 = state_28770;
if(cljs.core.truth_(inst_28690)){
var statearr_28772_28819 = state_28770__$1;
(statearr_28772_28819[(1)] = (8));

} else {
var statearr_28773_28820 = state_28770__$1;
(statearr_28773_28820[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (20))){
var inst_28764 = (state_28770[(2)]);
var state_28770__$1 = state_28770;
var statearr_28774_28821 = state_28770__$1;
(statearr_28774_28821[(2)] = inst_28764);

(statearr_28774_28821[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (27))){
var inst_28760 = (state_28770[(2)]);
var state_28770__$1 = state_28770;
var statearr_28775_28822 = state_28770__$1;
(statearr_28775_28822[(2)] = inst_28760);

(statearr_28775_28822[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (1))){
var inst_28683 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_28770__$1 = state_28770;
if(cljs.core.truth_(inst_28683)){
var statearr_28776_28823 = state_28770__$1;
(statearr_28776_28823[(1)] = (2));

} else {
var statearr_28777_28824 = state_28770__$1;
(statearr_28777_28824[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (24))){
var inst_28762 = (state_28770[(2)]);
var state_28770__$1 = state_28770;
var statearr_28778_28825 = state_28770__$1;
(statearr_28778_28825[(2)] = inst_28762);

(statearr_28778_28825[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (4))){
var inst_28768 = (state_28770[(2)]);
var state_28770__$1 = state_28770;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28770__$1,inst_28768);
} else {
if((state_val_28771 === (15))){
var inst_28766 = (state_28770[(2)]);
var state_28770__$1 = state_28770;
var statearr_28779_28826 = state_28770__$1;
(statearr_28779_28826[(2)] = inst_28766);

(statearr_28779_28826[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (21))){
var inst_28719 = (state_28770[(2)]);
var inst_28720 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_28721 = figwheel.client.auto_jump_to_error.call(null,opts,inst_28720);
var state_28770__$1 = (function (){var statearr_28780 = state_28770;
(statearr_28780[(7)] = inst_28719);

return statearr_28780;
})();
var statearr_28781_28827 = state_28770__$1;
(statearr_28781_28827[(2)] = inst_28721);

(statearr_28781_28827[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (31))){
var inst_28749 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_28770__$1 = state_28770;
if(cljs.core.truth_(inst_28749)){
var statearr_28782_28828 = state_28770__$1;
(statearr_28782_28828[(1)] = (34));

} else {
var statearr_28783_28829 = state_28770__$1;
(statearr_28783_28829[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (32))){
var inst_28758 = (state_28770[(2)]);
var state_28770__$1 = state_28770;
var statearr_28784_28830 = state_28770__$1;
(statearr_28784_28830[(2)] = inst_28758);

(statearr_28784_28830[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (33))){
var inst_28745 = (state_28770[(2)]);
var inst_28746 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_28747 = figwheel.client.auto_jump_to_error.call(null,opts,inst_28746);
var state_28770__$1 = (function (){var statearr_28785 = state_28770;
(statearr_28785[(8)] = inst_28745);

return statearr_28785;
})();
var statearr_28786_28831 = state_28770__$1;
(statearr_28786_28831[(2)] = inst_28747);

(statearr_28786_28831[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (13))){
var inst_28704 = figwheel.client.heads_up.clear.call(null);
var state_28770__$1 = state_28770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28770__$1,(16),inst_28704);
} else {
if((state_val_28771 === (22))){
var inst_28725 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_28726 = figwheel.client.heads_up.append_warning_message.call(null,inst_28725);
var state_28770__$1 = state_28770;
var statearr_28787_28832 = state_28770__$1;
(statearr_28787_28832[(2)] = inst_28726);

(statearr_28787_28832[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (36))){
var inst_28756 = (state_28770[(2)]);
var state_28770__$1 = state_28770;
var statearr_28788_28833 = state_28770__$1;
(statearr_28788_28833[(2)] = inst_28756);

(statearr_28788_28833[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (29))){
var inst_28736 = (state_28770[(2)]);
var inst_28737 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_28738 = figwheel.client.auto_jump_to_error.call(null,opts,inst_28737);
var state_28770__$1 = (function (){var statearr_28789 = state_28770;
(statearr_28789[(9)] = inst_28736);

return statearr_28789;
})();
var statearr_28790_28834 = state_28770__$1;
(statearr_28790_28834[(2)] = inst_28738);

(statearr_28790_28834[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (6))){
var inst_28685 = (state_28770[(10)]);
var state_28770__$1 = state_28770;
var statearr_28791_28835 = state_28770__$1;
(statearr_28791_28835[(2)] = inst_28685);

(statearr_28791_28835[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (28))){
var inst_28732 = (state_28770[(2)]);
var inst_28733 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_28734 = figwheel.client.heads_up.display_warning.call(null,inst_28733);
var state_28770__$1 = (function (){var statearr_28792 = state_28770;
(statearr_28792[(11)] = inst_28732);

return statearr_28792;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28770__$1,(29),inst_28734);
} else {
if((state_val_28771 === (25))){
var inst_28730 = figwheel.client.heads_up.clear.call(null);
var state_28770__$1 = state_28770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28770__$1,(28),inst_28730);
} else {
if((state_val_28771 === (34))){
var inst_28751 = figwheel.client.heads_up.flash_loaded.call(null);
var state_28770__$1 = state_28770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28770__$1,(37),inst_28751);
} else {
if((state_val_28771 === (17))){
var inst_28710 = (state_28770[(2)]);
var inst_28711 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_28712 = figwheel.client.auto_jump_to_error.call(null,opts,inst_28711);
var state_28770__$1 = (function (){var statearr_28793 = state_28770;
(statearr_28793[(12)] = inst_28710);

return statearr_28793;
})();
var statearr_28794_28836 = state_28770__$1;
(statearr_28794_28836[(2)] = inst_28712);

(statearr_28794_28836[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (3))){
var inst_28702 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_28770__$1 = state_28770;
if(cljs.core.truth_(inst_28702)){
var statearr_28795_28837 = state_28770__$1;
(statearr_28795_28837[(1)] = (13));

} else {
var statearr_28796_28838 = state_28770__$1;
(statearr_28796_28838[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (12))){
var inst_28698 = (state_28770[(2)]);
var state_28770__$1 = state_28770;
var statearr_28797_28839 = state_28770__$1;
(statearr_28797_28839[(2)] = inst_28698);

(statearr_28797_28839[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (2))){
var inst_28685 = (state_28770[(10)]);
var inst_28685__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_28770__$1 = (function (){var statearr_28798 = state_28770;
(statearr_28798[(10)] = inst_28685__$1);

return statearr_28798;
})();
if(cljs.core.truth_(inst_28685__$1)){
var statearr_28799_28840 = state_28770__$1;
(statearr_28799_28840[(1)] = (5));

} else {
var statearr_28800_28841 = state_28770__$1;
(statearr_28800_28841[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (23))){
var inst_28728 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_28770__$1 = state_28770;
if(cljs.core.truth_(inst_28728)){
var statearr_28801_28842 = state_28770__$1;
(statearr_28801_28842[(1)] = (25));

} else {
var statearr_28802_28843 = state_28770__$1;
(statearr_28802_28843[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (35))){
var state_28770__$1 = state_28770;
var statearr_28803_28844 = state_28770__$1;
(statearr_28803_28844[(2)] = null);

(statearr_28803_28844[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (19))){
var inst_28723 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_28770__$1 = state_28770;
if(cljs.core.truth_(inst_28723)){
var statearr_28804_28845 = state_28770__$1;
(statearr_28804_28845[(1)] = (22));

} else {
var statearr_28805_28846 = state_28770__$1;
(statearr_28805_28846[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (11))){
var inst_28694 = (state_28770[(2)]);
var state_28770__$1 = state_28770;
var statearr_28806_28847 = state_28770__$1;
(statearr_28806_28847[(2)] = inst_28694);

(statearr_28806_28847[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (9))){
var inst_28696 = figwheel.client.heads_up.clear.call(null);
var state_28770__$1 = state_28770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28770__$1,(12),inst_28696);
} else {
if((state_val_28771 === (5))){
var inst_28687 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_28770__$1 = state_28770;
var statearr_28807_28848 = state_28770__$1;
(statearr_28807_28848[(2)] = inst_28687);

(statearr_28807_28848[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (14))){
var inst_28714 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_28770__$1 = state_28770;
if(cljs.core.truth_(inst_28714)){
var statearr_28808_28849 = state_28770__$1;
(statearr_28808_28849[(1)] = (18));

} else {
var statearr_28809_28850 = state_28770__$1;
(statearr_28809_28850[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (26))){
var inst_28740 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_28770__$1 = state_28770;
if(cljs.core.truth_(inst_28740)){
var statearr_28810_28851 = state_28770__$1;
(statearr_28810_28851[(1)] = (30));

} else {
var statearr_28811_28852 = state_28770__$1;
(statearr_28811_28852[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (16))){
var inst_28706 = (state_28770[(2)]);
var inst_28707 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_28708 = figwheel.client.heads_up.display_exception.call(null,inst_28707);
var state_28770__$1 = (function (){var statearr_28812 = state_28770;
(statearr_28812[(13)] = inst_28706);

return statearr_28812;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28770__$1,(17),inst_28708);
} else {
if((state_val_28771 === (30))){
var inst_28742 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_28743 = figwheel.client.heads_up.display_warning.call(null,inst_28742);
var state_28770__$1 = state_28770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28770__$1,(33),inst_28743);
} else {
if((state_val_28771 === (10))){
var inst_28700 = (state_28770[(2)]);
var state_28770__$1 = state_28770;
var statearr_28813_28853 = state_28770__$1;
(statearr_28813_28853[(2)] = inst_28700);

(statearr_28813_28853[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (18))){
var inst_28716 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_28717 = figwheel.client.heads_up.display_exception.call(null,inst_28716);
var state_28770__$1 = state_28770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28770__$1,(21),inst_28717);
} else {
if((state_val_28771 === (37))){
var inst_28753 = (state_28770[(2)]);
var state_28770__$1 = state_28770;
var statearr_28814_28854 = state_28770__$1;
(statearr_28814_28854[(2)] = inst_28753);

(statearr_28814_28854[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28771 === (8))){
var inst_28692 = figwheel.client.heads_up.flash_loaded.call(null);
var state_28770__$1 = state_28770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28770__$1,(11),inst_28692);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__23144__auto__,c__23309__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23145__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23145__auto____0 = (function (){
var statearr_28815 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28815[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23145__auto__);

(statearr_28815[(1)] = (1));

return statearr_28815;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23145__auto____1 = (function (state_28770){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_28770);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e28816){if((e28816 instanceof Object)){
var ex__23148__auto__ = e28816;
var statearr_28817_28855 = state_28770;
(statearr_28817_28855[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28770);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28816;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28856 = state_28770;
state_28770 = G__28856;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23145__auto__ = function(state_28770){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23145__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23145__auto____1.call(this,state_28770);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23145__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23145__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto__,msg_hist,msg_names,msg))
})();
var state__23311__auto__ = (function (){var statearr_28818 = f__23310__auto__.call(null);
(statearr_28818[(6)] = c__23309__auto__);

return statearr_28818;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto__,msg_hist,msg_names,msg))
);

return c__23309__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__23309__auto___28885 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto___28885,ch){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto___28885,ch){
return (function (state_28871){
var state_val_28872 = (state_28871[(1)]);
if((state_val_28872 === (1))){
var state_28871__$1 = state_28871;
var statearr_28873_28886 = state_28871__$1;
(statearr_28873_28886[(2)] = null);

(statearr_28873_28886[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28872 === (2))){
var state_28871__$1 = state_28871;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28871__$1,(4),ch);
} else {
if((state_val_28872 === (3))){
var inst_28869 = (state_28871[(2)]);
var state_28871__$1 = state_28871;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28871__$1,inst_28869);
} else {
if((state_val_28872 === (4))){
var inst_28859 = (state_28871[(7)]);
var inst_28859__$1 = (state_28871[(2)]);
var state_28871__$1 = (function (){var statearr_28874 = state_28871;
(statearr_28874[(7)] = inst_28859__$1);

return statearr_28874;
})();
if(cljs.core.truth_(inst_28859__$1)){
var statearr_28875_28887 = state_28871__$1;
(statearr_28875_28887[(1)] = (5));

} else {
var statearr_28876_28888 = state_28871__$1;
(statearr_28876_28888[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28872 === (5))){
var inst_28859 = (state_28871[(7)]);
var inst_28861 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_28859);
var state_28871__$1 = state_28871;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28871__$1,(8),inst_28861);
} else {
if((state_val_28872 === (6))){
var state_28871__$1 = state_28871;
var statearr_28877_28889 = state_28871__$1;
(statearr_28877_28889[(2)] = null);

(statearr_28877_28889[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28872 === (7))){
var inst_28867 = (state_28871[(2)]);
var state_28871__$1 = state_28871;
var statearr_28878_28890 = state_28871__$1;
(statearr_28878_28890[(2)] = inst_28867);

(statearr_28878_28890[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28872 === (8))){
var inst_28863 = (state_28871[(2)]);
var state_28871__$1 = (function (){var statearr_28879 = state_28871;
(statearr_28879[(8)] = inst_28863);

return statearr_28879;
})();
var statearr_28880_28891 = state_28871__$1;
(statearr_28880_28891[(2)] = null);

(statearr_28880_28891[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__23309__auto___28885,ch))
;
return ((function (switch__23144__auto__,c__23309__auto___28885,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__23145__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__23145__auto____0 = (function (){
var statearr_28881 = [null,null,null,null,null,null,null,null,null];
(statearr_28881[(0)] = figwheel$client$heads_up_plugin_$_state_machine__23145__auto__);

(statearr_28881[(1)] = (1));

return statearr_28881;
});
var figwheel$client$heads_up_plugin_$_state_machine__23145__auto____1 = (function (state_28871){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_28871);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e28882){if((e28882 instanceof Object)){
var ex__23148__auto__ = e28882;
var statearr_28883_28892 = state_28871;
(statearr_28883_28892[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28871);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28882;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28893 = state_28871;
state_28871 = G__28893;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__23145__auto__ = function(state_28871){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__23145__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__23145__auto____1.call(this,state_28871);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__23145__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__23145__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto___28885,ch))
})();
var state__23311__auto__ = (function (){var statearr_28884 = f__23310__auto__.call(null);
(statearr_28884[(6)] = c__23309__auto___28885);

return statearr_28884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto___28885,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__23309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto__){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto__){
return (function (state_28899){
var state_val_28900 = (state_28899[(1)]);
if((state_val_28900 === (1))){
var inst_28894 = cljs.core.async.timeout.call(null,(3000));
var state_28899__$1 = state_28899;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28899__$1,(2),inst_28894);
} else {
if((state_val_28900 === (2))){
var inst_28896 = (state_28899[(2)]);
var inst_28897 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_28899__$1 = (function (){var statearr_28901 = state_28899;
(statearr_28901[(7)] = inst_28896);

return statearr_28901;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28899__$1,inst_28897);
} else {
return null;
}
}
});})(c__23309__auto__))
;
return ((function (switch__23144__auto__,c__23309__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__23145__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__23145__auto____0 = (function (){
var statearr_28902 = [null,null,null,null,null,null,null,null];
(statearr_28902[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__23145__auto__);

(statearr_28902[(1)] = (1));

return statearr_28902;
});
var figwheel$client$enforce_project_plugin_$_state_machine__23145__auto____1 = (function (state_28899){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_28899);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e28903){if((e28903 instanceof Object)){
var ex__23148__auto__ = e28903;
var statearr_28904_28906 = state_28899;
(statearr_28904_28906[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28899);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28903;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28907 = state_28899;
state_28899 = G__28907;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__23145__auto__ = function(state_28899){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__23145__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__23145__auto____1.call(this,state_28899);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__23145__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__23145__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto__))
})();
var state__23311__auto__ = (function (){var statearr_28905 = f__23310__auto__.call(null);
(statearr_28905[(6)] = c__23309__auto__);

return statearr_28905;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto__))
);

return c__23309__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__5457__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__5457__auto__)){
var figwheel_version = temp__5457__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__23309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto__,figwheel_version,temp__5457__auto__){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto__,figwheel_version,temp__5457__auto__){
return (function (state_28914){
var state_val_28915 = (state_28914[(1)]);
if((state_val_28915 === (1))){
var inst_28908 = cljs.core.async.timeout.call(null,(2000));
var state_28914__$1 = state_28914;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28914__$1,(2),inst_28908);
} else {
if((state_val_28915 === (2))){
var inst_28910 = (state_28914[(2)]);
var inst_28911 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_28912 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_28911);
var state_28914__$1 = (function (){var statearr_28916 = state_28914;
(statearr_28916[(7)] = inst_28910);

return statearr_28916;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28914__$1,inst_28912);
} else {
return null;
}
}
});})(c__23309__auto__,figwheel_version,temp__5457__auto__))
;
return ((function (switch__23144__auto__,c__23309__auto__,figwheel_version,temp__5457__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23145__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23145__auto____0 = (function (){
var statearr_28917 = [null,null,null,null,null,null,null,null];
(statearr_28917[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23145__auto__);

(statearr_28917[(1)] = (1));

return statearr_28917;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23145__auto____1 = (function (state_28914){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_28914);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e28918){if((e28918 instanceof Object)){
var ex__23148__auto__ = e28918;
var statearr_28919_28921 = state_28914;
(statearr_28919_28921[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28914);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28918;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28922 = state_28914;
state_28914 = G__28922;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23145__auto__ = function(state_28914){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23145__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23145__auto____1.call(this,state_28914);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23145__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23145__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto__,figwheel_version,temp__5457__auto__))
})();
var state__23311__auto__ = (function (){var statearr_28920 = f__23310__auto__.call(null);
(statearr_28920[(6)] = c__23309__auto__);

return statearr_28920;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto__,figwheel_version,temp__5457__auto__))
);

return c__23309__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__28923){
var map__28924 = p__28923;
var map__28924__$1 = ((((!((map__28924 == null)))?(((((map__28924.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28924.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28924):map__28924);
var file = cljs.core.get.call(null,map__28924__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__28924__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__28924__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__28926 = "";
var G__28926__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28926),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__28926);
var G__28926__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28926__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__28926__$1);
if(cljs.core.truth_((function (){var and__3911__auto__ = line;
if(cljs.core.truth_(and__3911__auto__)){
return column;
} else {
return and__3911__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28926__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__28926__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__28927){
var map__28928 = p__28927;
var map__28928__$1 = ((((!((map__28928 == null)))?(((((map__28928.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28928.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28928):map__28928);
var ed = map__28928__$1;
var formatted_exception = cljs.core.get.call(null,map__28928__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__28928__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__28928__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__28930_28934 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__28931_28935 = null;
var count__28932_28936 = (0);
var i__28933_28937 = (0);
while(true){
if((i__28933_28937 < count__28932_28936)){
var msg_28938 = cljs.core._nth.call(null,chunk__28931_28935,i__28933_28937);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_28938);


var G__28939 = seq__28930_28934;
var G__28940 = chunk__28931_28935;
var G__28941 = count__28932_28936;
var G__28942 = (i__28933_28937 + (1));
seq__28930_28934 = G__28939;
chunk__28931_28935 = G__28940;
count__28932_28936 = G__28941;
i__28933_28937 = G__28942;
continue;
} else {
var temp__5457__auto___28943 = cljs.core.seq.call(null,seq__28930_28934);
if(temp__5457__auto___28943){
var seq__28930_28944__$1 = temp__5457__auto___28943;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28930_28944__$1)){
var c__4319__auto___28945 = cljs.core.chunk_first.call(null,seq__28930_28944__$1);
var G__28946 = cljs.core.chunk_rest.call(null,seq__28930_28944__$1);
var G__28947 = c__4319__auto___28945;
var G__28948 = cljs.core.count.call(null,c__4319__auto___28945);
var G__28949 = (0);
seq__28930_28934 = G__28946;
chunk__28931_28935 = G__28947;
count__28932_28936 = G__28948;
i__28933_28937 = G__28949;
continue;
} else {
var msg_28950 = cljs.core.first.call(null,seq__28930_28944__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_28950);


var G__28951 = cljs.core.next.call(null,seq__28930_28944__$1);
var G__28952 = null;
var G__28953 = (0);
var G__28954 = (0);
seq__28930_28934 = G__28951;
chunk__28931_28935 = G__28952;
count__28932_28936 = G__28953;
i__28933_28937 = G__28954;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__28955){
var map__28956 = p__28955;
var map__28956__$1 = ((((!((map__28956 == null)))?(((((map__28956.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28956.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28956):map__28956);
var w = map__28956__$1;
var message = cljs.core.get.call(null,map__28956__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/out/figwheel/client.cljs",33,1,361,361,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/out/figwheel/client.cljs",30,1,353,353,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__3911__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__3911__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__3911__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_json_message_watch = (function figwheel$client$add_json_message_watch(key,callback){
return figwheel.client.add_message_watch.call(null,key,cljs.core.comp.call(null,callback,cljs.core.clj__GT_js));
});
goog.exportSymbol('figwheel.client.add_json_message_watch', figwheel.client.add_json_message_watch);
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__28958 = cljs.core.seq.call(null,plugins);
var chunk__28959 = null;
var count__28960 = (0);
var i__28961 = (0);
while(true){
if((i__28961 < count__28960)){
var vec__28962 = cljs.core._nth.call(null,chunk__28959,i__28961);
var k = cljs.core.nth.call(null,vec__28962,(0),null);
var plugin = cljs.core.nth.call(null,vec__28962,(1),null);
if(cljs.core.truth_(plugin)){
var pl_28968 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__28958,chunk__28959,count__28960,i__28961,pl_28968,vec__28962,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_28968.call(null,msg_hist);
});})(seq__28958,chunk__28959,count__28960,i__28961,pl_28968,vec__28962,k,plugin))
);
} else {
}


var G__28969 = seq__28958;
var G__28970 = chunk__28959;
var G__28971 = count__28960;
var G__28972 = (i__28961 + (1));
seq__28958 = G__28969;
chunk__28959 = G__28970;
count__28960 = G__28971;
i__28961 = G__28972;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__28958);
if(temp__5457__auto__){
var seq__28958__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28958__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__28958__$1);
var G__28973 = cljs.core.chunk_rest.call(null,seq__28958__$1);
var G__28974 = c__4319__auto__;
var G__28975 = cljs.core.count.call(null,c__4319__auto__);
var G__28976 = (0);
seq__28958 = G__28973;
chunk__28959 = G__28974;
count__28960 = G__28975;
i__28961 = G__28976;
continue;
} else {
var vec__28965 = cljs.core.first.call(null,seq__28958__$1);
var k = cljs.core.nth.call(null,vec__28965,(0),null);
var plugin = cljs.core.nth.call(null,vec__28965,(1),null);
if(cljs.core.truth_(plugin)){
var pl_28977 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__28958,chunk__28959,count__28960,i__28961,pl_28977,vec__28965,k,plugin,seq__28958__$1,temp__5457__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_28977.call(null,msg_hist);
});})(seq__28958,chunk__28959,count__28960,i__28961,pl_28977,vec__28965,k,plugin,seq__28958__$1,temp__5457__auto__))
);
} else {
}


var G__28978 = cljs.core.next.call(null,seq__28958__$1);
var G__28979 = null;
var G__28980 = (0);
var G__28981 = (0);
seq__28958 = G__28978;
chunk__28959 = G__28979;
count__28960 = G__28980;
i__28961 = G__28981;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__28983 = arguments.length;
switch (G__28983) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__28984_28989 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__28985_28990 = null;
var count__28986_28991 = (0);
var i__28987_28992 = (0);
while(true){
if((i__28987_28992 < count__28986_28991)){
var msg_28993 = cljs.core._nth.call(null,chunk__28985_28990,i__28987_28992);
figwheel.client.socket.handle_incoming_message.call(null,msg_28993);


var G__28994 = seq__28984_28989;
var G__28995 = chunk__28985_28990;
var G__28996 = count__28986_28991;
var G__28997 = (i__28987_28992 + (1));
seq__28984_28989 = G__28994;
chunk__28985_28990 = G__28995;
count__28986_28991 = G__28996;
i__28987_28992 = G__28997;
continue;
} else {
var temp__5457__auto___28998 = cljs.core.seq.call(null,seq__28984_28989);
if(temp__5457__auto___28998){
var seq__28984_28999__$1 = temp__5457__auto___28998;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28984_28999__$1)){
var c__4319__auto___29000 = cljs.core.chunk_first.call(null,seq__28984_28999__$1);
var G__29001 = cljs.core.chunk_rest.call(null,seq__28984_28999__$1);
var G__29002 = c__4319__auto___29000;
var G__29003 = cljs.core.count.call(null,c__4319__auto___29000);
var G__29004 = (0);
seq__28984_28989 = G__29001;
chunk__28985_28990 = G__29002;
count__28986_28991 = G__29003;
i__28987_28992 = G__29004;
continue;
} else {
var msg_29005 = cljs.core.first.call(null,seq__28984_28999__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_29005);


var G__29006 = cljs.core.next.call(null,seq__28984_28999__$1);
var G__29007 = null;
var G__29008 = (0);
var G__29009 = (0);
seq__28984_28989 = G__29006;
chunk__28985_28990 = G__29007;
count__28986_28991 = G__29008;
i__28987_28992 = G__29009;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__4502__auto__ = [];
var len__4499__auto___29014 = arguments.length;
var i__4500__auto___29015 = (0);
while(true){
if((i__4500__auto___29015 < len__4499__auto___29014)){
args__4502__auto__.push((arguments[i__4500__auto___29015]));

var G__29016 = (i__4500__auto___29015 + (1));
i__4500__auto___29015 = G__29016;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((0) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__4503__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__29011){
var map__29012 = p__29011;
var map__29012__$1 = ((((!((map__29012 == null)))?(((((map__29012.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29012.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29012):map__29012);
var opts = map__29012__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq29010){
var self__4487__auto__ = this;
return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29010));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e29017){if((e29017 instanceof Error)){
var e = e29017;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e29017;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__29018){
var map__29019 = p__29018;
var map__29019__$1 = ((((!((map__29019 == null)))?(((((map__29019.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29019.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29019):map__29019);
var msg_name = cljs.core.get.call(null,map__29019__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1529759829156
