// Compiled by ClojureScript 1.10.238 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__3922__auto__ = ((cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && ((((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string'))) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372))));
if(or__3922__auto__){
return or__3922__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__3922__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
var or__3922__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__3922__auto____$1)){
return or__3922__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__27584_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__27584_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__27585 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__27586 = null;
var count__27587 = (0);
var i__27588 = (0);
while(true){
if((i__27588 < count__27587)){
var n = cljs.core._nth.call(null,chunk__27586,i__27588);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__27589 = seq__27585;
var G__27590 = chunk__27586;
var G__27591 = count__27587;
var G__27592 = (i__27588 + (1));
seq__27585 = G__27589;
chunk__27586 = G__27590;
count__27587 = G__27591;
i__27588 = G__27592;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__27585);
if(temp__5457__auto__){
var seq__27585__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27585__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__27585__$1);
var G__27593 = cljs.core.chunk_rest.call(null,seq__27585__$1);
var G__27594 = c__4319__auto__;
var G__27595 = cljs.core.count.call(null,c__4319__auto__);
var G__27596 = (0);
seq__27585 = G__27593;
chunk__27586 = G__27594;
count__27587 = G__27595;
i__27588 = G__27596;
continue;
} else {
var n = cljs.core.first.call(null,seq__27585__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__27597 = cljs.core.next.call(null,seq__27585__$1);
var G__27598 = null;
var G__27599 = (0);
var G__27600 = (0);
seq__27585 = G__27597;
chunk__27586 = G__27598;
count__27587 = G__27599;
i__27588 = G__27600;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.in_upper_level_QMARK_ = (function figwheel$client$file_reloading$in_upper_level_QMARK_(topo_state,current_depth,dep){
return cljs.core.some.call(null,(function (p__27601){
var vec__27602 = p__27601;
var _ = cljs.core.nth.call(null,vec__27602,(0),null);
var v = cljs.core.nth.call(null,vec__27602,(1),null);
var and__3911__auto__ = v;
if(cljs.core.truth_(and__3911__auto__)){
return v.call(null,dep);
} else {
return and__3911__auto__;
}
}),cljs.core.filter.call(null,(function (p__27605){
var vec__27606 = p__27605;
var k = cljs.core.nth.call(null,vec__27606,(0),null);
var v = cljs.core.nth.call(null,vec__27606,(1),null);
return (k > current_depth);
}),topo_state));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__27623_27642 = cljs.core.seq.call(null,deps);
var chunk__27624_27643 = null;
var count__27625_27644 = (0);
var i__27626_27645 = (0);
while(true){
if((i__27626_27645 < count__27625_27644)){
var dep_27650 = cljs.core._nth.call(null,chunk__27624_27643,i__27626_27645);
if(cljs.core.truth_((function (){var and__3911__auto__ = dep_27650;
if(cljs.core.truth_(and__3911__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_27650));
} else {
return and__3911__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_27650,(depth + (1)),state);
} else {
}


var G__27656 = seq__27623_27642;
var G__27657 = chunk__27624_27643;
var G__27658 = count__27625_27644;
var G__27659 = (i__27626_27645 + (1));
seq__27623_27642 = G__27656;
chunk__27624_27643 = G__27657;
count__27625_27644 = G__27658;
i__27626_27645 = G__27659;
continue;
} else {
var temp__5457__auto___27662 = cljs.core.seq.call(null,seq__27623_27642);
if(temp__5457__auto___27662){
var seq__27623_27664__$1 = temp__5457__auto___27662;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27623_27664__$1)){
var c__4319__auto___27669 = cljs.core.chunk_first.call(null,seq__27623_27664__$1);
var G__27670 = cljs.core.chunk_rest.call(null,seq__27623_27664__$1);
var G__27671 = c__4319__auto___27669;
var G__27672 = cljs.core.count.call(null,c__4319__auto___27669);
var G__27673 = (0);
seq__27623_27642 = G__27670;
chunk__27624_27643 = G__27671;
count__27625_27644 = G__27672;
i__27626_27645 = G__27673;
continue;
} else {
var dep_27675 = cljs.core.first.call(null,seq__27623_27664__$1);
if(cljs.core.truth_((function (){var and__3911__auto__ = dep_27675;
if(cljs.core.truth_(and__3911__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_27675));
} else {
return and__3911__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_27675,(depth + (1)),state);
} else {
}


var G__27684 = cljs.core.next.call(null,seq__27623_27664__$1);
var G__27685 = null;
var G__27686 = (0);
var G__27687 = (0);
seq__27623_27642 = G__27684;
chunk__27624_27643 = G__27685;
count__27625_27644 = G__27686;
i__27626_27645 = G__27687;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__27635){
var vec__27636 = p__27635;
var seq__27637 = cljs.core.seq.call(null,vec__27636);
var first__27638 = cljs.core.first.call(null,seq__27637);
var seq__27637__$1 = cljs.core.next.call(null,seq__27637);
var x = first__27638;
var xs = seq__27637__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__27636,seq__27637,first__27638,seq__27637__$1,x,xs,get_deps__$1){
return (function (p1__27609_SHARP_){
return clojure.set.difference.call(null,p1__27609_SHARP_,x);
});})(vec__27636,seq__27637,first__27638,seq__27637__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__27705 = cljs.core.seq.call(null,provides);
var chunk__27706 = null;
var count__27707 = (0);
var i__27708 = (0);
while(true){
if((i__27708 < count__27707)){
var prov = cljs.core._nth.call(null,chunk__27706,i__27708);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__27709_27717 = cljs.core.seq.call(null,requires);
var chunk__27710_27718 = null;
var count__27711_27719 = (0);
var i__27712_27720 = (0);
while(true){
if((i__27712_27720 < count__27711_27719)){
var req_27721 = cljs.core._nth.call(null,chunk__27710_27718,i__27712_27720);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_27721,prov);


var G__27722 = seq__27709_27717;
var G__27723 = chunk__27710_27718;
var G__27724 = count__27711_27719;
var G__27725 = (i__27712_27720 + (1));
seq__27709_27717 = G__27722;
chunk__27710_27718 = G__27723;
count__27711_27719 = G__27724;
i__27712_27720 = G__27725;
continue;
} else {
var temp__5457__auto___27726 = cljs.core.seq.call(null,seq__27709_27717);
if(temp__5457__auto___27726){
var seq__27709_27727__$1 = temp__5457__auto___27726;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27709_27727__$1)){
var c__4319__auto___27728 = cljs.core.chunk_first.call(null,seq__27709_27727__$1);
var G__27729 = cljs.core.chunk_rest.call(null,seq__27709_27727__$1);
var G__27730 = c__4319__auto___27728;
var G__27731 = cljs.core.count.call(null,c__4319__auto___27728);
var G__27732 = (0);
seq__27709_27717 = G__27729;
chunk__27710_27718 = G__27730;
count__27711_27719 = G__27731;
i__27712_27720 = G__27732;
continue;
} else {
var req_27733 = cljs.core.first.call(null,seq__27709_27727__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_27733,prov);


var G__27734 = cljs.core.next.call(null,seq__27709_27727__$1);
var G__27735 = null;
var G__27736 = (0);
var G__27737 = (0);
seq__27709_27717 = G__27734;
chunk__27710_27718 = G__27735;
count__27711_27719 = G__27736;
i__27712_27720 = G__27737;
continue;
}
} else {
}
}
break;
}


var G__27739 = seq__27705;
var G__27740 = chunk__27706;
var G__27741 = count__27707;
var G__27742 = (i__27708 + (1));
seq__27705 = G__27739;
chunk__27706 = G__27740;
count__27707 = G__27741;
i__27708 = G__27742;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__27705);
if(temp__5457__auto__){
var seq__27705__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27705__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__27705__$1);
var G__27745 = cljs.core.chunk_rest.call(null,seq__27705__$1);
var G__27746 = c__4319__auto__;
var G__27747 = cljs.core.count.call(null,c__4319__auto__);
var G__27748 = (0);
seq__27705 = G__27745;
chunk__27706 = G__27746;
count__27707 = G__27747;
i__27708 = G__27748;
continue;
} else {
var prov = cljs.core.first.call(null,seq__27705__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__27713_27754 = cljs.core.seq.call(null,requires);
var chunk__27714_27755 = null;
var count__27715_27756 = (0);
var i__27716_27757 = (0);
while(true){
if((i__27716_27757 < count__27715_27756)){
var req_27758 = cljs.core._nth.call(null,chunk__27714_27755,i__27716_27757);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_27758,prov);


var G__27759 = seq__27713_27754;
var G__27760 = chunk__27714_27755;
var G__27761 = count__27715_27756;
var G__27762 = (i__27716_27757 + (1));
seq__27713_27754 = G__27759;
chunk__27714_27755 = G__27760;
count__27715_27756 = G__27761;
i__27716_27757 = G__27762;
continue;
} else {
var temp__5457__auto___27763__$1 = cljs.core.seq.call(null,seq__27713_27754);
if(temp__5457__auto___27763__$1){
var seq__27713_27764__$1 = temp__5457__auto___27763__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27713_27764__$1)){
var c__4319__auto___27765 = cljs.core.chunk_first.call(null,seq__27713_27764__$1);
var G__27766 = cljs.core.chunk_rest.call(null,seq__27713_27764__$1);
var G__27767 = c__4319__auto___27765;
var G__27768 = cljs.core.count.call(null,c__4319__auto___27765);
var G__27769 = (0);
seq__27713_27754 = G__27766;
chunk__27714_27755 = G__27767;
count__27715_27756 = G__27768;
i__27716_27757 = G__27769;
continue;
} else {
var req_27771 = cljs.core.first.call(null,seq__27713_27764__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_27771,prov);


var G__27774 = cljs.core.next.call(null,seq__27713_27764__$1);
var G__27775 = null;
var G__27776 = (0);
var G__27777 = (0);
seq__27713_27754 = G__27774;
chunk__27714_27755 = G__27775;
count__27715_27756 = G__27776;
i__27716_27757 = G__27777;
continue;
}
} else {
}
}
break;
}


var G__27778 = cljs.core.next.call(null,seq__27705__$1);
var G__27779 = null;
var G__27780 = (0);
var G__27781 = (0);
seq__27705 = G__27778;
chunk__27706 = G__27779;
count__27707 = G__27780;
i__27708 = G__27781;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__27782_27789 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__27783_27790 = null;
var count__27784_27791 = (0);
var i__27785_27792 = (0);
while(true){
if((i__27785_27792 < count__27784_27791)){
var ns_27793 = cljs.core._nth.call(null,chunk__27783_27790,i__27785_27792);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_27793);


var G__27794 = seq__27782_27789;
var G__27795 = chunk__27783_27790;
var G__27796 = count__27784_27791;
var G__27797 = (i__27785_27792 + (1));
seq__27782_27789 = G__27794;
chunk__27783_27790 = G__27795;
count__27784_27791 = G__27796;
i__27785_27792 = G__27797;
continue;
} else {
var temp__5457__auto___27798 = cljs.core.seq.call(null,seq__27782_27789);
if(temp__5457__auto___27798){
var seq__27782_27799__$1 = temp__5457__auto___27798;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27782_27799__$1)){
var c__4319__auto___27800 = cljs.core.chunk_first.call(null,seq__27782_27799__$1);
var G__27801 = cljs.core.chunk_rest.call(null,seq__27782_27799__$1);
var G__27802 = c__4319__auto___27800;
var G__27803 = cljs.core.count.call(null,c__4319__auto___27800);
var G__27804 = (0);
seq__27782_27789 = G__27801;
chunk__27783_27790 = G__27802;
count__27784_27791 = G__27803;
i__27785_27792 = G__27804;
continue;
} else {
var ns_27805 = cljs.core.first.call(null,seq__27782_27799__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_27805);


var G__27807 = cljs.core.next.call(null,seq__27782_27799__$1);
var G__27808 = null;
var G__27809 = (0);
var G__27810 = (0);
seq__27782_27789 = G__27807;
chunk__27783_27790 = G__27808;
count__27784_27791 = G__27809;
i__27785_27792 = G__27810;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__3922__auto__ = goog.require__;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__27833__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__27833 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__27834__i = 0, G__27834__a = new Array(arguments.length -  0);
while (G__27834__i < G__27834__a.length) {G__27834__a[G__27834__i] = arguments[G__27834__i + 0]; ++G__27834__i;}
  args = new cljs.core.IndexedSeq(G__27834__a,0,null);
} 
return G__27833__delegate.call(this,args);};
G__27833.cljs$lang$maxFixedArity = 0;
G__27833.cljs$lang$applyTo = (function (arglist__27835){
var args = cljs.core.seq(arglist__27835);
return G__27833__delegate(args);
});
G__27833.cljs$core$IFn$_invoke$arity$variadic = G__27833__delegate;
return G__27833;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = ((typeof goog.net.jsloader.safeLoad !== 'undefined')?(function (p1__27836_SHARP_,p2__27837_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__27836_SHARP_)].join('')),p2__27837_SHARP_);
}):((typeof goog.net.jsloader.load !== 'undefined')?(function (p1__27838_SHARP_,p2__27839_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__27838_SHARP_)].join(''),p2__27839_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__27840 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__27840.addCallback(((function (G__27840){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__27840))
);

G__27840.addErrback(((function (G__27840){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__27840))
);

return G__27840;
});
figwheel.client.file_reloading.write_script_tag_import = figwheel.client.file_reloading.reload_file_in_html_env;
goog.exportSymbol('figwheel.client.file_reloading.write_script_tag_import', figwheel.client.file_reloading.write_script_tag_import);
figwheel.client.file_reloading.worker_import_script = (function figwheel$client$file_reloading$worker_import_script(request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e27843){if((e27843 instanceof Error)){
var e = e27843;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e27843;

}
}})());
});
goog.exportSymbol('figwheel.client.file_reloading.worker_import_script', figwheel.client.file_reloading.worker_import_script);
figwheel.client.file_reloading.create_node_script_import_fn = (function figwheel$client$file_reloading$create_node_script_import_fn(){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e27847){if((e27847 instanceof Error)){
var e = e27847;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e27847;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path))
});
goog.exportSymbol('figwheel.client.file_reloading.create_node_script_import_fn', figwheel.client.file_reloading.create_node_script_import_fn);
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__27851 = cljs.core._EQ_;
var expr__27852 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__27851.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__27852))){
return figwheel.client.file_reloading.create_node_script_import_fn.call(null);
} else {
if(cljs.core.truth_(pred__27851.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__27852))){
return figwheel.client.file_reloading.write_script_tag_import;
} else {
if(cljs.core.truth_(pred__27851.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__27852))){
return figwheel.client.file_reloading.worker_import_script;
} else {
return ((function (pred__27851,expr__27852){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__27851,expr__27852))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__27854,callback){
var map__27855 = p__27854;
var map__27855__$1 = ((((!((map__27855 == null)))?(((((map__27855.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27855.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27855):map__27855);
var file_msg = map__27855__$1;
var request_url = cljs.core.get.call(null,map__27855__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return (function (){var or__3922__auto__ = goog.object.get(goog.global,"FIGWHEEL_IMPORT_SCRIPT");
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return figwheel.client.file_reloading.reload_file_STAR_;
}
})().call(null,request_url,((function (map__27855,map__27855__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__27855,map__27855__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__23309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto__){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto__){
return (function (state_27897){
var state_val_27898 = (state_27897[(1)]);
if((state_val_27898 === (7))){
var inst_27893 = (state_27897[(2)]);
var state_27897__$1 = state_27897;
var statearr_27902_27930 = state_27897__$1;
(statearr_27902_27930[(2)] = inst_27893);

(statearr_27902_27930[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27898 === (1))){
var state_27897__$1 = state_27897;
var statearr_27903_27931 = state_27897__$1;
(statearr_27903_27931[(2)] = null);

(statearr_27903_27931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27898 === (4))){
var inst_27859 = (state_27897[(7)]);
var inst_27859__$1 = (state_27897[(2)]);
var state_27897__$1 = (function (){var statearr_27904 = state_27897;
(statearr_27904[(7)] = inst_27859__$1);

return statearr_27904;
})();
if(cljs.core.truth_(inst_27859__$1)){
var statearr_27905_27933 = state_27897__$1;
(statearr_27905_27933[(1)] = (5));

} else {
var statearr_27906_27934 = state_27897__$1;
(statearr_27906_27934[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27898 === (15))){
var inst_27874 = (state_27897[(8)]);
var inst_27872 = (state_27897[(9)]);
var inst_27876 = inst_27874.call(null,inst_27872);
var state_27897__$1 = state_27897;
var statearr_27907_27937 = state_27897__$1;
(statearr_27907_27937[(2)] = inst_27876);

(statearr_27907_27937[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27898 === (13))){
var inst_27887 = (state_27897[(2)]);
var state_27897__$1 = state_27897;
var statearr_27908_27941 = state_27897__$1;
(statearr_27908_27941[(2)] = inst_27887);

(statearr_27908_27941[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27898 === (6))){
var state_27897__$1 = state_27897;
var statearr_27909_27942 = state_27897__$1;
(statearr_27909_27942[(2)] = null);

(statearr_27909_27942[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27898 === (17))){
var inst_27881 = (state_27897[(2)]);
var state_27897__$1 = state_27897;
var statearr_27910_27943 = state_27897__$1;
(statearr_27910_27943[(2)] = inst_27881);

(statearr_27910_27943[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27898 === (3))){
var inst_27895 = (state_27897[(2)]);
var state_27897__$1 = state_27897;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27897__$1,inst_27895);
} else {
if((state_val_27898 === (12))){
var state_27897__$1 = state_27897;
var statearr_27911_27944 = state_27897__$1;
(statearr_27911_27944[(2)] = null);

(statearr_27911_27944[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27898 === (2))){
var state_27897__$1 = state_27897;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27897__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_27898 === (11))){
var inst_27864 = (state_27897[(10)]);
var inst_27870 = figwheel.client.file_reloading.blocking_load.call(null,inst_27864);
var state_27897__$1 = state_27897;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27897__$1,(14),inst_27870);
} else {
if((state_val_27898 === (9))){
var inst_27864 = (state_27897[(10)]);
var state_27897__$1 = state_27897;
if(cljs.core.truth_(inst_27864)){
var statearr_27913_27945 = state_27897__$1;
(statearr_27913_27945[(1)] = (11));

} else {
var statearr_27914_27946 = state_27897__$1;
(statearr_27914_27946[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27898 === (5))){
var inst_27865 = (state_27897[(11)]);
var inst_27859 = (state_27897[(7)]);
var inst_27864 = cljs.core.nth.call(null,inst_27859,(0),null);
var inst_27865__$1 = cljs.core.nth.call(null,inst_27859,(1),null);
var state_27897__$1 = (function (){var statearr_27915 = state_27897;
(statearr_27915[(10)] = inst_27864);

(statearr_27915[(11)] = inst_27865__$1);

return statearr_27915;
})();
if(cljs.core.truth_(inst_27865__$1)){
var statearr_27916_27947 = state_27897__$1;
(statearr_27916_27947[(1)] = (8));

} else {
var statearr_27917_27948 = state_27897__$1;
(statearr_27917_27948[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27898 === (14))){
var inst_27874 = (state_27897[(8)]);
var inst_27864 = (state_27897[(10)]);
var inst_27872 = (state_27897[(2)]);
var inst_27873 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_27874__$1 = cljs.core.get.call(null,inst_27873,inst_27864);
var state_27897__$1 = (function (){var statearr_27918 = state_27897;
(statearr_27918[(8)] = inst_27874__$1);

(statearr_27918[(9)] = inst_27872);

return statearr_27918;
})();
if(cljs.core.truth_(inst_27874__$1)){
var statearr_27919_27949 = state_27897__$1;
(statearr_27919_27949[(1)] = (15));

} else {
var statearr_27920_27950 = state_27897__$1;
(statearr_27920_27950[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27898 === (16))){
var inst_27872 = (state_27897[(9)]);
var inst_27879 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_27872);
var state_27897__$1 = state_27897;
var statearr_27921_27951 = state_27897__$1;
(statearr_27921_27951[(2)] = inst_27879);

(statearr_27921_27951[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27898 === (10))){
var inst_27889 = (state_27897[(2)]);
var state_27897__$1 = (function (){var statearr_27923 = state_27897;
(statearr_27923[(12)] = inst_27889);

return statearr_27923;
})();
var statearr_27924_27952 = state_27897__$1;
(statearr_27924_27952[(2)] = null);

(statearr_27924_27952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27898 === (8))){
var inst_27865 = (state_27897[(11)]);
var inst_27867 = eval(inst_27865);
var state_27897__$1 = state_27897;
var statearr_27925_27953 = state_27897__$1;
(statearr_27925_27953[(2)] = inst_27867);

(statearr_27925_27953[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto__))
;
return ((function (switch__23144__auto__,c__23309__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__23145__auto__ = null;
var figwheel$client$file_reloading$state_machine__23145__auto____0 = (function (){
var statearr_27926 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27926[(0)] = figwheel$client$file_reloading$state_machine__23145__auto__);

(statearr_27926[(1)] = (1));

return statearr_27926;
});
var figwheel$client$file_reloading$state_machine__23145__auto____1 = (function (state_27897){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_27897);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e27927){if((e27927 instanceof Object)){
var ex__23148__auto__ = e27927;
var statearr_27928_27954 = state_27897;
(statearr_27928_27954[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27897);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27927;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27955 = state_27897;
state_27897 = G__27955;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__23145__auto__ = function(state_27897){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__23145__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__23145__auto____1.call(this,state_27897);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__23145__auto____0;
figwheel$client$file_reloading$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__23145__auto____1;
return figwheel$client$file_reloading$state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto__))
})();
var state__23311__auto__ = (function (){var statearr_27929 = f__23310__auto__.call(null);
(statearr_27929[(6)] = c__23309__auto__);

return statearr_27929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto__))
);

return c__23309__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(var_args){
var G__27959 = arguments.length;
switch (G__27959) {
case 1:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1 = (function (url){
return figwheel.client.file_reloading.queued_file_reload.call(null,url,null);
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2 = (function (url,opt_source_text){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,opt_source_text], null));
});

figwheel.client.file_reloading.queued_file_reload.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__27962,callback){
var map__27963 = p__27962;
var map__27963__$1 = ((((!((map__27963 == null)))?(((((map__27963.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27963.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27963):map__27963);
var file_msg = map__27963__$1;
var namespace = cljs.core.get.call(null,map__27963__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__27963,map__27963__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__27963,map__27963__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__27968){
var map__27969 = p__27968;
var map__27969__$1 = ((((!((map__27969 == null)))?(((((map__27969.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27969.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27969):map__27969);
var file_msg = map__27969__$1;
var namespace = cljs.core.get.call(null,map__27969__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.ns_exists_QMARK_ = (function figwheel$client$file_reloading$ns_exists_QMARK_(namespace){
return !((cljs.core.reduce.call(null,cljs.core.fnil.call(null,goog.object.get,({})),goog.global,clojure.string.split.call(null,cljs.core.name.call(null,namespace),".")) == null));
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__27975){
var map__27976 = p__27975;
var map__27976__$1 = ((((!((map__27976 == null)))?(((((map__27976.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27976.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27976):map__27976);
var file_msg = map__27976__$1;
var namespace = cljs.core.get.call(null,map__27976__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__3911__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__3911__auto__){
var or__3922__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
var or__3922__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__3922__auto____$1)){
return or__3922__auto____$1;
} else {
var or__3922__auto____$2 = figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
if(cljs.core.truth_(or__3922__auto____$2)){
return or__3922__auto____$2;
} else {
return figwheel.client.file_reloading.ns_exists_QMARK_.call(null,namespace);
}
}
}
} else {
return and__3911__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__27978,callback){
var map__27979 = p__27978;
var map__27979__$1 = ((((!((map__27979 == null)))?(((((map__27979.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27979.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27979):map__27979);
var file_msg = map__27979__$1;
var request_url = cljs.core.get.call(null,map__27979__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__27979__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__23309__auto___28038 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto___28038,out){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto___28038,out){
return (function (state_28016){
var state_val_28017 = (state_28016[(1)]);
if((state_val_28017 === (1))){
var inst_27990 = cljs.core.seq.call(null,files);
var inst_27991 = cljs.core.first.call(null,inst_27990);
var inst_27992 = cljs.core.next.call(null,inst_27990);
var inst_27993 = files;
var state_28016__$1 = (function (){var statearr_28021 = state_28016;
(statearr_28021[(7)] = inst_27991);

(statearr_28021[(8)] = inst_27993);

(statearr_28021[(9)] = inst_27992);

return statearr_28021;
})();
var statearr_28022_28041 = state_28016__$1;
(statearr_28022_28041[(2)] = null);

(statearr_28022_28041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28017 === (2))){
var inst_27993 = (state_28016[(8)]);
var inst_27999 = (state_28016[(10)]);
var inst_27998 = cljs.core.seq.call(null,inst_27993);
var inst_27999__$1 = cljs.core.first.call(null,inst_27998);
var inst_28000 = cljs.core.next.call(null,inst_27998);
var inst_28001 = (inst_27999__$1 == null);
var inst_28002 = cljs.core.not.call(null,inst_28001);
var state_28016__$1 = (function (){var statearr_28024 = state_28016;
(statearr_28024[(11)] = inst_28000);

(statearr_28024[(10)] = inst_27999__$1);

return statearr_28024;
})();
if(inst_28002){
var statearr_28025_28042 = state_28016__$1;
(statearr_28025_28042[(1)] = (4));

} else {
var statearr_28026_28043 = state_28016__$1;
(statearr_28026_28043[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28017 === (3))){
var inst_28014 = (state_28016[(2)]);
var state_28016__$1 = state_28016;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28016__$1,inst_28014);
} else {
if((state_val_28017 === (4))){
var inst_27999 = (state_28016[(10)]);
var inst_28004 = figwheel.client.file_reloading.reload_js_file.call(null,inst_27999);
var state_28016__$1 = state_28016;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28016__$1,(7),inst_28004);
} else {
if((state_val_28017 === (5))){
var inst_28010 = cljs.core.async.close_BANG_.call(null,out);
var state_28016__$1 = state_28016;
var statearr_28027_28044 = state_28016__$1;
(statearr_28027_28044[(2)] = inst_28010);

(statearr_28027_28044[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28017 === (6))){
var inst_28012 = (state_28016[(2)]);
var state_28016__$1 = state_28016;
var statearr_28028_28045 = state_28016__$1;
(statearr_28028_28045[(2)] = inst_28012);

(statearr_28028_28045[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28017 === (7))){
var inst_28000 = (state_28016[(11)]);
var inst_28006 = (state_28016[(2)]);
var inst_28007 = cljs.core.async.put_BANG_.call(null,out,inst_28006);
var inst_27993 = inst_28000;
var state_28016__$1 = (function (){var statearr_28029 = state_28016;
(statearr_28029[(12)] = inst_28007);

(statearr_28029[(8)] = inst_27993);

return statearr_28029;
})();
var statearr_28030_28046 = state_28016__$1;
(statearr_28030_28046[(2)] = null);

(statearr_28030_28046[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__23309__auto___28038,out))
;
return ((function (switch__23144__auto__,c__23309__auto___28038,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__23145__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__23145__auto____0 = (function (){
var statearr_28031 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28031[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__23145__auto__);

(statearr_28031[(1)] = (1));

return statearr_28031;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__23145__auto____1 = (function (state_28016){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_28016);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e28032){if((e28032 instanceof Object)){
var ex__23148__auto__ = e28032;
var statearr_28033_28067 = state_28016;
(statearr_28033_28067[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28016);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28032;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28072 = state_28016;
state_28016 = G__28072;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__23145__auto__ = function(state_28016){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__23145__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__23145__auto____1.call(this,state_28016);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__23145__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__23145__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto___28038,out))
})();
var state__23311__auto__ = (function (){var statearr_28034 = f__23310__auto__.call(null);
(statearr_28034[(6)] = c__23309__auto___28038);

return statearr_28034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto___28038,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__28077,opts){
var map__28078 = p__28077;
var map__28078__$1 = ((((!((map__28078 == null)))?(((((map__28078.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28078.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28078):map__28078);
var eval_body = cljs.core.get.call(null,map__28078__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__28078__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__3911__auto__ = eval_body;
if(cljs.core.truth_(and__3911__auto__)){
return typeof eval_body === 'string';
} else {
return and__3911__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e28080){var e = e28080;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__5455__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__28086_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__28086_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__5455__auto__)){
var file_msg = temp__5455__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__28102){
var vec__28103 = p__28102;
var k = cljs.core.nth.call(null,vec__28103,(0),null);
var v = cljs.core.nth.call(null,vec__28103,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__28106){
var vec__28107 = p__28106;
var k = cljs.core.nth.call(null,vec__28107,(0),null);
var v = cljs.core.nth.call(null,vec__28107,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__28137,p__28138){
var map__28139 = p__28137;
var map__28139__$1 = ((((!((map__28139 == null)))?(((((map__28139.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28139.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28139):map__28139);
var opts = map__28139__$1;
var before_jsload = cljs.core.get.call(null,map__28139__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__28139__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__28139__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__28140 = p__28138;
var map__28140__$1 = ((((!((map__28140 == null)))?(((((map__28140.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28140.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28140):map__28140);
var msg = map__28140__$1;
var files = cljs.core.get.call(null,map__28140__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__28140__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__28140__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__23309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_28320){
var state_val_28321 = (state_28320[(1)]);
if((state_val_28321 === (7))){
var inst_28176 = (state_28320[(7)]);
var inst_28175 = (state_28320[(8)]);
var inst_28173 = (state_28320[(9)]);
var inst_28174 = (state_28320[(10)]);
var inst_28181 = cljs.core._nth.call(null,inst_28174,inst_28176);
var inst_28182 = figwheel.client.file_reloading.eval_body.call(null,inst_28181,opts);
var inst_28183 = (inst_28176 + (1));
var tmp28322 = inst_28175;
var tmp28323 = inst_28173;
var tmp28324 = inst_28174;
var inst_28173__$1 = tmp28323;
var inst_28174__$1 = tmp28324;
var inst_28175__$1 = tmp28322;
var inst_28176__$1 = inst_28183;
var state_28320__$1 = (function (){var statearr_28336 = state_28320;
(statearr_28336[(7)] = inst_28176__$1);

(statearr_28336[(8)] = inst_28175__$1);

(statearr_28336[(9)] = inst_28173__$1);

(statearr_28336[(10)] = inst_28174__$1);

(statearr_28336[(11)] = inst_28182);

return statearr_28336;
})();
var statearr_28337_28457 = state_28320__$1;
(statearr_28337_28457[(2)] = null);

(statearr_28337_28457[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (20))){
var inst_28221 = (state_28320[(12)]);
var inst_28230 = figwheel.client.file_reloading.sort_files.call(null,inst_28221);
var state_28320__$1 = state_28320;
var statearr_28338_28458 = state_28320__$1;
(statearr_28338_28458[(2)] = inst_28230);

(statearr_28338_28458[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (27))){
var state_28320__$1 = state_28320;
var statearr_28339_28459 = state_28320__$1;
(statearr_28339_28459[(2)] = null);

(statearr_28339_28459[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (1))){
var inst_28160 = (state_28320[(13)]);
var inst_28157 = before_jsload.call(null,files);
var inst_28158 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_28159 = (function (){return ((function (inst_28160,inst_28157,inst_28158,state_val_28321,c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__28131_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__28131_SHARP_);
});
;})(inst_28160,inst_28157,inst_28158,state_val_28321,c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28160__$1 = cljs.core.filter.call(null,inst_28159,files);
var inst_28162 = cljs.core.not_empty.call(null,inst_28160__$1);
var state_28320__$1 = (function (){var statearr_28346 = state_28320;
(statearr_28346[(14)] = inst_28157);

(statearr_28346[(15)] = inst_28158);

(statearr_28346[(13)] = inst_28160__$1);

return statearr_28346;
})();
if(cljs.core.truth_(inst_28162)){
var statearr_28348_28460 = state_28320__$1;
(statearr_28348_28460[(1)] = (2));

} else {
var statearr_28353_28461 = state_28320__$1;
(statearr_28353_28461[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (24))){
var state_28320__$1 = state_28320;
var statearr_28354_28462 = state_28320__$1;
(statearr_28354_28462[(2)] = null);

(statearr_28354_28462[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (39))){
var inst_28272 = (state_28320[(16)]);
var state_28320__$1 = state_28320;
var statearr_28361_28463 = state_28320__$1;
(statearr_28361_28463[(2)] = inst_28272);

(statearr_28361_28463[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (46))){
var inst_28315 = (state_28320[(2)]);
var state_28320__$1 = state_28320;
var statearr_28362_28464 = state_28320__$1;
(statearr_28362_28464[(2)] = inst_28315);

(statearr_28362_28464[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (4))){
var inst_28215 = (state_28320[(2)]);
var inst_28216 = cljs.core.List.EMPTY;
var inst_28217 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_28216);
var inst_28218 = (function (){return ((function (inst_28215,inst_28216,inst_28217,state_val_28321,c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__28132_SHARP_){
var and__3911__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__28132_SHARP_);
if(cljs.core.truth_(and__3911__auto__)){
return ((cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__28132_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__28132_SHARP_))));
} else {
return and__3911__auto__;
}
});
;})(inst_28215,inst_28216,inst_28217,state_val_28321,c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28219 = cljs.core.filter.call(null,inst_28218,files);
var inst_28220 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_28221 = cljs.core.concat.call(null,inst_28219,inst_28220);
var state_28320__$1 = (function (){var statearr_28363 = state_28320;
(statearr_28363[(17)] = inst_28217);

(statearr_28363[(12)] = inst_28221);

(statearr_28363[(18)] = inst_28215);

return statearr_28363;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_28368_28465 = state_28320__$1;
(statearr_28368_28465[(1)] = (16));

} else {
var statearr_28369_28466 = state_28320__$1;
(statearr_28369_28466[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (15))){
var inst_28205 = (state_28320[(2)]);
var state_28320__$1 = state_28320;
var statearr_28370_28467 = state_28320__$1;
(statearr_28370_28467[(2)] = inst_28205);

(statearr_28370_28467[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (21))){
var inst_28232 = (state_28320[(19)]);
var inst_28232__$1 = (state_28320[(2)]);
var inst_28233 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_28232__$1);
var state_28320__$1 = (function (){var statearr_28371 = state_28320;
(statearr_28371[(19)] = inst_28232__$1);

return statearr_28371;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28320__$1,(22),inst_28233);
} else {
if((state_val_28321 === (31))){
var inst_28318 = (state_28320[(2)]);
var state_28320__$1 = state_28320;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28320__$1,inst_28318);
} else {
if((state_val_28321 === (32))){
var inst_28272 = (state_28320[(16)]);
var inst_28278 = inst_28272.cljs$lang$protocol_mask$partition0$;
var inst_28279 = (inst_28278 & (64));
var inst_28280 = inst_28272.cljs$core$ISeq$;
var inst_28281 = (cljs.core.PROTOCOL_SENTINEL === inst_28280);
var inst_28282 = ((inst_28279) || (inst_28281));
var state_28320__$1 = state_28320;
if(cljs.core.truth_(inst_28282)){
var statearr_28372_28468 = state_28320__$1;
(statearr_28372_28468[(1)] = (35));

} else {
var statearr_28373_28469 = state_28320__$1;
(statearr_28373_28469[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (40))){
var inst_28295 = (state_28320[(20)]);
var inst_28294 = (state_28320[(2)]);
var inst_28295__$1 = cljs.core.get.call(null,inst_28294,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_28296 = cljs.core.get.call(null,inst_28294,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_28297 = cljs.core.not_empty.call(null,inst_28295__$1);
var state_28320__$1 = (function (){var statearr_28376 = state_28320;
(statearr_28376[(21)] = inst_28296);

(statearr_28376[(20)] = inst_28295__$1);

return statearr_28376;
})();
if(cljs.core.truth_(inst_28297)){
var statearr_28377_28470 = state_28320__$1;
(statearr_28377_28470[(1)] = (41));

} else {
var statearr_28378_28471 = state_28320__$1;
(statearr_28378_28471[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (33))){
var state_28320__$1 = state_28320;
var statearr_28383_28472 = state_28320__$1;
(statearr_28383_28472[(2)] = false);

(statearr_28383_28472[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (13))){
var inst_28186 = (state_28320[(22)]);
var inst_28191 = cljs.core.chunk_first.call(null,inst_28186);
var inst_28192 = cljs.core.chunk_rest.call(null,inst_28186);
var inst_28193 = cljs.core.count.call(null,inst_28191);
var inst_28173 = inst_28192;
var inst_28174 = inst_28191;
var inst_28175 = inst_28193;
var inst_28176 = (0);
var state_28320__$1 = (function (){var statearr_28384 = state_28320;
(statearr_28384[(7)] = inst_28176);

(statearr_28384[(8)] = inst_28175);

(statearr_28384[(9)] = inst_28173);

(statearr_28384[(10)] = inst_28174);

return statearr_28384;
})();
var statearr_28389_28473 = state_28320__$1;
(statearr_28389_28473[(2)] = null);

(statearr_28389_28473[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (22))){
var inst_28240 = (state_28320[(23)]);
var inst_28235 = (state_28320[(24)]);
var inst_28232 = (state_28320[(19)]);
var inst_28236 = (state_28320[(25)]);
var inst_28235__$1 = (state_28320[(2)]);
var inst_28236__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_28235__$1);
var inst_28237 = (function (){var all_files = inst_28232;
var res_SINGLEQUOTE_ = inst_28235__$1;
var res = inst_28236__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_28240,inst_28235,inst_28232,inst_28236,inst_28235__$1,inst_28236__$1,state_val_28321,c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__28133_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__28133_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_28240,inst_28235,inst_28232,inst_28236,inst_28235__$1,inst_28236__$1,state_val_28321,c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28238 = cljs.core.filter.call(null,inst_28237,inst_28235__$1);
var inst_28239 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_28240__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_28239);
var inst_28241 = cljs.core.not_empty.call(null,inst_28240__$1);
var state_28320__$1 = (function (){var statearr_28396 = state_28320;
(statearr_28396[(26)] = inst_28238);

(statearr_28396[(23)] = inst_28240__$1);

(statearr_28396[(24)] = inst_28235__$1);

(statearr_28396[(25)] = inst_28236__$1);

return statearr_28396;
})();
if(cljs.core.truth_(inst_28241)){
var statearr_28397_28474 = state_28320__$1;
(statearr_28397_28474[(1)] = (23));

} else {
var statearr_28398_28475 = state_28320__$1;
(statearr_28398_28475[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (36))){
var state_28320__$1 = state_28320;
var statearr_28399_28476 = state_28320__$1;
(statearr_28399_28476[(2)] = false);

(statearr_28399_28476[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (41))){
var inst_28295 = (state_28320[(20)]);
var inst_28299 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_28300 = cljs.core.map.call(null,inst_28299,inst_28295);
var inst_28301 = cljs.core.pr_str.call(null,inst_28300);
var inst_28302 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28301)].join('');
var inst_28303 = figwheel.client.utils.log.call(null,inst_28302);
var state_28320__$1 = state_28320;
var statearr_28400_28477 = state_28320__$1;
(statearr_28400_28477[(2)] = inst_28303);

(statearr_28400_28477[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (43))){
var inst_28296 = (state_28320[(21)]);
var inst_28306 = (state_28320[(2)]);
var inst_28307 = cljs.core.not_empty.call(null,inst_28296);
var state_28320__$1 = (function (){var statearr_28401 = state_28320;
(statearr_28401[(27)] = inst_28306);

return statearr_28401;
})();
if(cljs.core.truth_(inst_28307)){
var statearr_28402_28478 = state_28320__$1;
(statearr_28402_28478[(1)] = (44));

} else {
var statearr_28403_28479 = state_28320__$1;
(statearr_28403_28479[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (29))){
var inst_28238 = (state_28320[(26)]);
var inst_28272 = (state_28320[(16)]);
var inst_28240 = (state_28320[(23)]);
var inst_28235 = (state_28320[(24)]);
var inst_28232 = (state_28320[(19)]);
var inst_28236 = (state_28320[(25)]);
var inst_28268 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_28271 = (function (){var all_files = inst_28232;
var res_SINGLEQUOTE_ = inst_28235;
var res = inst_28236;
var files_not_loaded = inst_28238;
var dependencies_that_loaded = inst_28240;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28238,inst_28272,inst_28240,inst_28235,inst_28232,inst_28236,inst_28268,state_val_28321,c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__28270){
var map__28404 = p__28270;
var map__28404__$1 = ((((!((map__28404 == null)))?(((((map__28404.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28404.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28404):map__28404);
var namespace = cljs.core.get.call(null,map__28404__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28238,inst_28272,inst_28240,inst_28235,inst_28232,inst_28236,inst_28268,state_val_28321,c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28272__$1 = cljs.core.group_by.call(null,inst_28271,inst_28238);
var inst_28274 = (inst_28272__$1 == null);
var inst_28275 = cljs.core.not.call(null,inst_28274);
var state_28320__$1 = (function (){var statearr_28406 = state_28320;
(statearr_28406[(28)] = inst_28268);

(statearr_28406[(16)] = inst_28272__$1);

return statearr_28406;
})();
if(inst_28275){
var statearr_28407_28480 = state_28320__$1;
(statearr_28407_28480[(1)] = (32));

} else {
var statearr_28408_28481 = state_28320__$1;
(statearr_28408_28481[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (44))){
var inst_28296 = (state_28320[(21)]);
var inst_28309 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_28296);
var inst_28310 = cljs.core.pr_str.call(null,inst_28309);
var inst_28311 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28310)].join('');
var inst_28312 = figwheel.client.utils.log.call(null,inst_28311);
var state_28320__$1 = state_28320;
var statearr_28409_28482 = state_28320__$1;
(statearr_28409_28482[(2)] = inst_28312);

(statearr_28409_28482[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (6))){
var inst_28212 = (state_28320[(2)]);
var state_28320__$1 = state_28320;
var statearr_28410_28483 = state_28320__$1;
(statearr_28410_28483[(2)] = inst_28212);

(statearr_28410_28483[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (28))){
var inst_28238 = (state_28320[(26)]);
var inst_28265 = (state_28320[(2)]);
var inst_28266 = cljs.core.not_empty.call(null,inst_28238);
var state_28320__$1 = (function (){var statearr_28411 = state_28320;
(statearr_28411[(29)] = inst_28265);

return statearr_28411;
})();
if(cljs.core.truth_(inst_28266)){
var statearr_28412_28484 = state_28320__$1;
(statearr_28412_28484[(1)] = (29));

} else {
var statearr_28413_28485 = state_28320__$1;
(statearr_28413_28485[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (25))){
var inst_28236 = (state_28320[(25)]);
var inst_28252 = (state_28320[(2)]);
var inst_28253 = cljs.core.not_empty.call(null,inst_28236);
var state_28320__$1 = (function (){var statearr_28414 = state_28320;
(statearr_28414[(30)] = inst_28252);

return statearr_28414;
})();
if(cljs.core.truth_(inst_28253)){
var statearr_28415_28486 = state_28320__$1;
(statearr_28415_28486[(1)] = (26));

} else {
var statearr_28416_28487 = state_28320__$1;
(statearr_28416_28487[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (34))){
var inst_28289 = (state_28320[(2)]);
var state_28320__$1 = state_28320;
if(cljs.core.truth_(inst_28289)){
var statearr_28417_28488 = state_28320__$1;
(statearr_28417_28488[(1)] = (38));

} else {
var statearr_28418_28489 = state_28320__$1;
(statearr_28418_28489[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (17))){
var state_28320__$1 = state_28320;
var statearr_28419_28490 = state_28320__$1;
(statearr_28419_28490[(2)] = recompile_dependents);

(statearr_28419_28490[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (3))){
var state_28320__$1 = state_28320;
var statearr_28420_28491 = state_28320__$1;
(statearr_28420_28491[(2)] = null);

(statearr_28420_28491[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (12))){
var inst_28208 = (state_28320[(2)]);
var state_28320__$1 = state_28320;
var statearr_28421_28492 = state_28320__$1;
(statearr_28421_28492[(2)] = inst_28208);

(statearr_28421_28492[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (2))){
var inst_28160 = (state_28320[(13)]);
var inst_28172 = cljs.core.seq.call(null,inst_28160);
var inst_28173 = inst_28172;
var inst_28174 = null;
var inst_28175 = (0);
var inst_28176 = (0);
var state_28320__$1 = (function (){var statearr_28422 = state_28320;
(statearr_28422[(7)] = inst_28176);

(statearr_28422[(8)] = inst_28175);

(statearr_28422[(9)] = inst_28173);

(statearr_28422[(10)] = inst_28174);

return statearr_28422;
})();
var statearr_28423_28493 = state_28320__$1;
(statearr_28423_28493[(2)] = null);

(statearr_28423_28493[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (23))){
var inst_28238 = (state_28320[(26)]);
var inst_28240 = (state_28320[(23)]);
var inst_28235 = (state_28320[(24)]);
var inst_28232 = (state_28320[(19)]);
var inst_28236 = (state_28320[(25)]);
var inst_28243 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_28245 = (function (){var all_files = inst_28232;
var res_SINGLEQUOTE_ = inst_28235;
var res = inst_28236;
var files_not_loaded = inst_28238;
var dependencies_that_loaded = inst_28240;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28238,inst_28240,inst_28235,inst_28232,inst_28236,inst_28243,state_val_28321,c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__28244){
var map__28424 = p__28244;
var map__28424__$1 = ((((!((map__28424 == null)))?(((((map__28424.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28424.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28424):map__28424);
var request_url = cljs.core.get.call(null,map__28424__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28238,inst_28240,inst_28235,inst_28232,inst_28236,inst_28243,state_val_28321,c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28246 = cljs.core.reverse.call(null,inst_28240);
var inst_28247 = cljs.core.map.call(null,inst_28245,inst_28246);
var inst_28248 = cljs.core.pr_str.call(null,inst_28247);
var inst_28249 = figwheel.client.utils.log.call(null,inst_28248);
var state_28320__$1 = (function (){var statearr_28426 = state_28320;
(statearr_28426[(31)] = inst_28243);

return statearr_28426;
})();
var statearr_28427_28494 = state_28320__$1;
(statearr_28427_28494[(2)] = inst_28249);

(statearr_28427_28494[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (35))){
var state_28320__$1 = state_28320;
var statearr_28428_28495 = state_28320__$1;
(statearr_28428_28495[(2)] = true);

(statearr_28428_28495[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (19))){
var inst_28221 = (state_28320[(12)]);
var inst_28228 = figwheel.client.file_reloading.expand_files.call(null,inst_28221);
var state_28320__$1 = state_28320;
var statearr_28429_28496 = state_28320__$1;
(statearr_28429_28496[(2)] = inst_28228);

(statearr_28429_28496[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (11))){
var state_28320__$1 = state_28320;
var statearr_28430_28497 = state_28320__$1;
(statearr_28430_28497[(2)] = null);

(statearr_28430_28497[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (9))){
var inst_28210 = (state_28320[(2)]);
var state_28320__$1 = state_28320;
var statearr_28431_28498 = state_28320__$1;
(statearr_28431_28498[(2)] = inst_28210);

(statearr_28431_28498[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (5))){
var inst_28176 = (state_28320[(7)]);
var inst_28175 = (state_28320[(8)]);
var inst_28178 = (inst_28176 < inst_28175);
var inst_28179 = inst_28178;
var state_28320__$1 = state_28320;
if(cljs.core.truth_(inst_28179)){
var statearr_28432_28499 = state_28320__$1;
(statearr_28432_28499[(1)] = (7));

} else {
var statearr_28433_28500 = state_28320__$1;
(statearr_28433_28500[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (14))){
var inst_28186 = (state_28320[(22)]);
var inst_28200 = cljs.core.first.call(null,inst_28186);
var inst_28201 = figwheel.client.file_reloading.eval_body.call(null,inst_28200,opts);
var inst_28202 = cljs.core.next.call(null,inst_28186);
var inst_28173 = inst_28202;
var inst_28174 = null;
var inst_28175 = (0);
var inst_28176 = (0);
var state_28320__$1 = (function (){var statearr_28434 = state_28320;
(statearr_28434[(7)] = inst_28176);

(statearr_28434[(8)] = inst_28175);

(statearr_28434[(9)] = inst_28173);

(statearr_28434[(10)] = inst_28174);

(statearr_28434[(32)] = inst_28201);

return statearr_28434;
})();
var statearr_28435_28501 = state_28320__$1;
(statearr_28435_28501[(2)] = null);

(statearr_28435_28501[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (45))){
var state_28320__$1 = state_28320;
var statearr_28436_28502 = state_28320__$1;
(statearr_28436_28502[(2)] = null);

(statearr_28436_28502[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (26))){
var inst_28238 = (state_28320[(26)]);
var inst_28240 = (state_28320[(23)]);
var inst_28235 = (state_28320[(24)]);
var inst_28232 = (state_28320[(19)]);
var inst_28236 = (state_28320[(25)]);
var inst_28255 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_28257 = (function (){var all_files = inst_28232;
var res_SINGLEQUOTE_ = inst_28235;
var res = inst_28236;
var files_not_loaded = inst_28238;
var dependencies_that_loaded = inst_28240;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28238,inst_28240,inst_28235,inst_28232,inst_28236,inst_28255,state_val_28321,c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__28256){
var map__28437 = p__28256;
var map__28437__$1 = ((((!((map__28437 == null)))?(((((map__28437.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28437.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28437):map__28437);
var namespace = cljs.core.get.call(null,map__28437__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__28437__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28238,inst_28240,inst_28235,inst_28232,inst_28236,inst_28255,state_val_28321,c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28258 = cljs.core.map.call(null,inst_28257,inst_28236);
var inst_28259 = cljs.core.pr_str.call(null,inst_28258);
var inst_28260 = figwheel.client.utils.log.call(null,inst_28259);
var inst_28261 = (function (){var all_files = inst_28232;
var res_SINGLEQUOTE_ = inst_28235;
var res = inst_28236;
var files_not_loaded = inst_28238;
var dependencies_that_loaded = inst_28240;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28238,inst_28240,inst_28235,inst_28232,inst_28236,inst_28255,inst_28257,inst_28258,inst_28259,inst_28260,state_val_28321,c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28238,inst_28240,inst_28235,inst_28232,inst_28236,inst_28255,inst_28257,inst_28258,inst_28259,inst_28260,state_val_28321,c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28262 = setTimeout(inst_28261,(10));
var state_28320__$1 = (function (){var statearr_28439 = state_28320;
(statearr_28439[(33)] = inst_28260);

(statearr_28439[(34)] = inst_28255);

return statearr_28439;
})();
var statearr_28440_28503 = state_28320__$1;
(statearr_28440_28503[(2)] = inst_28262);

(statearr_28440_28503[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (16))){
var state_28320__$1 = state_28320;
var statearr_28441_28504 = state_28320__$1;
(statearr_28441_28504[(2)] = reload_dependents);

(statearr_28441_28504[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (38))){
var inst_28272 = (state_28320[(16)]);
var inst_28291 = cljs.core.apply.call(null,cljs.core.hash_map,inst_28272);
var state_28320__$1 = state_28320;
var statearr_28442_28505 = state_28320__$1;
(statearr_28442_28505[(2)] = inst_28291);

(statearr_28442_28505[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (30))){
var state_28320__$1 = state_28320;
var statearr_28443_28506 = state_28320__$1;
(statearr_28443_28506[(2)] = null);

(statearr_28443_28506[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (10))){
var inst_28186 = (state_28320[(22)]);
var inst_28189 = cljs.core.chunked_seq_QMARK_.call(null,inst_28186);
var state_28320__$1 = state_28320;
if(inst_28189){
var statearr_28444_28507 = state_28320__$1;
(statearr_28444_28507[(1)] = (13));

} else {
var statearr_28445_28508 = state_28320__$1;
(statearr_28445_28508[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (18))){
var inst_28225 = (state_28320[(2)]);
var state_28320__$1 = state_28320;
if(cljs.core.truth_(inst_28225)){
var statearr_28446_28509 = state_28320__$1;
(statearr_28446_28509[(1)] = (19));

} else {
var statearr_28447_28510 = state_28320__$1;
(statearr_28447_28510[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (42))){
var state_28320__$1 = state_28320;
var statearr_28448_28511 = state_28320__$1;
(statearr_28448_28511[(2)] = null);

(statearr_28448_28511[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (37))){
var inst_28286 = (state_28320[(2)]);
var state_28320__$1 = state_28320;
var statearr_28449_28512 = state_28320__$1;
(statearr_28449_28512[(2)] = inst_28286);

(statearr_28449_28512[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (8))){
var inst_28186 = (state_28320[(22)]);
var inst_28173 = (state_28320[(9)]);
var inst_28186__$1 = cljs.core.seq.call(null,inst_28173);
var state_28320__$1 = (function (){var statearr_28450 = state_28320;
(statearr_28450[(22)] = inst_28186__$1);

return statearr_28450;
})();
if(inst_28186__$1){
var statearr_28451_28513 = state_28320__$1;
(statearr_28451_28513[(1)] = (10));

} else {
var statearr_28452_28514 = state_28320__$1;
(statearr_28452_28514[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__23144__auto__,c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__23145__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__23145__auto____0 = (function (){
var statearr_28453 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28453[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__23145__auto__);

(statearr_28453[(1)] = (1));

return statearr_28453;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__23145__auto____1 = (function (state_28320){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_28320);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e28454){if((e28454 instanceof Object)){
var ex__23148__auto__ = e28454;
var statearr_28455_28515 = state_28320;
(statearr_28455_28515[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28320);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28454;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28516 = state_28320;
state_28320 = G__28516;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__23145__auto__ = function(state_28320){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__23145__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__23145__auto____1.call(this,state_28320);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__23145__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__23145__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__23311__auto__ = (function (){var statearr_28456 = f__23310__auto__.call(null);
(statearr_28456[(6)] = c__23309__auto__);

return statearr_28456;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto__,map__28139,map__28139__$1,opts,before_jsload,on_jsload,reload_dependents,map__28140,map__28140__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__23309__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__28519,link){
var map__28520 = p__28519;
var map__28520__$1 = ((((!((map__28520 == null)))?(((((map__28520.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28520.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28520):map__28520);
var file = cljs.core.get.call(null,map__28520__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__5457__auto__ = link.href;
if(cljs.core.truth_(temp__5457__auto__)){
var link_href = temp__5457__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__5457__auto__,map__28520,map__28520__$1,file){
return (function (p1__28517_SHARP_,p2__28518_SHARP_){
if(cljs.core._EQ_.call(null,p1__28517_SHARP_,p2__28518_SHARP_)){
return p1__28517_SHARP_;
} else {
return false;
}
});})(link_href,temp__5457__auto__,map__28520,map__28520__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__5457__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__28523){
var map__28524 = p__28523;
var map__28524__$1 = ((((!((map__28524 == null)))?(((((map__28524.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28524.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28524):map__28524);
var match_length = cljs.core.get.call(null,map__28524__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__28524__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__28522_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__28522_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__5457__auto__)){
var res = temp__5457__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__28526_SHARP_,p2__28527_SHARP_){
return cljs.core.assoc.call(null,p1__28526_SHARP_,cljs.core.get.call(null,p2__28527_SHARP_,key),p2__28527_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__5455__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__5455__auto__)){
var link = temp__5455__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__5455__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__5455__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_28528 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_28528);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_28528);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__28529,p__28530){
var map__28531 = p__28529;
var map__28531__$1 = ((((!((map__28531 == null)))?(((((map__28531.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28531.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28531):map__28531);
var on_cssload = cljs.core.get.call(null,map__28531__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__28532 = p__28530;
var map__28532__$1 = ((((!((map__28532 == null)))?(((((map__28532.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28532.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28532):map__28532);
var files_msg = map__28532__$1;
var files = cljs.core.get.call(null,map__28532__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__5457__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__5457__auto__)){
var f_datas = temp__5457__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1529759828780
