// Compiled by ClojureScript 1.10.238 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__23380 = arguments.length;
switch (G__23380) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async23384 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23384 = (function (f,blockable,meta23385){
this.f = f;
this.blockable = blockable;
this.meta23385 = meta23385;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async23384.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23386,meta23385__$1){
var self__ = this;
var _23386__$1 = this;
return (new cljs.core.async.t_cljs$core$async23384(self__.f,self__.blockable,meta23385__$1));
});

cljs.core.async.t_cljs$core$async23384.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23386){
var self__ = this;
var _23386__$1 = this;
return self__.meta23385;
});

cljs.core.async.t_cljs$core$async23384.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23384.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async23384.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async23384.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async23384.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta23385","meta23385",-155353470,null)], null);
});

cljs.core.async.t_cljs$core$async23384.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23384.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23384";

cljs.core.async.t_cljs$core$async23384.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async23384");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23384.
 */
cljs.core.async.__GT_t_cljs$core$async23384 = (function cljs$core$async$__GT_t_cljs$core$async23384(f__$1,blockable__$1,meta23385){
return (new cljs.core.async.t_cljs$core$async23384(f__$1,blockable__$1,meta23385));
});

}

return (new cljs.core.async.t_cljs$core$async23384(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__23401 = arguments.length;
switch (G__23401) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__23417 = arguments.length;
switch (G__23417) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__23428 = arguments.length;
switch (G__23428) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_23438 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_23438);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_23438,ret){
return (function (){
return fn1.call(null,val_23438);
});})(val_23438,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__23449 = arguments.length;
switch (G__23449) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5455__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4376__auto___23476 = n;
var x_23477 = (0);
while(true){
if((x_23477 < n__4376__auto___23476)){
(a[x_23477] = (0));

var G__23478 = (x_23477 + (1));
x_23477 = G__23478;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__23484 = (i + (1));
i = G__23484;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async23485 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23485 = (function (flag,meta23486){
this.flag = flag;
this.meta23486 = meta23486;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async23485.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_23487,meta23486__$1){
var self__ = this;
var _23487__$1 = this;
return (new cljs.core.async.t_cljs$core$async23485(self__.flag,meta23486__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async23485.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_23487){
var self__ = this;
var _23487__$1 = this;
return self__.meta23486;
});})(flag))
;

cljs.core.async.t_cljs$core$async23485.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23485.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async23485.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async23485.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async23485.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta23486","meta23486",1079854477,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async23485.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23485.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23485";

cljs.core.async.t_cljs$core$async23485.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async23485");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23485.
 */
cljs.core.async.__GT_t_cljs$core$async23485 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async23485(flag__$1,meta23486){
return (new cljs.core.async.t_cljs$core$async23485(flag__$1,meta23486));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async23485(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async23526 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23526 = (function (flag,cb,meta23527){
this.flag = flag;
this.cb = cb;
this.meta23527 = meta23527;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async23526.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23528,meta23527__$1){
var self__ = this;
var _23528__$1 = this;
return (new cljs.core.async.t_cljs$core$async23526(self__.flag,self__.cb,meta23527__$1));
});

cljs.core.async.t_cljs$core$async23526.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23528){
var self__ = this;
var _23528__$1 = this;
return self__.meta23527;
});

cljs.core.async.t_cljs$core$async23526.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23526.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async23526.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async23526.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async23526.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta23527","meta23527",-1086211707,null)], null);
});

cljs.core.async.t_cljs$core$async23526.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23526.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23526";

cljs.core.async.t_cljs$core$async23526.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async23526");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23526.
 */
cljs.core.async.__GT_t_cljs$core$async23526 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async23526(flag__$1,cb__$1,meta23527){
return (new cljs.core.async.t_cljs$core$async23526(flag__$1,cb__$1,meta23527));
});

}

return (new cljs.core.async.t_cljs$core$async23526(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__23552_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__23552_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__23553_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__23553_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__3922__auto__ = wport;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return port;
}
})()], null));
} else {
var G__23561 = (i + (1));
i = G__23561;
continue;
}
} else {
return null;
}
break;
}
})();
var or__3922__auto__ = ret;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__3911__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__3911__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__3911__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4502__auto__ = [];
var len__4499__auto___23572 = arguments.length;
var i__4500__auto___23573 = (0);
while(true){
if((i__4500__auto___23573 < len__4499__auto___23572)){
args__4502__auto__.push((arguments[i__4500__auto___23573]));

var G__23574 = (i__4500__auto___23573 + (1));
i__4500__auto___23573 = G__23574;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((1) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4503__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__23567){
var map__23568 = p__23567;
var map__23568__$1 = ((((!((map__23568 == null)))?(((((map__23568.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23568.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23568):map__23568);
var opts = map__23568__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq23563){
var G__23564 = cljs.core.first.call(null,seq23563);
var seq23563__$1 = cljs.core.next.call(null,seq23563);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__23564,seq23563__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__23590 = arguments.length;
switch (G__23590) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__23309__auto___23716 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto___23716){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto___23716){
return (function (state_23673){
var state_val_23675 = (state_23673[(1)]);
if((state_val_23675 === (7))){
var inst_23662 = (state_23673[(2)]);
var state_23673__$1 = state_23673;
var statearr_23679_23717 = state_23673__$1;
(statearr_23679_23717[(2)] = inst_23662);

(statearr_23679_23717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (1))){
var state_23673__$1 = state_23673;
var statearr_23680_23718 = state_23673__$1;
(statearr_23680_23718[(2)] = null);

(statearr_23680_23718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (4))){
var inst_23629 = (state_23673[(7)]);
var inst_23629__$1 = (state_23673[(2)]);
var inst_23636 = (inst_23629__$1 == null);
var state_23673__$1 = (function (){var statearr_23682 = state_23673;
(statearr_23682[(7)] = inst_23629__$1);

return statearr_23682;
})();
if(cljs.core.truth_(inst_23636)){
var statearr_23683_23719 = state_23673__$1;
(statearr_23683_23719[(1)] = (5));

} else {
var statearr_23684_23720 = state_23673__$1;
(statearr_23684_23720[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (13))){
var state_23673__$1 = state_23673;
var statearr_23685_23721 = state_23673__$1;
(statearr_23685_23721[(2)] = null);

(statearr_23685_23721[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (6))){
var inst_23629 = (state_23673[(7)]);
var state_23673__$1 = state_23673;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23673__$1,(11),to,inst_23629);
} else {
if((state_val_23675 === (3))){
var inst_23664 = (state_23673[(2)]);
var state_23673__$1 = state_23673;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23673__$1,inst_23664);
} else {
if((state_val_23675 === (12))){
var state_23673__$1 = state_23673;
var statearr_23691_23723 = state_23673__$1;
(statearr_23691_23723[(2)] = null);

(statearr_23691_23723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (2))){
var state_23673__$1 = state_23673;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23673__$1,(4),from);
} else {
if((state_val_23675 === (11))){
var inst_23649 = (state_23673[(2)]);
var state_23673__$1 = state_23673;
if(cljs.core.truth_(inst_23649)){
var statearr_23692_23724 = state_23673__$1;
(statearr_23692_23724[(1)] = (12));

} else {
var statearr_23696_23725 = state_23673__$1;
(statearr_23696_23725[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (9))){
var state_23673__$1 = state_23673;
var statearr_23697_23727 = state_23673__$1;
(statearr_23697_23727[(2)] = null);

(statearr_23697_23727[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (5))){
var state_23673__$1 = state_23673;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23701_23728 = state_23673__$1;
(statearr_23701_23728[(1)] = (8));

} else {
var statearr_23702_23729 = state_23673__$1;
(statearr_23702_23729[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (14))){
var inst_23660 = (state_23673[(2)]);
var state_23673__$1 = state_23673;
var statearr_23703_23730 = state_23673__$1;
(statearr_23703_23730[(2)] = inst_23660);

(statearr_23703_23730[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (10))){
var inst_23646 = (state_23673[(2)]);
var state_23673__$1 = state_23673;
var statearr_23704_23731 = state_23673__$1;
(statearr_23704_23731[(2)] = inst_23646);

(statearr_23704_23731[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (8))){
var inst_23643 = cljs.core.async.close_BANG_.call(null,to);
var state_23673__$1 = state_23673;
var statearr_23707_23733 = state_23673__$1;
(statearr_23707_23733[(2)] = inst_23643);

(statearr_23707_23733[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto___23716))
;
return ((function (switch__23144__auto__,c__23309__auto___23716){
return (function() {
var cljs$core$async$state_machine__23145__auto__ = null;
var cljs$core$async$state_machine__23145__auto____0 = (function (){
var statearr_23708 = [null,null,null,null,null,null,null,null];
(statearr_23708[(0)] = cljs$core$async$state_machine__23145__auto__);

(statearr_23708[(1)] = (1));

return statearr_23708;
});
var cljs$core$async$state_machine__23145__auto____1 = (function (state_23673){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_23673);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e23709){if((e23709 instanceof Object)){
var ex__23148__auto__ = e23709;
var statearr_23710_23734 = state_23673;
(statearr_23710_23734[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23673);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23709;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23735 = state_23673;
state_23673 = G__23735;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$state_machine__23145__auto__ = function(state_23673){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23145__auto____1.call(this,state_23673);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23145__auto____0;
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23145__auto____1;
return cljs$core$async$state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto___23716))
})();
var state__23311__auto__ = (function (){var statearr_23712 = f__23310__auto__.call(null);
(statearr_23712[(6)] = c__23309__auto___23716);

return statearr_23712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto___23716))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__23739){
var vec__23740 = p__23739;
var v = cljs.core.nth.call(null,vec__23740,(0),null);
var p = cljs.core.nth.call(null,vec__23740,(1),null);
var job = vec__23740;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__23309__auto___23956 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto___23956,res,vec__23740,v,p,job,jobs,results){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto___23956,res,vec__23740,v,p,job,jobs,results){
return (function (state_23747){
var state_val_23748 = (state_23747[(1)]);
if((state_val_23748 === (1))){
var state_23747__$1 = state_23747;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23747__$1,(2),res,v);
} else {
if((state_val_23748 === (2))){
var inst_23744 = (state_23747[(2)]);
var inst_23745 = cljs.core.async.close_BANG_.call(null,res);
var state_23747__$1 = (function (){var statearr_23749 = state_23747;
(statearr_23749[(7)] = inst_23744);

return statearr_23749;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23747__$1,inst_23745);
} else {
return null;
}
}
});})(c__23309__auto___23956,res,vec__23740,v,p,job,jobs,results))
;
return ((function (switch__23144__auto__,c__23309__auto___23956,res,vec__23740,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____0 = (function (){
var statearr_23750 = [null,null,null,null,null,null,null,null];
(statearr_23750[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__);

(statearr_23750[(1)] = (1));

return statearr_23750;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____1 = (function (state_23747){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_23747);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e23751){if((e23751 instanceof Object)){
var ex__23148__auto__ = e23751;
var statearr_23752_23968 = state_23747;
(statearr_23752_23968[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23747);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23751;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23969 = state_23747;
state_23747 = G__23969;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__ = function(state_23747){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____1.call(this,state_23747);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto___23956,res,vec__23740,v,p,job,jobs,results))
})();
var state__23311__auto__ = (function (){var statearr_23753 = f__23310__auto__.call(null);
(statearr_23753[(6)] = c__23309__auto___23956);

return statearr_23753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto___23956,res,vec__23740,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__23755){
var vec__23756 = p__23755;
var v = cljs.core.nth.call(null,vec__23756,(0),null);
var p = cljs.core.nth.call(null,vec__23756,(1),null);
var job = vec__23756;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4376__auto___23975 = n;
var __23976 = (0);
while(true){
if((__23976 < n__4376__auto___23975)){
var G__23760_23977 = type;
var G__23760_23978__$1 = (((G__23760_23977 instanceof cljs.core.Keyword))?G__23760_23977.fqn:null);
switch (G__23760_23978__$1) {
case "compute":
var c__23309__auto___23980 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__23976,c__23309__auto___23980,G__23760_23977,G__23760_23978__$1,n__4376__auto___23975,jobs,results,process,async){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (__23976,c__23309__auto___23980,G__23760_23977,G__23760_23978__$1,n__4376__auto___23975,jobs,results,process,async){
return (function (state_23773){
var state_val_23774 = (state_23773[(1)]);
if((state_val_23774 === (1))){
var state_23773__$1 = state_23773;
var statearr_23775_23981 = state_23773__$1;
(statearr_23775_23981[(2)] = null);

(statearr_23775_23981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23774 === (2))){
var state_23773__$1 = state_23773;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23773__$1,(4),jobs);
} else {
if((state_val_23774 === (3))){
var inst_23771 = (state_23773[(2)]);
var state_23773__$1 = state_23773;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23773__$1,inst_23771);
} else {
if((state_val_23774 === (4))){
var inst_23763 = (state_23773[(2)]);
var inst_23764 = process.call(null,inst_23763);
var state_23773__$1 = state_23773;
if(cljs.core.truth_(inst_23764)){
var statearr_23785_23982 = state_23773__$1;
(statearr_23785_23982[(1)] = (5));

} else {
var statearr_23786_23983 = state_23773__$1;
(statearr_23786_23983[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23774 === (5))){
var state_23773__$1 = state_23773;
var statearr_23787_23984 = state_23773__$1;
(statearr_23787_23984[(2)] = null);

(statearr_23787_23984[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23774 === (6))){
var state_23773__$1 = state_23773;
var statearr_23788_23986 = state_23773__$1;
(statearr_23788_23986[(2)] = null);

(statearr_23788_23986[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23774 === (7))){
var inst_23769 = (state_23773[(2)]);
var state_23773__$1 = state_23773;
var statearr_23789_23987 = state_23773__$1;
(statearr_23789_23987[(2)] = inst_23769);

(statearr_23789_23987[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__23976,c__23309__auto___23980,G__23760_23977,G__23760_23978__$1,n__4376__auto___23975,jobs,results,process,async))
;
return ((function (__23976,switch__23144__auto__,c__23309__auto___23980,G__23760_23977,G__23760_23978__$1,n__4376__auto___23975,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____0 = (function (){
var statearr_23790 = [null,null,null,null,null,null,null];
(statearr_23790[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__);

(statearr_23790[(1)] = (1));

return statearr_23790;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____1 = (function (state_23773){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_23773);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e23791){if((e23791 instanceof Object)){
var ex__23148__auto__ = e23791;
var statearr_23792_23988 = state_23773;
(statearr_23792_23988[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23773);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23791;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23989 = state_23773;
state_23773 = G__23989;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__ = function(state_23773){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____1.call(this,state_23773);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__;
})()
;})(__23976,switch__23144__auto__,c__23309__auto___23980,G__23760_23977,G__23760_23978__$1,n__4376__auto___23975,jobs,results,process,async))
})();
var state__23311__auto__ = (function (){var statearr_23793 = f__23310__auto__.call(null);
(statearr_23793[(6)] = c__23309__auto___23980);

return statearr_23793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(__23976,c__23309__auto___23980,G__23760_23977,G__23760_23978__$1,n__4376__auto___23975,jobs,results,process,async))
);


break;
case "async":
var c__23309__auto___23990 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__23976,c__23309__auto___23990,G__23760_23977,G__23760_23978__$1,n__4376__auto___23975,jobs,results,process,async){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (__23976,c__23309__auto___23990,G__23760_23977,G__23760_23978__$1,n__4376__auto___23975,jobs,results,process,async){
return (function (state_23806){
var state_val_23807 = (state_23806[(1)]);
if((state_val_23807 === (1))){
var state_23806__$1 = state_23806;
var statearr_23808_23991 = state_23806__$1;
(statearr_23808_23991[(2)] = null);

(statearr_23808_23991[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (2))){
var state_23806__$1 = state_23806;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23806__$1,(4),jobs);
} else {
if((state_val_23807 === (3))){
var inst_23804 = (state_23806[(2)]);
var state_23806__$1 = state_23806;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23806__$1,inst_23804);
} else {
if((state_val_23807 === (4))){
var inst_23796 = (state_23806[(2)]);
var inst_23797 = async.call(null,inst_23796);
var state_23806__$1 = state_23806;
if(cljs.core.truth_(inst_23797)){
var statearr_23809_23995 = state_23806__$1;
(statearr_23809_23995[(1)] = (5));

} else {
var statearr_23810_23996 = state_23806__$1;
(statearr_23810_23996[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (5))){
var state_23806__$1 = state_23806;
var statearr_23811_23998 = state_23806__$1;
(statearr_23811_23998[(2)] = null);

(statearr_23811_23998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (6))){
var state_23806__$1 = state_23806;
var statearr_23815_23999 = state_23806__$1;
(statearr_23815_23999[(2)] = null);

(statearr_23815_23999[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (7))){
var inst_23802 = (state_23806[(2)]);
var state_23806__$1 = state_23806;
var statearr_23822_24001 = state_23806__$1;
(statearr_23822_24001[(2)] = inst_23802);

(statearr_23822_24001[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__23976,c__23309__auto___23990,G__23760_23977,G__23760_23978__$1,n__4376__auto___23975,jobs,results,process,async))
;
return ((function (__23976,switch__23144__auto__,c__23309__auto___23990,G__23760_23977,G__23760_23978__$1,n__4376__auto___23975,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____0 = (function (){
var statearr_23823 = [null,null,null,null,null,null,null];
(statearr_23823[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__);

(statearr_23823[(1)] = (1));

return statearr_23823;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____1 = (function (state_23806){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_23806);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e23824){if((e23824 instanceof Object)){
var ex__23148__auto__ = e23824;
var statearr_23825_24007 = state_23806;
(statearr_23825_24007[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23806);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23824;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24008 = state_23806;
state_23806 = G__24008;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__ = function(state_23806){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____1.call(this,state_23806);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__;
})()
;})(__23976,switch__23144__auto__,c__23309__auto___23990,G__23760_23977,G__23760_23978__$1,n__4376__auto___23975,jobs,results,process,async))
})();
var state__23311__auto__ = (function (){var statearr_23829 = f__23310__auto__.call(null);
(statearr_23829[(6)] = c__23309__auto___23990);

return statearr_23829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(__23976,c__23309__auto___23990,G__23760_23977,G__23760_23978__$1,n__4376__auto___23975,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23760_23978__$1)].join('')));

}

var G__24009 = (__23976 + (1));
__23976 = G__24009;
continue;
} else {
}
break;
}

var c__23309__auto___24010 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto___24010,jobs,results,process,async){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto___24010,jobs,results,process,async){
return (function (state_23851){
var state_val_23852 = (state_23851[(1)]);
if((state_val_23852 === (1))){
var state_23851__$1 = state_23851;
var statearr_23854_24011 = state_23851__$1;
(statearr_23854_24011[(2)] = null);

(statearr_23854_24011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23852 === (2))){
var state_23851__$1 = state_23851;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23851__$1,(4),from);
} else {
if((state_val_23852 === (3))){
var inst_23849 = (state_23851[(2)]);
var state_23851__$1 = state_23851;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23851__$1,inst_23849);
} else {
if((state_val_23852 === (4))){
var inst_23832 = (state_23851[(7)]);
var inst_23832__$1 = (state_23851[(2)]);
var inst_23833 = (inst_23832__$1 == null);
var state_23851__$1 = (function (){var statearr_23855 = state_23851;
(statearr_23855[(7)] = inst_23832__$1);

return statearr_23855;
})();
if(cljs.core.truth_(inst_23833)){
var statearr_23856_24012 = state_23851__$1;
(statearr_23856_24012[(1)] = (5));

} else {
var statearr_23857_24013 = state_23851__$1;
(statearr_23857_24013[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23852 === (5))){
var inst_23835 = cljs.core.async.close_BANG_.call(null,jobs);
var state_23851__$1 = state_23851;
var statearr_23858_24014 = state_23851__$1;
(statearr_23858_24014[(2)] = inst_23835);

(statearr_23858_24014[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23852 === (6))){
var inst_23832 = (state_23851[(7)]);
var inst_23837 = (state_23851[(8)]);
var inst_23837__$1 = cljs.core.async.chan.call(null,(1));
var inst_23838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23839 = [inst_23832,inst_23837__$1];
var inst_23840 = (new cljs.core.PersistentVector(null,2,(5),inst_23838,inst_23839,null));
var state_23851__$1 = (function (){var statearr_23865 = state_23851;
(statearr_23865[(8)] = inst_23837__$1);

return statearr_23865;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23851__$1,(8),jobs,inst_23840);
} else {
if((state_val_23852 === (7))){
var inst_23847 = (state_23851[(2)]);
var state_23851__$1 = state_23851;
var statearr_23866_24021 = state_23851__$1;
(statearr_23866_24021[(2)] = inst_23847);

(statearr_23866_24021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23852 === (8))){
var inst_23837 = (state_23851[(8)]);
var inst_23842 = (state_23851[(2)]);
var state_23851__$1 = (function (){var statearr_23867 = state_23851;
(statearr_23867[(9)] = inst_23842);

return statearr_23867;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23851__$1,(9),results,inst_23837);
} else {
if((state_val_23852 === (9))){
var inst_23844 = (state_23851[(2)]);
var state_23851__$1 = (function (){var statearr_23868 = state_23851;
(statearr_23868[(10)] = inst_23844);

return statearr_23868;
})();
var statearr_23869_24022 = state_23851__$1;
(statearr_23869_24022[(2)] = null);

(statearr_23869_24022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__23309__auto___24010,jobs,results,process,async))
;
return ((function (switch__23144__auto__,c__23309__auto___24010,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____0 = (function (){
var statearr_23870 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23870[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__);

(statearr_23870[(1)] = (1));

return statearr_23870;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____1 = (function (state_23851){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_23851);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e23871){if((e23871 instanceof Object)){
var ex__23148__auto__ = e23871;
var statearr_23872_24023 = state_23851;
(statearr_23872_24023[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23851);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23871;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24024 = state_23851;
state_23851 = G__24024;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__ = function(state_23851){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____1.call(this,state_23851);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto___24010,jobs,results,process,async))
})();
var state__23311__auto__ = (function (){var statearr_23873 = f__23310__auto__.call(null);
(statearr_23873[(6)] = c__23309__auto___24010);

return statearr_23873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto___24010,jobs,results,process,async))
);


var c__23309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto__,jobs,results,process,async){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto__,jobs,results,process,async){
return (function (state_23911){
var state_val_23912 = (state_23911[(1)]);
if((state_val_23912 === (7))){
var inst_23907 = (state_23911[(2)]);
var state_23911__$1 = state_23911;
var statearr_23913_24027 = state_23911__$1;
(statearr_23913_24027[(2)] = inst_23907);

(statearr_23913_24027[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23912 === (20))){
var state_23911__$1 = state_23911;
var statearr_23914_24028 = state_23911__$1;
(statearr_23914_24028[(2)] = null);

(statearr_23914_24028[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23912 === (1))){
var state_23911__$1 = state_23911;
var statearr_23915_24029 = state_23911__$1;
(statearr_23915_24029[(2)] = null);

(statearr_23915_24029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23912 === (4))){
var inst_23876 = (state_23911[(7)]);
var inst_23876__$1 = (state_23911[(2)]);
var inst_23877 = (inst_23876__$1 == null);
var state_23911__$1 = (function (){var statearr_23917 = state_23911;
(statearr_23917[(7)] = inst_23876__$1);

return statearr_23917;
})();
if(cljs.core.truth_(inst_23877)){
var statearr_23918_24030 = state_23911__$1;
(statearr_23918_24030[(1)] = (5));

} else {
var statearr_23919_24031 = state_23911__$1;
(statearr_23919_24031[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23912 === (15))){
var inst_23889 = (state_23911[(8)]);
var state_23911__$1 = state_23911;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23911__$1,(18),to,inst_23889);
} else {
if((state_val_23912 === (21))){
var inst_23902 = (state_23911[(2)]);
var state_23911__$1 = state_23911;
var statearr_23924_24033 = state_23911__$1;
(statearr_23924_24033[(2)] = inst_23902);

(statearr_23924_24033[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23912 === (13))){
var inst_23904 = (state_23911[(2)]);
var state_23911__$1 = (function (){var statearr_23927 = state_23911;
(statearr_23927[(9)] = inst_23904);

return statearr_23927;
})();
var statearr_23928_24034 = state_23911__$1;
(statearr_23928_24034[(2)] = null);

(statearr_23928_24034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23912 === (6))){
var inst_23876 = (state_23911[(7)]);
var state_23911__$1 = state_23911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23911__$1,(11),inst_23876);
} else {
if((state_val_23912 === (17))){
var inst_23897 = (state_23911[(2)]);
var state_23911__$1 = state_23911;
if(cljs.core.truth_(inst_23897)){
var statearr_23929_24040 = state_23911__$1;
(statearr_23929_24040[(1)] = (19));

} else {
var statearr_23930_24041 = state_23911__$1;
(statearr_23930_24041[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23912 === (3))){
var inst_23909 = (state_23911[(2)]);
var state_23911__$1 = state_23911;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23911__$1,inst_23909);
} else {
if((state_val_23912 === (12))){
var inst_23886 = (state_23911[(10)]);
var state_23911__$1 = state_23911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23911__$1,(14),inst_23886);
} else {
if((state_val_23912 === (2))){
var state_23911__$1 = state_23911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23911__$1,(4),results);
} else {
if((state_val_23912 === (19))){
var state_23911__$1 = state_23911;
var statearr_23934_24043 = state_23911__$1;
(statearr_23934_24043[(2)] = null);

(statearr_23934_24043[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23912 === (11))){
var inst_23886 = (state_23911[(2)]);
var state_23911__$1 = (function (){var statearr_23935 = state_23911;
(statearr_23935[(10)] = inst_23886);

return statearr_23935;
})();
var statearr_23936_24044 = state_23911__$1;
(statearr_23936_24044[(2)] = null);

(statearr_23936_24044[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23912 === (9))){
var state_23911__$1 = state_23911;
var statearr_23937_24045 = state_23911__$1;
(statearr_23937_24045[(2)] = null);

(statearr_23937_24045[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23912 === (5))){
var state_23911__$1 = state_23911;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23939_24047 = state_23911__$1;
(statearr_23939_24047[(1)] = (8));

} else {
var statearr_23940_24048 = state_23911__$1;
(statearr_23940_24048[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23912 === (14))){
var inst_23891 = (state_23911[(11)]);
var inst_23889 = (state_23911[(8)]);
var inst_23889__$1 = (state_23911[(2)]);
var inst_23890 = (inst_23889__$1 == null);
var inst_23891__$1 = cljs.core.not.call(null,inst_23890);
var state_23911__$1 = (function (){var statearr_23941 = state_23911;
(statearr_23941[(11)] = inst_23891__$1);

(statearr_23941[(8)] = inst_23889__$1);

return statearr_23941;
})();
if(inst_23891__$1){
var statearr_23942_24049 = state_23911__$1;
(statearr_23942_24049[(1)] = (15));

} else {
var statearr_23943_24050 = state_23911__$1;
(statearr_23943_24050[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23912 === (16))){
var inst_23891 = (state_23911[(11)]);
var state_23911__$1 = state_23911;
var statearr_23944_24051 = state_23911__$1;
(statearr_23944_24051[(2)] = inst_23891);

(statearr_23944_24051[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23912 === (10))){
var inst_23883 = (state_23911[(2)]);
var state_23911__$1 = state_23911;
var statearr_23946_24053 = state_23911__$1;
(statearr_23946_24053[(2)] = inst_23883);

(statearr_23946_24053[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23912 === (18))){
var inst_23894 = (state_23911[(2)]);
var state_23911__$1 = state_23911;
var statearr_23947_24054 = state_23911__$1;
(statearr_23947_24054[(2)] = inst_23894);

(statearr_23947_24054[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23912 === (8))){
var inst_23880 = cljs.core.async.close_BANG_.call(null,to);
var state_23911__$1 = state_23911;
var statearr_23948_24058 = state_23911__$1;
(statearr_23948_24058[(2)] = inst_23880);

(statearr_23948_24058[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto__,jobs,results,process,async))
;
return ((function (switch__23144__auto__,c__23309__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____0 = (function (){
var statearr_23949 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23949[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__);

(statearr_23949[(1)] = (1));

return statearr_23949;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____1 = (function (state_23911){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_23911);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e23950){if((e23950 instanceof Object)){
var ex__23148__auto__ = e23950;
var statearr_23951_24060 = state_23911;
(statearr_23951_24060[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23911);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23950;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24061 = state_23911;
state_23911 = G__24061;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__ = function(state_23911){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____1.call(this,state_23911);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23145__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto__,jobs,results,process,async))
})();
var state__23311__auto__ = (function (){var statearr_23952 = f__23310__auto__.call(null);
(statearr_23952[(6)] = c__23309__auto__);

return statearr_23952;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto__,jobs,results,process,async))
);

return c__23309__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__24067 = arguments.length;
switch (G__24067) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__24072 = arguments.length;
switch (G__24072) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__24075 = arguments.length;
switch (G__24075) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__23309__auto___24133 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto___24133,tc,fc){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto___24133,tc,fc){
return (function (state_24102){
var state_val_24103 = (state_24102[(1)]);
if((state_val_24103 === (7))){
var inst_24097 = (state_24102[(2)]);
var state_24102__$1 = state_24102;
var statearr_24105_24134 = state_24102__$1;
(statearr_24105_24134[(2)] = inst_24097);

(statearr_24105_24134[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24103 === (1))){
var state_24102__$1 = state_24102;
var statearr_24106_24136 = state_24102__$1;
(statearr_24106_24136[(2)] = null);

(statearr_24106_24136[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24103 === (4))){
var inst_24078 = (state_24102[(7)]);
var inst_24078__$1 = (state_24102[(2)]);
var inst_24079 = (inst_24078__$1 == null);
var state_24102__$1 = (function (){var statearr_24107 = state_24102;
(statearr_24107[(7)] = inst_24078__$1);

return statearr_24107;
})();
if(cljs.core.truth_(inst_24079)){
var statearr_24108_24138 = state_24102__$1;
(statearr_24108_24138[(1)] = (5));

} else {
var statearr_24109_24139 = state_24102__$1;
(statearr_24109_24139[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24103 === (13))){
var state_24102__$1 = state_24102;
var statearr_24110_24140 = state_24102__$1;
(statearr_24110_24140[(2)] = null);

(statearr_24110_24140[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24103 === (6))){
var inst_24078 = (state_24102[(7)]);
var inst_24084 = p.call(null,inst_24078);
var state_24102__$1 = state_24102;
if(cljs.core.truth_(inst_24084)){
var statearr_24111_24141 = state_24102__$1;
(statearr_24111_24141[(1)] = (9));

} else {
var statearr_24112_24142 = state_24102__$1;
(statearr_24112_24142[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24103 === (3))){
var inst_24100 = (state_24102[(2)]);
var state_24102__$1 = state_24102;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24102__$1,inst_24100);
} else {
if((state_val_24103 === (12))){
var state_24102__$1 = state_24102;
var statearr_24113_24143 = state_24102__$1;
(statearr_24113_24143[(2)] = null);

(statearr_24113_24143[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24103 === (2))){
var state_24102__$1 = state_24102;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24102__$1,(4),ch);
} else {
if((state_val_24103 === (11))){
var inst_24078 = (state_24102[(7)]);
var inst_24088 = (state_24102[(2)]);
var state_24102__$1 = state_24102;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24102__$1,(8),inst_24088,inst_24078);
} else {
if((state_val_24103 === (9))){
var state_24102__$1 = state_24102;
var statearr_24116_24147 = state_24102__$1;
(statearr_24116_24147[(2)] = tc);

(statearr_24116_24147[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24103 === (5))){
var inst_24081 = cljs.core.async.close_BANG_.call(null,tc);
var inst_24082 = cljs.core.async.close_BANG_.call(null,fc);
var state_24102__$1 = (function (){var statearr_24117 = state_24102;
(statearr_24117[(8)] = inst_24081);

return statearr_24117;
})();
var statearr_24118_24148 = state_24102__$1;
(statearr_24118_24148[(2)] = inst_24082);

(statearr_24118_24148[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24103 === (14))){
var inst_24095 = (state_24102[(2)]);
var state_24102__$1 = state_24102;
var statearr_24119_24151 = state_24102__$1;
(statearr_24119_24151[(2)] = inst_24095);

(statearr_24119_24151[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24103 === (10))){
var state_24102__$1 = state_24102;
var statearr_24120_24152 = state_24102__$1;
(statearr_24120_24152[(2)] = fc);

(statearr_24120_24152[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24103 === (8))){
var inst_24090 = (state_24102[(2)]);
var state_24102__$1 = state_24102;
if(cljs.core.truth_(inst_24090)){
var statearr_24121_24153 = state_24102__$1;
(statearr_24121_24153[(1)] = (12));

} else {
var statearr_24122_24154 = state_24102__$1;
(statearr_24122_24154[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto___24133,tc,fc))
;
return ((function (switch__23144__auto__,c__23309__auto___24133,tc,fc){
return (function() {
var cljs$core$async$state_machine__23145__auto__ = null;
var cljs$core$async$state_machine__23145__auto____0 = (function (){
var statearr_24123 = [null,null,null,null,null,null,null,null,null];
(statearr_24123[(0)] = cljs$core$async$state_machine__23145__auto__);

(statearr_24123[(1)] = (1));

return statearr_24123;
});
var cljs$core$async$state_machine__23145__auto____1 = (function (state_24102){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_24102);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e24124){if((e24124 instanceof Object)){
var ex__23148__auto__ = e24124;
var statearr_24125_24158 = state_24102;
(statearr_24125_24158[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24102);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24124;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24159 = state_24102;
state_24102 = G__24159;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$state_machine__23145__auto__ = function(state_24102){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23145__auto____1.call(this,state_24102);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23145__auto____0;
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23145__auto____1;
return cljs$core$async$state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto___24133,tc,fc))
})();
var state__23311__auto__ = (function (){var statearr_24126 = f__23310__auto__.call(null);
(statearr_24126[(6)] = c__23309__auto___24133);

return statearr_24126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto___24133,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__23309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto__){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto__){
return (function (state_24182){
var state_val_24183 = (state_24182[(1)]);
if((state_val_24183 === (7))){
var inst_24178 = (state_24182[(2)]);
var state_24182__$1 = state_24182;
var statearr_24184_24202 = state_24182__$1;
(statearr_24184_24202[(2)] = inst_24178);

(statearr_24184_24202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24183 === (1))){
var inst_24161 = init;
var state_24182__$1 = (function (){var statearr_24185 = state_24182;
(statearr_24185[(7)] = inst_24161);

return statearr_24185;
})();
var statearr_24186_24203 = state_24182__$1;
(statearr_24186_24203[(2)] = null);

(statearr_24186_24203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24183 === (4))){
var inst_24164 = (state_24182[(8)]);
var inst_24164__$1 = (state_24182[(2)]);
var inst_24165 = (inst_24164__$1 == null);
var state_24182__$1 = (function (){var statearr_24187 = state_24182;
(statearr_24187[(8)] = inst_24164__$1);

return statearr_24187;
})();
if(cljs.core.truth_(inst_24165)){
var statearr_24188_24204 = state_24182__$1;
(statearr_24188_24204[(1)] = (5));

} else {
var statearr_24189_24205 = state_24182__$1;
(statearr_24189_24205[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24183 === (6))){
var inst_24164 = (state_24182[(8)]);
var inst_24168 = (state_24182[(9)]);
var inst_24161 = (state_24182[(7)]);
var inst_24168__$1 = f.call(null,inst_24161,inst_24164);
var inst_24170 = cljs.core.reduced_QMARK_.call(null,inst_24168__$1);
var state_24182__$1 = (function (){var statearr_24190 = state_24182;
(statearr_24190[(9)] = inst_24168__$1);

return statearr_24190;
})();
if(inst_24170){
var statearr_24191_24206 = state_24182__$1;
(statearr_24191_24206[(1)] = (8));

} else {
var statearr_24192_24207 = state_24182__$1;
(statearr_24192_24207[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24183 === (3))){
var inst_24180 = (state_24182[(2)]);
var state_24182__$1 = state_24182;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24182__$1,inst_24180);
} else {
if((state_val_24183 === (2))){
var state_24182__$1 = state_24182;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24182__$1,(4),ch);
} else {
if((state_val_24183 === (9))){
var inst_24168 = (state_24182[(9)]);
var inst_24161 = inst_24168;
var state_24182__$1 = (function (){var statearr_24193 = state_24182;
(statearr_24193[(7)] = inst_24161);

return statearr_24193;
})();
var statearr_24194_24209 = state_24182__$1;
(statearr_24194_24209[(2)] = null);

(statearr_24194_24209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24183 === (5))){
var inst_24161 = (state_24182[(7)]);
var state_24182__$1 = state_24182;
var statearr_24195_24210 = state_24182__$1;
(statearr_24195_24210[(2)] = inst_24161);

(statearr_24195_24210[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24183 === (10))){
var inst_24176 = (state_24182[(2)]);
var state_24182__$1 = state_24182;
var statearr_24196_24215 = state_24182__$1;
(statearr_24196_24215[(2)] = inst_24176);

(statearr_24196_24215[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24183 === (8))){
var inst_24168 = (state_24182[(9)]);
var inst_24172 = cljs.core.deref.call(null,inst_24168);
var state_24182__$1 = state_24182;
var statearr_24197_24217 = state_24182__$1;
(statearr_24197_24217[(2)] = inst_24172);

(statearr_24197_24217[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto__))
;
return ((function (switch__23144__auto__,c__23309__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__23145__auto__ = null;
var cljs$core$async$reduce_$_state_machine__23145__auto____0 = (function (){
var statearr_24198 = [null,null,null,null,null,null,null,null,null,null];
(statearr_24198[(0)] = cljs$core$async$reduce_$_state_machine__23145__auto__);

(statearr_24198[(1)] = (1));

return statearr_24198;
});
var cljs$core$async$reduce_$_state_machine__23145__auto____1 = (function (state_24182){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_24182);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e24199){if((e24199 instanceof Object)){
var ex__23148__auto__ = e24199;
var statearr_24200_24219 = state_24182;
(statearr_24200_24219[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24182);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24199;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24220 = state_24182;
state_24182 = G__24220;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__23145__auto__ = function(state_24182){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__23145__auto____1.call(this,state_24182);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__23145__auto____0;
cljs$core$async$reduce_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__23145__auto____1;
return cljs$core$async$reduce_$_state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto__))
})();
var state__23311__auto__ = (function (){var statearr_24201 = f__23310__auto__.call(null);
(statearr_24201[(6)] = c__23309__auto__);

return statearr_24201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto__))
);

return c__23309__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__23309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto__,f__$1){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto__,f__$1){
return (function (state_24226){
var state_val_24227 = (state_24226[(1)]);
if((state_val_24227 === (1))){
var inst_24221 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_24226__$1 = state_24226;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24226__$1,(2),inst_24221);
} else {
if((state_val_24227 === (2))){
var inst_24223 = (state_24226[(2)]);
var inst_24224 = f__$1.call(null,inst_24223);
var state_24226__$1 = state_24226;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24226__$1,inst_24224);
} else {
return null;
}
}
});})(c__23309__auto__,f__$1))
;
return ((function (switch__23144__auto__,c__23309__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__23145__auto__ = null;
var cljs$core$async$transduce_$_state_machine__23145__auto____0 = (function (){
var statearr_24228 = [null,null,null,null,null,null,null];
(statearr_24228[(0)] = cljs$core$async$transduce_$_state_machine__23145__auto__);

(statearr_24228[(1)] = (1));

return statearr_24228;
});
var cljs$core$async$transduce_$_state_machine__23145__auto____1 = (function (state_24226){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_24226);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e24229){if((e24229 instanceof Object)){
var ex__23148__auto__ = e24229;
var statearr_24230_24237 = state_24226;
(statearr_24230_24237[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24226);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24229;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24239 = state_24226;
state_24226 = G__24239;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__23145__auto__ = function(state_24226){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__23145__auto____1.call(this,state_24226);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__23145__auto____0;
cljs$core$async$transduce_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__23145__auto____1;
return cljs$core$async$transduce_$_state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto__,f__$1))
})();
var state__23311__auto__ = (function (){var statearr_24231 = f__23310__auto__.call(null);
(statearr_24231[(6)] = c__23309__auto__);

return statearr_24231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto__,f__$1))
);

return c__23309__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__24241 = arguments.length;
switch (G__24241) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__23309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto__){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto__){
return (function (state_24267){
var state_val_24268 = (state_24267[(1)]);
if((state_val_24268 === (7))){
var inst_24249 = (state_24267[(2)]);
var state_24267__$1 = state_24267;
var statearr_24269_24294 = state_24267__$1;
(statearr_24269_24294[(2)] = inst_24249);

(statearr_24269_24294[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24268 === (1))){
var inst_24242 = cljs.core.seq.call(null,coll);
var inst_24243 = inst_24242;
var state_24267__$1 = (function (){var statearr_24270 = state_24267;
(statearr_24270[(7)] = inst_24243);

return statearr_24270;
})();
var statearr_24271_24295 = state_24267__$1;
(statearr_24271_24295[(2)] = null);

(statearr_24271_24295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24268 === (4))){
var inst_24243 = (state_24267[(7)]);
var inst_24246 = cljs.core.first.call(null,inst_24243);
var state_24267__$1 = state_24267;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24267__$1,(7),ch,inst_24246);
} else {
if((state_val_24268 === (13))){
var inst_24261 = (state_24267[(2)]);
var state_24267__$1 = state_24267;
var statearr_24272_24296 = state_24267__$1;
(statearr_24272_24296[(2)] = inst_24261);

(statearr_24272_24296[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24268 === (6))){
var inst_24252 = (state_24267[(2)]);
var state_24267__$1 = state_24267;
if(cljs.core.truth_(inst_24252)){
var statearr_24273_24297 = state_24267__$1;
(statearr_24273_24297[(1)] = (8));

} else {
var statearr_24274_24298 = state_24267__$1;
(statearr_24274_24298[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24268 === (3))){
var inst_24265 = (state_24267[(2)]);
var state_24267__$1 = state_24267;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24267__$1,inst_24265);
} else {
if((state_val_24268 === (12))){
var state_24267__$1 = state_24267;
var statearr_24276_24299 = state_24267__$1;
(statearr_24276_24299[(2)] = null);

(statearr_24276_24299[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24268 === (2))){
var inst_24243 = (state_24267[(7)]);
var state_24267__$1 = state_24267;
if(cljs.core.truth_(inst_24243)){
var statearr_24277_24300 = state_24267__$1;
(statearr_24277_24300[(1)] = (4));

} else {
var statearr_24278_24301 = state_24267__$1;
(statearr_24278_24301[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24268 === (11))){
var inst_24258 = cljs.core.async.close_BANG_.call(null,ch);
var state_24267__$1 = state_24267;
var statearr_24279_24302 = state_24267__$1;
(statearr_24279_24302[(2)] = inst_24258);

(statearr_24279_24302[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24268 === (9))){
var state_24267__$1 = state_24267;
if(cljs.core.truth_(close_QMARK_)){
var statearr_24280_24303 = state_24267__$1;
(statearr_24280_24303[(1)] = (11));

} else {
var statearr_24281_24304 = state_24267__$1;
(statearr_24281_24304[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24268 === (5))){
var inst_24243 = (state_24267[(7)]);
var state_24267__$1 = state_24267;
var statearr_24283_24309 = state_24267__$1;
(statearr_24283_24309[(2)] = inst_24243);

(statearr_24283_24309[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24268 === (10))){
var inst_24263 = (state_24267[(2)]);
var state_24267__$1 = state_24267;
var statearr_24284_24311 = state_24267__$1;
(statearr_24284_24311[(2)] = inst_24263);

(statearr_24284_24311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24268 === (8))){
var inst_24243 = (state_24267[(7)]);
var inst_24254 = cljs.core.next.call(null,inst_24243);
var inst_24243__$1 = inst_24254;
var state_24267__$1 = (function (){var statearr_24285 = state_24267;
(statearr_24285[(7)] = inst_24243__$1);

return statearr_24285;
})();
var statearr_24286_24312 = state_24267__$1;
(statearr_24286_24312[(2)] = null);

(statearr_24286_24312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto__))
;
return ((function (switch__23144__auto__,c__23309__auto__){
return (function() {
var cljs$core$async$state_machine__23145__auto__ = null;
var cljs$core$async$state_machine__23145__auto____0 = (function (){
var statearr_24287 = [null,null,null,null,null,null,null,null];
(statearr_24287[(0)] = cljs$core$async$state_machine__23145__auto__);

(statearr_24287[(1)] = (1));

return statearr_24287;
});
var cljs$core$async$state_machine__23145__auto____1 = (function (state_24267){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_24267);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e24289){if((e24289 instanceof Object)){
var ex__23148__auto__ = e24289;
var statearr_24290_24314 = state_24267;
(statearr_24290_24314[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24267);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24289;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24315 = state_24267;
state_24267 = G__24315;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$state_machine__23145__auto__ = function(state_24267){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23145__auto____1.call(this,state_24267);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23145__auto____0;
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23145__auto____1;
return cljs$core$async$state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto__))
})();
var state__23311__auto__ = (function (){var statearr_24292 = f__23310__auto__.call(null);
(statearr_24292[(6)] = c__23309__auto__);

return statearr_24292;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto__))
);

return c__23309__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if(((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4211__auto__ = (((_ == null))?null:_);
var m__4212__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,_);
} else {
var m__4212__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4212__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m,ch);
} else {
var m__4212__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m);
} else {
var m__4212__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async24330 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24330 = (function (ch,cs,meta24331){
this.ch = ch;
this.cs = cs;
this.meta24331 = meta24331;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async24330.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_24332,meta24331__$1){
var self__ = this;
var _24332__$1 = this;
return (new cljs.core.async.t_cljs$core$async24330(self__.ch,self__.cs,meta24331__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async24330.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_24332){
var self__ = this;
var _24332__$1 = this;
return self__.meta24331;
});})(cs))
;

cljs.core.async.t_cljs$core$async24330.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24330.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async24330.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24330.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async24330.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async24330.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async24330.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta24331","meta24331",1819310095,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async24330.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24330.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24330";

cljs.core.async.t_cljs$core$async24330.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async24330");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24330.
 */
cljs.core.async.__GT_t_cljs$core$async24330 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async24330(ch__$1,cs__$1,meta24331){
return (new cljs.core.async.t_cljs$core$async24330(ch__$1,cs__$1,meta24331));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async24330(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__23309__auto___24570 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto___24570,cs,m,dchan,dctr,done){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto___24570,cs,m,dchan,dctr,done){
return (function (state_24475){
var state_val_24476 = (state_24475[(1)]);
if((state_val_24476 === (7))){
var inst_24471 = (state_24475[(2)]);
var state_24475__$1 = state_24475;
var statearr_24477_24571 = state_24475__$1;
(statearr_24477_24571[(2)] = inst_24471);

(statearr_24477_24571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (20))){
var inst_24371 = (state_24475[(7)]);
var inst_24383 = cljs.core.first.call(null,inst_24371);
var inst_24384 = cljs.core.nth.call(null,inst_24383,(0),null);
var inst_24385 = cljs.core.nth.call(null,inst_24383,(1),null);
var state_24475__$1 = (function (){var statearr_24482 = state_24475;
(statearr_24482[(8)] = inst_24384);

return statearr_24482;
})();
if(cljs.core.truth_(inst_24385)){
var statearr_24483_24572 = state_24475__$1;
(statearr_24483_24572[(1)] = (22));

} else {
var statearr_24485_24573 = state_24475__$1;
(statearr_24485_24573[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (27))){
var inst_24337 = (state_24475[(9)]);
var inst_24415 = (state_24475[(10)]);
var inst_24420 = (state_24475[(11)]);
var inst_24413 = (state_24475[(12)]);
var inst_24420__$1 = cljs.core._nth.call(null,inst_24413,inst_24415);
var inst_24421 = cljs.core.async.put_BANG_.call(null,inst_24420__$1,inst_24337,done);
var state_24475__$1 = (function (){var statearr_24486 = state_24475;
(statearr_24486[(11)] = inst_24420__$1);

return statearr_24486;
})();
if(cljs.core.truth_(inst_24421)){
var statearr_24487_24574 = state_24475__$1;
(statearr_24487_24574[(1)] = (30));

} else {
var statearr_24488_24575 = state_24475__$1;
(statearr_24488_24575[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (1))){
var state_24475__$1 = state_24475;
var statearr_24489_24576 = state_24475__$1;
(statearr_24489_24576[(2)] = null);

(statearr_24489_24576[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (24))){
var inst_24371 = (state_24475[(7)]);
var inst_24390 = (state_24475[(2)]);
var inst_24391 = cljs.core.next.call(null,inst_24371);
var inst_24346 = inst_24391;
var inst_24347 = null;
var inst_24348 = (0);
var inst_24349 = (0);
var state_24475__$1 = (function (){var statearr_24491 = state_24475;
(statearr_24491[(13)] = inst_24347);

(statearr_24491[(14)] = inst_24349);

(statearr_24491[(15)] = inst_24390);

(statearr_24491[(16)] = inst_24346);

(statearr_24491[(17)] = inst_24348);

return statearr_24491;
})();
var statearr_24492_24579 = state_24475__$1;
(statearr_24492_24579[(2)] = null);

(statearr_24492_24579[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (39))){
var state_24475__$1 = state_24475;
var statearr_24496_24580 = state_24475__$1;
(statearr_24496_24580[(2)] = null);

(statearr_24496_24580[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (4))){
var inst_24337 = (state_24475[(9)]);
var inst_24337__$1 = (state_24475[(2)]);
var inst_24338 = (inst_24337__$1 == null);
var state_24475__$1 = (function (){var statearr_24497 = state_24475;
(statearr_24497[(9)] = inst_24337__$1);

return statearr_24497;
})();
if(cljs.core.truth_(inst_24338)){
var statearr_24498_24581 = state_24475__$1;
(statearr_24498_24581[(1)] = (5));

} else {
var statearr_24499_24582 = state_24475__$1;
(statearr_24499_24582[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (15))){
var inst_24347 = (state_24475[(13)]);
var inst_24349 = (state_24475[(14)]);
var inst_24346 = (state_24475[(16)]);
var inst_24348 = (state_24475[(17)]);
var inst_24365 = (state_24475[(2)]);
var inst_24366 = (inst_24349 + (1));
var tmp24493 = inst_24347;
var tmp24494 = inst_24346;
var tmp24495 = inst_24348;
var inst_24346__$1 = tmp24494;
var inst_24347__$1 = tmp24493;
var inst_24348__$1 = tmp24495;
var inst_24349__$1 = inst_24366;
var state_24475__$1 = (function (){var statearr_24500 = state_24475;
(statearr_24500[(18)] = inst_24365);

(statearr_24500[(13)] = inst_24347__$1);

(statearr_24500[(14)] = inst_24349__$1);

(statearr_24500[(16)] = inst_24346__$1);

(statearr_24500[(17)] = inst_24348__$1);

return statearr_24500;
})();
var statearr_24501_24587 = state_24475__$1;
(statearr_24501_24587[(2)] = null);

(statearr_24501_24587[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (21))){
var inst_24394 = (state_24475[(2)]);
var state_24475__$1 = state_24475;
var statearr_24505_24588 = state_24475__$1;
(statearr_24505_24588[(2)] = inst_24394);

(statearr_24505_24588[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (31))){
var inst_24420 = (state_24475[(11)]);
var inst_24424 = done.call(null,null);
var inst_24425 = cljs.core.async.untap_STAR_.call(null,m,inst_24420);
var state_24475__$1 = (function (){var statearr_24506 = state_24475;
(statearr_24506[(19)] = inst_24424);

return statearr_24506;
})();
var statearr_24507_24589 = state_24475__$1;
(statearr_24507_24589[(2)] = inst_24425);

(statearr_24507_24589[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (32))){
var inst_24415 = (state_24475[(10)]);
var inst_24414 = (state_24475[(20)]);
var inst_24413 = (state_24475[(12)]);
var inst_24412 = (state_24475[(21)]);
var inst_24427 = (state_24475[(2)]);
var inst_24428 = (inst_24415 + (1));
var tmp24502 = inst_24414;
var tmp24503 = inst_24413;
var tmp24504 = inst_24412;
var inst_24412__$1 = tmp24504;
var inst_24413__$1 = tmp24503;
var inst_24414__$1 = tmp24502;
var inst_24415__$1 = inst_24428;
var state_24475__$1 = (function (){var statearr_24508 = state_24475;
(statearr_24508[(22)] = inst_24427);

(statearr_24508[(10)] = inst_24415__$1);

(statearr_24508[(20)] = inst_24414__$1);

(statearr_24508[(12)] = inst_24413__$1);

(statearr_24508[(21)] = inst_24412__$1);

return statearr_24508;
})();
var statearr_24509_24595 = state_24475__$1;
(statearr_24509_24595[(2)] = null);

(statearr_24509_24595[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (40))){
var inst_24442 = (state_24475[(23)]);
var inst_24447 = done.call(null,null);
var inst_24448 = cljs.core.async.untap_STAR_.call(null,m,inst_24442);
var state_24475__$1 = (function (){var statearr_24510 = state_24475;
(statearr_24510[(24)] = inst_24447);

return statearr_24510;
})();
var statearr_24511_24596 = state_24475__$1;
(statearr_24511_24596[(2)] = inst_24448);

(statearr_24511_24596[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (33))){
var inst_24431 = (state_24475[(25)]);
var inst_24433 = cljs.core.chunked_seq_QMARK_.call(null,inst_24431);
var state_24475__$1 = state_24475;
if(inst_24433){
var statearr_24512_24597 = state_24475__$1;
(statearr_24512_24597[(1)] = (36));

} else {
var statearr_24513_24598 = state_24475__$1;
(statearr_24513_24598[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (13))){
var inst_24359 = (state_24475[(26)]);
var inst_24362 = cljs.core.async.close_BANG_.call(null,inst_24359);
var state_24475__$1 = state_24475;
var statearr_24514_24599 = state_24475__$1;
(statearr_24514_24599[(2)] = inst_24362);

(statearr_24514_24599[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (22))){
var inst_24384 = (state_24475[(8)]);
var inst_24387 = cljs.core.async.close_BANG_.call(null,inst_24384);
var state_24475__$1 = state_24475;
var statearr_24515_24600 = state_24475__$1;
(statearr_24515_24600[(2)] = inst_24387);

(statearr_24515_24600[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (36))){
var inst_24431 = (state_24475[(25)]);
var inst_24436 = cljs.core.chunk_first.call(null,inst_24431);
var inst_24437 = cljs.core.chunk_rest.call(null,inst_24431);
var inst_24438 = cljs.core.count.call(null,inst_24436);
var inst_24412 = inst_24437;
var inst_24413 = inst_24436;
var inst_24414 = inst_24438;
var inst_24415 = (0);
var state_24475__$1 = (function (){var statearr_24519 = state_24475;
(statearr_24519[(10)] = inst_24415);

(statearr_24519[(20)] = inst_24414);

(statearr_24519[(12)] = inst_24413);

(statearr_24519[(21)] = inst_24412);

return statearr_24519;
})();
var statearr_24520_24601 = state_24475__$1;
(statearr_24520_24601[(2)] = null);

(statearr_24520_24601[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (41))){
var inst_24431 = (state_24475[(25)]);
var inst_24450 = (state_24475[(2)]);
var inst_24451 = cljs.core.next.call(null,inst_24431);
var inst_24412 = inst_24451;
var inst_24413 = null;
var inst_24414 = (0);
var inst_24415 = (0);
var state_24475__$1 = (function (){var statearr_24521 = state_24475;
(statearr_24521[(10)] = inst_24415);

(statearr_24521[(20)] = inst_24414);

(statearr_24521[(12)] = inst_24413);

(statearr_24521[(21)] = inst_24412);

(statearr_24521[(27)] = inst_24450);

return statearr_24521;
})();
var statearr_24522_24604 = state_24475__$1;
(statearr_24522_24604[(2)] = null);

(statearr_24522_24604[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (43))){
var state_24475__$1 = state_24475;
var statearr_24523_24605 = state_24475__$1;
(statearr_24523_24605[(2)] = null);

(statearr_24523_24605[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (29))){
var inst_24459 = (state_24475[(2)]);
var state_24475__$1 = state_24475;
var statearr_24524_24610 = state_24475__$1;
(statearr_24524_24610[(2)] = inst_24459);

(statearr_24524_24610[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (44))){
var inst_24468 = (state_24475[(2)]);
var state_24475__$1 = (function (){var statearr_24525 = state_24475;
(statearr_24525[(28)] = inst_24468);

return statearr_24525;
})();
var statearr_24526_24611 = state_24475__$1;
(statearr_24526_24611[(2)] = null);

(statearr_24526_24611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (6))){
var inst_24404 = (state_24475[(29)]);
var inst_24403 = cljs.core.deref.call(null,cs);
var inst_24404__$1 = cljs.core.keys.call(null,inst_24403);
var inst_24405 = cljs.core.count.call(null,inst_24404__$1);
var inst_24406 = cljs.core.reset_BANG_.call(null,dctr,inst_24405);
var inst_24411 = cljs.core.seq.call(null,inst_24404__$1);
var inst_24412 = inst_24411;
var inst_24413 = null;
var inst_24414 = (0);
var inst_24415 = (0);
var state_24475__$1 = (function (){var statearr_24527 = state_24475;
(statearr_24527[(10)] = inst_24415);

(statearr_24527[(20)] = inst_24414);

(statearr_24527[(12)] = inst_24413);

(statearr_24527[(21)] = inst_24412);

(statearr_24527[(30)] = inst_24406);

(statearr_24527[(29)] = inst_24404__$1);

return statearr_24527;
})();
var statearr_24528_24612 = state_24475__$1;
(statearr_24528_24612[(2)] = null);

(statearr_24528_24612[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (28))){
var inst_24431 = (state_24475[(25)]);
var inst_24412 = (state_24475[(21)]);
var inst_24431__$1 = cljs.core.seq.call(null,inst_24412);
var state_24475__$1 = (function (){var statearr_24529 = state_24475;
(statearr_24529[(25)] = inst_24431__$1);

return statearr_24529;
})();
if(inst_24431__$1){
var statearr_24530_24613 = state_24475__$1;
(statearr_24530_24613[(1)] = (33));

} else {
var statearr_24531_24614 = state_24475__$1;
(statearr_24531_24614[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (25))){
var inst_24415 = (state_24475[(10)]);
var inst_24414 = (state_24475[(20)]);
var inst_24417 = (inst_24415 < inst_24414);
var inst_24418 = inst_24417;
var state_24475__$1 = state_24475;
if(cljs.core.truth_(inst_24418)){
var statearr_24532_24617 = state_24475__$1;
(statearr_24532_24617[(1)] = (27));

} else {
var statearr_24533_24618 = state_24475__$1;
(statearr_24533_24618[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (34))){
var state_24475__$1 = state_24475;
var statearr_24534_24620 = state_24475__$1;
(statearr_24534_24620[(2)] = null);

(statearr_24534_24620[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (17))){
var state_24475__$1 = state_24475;
var statearr_24535_24621 = state_24475__$1;
(statearr_24535_24621[(2)] = null);

(statearr_24535_24621[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (3))){
var inst_24473 = (state_24475[(2)]);
var state_24475__$1 = state_24475;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24475__$1,inst_24473);
} else {
if((state_val_24476 === (12))){
var inst_24399 = (state_24475[(2)]);
var state_24475__$1 = state_24475;
var statearr_24536_24626 = state_24475__$1;
(statearr_24536_24626[(2)] = inst_24399);

(statearr_24536_24626[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (2))){
var state_24475__$1 = state_24475;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24475__$1,(4),ch);
} else {
if((state_val_24476 === (23))){
var state_24475__$1 = state_24475;
var statearr_24538_24631 = state_24475__$1;
(statearr_24538_24631[(2)] = null);

(statearr_24538_24631[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (35))){
var inst_24457 = (state_24475[(2)]);
var state_24475__$1 = state_24475;
var statearr_24539_24633 = state_24475__$1;
(statearr_24539_24633[(2)] = inst_24457);

(statearr_24539_24633[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (19))){
var inst_24371 = (state_24475[(7)]);
var inst_24375 = cljs.core.chunk_first.call(null,inst_24371);
var inst_24376 = cljs.core.chunk_rest.call(null,inst_24371);
var inst_24377 = cljs.core.count.call(null,inst_24375);
var inst_24346 = inst_24376;
var inst_24347 = inst_24375;
var inst_24348 = inst_24377;
var inst_24349 = (0);
var state_24475__$1 = (function (){var statearr_24540 = state_24475;
(statearr_24540[(13)] = inst_24347);

(statearr_24540[(14)] = inst_24349);

(statearr_24540[(16)] = inst_24346);

(statearr_24540[(17)] = inst_24348);

return statearr_24540;
})();
var statearr_24541_24636 = state_24475__$1;
(statearr_24541_24636[(2)] = null);

(statearr_24541_24636[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (11))){
var inst_24371 = (state_24475[(7)]);
var inst_24346 = (state_24475[(16)]);
var inst_24371__$1 = cljs.core.seq.call(null,inst_24346);
var state_24475__$1 = (function (){var statearr_24542 = state_24475;
(statearr_24542[(7)] = inst_24371__$1);

return statearr_24542;
})();
if(inst_24371__$1){
var statearr_24543_24641 = state_24475__$1;
(statearr_24543_24641[(1)] = (16));

} else {
var statearr_24544_24642 = state_24475__$1;
(statearr_24544_24642[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (9))){
var inst_24401 = (state_24475[(2)]);
var state_24475__$1 = state_24475;
var statearr_24545_24643 = state_24475__$1;
(statearr_24545_24643[(2)] = inst_24401);

(statearr_24545_24643[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (5))){
var inst_24344 = cljs.core.deref.call(null,cs);
var inst_24345 = cljs.core.seq.call(null,inst_24344);
var inst_24346 = inst_24345;
var inst_24347 = null;
var inst_24348 = (0);
var inst_24349 = (0);
var state_24475__$1 = (function (){var statearr_24546 = state_24475;
(statearr_24546[(13)] = inst_24347);

(statearr_24546[(14)] = inst_24349);

(statearr_24546[(16)] = inst_24346);

(statearr_24546[(17)] = inst_24348);

return statearr_24546;
})();
var statearr_24547_24644 = state_24475__$1;
(statearr_24547_24644[(2)] = null);

(statearr_24547_24644[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (14))){
var state_24475__$1 = state_24475;
var statearr_24548_24645 = state_24475__$1;
(statearr_24548_24645[(2)] = null);

(statearr_24548_24645[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (45))){
var inst_24465 = (state_24475[(2)]);
var state_24475__$1 = state_24475;
var statearr_24549_24646 = state_24475__$1;
(statearr_24549_24646[(2)] = inst_24465);

(statearr_24549_24646[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (26))){
var inst_24404 = (state_24475[(29)]);
var inst_24461 = (state_24475[(2)]);
var inst_24462 = cljs.core.seq.call(null,inst_24404);
var state_24475__$1 = (function (){var statearr_24550 = state_24475;
(statearr_24550[(31)] = inst_24461);

return statearr_24550;
})();
if(inst_24462){
var statearr_24551_24647 = state_24475__$1;
(statearr_24551_24647[(1)] = (42));

} else {
var statearr_24552_24648 = state_24475__$1;
(statearr_24552_24648[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (16))){
var inst_24371 = (state_24475[(7)]);
var inst_24373 = cljs.core.chunked_seq_QMARK_.call(null,inst_24371);
var state_24475__$1 = state_24475;
if(inst_24373){
var statearr_24553_24649 = state_24475__$1;
(statearr_24553_24649[(1)] = (19));

} else {
var statearr_24554_24650 = state_24475__$1;
(statearr_24554_24650[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (38))){
var inst_24454 = (state_24475[(2)]);
var state_24475__$1 = state_24475;
var statearr_24555_24651 = state_24475__$1;
(statearr_24555_24651[(2)] = inst_24454);

(statearr_24555_24651[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (30))){
var state_24475__$1 = state_24475;
var statearr_24556_24652 = state_24475__$1;
(statearr_24556_24652[(2)] = null);

(statearr_24556_24652[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (10))){
var inst_24347 = (state_24475[(13)]);
var inst_24349 = (state_24475[(14)]);
var inst_24358 = cljs.core._nth.call(null,inst_24347,inst_24349);
var inst_24359 = cljs.core.nth.call(null,inst_24358,(0),null);
var inst_24360 = cljs.core.nth.call(null,inst_24358,(1),null);
var state_24475__$1 = (function (){var statearr_24557 = state_24475;
(statearr_24557[(26)] = inst_24359);

return statearr_24557;
})();
if(cljs.core.truth_(inst_24360)){
var statearr_24558_24653 = state_24475__$1;
(statearr_24558_24653[(1)] = (13));

} else {
var statearr_24559_24654 = state_24475__$1;
(statearr_24559_24654[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (18))){
var inst_24397 = (state_24475[(2)]);
var state_24475__$1 = state_24475;
var statearr_24560_24655 = state_24475__$1;
(statearr_24560_24655[(2)] = inst_24397);

(statearr_24560_24655[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (42))){
var state_24475__$1 = state_24475;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24475__$1,(45),dchan);
} else {
if((state_val_24476 === (37))){
var inst_24337 = (state_24475[(9)]);
var inst_24431 = (state_24475[(25)]);
var inst_24442 = (state_24475[(23)]);
var inst_24442__$1 = cljs.core.first.call(null,inst_24431);
var inst_24443 = cljs.core.async.put_BANG_.call(null,inst_24442__$1,inst_24337,done);
var state_24475__$1 = (function (){var statearr_24561 = state_24475;
(statearr_24561[(23)] = inst_24442__$1);

return statearr_24561;
})();
if(cljs.core.truth_(inst_24443)){
var statearr_24562_24656 = state_24475__$1;
(statearr_24562_24656[(1)] = (39));

} else {
var statearr_24563_24657 = state_24475__$1;
(statearr_24563_24657[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24476 === (8))){
var inst_24349 = (state_24475[(14)]);
var inst_24348 = (state_24475[(17)]);
var inst_24352 = (inst_24349 < inst_24348);
var inst_24353 = inst_24352;
var state_24475__$1 = state_24475;
if(cljs.core.truth_(inst_24353)){
var statearr_24564_24658 = state_24475__$1;
(statearr_24564_24658[(1)] = (10));

} else {
var statearr_24565_24659 = state_24475__$1;
(statearr_24565_24659[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto___24570,cs,m,dchan,dctr,done))
;
return ((function (switch__23144__auto__,c__23309__auto___24570,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__23145__auto__ = null;
var cljs$core$async$mult_$_state_machine__23145__auto____0 = (function (){
var statearr_24566 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24566[(0)] = cljs$core$async$mult_$_state_machine__23145__auto__);

(statearr_24566[(1)] = (1));

return statearr_24566;
});
var cljs$core$async$mult_$_state_machine__23145__auto____1 = (function (state_24475){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_24475);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e24567){if((e24567 instanceof Object)){
var ex__23148__auto__ = e24567;
var statearr_24568_24663 = state_24475;
(statearr_24568_24663[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24475);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24567;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24664 = state_24475;
state_24475 = G__24664;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__23145__auto__ = function(state_24475){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__23145__auto____1.call(this,state_24475);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__23145__auto____0;
cljs$core$async$mult_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__23145__auto____1;
return cljs$core$async$mult_$_state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto___24570,cs,m,dchan,dctr,done))
})();
var state__23311__auto__ = (function (){var statearr_24569 = f__23310__auto__.call(null);
(statearr_24569[(6)] = c__23309__auto___24570);

return statearr_24569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto___24570,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__24666 = arguments.length;
switch (G__24666) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m,ch);
} else {
var m__4212__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m,ch);
} else {
var m__4212__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m);
} else {
var m__4212__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m,state_map);
} else {
var m__4212__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m,mode);
} else {
var m__4212__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4502__auto__ = [];
var len__4499__auto___24703 = arguments.length;
var i__4500__auto___24704 = (0);
while(true){
if((i__4500__auto___24704 < len__4499__auto___24703)){
args__4502__auto__.push((arguments[i__4500__auto___24704]));

var G__24705 = (i__4500__auto___24704 + (1));
i__4500__auto___24704 = G__24705;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((3) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4503__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__24697){
var map__24698 = p__24697;
var map__24698__$1 = ((((!((map__24698 == null)))?(((((map__24698.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24698.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24698):map__24698);
var opts = map__24698__$1;
var statearr_24700_24706 = state;
(statearr_24700_24706[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts.call(null,((function (map__24698,map__24698__$1,opts){
return (function (val){
var statearr_24701_24707 = state;
(statearr_24701_24707[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__24698,map__24698__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_24702_24712 = state;
(statearr_24702_24712[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq24691){
var G__24692 = cljs.core.first.call(null,seq24691);
var seq24691__$1 = cljs.core.next.call(null,seq24691);
var G__24693 = cljs.core.first.call(null,seq24691__$1);
var seq24691__$2 = cljs.core.next.call(null,seq24691__$1);
var G__24694 = cljs.core.first.call(null,seq24691__$2);
var seq24691__$3 = cljs.core.next.call(null,seq24691__$2);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__24692,G__24693,G__24694,seq24691__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos)))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async24715 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24715 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta24716){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta24716 = meta24716;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async24715.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_24717,meta24716__$1){
var self__ = this;
var _24717__$1 = this;
return (new cljs.core.async.t_cljs$core$async24715(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta24716__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24715.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_24717){
var self__ = this;
var _24717__$1 = this;
return self__.meta24716;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24715.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24715.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24715.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24715.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24715.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24715.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24715.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24715.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24715.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta24716","meta24716",599821853,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24715.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24715.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24715";

cljs.core.async.t_cljs$core$async24715.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async24715");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24715.
 */
cljs.core.async.__GT_t_cljs$core$async24715 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async24715(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta24716){
return (new cljs.core.async.t_cljs$core$async24715(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta24716));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async24715(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__23309__auto___24940 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto___24940,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto___24940,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_24849){
var state_val_24850 = (state_24849[(1)]);
if((state_val_24850 === (7))){
var inst_24761 = (state_24849[(2)]);
var state_24849__$1 = state_24849;
var statearr_24851_24942 = state_24849__$1;
(statearr_24851_24942[(2)] = inst_24761);

(statearr_24851_24942[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (20))){
var inst_24773 = (state_24849[(7)]);
var state_24849__$1 = state_24849;
var statearr_24852_24944 = state_24849__$1;
(statearr_24852_24944[(2)] = inst_24773);

(statearr_24852_24944[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (27))){
var state_24849__$1 = state_24849;
var statearr_24853_24945 = state_24849__$1;
(statearr_24853_24945[(2)] = null);

(statearr_24853_24945[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (1))){
var inst_24748 = (state_24849[(8)]);
var inst_24748__$1 = calc_state.call(null);
var inst_24750 = (inst_24748__$1 == null);
var inst_24751 = cljs.core.not.call(null,inst_24750);
var state_24849__$1 = (function (){var statearr_24854 = state_24849;
(statearr_24854[(8)] = inst_24748__$1);

return statearr_24854;
})();
if(inst_24751){
var statearr_24855_24951 = state_24849__$1;
(statearr_24855_24951[(1)] = (2));

} else {
var statearr_24856_24952 = state_24849__$1;
(statearr_24856_24952[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (24))){
var inst_24797 = (state_24849[(9)]);
var inst_24806 = (state_24849[(10)]);
var inst_24823 = (state_24849[(11)]);
var inst_24823__$1 = inst_24797.call(null,inst_24806);
var state_24849__$1 = (function (){var statearr_24861 = state_24849;
(statearr_24861[(11)] = inst_24823__$1);

return statearr_24861;
})();
if(cljs.core.truth_(inst_24823__$1)){
var statearr_24862_24953 = state_24849__$1;
(statearr_24862_24953[(1)] = (29));

} else {
var statearr_24863_24954 = state_24849__$1;
(statearr_24863_24954[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (4))){
var inst_24764 = (state_24849[(2)]);
var state_24849__$1 = state_24849;
if(cljs.core.truth_(inst_24764)){
var statearr_24864_24955 = state_24849__$1;
(statearr_24864_24955[(1)] = (8));

} else {
var statearr_24866_24956 = state_24849__$1;
(statearr_24866_24956[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (15))){
var inst_24791 = (state_24849[(2)]);
var state_24849__$1 = state_24849;
if(cljs.core.truth_(inst_24791)){
var statearr_24867_24957 = state_24849__$1;
(statearr_24867_24957[(1)] = (19));

} else {
var statearr_24868_24958 = state_24849__$1;
(statearr_24868_24958[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (21))){
var inst_24796 = (state_24849[(12)]);
var inst_24796__$1 = (state_24849[(2)]);
var inst_24797 = cljs.core.get.call(null,inst_24796__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_24798 = cljs.core.get.call(null,inst_24796__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_24799 = cljs.core.get.call(null,inst_24796__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_24849__$1 = (function (){var statearr_24869 = state_24849;
(statearr_24869[(9)] = inst_24797);

(statearr_24869[(12)] = inst_24796__$1);

(statearr_24869[(13)] = inst_24798);

return statearr_24869;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_24849__$1,(22),inst_24799);
} else {
if((state_val_24850 === (31))){
var inst_24831 = (state_24849[(2)]);
var state_24849__$1 = state_24849;
if(cljs.core.truth_(inst_24831)){
var statearr_24873_24961 = state_24849__$1;
(statearr_24873_24961[(1)] = (32));

} else {
var statearr_24874_24962 = state_24849__$1;
(statearr_24874_24962[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (32))){
var inst_24805 = (state_24849[(14)]);
var state_24849__$1 = state_24849;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24849__$1,(35),out,inst_24805);
} else {
if((state_val_24850 === (33))){
var inst_24796 = (state_24849[(12)]);
var inst_24773 = inst_24796;
var state_24849__$1 = (function (){var statearr_24877 = state_24849;
(statearr_24877[(7)] = inst_24773);

return statearr_24877;
})();
var statearr_24878_24968 = state_24849__$1;
(statearr_24878_24968[(2)] = null);

(statearr_24878_24968[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (13))){
var inst_24773 = (state_24849[(7)]);
var inst_24780 = inst_24773.cljs$lang$protocol_mask$partition0$;
var inst_24781 = (inst_24780 & (64));
var inst_24782 = inst_24773.cljs$core$ISeq$;
var inst_24783 = (cljs.core.PROTOCOL_SENTINEL === inst_24782);
var inst_24784 = ((inst_24781) || (inst_24783));
var state_24849__$1 = state_24849;
if(cljs.core.truth_(inst_24784)){
var statearr_24879_24969 = state_24849__$1;
(statearr_24879_24969[(1)] = (16));

} else {
var statearr_24880_24970 = state_24849__$1;
(statearr_24880_24970[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (22))){
var inst_24805 = (state_24849[(14)]);
var inst_24806 = (state_24849[(10)]);
var inst_24804 = (state_24849[(2)]);
var inst_24805__$1 = cljs.core.nth.call(null,inst_24804,(0),null);
var inst_24806__$1 = cljs.core.nth.call(null,inst_24804,(1),null);
var inst_24807 = (inst_24805__$1 == null);
var inst_24808 = cljs.core._EQ_.call(null,inst_24806__$1,change);
var inst_24809 = ((inst_24807) || (inst_24808));
var state_24849__$1 = (function (){var statearr_24881 = state_24849;
(statearr_24881[(14)] = inst_24805__$1);

(statearr_24881[(10)] = inst_24806__$1);

return statearr_24881;
})();
if(cljs.core.truth_(inst_24809)){
var statearr_24883_24973 = state_24849__$1;
(statearr_24883_24973[(1)] = (23));

} else {
var statearr_24884_24974 = state_24849__$1;
(statearr_24884_24974[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (36))){
var inst_24796 = (state_24849[(12)]);
var inst_24773 = inst_24796;
var state_24849__$1 = (function (){var statearr_24885 = state_24849;
(statearr_24885[(7)] = inst_24773);

return statearr_24885;
})();
var statearr_24886_24976 = state_24849__$1;
(statearr_24886_24976[(2)] = null);

(statearr_24886_24976[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (29))){
var inst_24823 = (state_24849[(11)]);
var state_24849__$1 = state_24849;
var statearr_24887_24977 = state_24849__$1;
(statearr_24887_24977[(2)] = inst_24823);

(statearr_24887_24977[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (6))){
var state_24849__$1 = state_24849;
var statearr_24888_24978 = state_24849__$1;
(statearr_24888_24978[(2)] = false);

(statearr_24888_24978[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (28))){
var inst_24816 = (state_24849[(2)]);
var inst_24820 = calc_state.call(null);
var inst_24773 = inst_24820;
var state_24849__$1 = (function (){var statearr_24890 = state_24849;
(statearr_24890[(15)] = inst_24816);

(statearr_24890[(7)] = inst_24773);

return statearr_24890;
})();
var statearr_24891_24979 = state_24849__$1;
(statearr_24891_24979[(2)] = null);

(statearr_24891_24979[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (25))){
var inst_24845 = (state_24849[(2)]);
var state_24849__$1 = state_24849;
var statearr_24892_24980 = state_24849__$1;
(statearr_24892_24980[(2)] = inst_24845);

(statearr_24892_24980[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (34))){
var inst_24843 = (state_24849[(2)]);
var state_24849__$1 = state_24849;
var statearr_24893_24981 = state_24849__$1;
(statearr_24893_24981[(2)] = inst_24843);

(statearr_24893_24981[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (17))){
var state_24849__$1 = state_24849;
var statearr_24894_24982 = state_24849__$1;
(statearr_24894_24982[(2)] = false);

(statearr_24894_24982[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (3))){
var state_24849__$1 = state_24849;
var statearr_24895_24983 = state_24849__$1;
(statearr_24895_24983[(2)] = false);

(statearr_24895_24983[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (12))){
var inst_24847 = (state_24849[(2)]);
var state_24849__$1 = state_24849;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24849__$1,inst_24847);
} else {
if((state_val_24850 === (2))){
var inst_24748 = (state_24849[(8)]);
var inst_24753 = inst_24748.cljs$lang$protocol_mask$partition0$;
var inst_24754 = (inst_24753 & (64));
var inst_24755 = inst_24748.cljs$core$ISeq$;
var inst_24756 = (cljs.core.PROTOCOL_SENTINEL === inst_24755);
var inst_24757 = ((inst_24754) || (inst_24756));
var state_24849__$1 = state_24849;
if(cljs.core.truth_(inst_24757)){
var statearr_24896_24984 = state_24849__$1;
(statearr_24896_24984[(1)] = (5));

} else {
var statearr_24898_24985 = state_24849__$1;
(statearr_24898_24985[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (23))){
var inst_24805 = (state_24849[(14)]);
var inst_24811 = (inst_24805 == null);
var state_24849__$1 = state_24849;
if(cljs.core.truth_(inst_24811)){
var statearr_24900_24986 = state_24849__$1;
(statearr_24900_24986[(1)] = (26));

} else {
var statearr_24901_24987 = state_24849__$1;
(statearr_24901_24987[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (35))){
var inst_24834 = (state_24849[(2)]);
var state_24849__$1 = state_24849;
if(cljs.core.truth_(inst_24834)){
var statearr_24903_24990 = state_24849__$1;
(statearr_24903_24990[(1)] = (36));

} else {
var statearr_24904_24991 = state_24849__$1;
(statearr_24904_24991[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (19))){
var inst_24773 = (state_24849[(7)]);
var inst_24793 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24773);
var state_24849__$1 = state_24849;
var statearr_24905_24992 = state_24849__$1;
(statearr_24905_24992[(2)] = inst_24793);

(statearr_24905_24992[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (11))){
var inst_24773 = (state_24849[(7)]);
var inst_24777 = (inst_24773 == null);
var inst_24778 = cljs.core.not.call(null,inst_24777);
var state_24849__$1 = state_24849;
if(inst_24778){
var statearr_24906_25008 = state_24849__$1;
(statearr_24906_25008[(1)] = (13));

} else {
var statearr_24907_25009 = state_24849__$1;
(statearr_24907_25009[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (9))){
var inst_24748 = (state_24849[(8)]);
var state_24849__$1 = state_24849;
var statearr_24910_25010 = state_24849__$1;
(statearr_24910_25010[(2)] = inst_24748);

(statearr_24910_25010[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (5))){
var state_24849__$1 = state_24849;
var statearr_24911_25013 = state_24849__$1;
(statearr_24911_25013[(2)] = true);

(statearr_24911_25013[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (14))){
var state_24849__$1 = state_24849;
var statearr_24912_25014 = state_24849__$1;
(statearr_24912_25014[(2)] = false);

(statearr_24912_25014[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (26))){
var inst_24806 = (state_24849[(10)]);
var inst_24813 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_24806);
var state_24849__$1 = state_24849;
var statearr_24915_25018 = state_24849__$1;
(statearr_24915_25018[(2)] = inst_24813);

(statearr_24915_25018[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (16))){
var state_24849__$1 = state_24849;
var statearr_24916_25019 = state_24849__$1;
(statearr_24916_25019[(2)] = true);

(statearr_24916_25019[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (38))){
var inst_24839 = (state_24849[(2)]);
var state_24849__$1 = state_24849;
var statearr_24917_25020 = state_24849__$1;
(statearr_24917_25020[(2)] = inst_24839);

(statearr_24917_25020[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (30))){
var inst_24797 = (state_24849[(9)]);
var inst_24806 = (state_24849[(10)]);
var inst_24798 = (state_24849[(13)]);
var inst_24826 = cljs.core.empty_QMARK_.call(null,inst_24797);
var inst_24827 = inst_24798.call(null,inst_24806);
var inst_24828 = cljs.core.not.call(null,inst_24827);
var inst_24829 = ((inst_24826) && (inst_24828));
var state_24849__$1 = state_24849;
var statearr_24919_25021 = state_24849__$1;
(statearr_24919_25021[(2)] = inst_24829);

(statearr_24919_25021[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (10))){
var inst_24748 = (state_24849[(8)]);
var inst_24769 = (state_24849[(2)]);
var inst_24770 = cljs.core.get.call(null,inst_24769,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_24771 = cljs.core.get.call(null,inst_24769,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_24772 = cljs.core.get.call(null,inst_24769,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_24773 = inst_24748;
var state_24849__$1 = (function (){var statearr_24920 = state_24849;
(statearr_24920[(16)] = inst_24771);

(statearr_24920[(7)] = inst_24773);

(statearr_24920[(17)] = inst_24770);

(statearr_24920[(18)] = inst_24772);

return statearr_24920;
})();
var statearr_24921_25022 = state_24849__$1;
(statearr_24921_25022[(2)] = null);

(statearr_24921_25022[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (18))){
var inst_24788 = (state_24849[(2)]);
var state_24849__$1 = state_24849;
var statearr_24923_25025 = state_24849__$1;
(statearr_24923_25025[(2)] = inst_24788);

(statearr_24923_25025[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (37))){
var state_24849__$1 = state_24849;
var statearr_24924_25028 = state_24849__$1;
(statearr_24924_25028[(2)] = null);

(statearr_24924_25028[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24850 === (8))){
var inst_24748 = (state_24849[(8)]);
var inst_24766 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24748);
var state_24849__$1 = state_24849;
var statearr_24925_25029 = state_24849__$1;
(statearr_24925_25029[(2)] = inst_24766);

(statearr_24925_25029[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto___24940,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__23144__auto__,c__23309__auto___24940,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__23145__auto__ = null;
var cljs$core$async$mix_$_state_machine__23145__auto____0 = (function (){
var statearr_24926 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24926[(0)] = cljs$core$async$mix_$_state_machine__23145__auto__);

(statearr_24926[(1)] = (1));

return statearr_24926;
});
var cljs$core$async$mix_$_state_machine__23145__auto____1 = (function (state_24849){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_24849);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e24927){if((e24927 instanceof Object)){
var ex__23148__auto__ = e24927;
var statearr_24928_25035 = state_24849;
(statearr_24928_25035[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24849);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24927;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25037 = state_24849;
state_24849 = G__25037;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__23145__auto__ = function(state_24849){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__23145__auto____1.call(this,state_24849);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__23145__auto____0;
cljs$core$async$mix_$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__23145__auto____1;
return cljs$core$async$mix_$_state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto___24940,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__23311__auto__ = (function (){var statearr_24929 = f__23310__auto__.call(null);
(statearr_24929[(6)] = c__23309__auto___24940);

return statearr_24929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto___24940,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4211__auto__ = (((p == null))?null:p);
var m__4212__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4212__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4211__auto__ = (((p == null))?null:p);
var m__4212__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,p,v,ch);
} else {
var m__4212__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__25043 = arguments.length;
switch (G__25043) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4211__auto__ = (((p == null))?null:p);
var m__4212__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,p);
} else {
var m__4212__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4211__auto__ = (((p == null))?null:p);
var m__4212__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,p,v);
} else {
var m__4212__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__25056 = arguments.length;
switch (G__25056) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__3922__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__3922__auto__,mults){
return (function (p1__25054_SHARP_){
if(cljs.core.truth_(p1__25054_SHARP_.call(null,topic))){
return p1__25054_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__25054_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__3922__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async25057 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25057 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta25058){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta25058 = meta25058;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25057.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_25059,meta25058__$1){
var self__ = this;
var _25059__$1 = this;
return (new cljs.core.async.t_cljs$core$async25057(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta25058__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25057.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_25059){
var self__ = this;
var _25059__$1 = this;
return self__.meta25058;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25057.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25057.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25057.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25057.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25057.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25057.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25057.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25057.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta25058","meta25058",-1812985915,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25057.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25057.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25057";

cljs.core.async.t_cljs$core$async25057.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async25057");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25057.
 */
cljs.core.async.__GT_t_cljs$core$async25057 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async25057(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta25058){
return (new cljs.core.async.t_cljs$core$async25057(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta25058));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async25057(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__23309__auto___25243 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto___25243,mults,ensure_mult,p){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto___25243,mults,ensure_mult,p){
return (function (state_25147){
var state_val_25148 = (state_25147[(1)]);
if((state_val_25148 === (7))){
var inst_25142 = (state_25147[(2)]);
var state_25147__$1 = state_25147;
var statearr_25155_25255 = state_25147__$1;
(statearr_25155_25255[(2)] = inst_25142);

(statearr_25155_25255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (20))){
var state_25147__$1 = state_25147;
var statearr_25157_25259 = state_25147__$1;
(statearr_25157_25259[(2)] = null);

(statearr_25157_25259[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (1))){
var state_25147__$1 = state_25147;
var statearr_25158_25260 = state_25147__$1;
(statearr_25158_25260[(2)] = null);

(statearr_25158_25260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (24))){
var inst_25122 = (state_25147[(7)]);
var inst_25133 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_25122);
var state_25147__$1 = state_25147;
var statearr_25160_25266 = state_25147__$1;
(statearr_25160_25266[(2)] = inst_25133);

(statearr_25160_25266[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (4))){
var inst_25073 = (state_25147[(8)]);
var inst_25073__$1 = (state_25147[(2)]);
var inst_25074 = (inst_25073__$1 == null);
var state_25147__$1 = (function (){var statearr_25169 = state_25147;
(statearr_25169[(8)] = inst_25073__$1);

return statearr_25169;
})();
if(cljs.core.truth_(inst_25074)){
var statearr_25170_25286 = state_25147__$1;
(statearr_25170_25286[(1)] = (5));

} else {
var statearr_25171_25294 = state_25147__$1;
(statearr_25171_25294[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (15))){
var inst_25116 = (state_25147[(2)]);
var state_25147__$1 = state_25147;
var statearr_25179_25298 = state_25147__$1;
(statearr_25179_25298[(2)] = inst_25116);

(statearr_25179_25298[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (21))){
var inst_25138 = (state_25147[(2)]);
var state_25147__$1 = (function (){var statearr_25180 = state_25147;
(statearr_25180[(9)] = inst_25138);

return statearr_25180;
})();
var statearr_25181_25306 = state_25147__$1;
(statearr_25181_25306[(2)] = null);

(statearr_25181_25306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (13))){
var inst_25097 = (state_25147[(10)]);
var inst_25099 = cljs.core.chunked_seq_QMARK_.call(null,inst_25097);
var state_25147__$1 = state_25147;
if(inst_25099){
var statearr_25182_25314 = state_25147__$1;
(statearr_25182_25314[(1)] = (16));

} else {
var statearr_25183_25315 = state_25147__$1;
(statearr_25183_25315[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (22))){
var inst_25130 = (state_25147[(2)]);
var state_25147__$1 = state_25147;
if(cljs.core.truth_(inst_25130)){
var statearr_25184_25316 = state_25147__$1;
(statearr_25184_25316[(1)] = (23));

} else {
var statearr_25185_25317 = state_25147__$1;
(statearr_25185_25317[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (6))){
var inst_25124 = (state_25147[(11)]);
var inst_25073 = (state_25147[(8)]);
var inst_25122 = (state_25147[(7)]);
var inst_25122__$1 = topic_fn.call(null,inst_25073);
var inst_25123 = cljs.core.deref.call(null,mults);
var inst_25124__$1 = cljs.core.get.call(null,inst_25123,inst_25122__$1);
var state_25147__$1 = (function (){var statearr_25186 = state_25147;
(statearr_25186[(11)] = inst_25124__$1);

(statearr_25186[(7)] = inst_25122__$1);

return statearr_25186;
})();
if(cljs.core.truth_(inst_25124__$1)){
var statearr_25187_25324 = state_25147__$1;
(statearr_25187_25324[(1)] = (19));

} else {
var statearr_25188_25325 = state_25147__$1;
(statearr_25188_25325[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (25))){
var inst_25135 = (state_25147[(2)]);
var state_25147__$1 = state_25147;
var statearr_25189_25326 = state_25147__$1;
(statearr_25189_25326[(2)] = inst_25135);

(statearr_25189_25326[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (17))){
var inst_25097 = (state_25147[(10)]);
var inst_25106 = cljs.core.first.call(null,inst_25097);
var inst_25107 = cljs.core.async.muxch_STAR_.call(null,inst_25106);
var inst_25108 = cljs.core.async.close_BANG_.call(null,inst_25107);
var inst_25110 = cljs.core.next.call(null,inst_25097);
var inst_25083 = inst_25110;
var inst_25084 = null;
var inst_25085 = (0);
var inst_25086 = (0);
var state_25147__$1 = (function (){var statearr_25190 = state_25147;
(statearr_25190[(12)] = inst_25084);

(statearr_25190[(13)] = inst_25085);

(statearr_25190[(14)] = inst_25083);

(statearr_25190[(15)] = inst_25086);

(statearr_25190[(16)] = inst_25108);

return statearr_25190;
})();
var statearr_25191_25330 = state_25147__$1;
(statearr_25191_25330[(2)] = null);

(statearr_25191_25330[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (3))){
var inst_25144 = (state_25147[(2)]);
var state_25147__$1 = state_25147;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25147__$1,inst_25144);
} else {
if((state_val_25148 === (12))){
var inst_25118 = (state_25147[(2)]);
var state_25147__$1 = state_25147;
var statearr_25192_25334 = state_25147__$1;
(statearr_25192_25334[(2)] = inst_25118);

(statearr_25192_25334[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (2))){
var state_25147__$1 = state_25147;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25147__$1,(4),ch);
} else {
if((state_val_25148 === (23))){
var state_25147__$1 = state_25147;
var statearr_25196_25336 = state_25147__$1;
(statearr_25196_25336[(2)] = null);

(statearr_25196_25336[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (19))){
var inst_25124 = (state_25147[(11)]);
var inst_25073 = (state_25147[(8)]);
var inst_25128 = cljs.core.async.muxch_STAR_.call(null,inst_25124);
var state_25147__$1 = state_25147;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25147__$1,(22),inst_25128,inst_25073);
} else {
if((state_val_25148 === (11))){
var inst_25097 = (state_25147[(10)]);
var inst_25083 = (state_25147[(14)]);
var inst_25097__$1 = cljs.core.seq.call(null,inst_25083);
var state_25147__$1 = (function (){var statearr_25197 = state_25147;
(statearr_25197[(10)] = inst_25097__$1);

return statearr_25197;
})();
if(inst_25097__$1){
var statearr_25198_25339 = state_25147__$1;
(statearr_25198_25339[(1)] = (13));

} else {
var statearr_25199_25340 = state_25147__$1;
(statearr_25199_25340[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (9))){
var inst_25120 = (state_25147[(2)]);
var state_25147__$1 = state_25147;
var statearr_25200_25341 = state_25147__$1;
(statearr_25200_25341[(2)] = inst_25120);

(statearr_25200_25341[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (5))){
var inst_25080 = cljs.core.deref.call(null,mults);
var inst_25081 = cljs.core.vals.call(null,inst_25080);
var inst_25082 = cljs.core.seq.call(null,inst_25081);
var inst_25083 = inst_25082;
var inst_25084 = null;
var inst_25085 = (0);
var inst_25086 = (0);
var state_25147__$1 = (function (){var statearr_25201 = state_25147;
(statearr_25201[(12)] = inst_25084);

(statearr_25201[(13)] = inst_25085);

(statearr_25201[(14)] = inst_25083);

(statearr_25201[(15)] = inst_25086);

return statearr_25201;
})();
var statearr_25202_25344 = state_25147__$1;
(statearr_25202_25344[(2)] = null);

(statearr_25202_25344[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (14))){
var state_25147__$1 = state_25147;
var statearr_25206_25345 = state_25147__$1;
(statearr_25206_25345[(2)] = null);

(statearr_25206_25345[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (16))){
var inst_25097 = (state_25147[(10)]);
var inst_25101 = cljs.core.chunk_first.call(null,inst_25097);
var inst_25102 = cljs.core.chunk_rest.call(null,inst_25097);
var inst_25103 = cljs.core.count.call(null,inst_25101);
var inst_25083 = inst_25102;
var inst_25084 = inst_25101;
var inst_25085 = inst_25103;
var inst_25086 = (0);
var state_25147__$1 = (function (){var statearr_25207 = state_25147;
(statearr_25207[(12)] = inst_25084);

(statearr_25207[(13)] = inst_25085);

(statearr_25207[(14)] = inst_25083);

(statearr_25207[(15)] = inst_25086);

return statearr_25207;
})();
var statearr_25208_25349 = state_25147__$1;
(statearr_25208_25349[(2)] = null);

(statearr_25208_25349[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (10))){
var inst_25084 = (state_25147[(12)]);
var inst_25085 = (state_25147[(13)]);
var inst_25083 = (state_25147[(14)]);
var inst_25086 = (state_25147[(15)]);
var inst_25091 = cljs.core._nth.call(null,inst_25084,inst_25086);
var inst_25092 = cljs.core.async.muxch_STAR_.call(null,inst_25091);
var inst_25093 = cljs.core.async.close_BANG_.call(null,inst_25092);
var inst_25094 = (inst_25086 + (1));
var tmp25203 = inst_25084;
var tmp25204 = inst_25085;
var tmp25205 = inst_25083;
var inst_25083__$1 = tmp25205;
var inst_25084__$1 = tmp25203;
var inst_25085__$1 = tmp25204;
var inst_25086__$1 = inst_25094;
var state_25147__$1 = (function (){var statearr_25209 = state_25147;
(statearr_25209[(12)] = inst_25084__$1);

(statearr_25209[(13)] = inst_25085__$1);

(statearr_25209[(14)] = inst_25083__$1);

(statearr_25209[(17)] = inst_25093);

(statearr_25209[(15)] = inst_25086__$1);

return statearr_25209;
})();
var statearr_25213_25353 = state_25147__$1;
(statearr_25213_25353[(2)] = null);

(statearr_25213_25353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (18))){
var inst_25113 = (state_25147[(2)]);
var state_25147__$1 = state_25147;
var statearr_25214_25355 = state_25147__$1;
(statearr_25214_25355[(2)] = inst_25113);

(statearr_25214_25355[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25148 === (8))){
var inst_25085 = (state_25147[(13)]);
var inst_25086 = (state_25147[(15)]);
var inst_25088 = (inst_25086 < inst_25085);
var inst_25089 = inst_25088;
var state_25147__$1 = state_25147;
if(cljs.core.truth_(inst_25089)){
var statearr_25217_25356 = state_25147__$1;
(statearr_25217_25356[(1)] = (10));

} else {
var statearr_25218_25357 = state_25147__$1;
(statearr_25218_25357[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto___25243,mults,ensure_mult,p))
;
return ((function (switch__23144__auto__,c__23309__auto___25243,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__23145__auto__ = null;
var cljs$core$async$state_machine__23145__auto____0 = (function (){
var statearr_25219 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25219[(0)] = cljs$core$async$state_machine__23145__auto__);

(statearr_25219[(1)] = (1));

return statearr_25219;
});
var cljs$core$async$state_machine__23145__auto____1 = (function (state_25147){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_25147);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e25220){if((e25220 instanceof Object)){
var ex__23148__auto__ = e25220;
var statearr_25221_25359 = state_25147;
(statearr_25221_25359[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25147);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25220;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25360 = state_25147;
state_25147 = G__25360;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$state_machine__23145__auto__ = function(state_25147){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23145__auto____1.call(this,state_25147);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23145__auto____0;
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23145__auto____1;
return cljs$core$async$state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto___25243,mults,ensure_mult,p))
})();
var state__23311__auto__ = (function (){var statearr_25222 = f__23310__auto__.call(null);
(statearr_25222[(6)] = c__23309__auto___25243);

return statearr_25222;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto___25243,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__25363 = arguments.length;
switch (G__25363) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__25381 = arguments.length;
switch (G__25381) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__25386 = arguments.length;
switch (G__25386) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__23309__auto___25477 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto___25477,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto___25477,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_25430){
var state_val_25431 = (state_25430[(1)]);
if((state_val_25431 === (7))){
var state_25430__$1 = state_25430;
var statearr_25432_25479 = state_25430__$1;
(statearr_25432_25479[(2)] = null);

(statearr_25432_25479[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25431 === (1))){
var state_25430__$1 = state_25430;
var statearr_25433_25486 = state_25430__$1;
(statearr_25433_25486[(2)] = null);

(statearr_25433_25486[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25431 === (4))){
var inst_25393 = (state_25430[(7)]);
var inst_25395 = (inst_25393 < cnt);
var state_25430__$1 = state_25430;
if(cljs.core.truth_(inst_25395)){
var statearr_25435_25489 = state_25430__$1;
(statearr_25435_25489[(1)] = (6));

} else {
var statearr_25436_25491 = state_25430__$1;
(statearr_25436_25491[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25431 === (15))){
var inst_25426 = (state_25430[(2)]);
var state_25430__$1 = state_25430;
var statearr_25437_25492 = state_25430__$1;
(statearr_25437_25492[(2)] = inst_25426);

(statearr_25437_25492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25431 === (13))){
var inst_25419 = cljs.core.async.close_BANG_.call(null,out);
var state_25430__$1 = state_25430;
var statearr_25438_25493 = state_25430__$1;
(statearr_25438_25493[(2)] = inst_25419);

(statearr_25438_25493[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25431 === (6))){
var state_25430__$1 = state_25430;
var statearr_25439_25495 = state_25430__$1;
(statearr_25439_25495[(2)] = null);

(statearr_25439_25495[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25431 === (3))){
var inst_25428 = (state_25430[(2)]);
var state_25430__$1 = state_25430;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25430__$1,inst_25428);
} else {
if((state_val_25431 === (12))){
var inst_25416 = (state_25430[(8)]);
var inst_25416__$1 = (state_25430[(2)]);
var inst_25417 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_25416__$1);
var state_25430__$1 = (function (){var statearr_25445 = state_25430;
(statearr_25445[(8)] = inst_25416__$1);

return statearr_25445;
})();
if(cljs.core.truth_(inst_25417)){
var statearr_25446_25499 = state_25430__$1;
(statearr_25446_25499[(1)] = (13));

} else {
var statearr_25447_25500 = state_25430__$1;
(statearr_25447_25500[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25431 === (2))){
var inst_25392 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_25393 = (0);
var state_25430__$1 = (function (){var statearr_25448 = state_25430;
(statearr_25448[(9)] = inst_25392);

(statearr_25448[(7)] = inst_25393);

return statearr_25448;
})();
var statearr_25449_25502 = state_25430__$1;
(statearr_25449_25502[(2)] = null);

(statearr_25449_25502[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25431 === (11))){
var inst_25393 = (state_25430[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_25430,(10),Object,null,(9));
var inst_25402 = chs__$1.call(null,inst_25393);
var inst_25403 = done.call(null,inst_25393);
var inst_25404 = cljs.core.async.take_BANG_.call(null,inst_25402,inst_25403);
var state_25430__$1 = state_25430;
var statearr_25451_25505 = state_25430__$1;
(statearr_25451_25505[(2)] = inst_25404);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25430__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25431 === (9))){
var inst_25393 = (state_25430[(7)]);
var inst_25406 = (state_25430[(2)]);
var inst_25408 = (inst_25393 + (1));
var inst_25393__$1 = inst_25408;
var state_25430__$1 = (function (){var statearr_25453 = state_25430;
(statearr_25453[(10)] = inst_25406);

(statearr_25453[(7)] = inst_25393__$1);

return statearr_25453;
})();
var statearr_25454_25507 = state_25430__$1;
(statearr_25454_25507[(2)] = null);

(statearr_25454_25507[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25431 === (5))){
var inst_25414 = (state_25430[(2)]);
var state_25430__$1 = (function (){var statearr_25455 = state_25430;
(statearr_25455[(11)] = inst_25414);

return statearr_25455;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25430__$1,(12),dchan);
} else {
if((state_val_25431 === (14))){
var inst_25416 = (state_25430[(8)]);
var inst_25421 = cljs.core.apply.call(null,f,inst_25416);
var state_25430__$1 = state_25430;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25430__$1,(16),out,inst_25421);
} else {
if((state_val_25431 === (16))){
var inst_25423 = (state_25430[(2)]);
var state_25430__$1 = (function (){var statearr_25459 = state_25430;
(statearr_25459[(12)] = inst_25423);

return statearr_25459;
})();
var statearr_25460_25511 = state_25430__$1;
(statearr_25460_25511[(2)] = null);

(statearr_25460_25511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25431 === (10))){
var inst_25397 = (state_25430[(2)]);
var inst_25398 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_25430__$1 = (function (){var statearr_25461 = state_25430;
(statearr_25461[(13)] = inst_25397);

return statearr_25461;
})();
var statearr_25462_25513 = state_25430__$1;
(statearr_25462_25513[(2)] = inst_25398);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25430__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25431 === (8))){
var inst_25412 = (state_25430[(2)]);
var state_25430__$1 = state_25430;
var statearr_25463_25514 = state_25430__$1;
(statearr_25463_25514[(2)] = inst_25412);

(statearr_25463_25514[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto___25477,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__23144__auto__,c__23309__auto___25477,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__23145__auto__ = null;
var cljs$core$async$state_machine__23145__auto____0 = (function (){
var statearr_25464 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25464[(0)] = cljs$core$async$state_machine__23145__auto__);

(statearr_25464[(1)] = (1));

return statearr_25464;
});
var cljs$core$async$state_machine__23145__auto____1 = (function (state_25430){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_25430);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e25466){if((e25466 instanceof Object)){
var ex__23148__auto__ = e25466;
var statearr_25467_25519 = state_25430;
(statearr_25467_25519[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25430);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25466;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25520 = state_25430;
state_25430 = G__25520;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$state_machine__23145__auto__ = function(state_25430){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23145__auto____1.call(this,state_25430);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23145__auto____0;
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23145__auto____1;
return cljs$core$async$state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto___25477,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__23311__auto__ = (function (){var statearr_25468 = f__23310__auto__.call(null);
(statearr_25468[(6)] = c__23309__auto___25477);

return statearr_25468;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto___25477,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__25531 = arguments.length;
switch (G__25531) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23309__auto___25606 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto___25606,out){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto___25606,out){
return (function (state_25567){
var state_val_25568 = (state_25567[(1)]);
if((state_val_25568 === (7))){
var inst_25546 = (state_25567[(7)]);
var inst_25547 = (state_25567[(8)]);
var inst_25546__$1 = (state_25567[(2)]);
var inst_25547__$1 = cljs.core.nth.call(null,inst_25546__$1,(0),null);
var inst_25548 = cljs.core.nth.call(null,inst_25546__$1,(1),null);
var inst_25549 = (inst_25547__$1 == null);
var state_25567__$1 = (function (){var statearr_25572 = state_25567;
(statearr_25572[(7)] = inst_25546__$1);

(statearr_25572[(9)] = inst_25548);

(statearr_25572[(8)] = inst_25547__$1);

return statearr_25572;
})();
if(cljs.core.truth_(inst_25549)){
var statearr_25575_25611 = state_25567__$1;
(statearr_25575_25611[(1)] = (8));

} else {
var statearr_25576_25613 = state_25567__$1;
(statearr_25576_25613[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25568 === (1))){
var inst_25535 = cljs.core.vec.call(null,chs);
var inst_25536 = inst_25535;
var state_25567__$1 = (function (){var statearr_25577 = state_25567;
(statearr_25577[(10)] = inst_25536);

return statearr_25577;
})();
var statearr_25580_25616 = state_25567__$1;
(statearr_25580_25616[(2)] = null);

(statearr_25580_25616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25568 === (4))){
var inst_25536 = (state_25567[(10)]);
var state_25567__$1 = state_25567;
return cljs.core.async.ioc_alts_BANG_.call(null,state_25567__$1,(7),inst_25536);
} else {
if((state_val_25568 === (6))){
var inst_25563 = (state_25567[(2)]);
var state_25567__$1 = state_25567;
var statearr_25581_25621 = state_25567__$1;
(statearr_25581_25621[(2)] = inst_25563);

(statearr_25581_25621[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25568 === (3))){
var inst_25565 = (state_25567[(2)]);
var state_25567__$1 = state_25567;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25567__$1,inst_25565);
} else {
if((state_val_25568 === (2))){
var inst_25536 = (state_25567[(10)]);
var inst_25538 = cljs.core.count.call(null,inst_25536);
var inst_25539 = (inst_25538 > (0));
var state_25567__$1 = state_25567;
if(cljs.core.truth_(inst_25539)){
var statearr_25584_25625 = state_25567__$1;
(statearr_25584_25625[(1)] = (4));

} else {
var statearr_25585_25626 = state_25567__$1;
(statearr_25585_25626[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25568 === (11))){
var inst_25536 = (state_25567[(10)]);
var inst_25556 = (state_25567[(2)]);
var tmp25583 = inst_25536;
var inst_25536__$1 = tmp25583;
var state_25567__$1 = (function (){var statearr_25589 = state_25567;
(statearr_25589[(10)] = inst_25536__$1);

(statearr_25589[(11)] = inst_25556);

return statearr_25589;
})();
var statearr_25590_25630 = state_25567__$1;
(statearr_25590_25630[(2)] = null);

(statearr_25590_25630[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25568 === (9))){
var inst_25547 = (state_25567[(8)]);
var state_25567__$1 = state_25567;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25567__$1,(11),out,inst_25547);
} else {
if((state_val_25568 === (5))){
var inst_25561 = cljs.core.async.close_BANG_.call(null,out);
var state_25567__$1 = state_25567;
var statearr_25591_25632 = state_25567__$1;
(statearr_25591_25632[(2)] = inst_25561);

(statearr_25591_25632[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25568 === (10))){
var inst_25559 = (state_25567[(2)]);
var state_25567__$1 = state_25567;
var statearr_25593_25634 = state_25567__$1;
(statearr_25593_25634[(2)] = inst_25559);

(statearr_25593_25634[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25568 === (8))){
var inst_25546 = (state_25567[(7)]);
var inst_25536 = (state_25567[(10)]);
var inst_25548 = (state_25567[(9)]);
var inst_25547 = (state_25567[(8)]);
var inst_25551 = (function (){var cs = inst_25536;
var vec__25541 = inst_25546;
var v = inst_25547;
var c = inst_25548;
return ((function (cs,vec__25541,v,c,inst_25546,inst_25536,inst_25548,inst_25547,state_val_25568,c__23309__auto___25606,out){
return (function (p1__25529_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__25529_SHARP_);
});
;})(cs,vec__25541,v,c,inst_25546,inst_25536,inst_25548,inst_25547,state_val_25568,c__23309__auto___25606,out))
})();
var inst_25552 = cljs.core.filterv.call(null,inst_25551,inst_25536);
var inst_25536__$1 = inst_25552;
var state_25567__$1 = (function (){var statearr_25594 = state_25567;
(statearr_25594[(10)] = inst_25536__$1);

return statearr_25594;
})();
var statearr_25595_25641 = state_25567__$1;
(statearr_25595_25641[(2)] = null);

(statearr_25595_25641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto___25606,out))
;
return ((function (switch__23144__auto__,c__23309__auto___25606,out){
return (function() {
var cljs$core$async$state_machine__23145__auto__ = null;
var cljs$core$async$state_machine__23145__auto____0 = (function (){
var statearr_25598 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25598[(0)] = cljs$core$async$state_machine__23145__auto__);

(statearr_25598[(1)] = (1));

return statearr_25598;
});
var cljs$core$async$state_machine__23145__auto____1 = (function (state_25567){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_25567);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e25600){if((e25600 instanceof Object)){
var ex__23148__auto__ = e25600;
var statearr_25601_25654 = state_25567;
(statearr_25601_25654[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25567);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25600;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25655 = state_25567;
state_25567 = G__25655;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$state_machine__23145__auto__ = function(state_25567){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23145__auto____1.call(this,state_25567);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23145__auto____0;
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23145__auto____1;
return cljs$core$async$state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto___25606,out))
})();
var state__23311__auto__ = (function (){var statearr_25602 = f__23310__auto__.call(null);
(statearr_25602[(6)] = c__23309__auto___25606);

return statearr_25602;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto___25606,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__25661 = arguments.length;
switch (G__25661) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23309__auto___25735 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto___25735,out){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto___25735,out){
return (function (state_25691){
var state_val_25692 = (state_25691[(1)]);
if((state_val_25692 === (7))){
var inst_25673 = (state_25691[(7)]);
var inst_25673__$1 = (state_25691[(2)]);
var inst_25674 = (inst_25673__$1 == null);
var inst_25675 = cljs.core.not.call(null,inst_25674);
var state_25691__$1 = (function (){var statearr_25694 = state_25691;
(statearr_25694[(7)] = inst_25673__$1);

return statearr_25694;
})();
if(inst_25675){
var statearr_25695_25736 = state_25691__$1;
(statearr_25695_25736[(1)] = (8));

} else {
var statearr_25696_25737 = state_25691__$1;
(statearr_25696_25737[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25692 === (1))){
var inst_25668 = (0);
var state_25691__$1 = (function (){var statearr_25697 = state_25691;
(statearr_25697[(8)] = inst_25668);

return statearr_25697;
})();
var statearr_25698_25739 = state_25691__$1;
(statearr_25698_25739[(2)] = null);

(statearr_25698_25739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25692 === (4))){
var state_25691__$1 = state_25691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25691__$1,(7),ch);
} else {
if((state_val_25692 === (6))){
var inst_25686 = (state_25691[(2)]);
var state_25691__$1 = state_25691;
var statearr_25701_25740 = state_25691__$1;
(statearr_25701_25740[(2)] = inst_25686);

(statearr_25701_25740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25692 === (3))){
var inst_25688 = (state_25691[(2)]);
var inst_25689 = cljs.core.async.close_BANG_.call(null,out);
var state_25691__$1 = (function (){var statearr_25703 = state_25691;
(statearr_25703[(9)] = inst_25688);

return statearr_25703;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25691__$1,inst_25689);
} else {
if((state_val_25692 === (2))){
var inst_25668 = (state_25691[(8)]);
var inst_25670 = (inst_25668 < n);
var state_25691__$1 = state_25691;
if(cljs.core.truth_(inst_25670)){
var statearr_25704_25741 = state_25691__$1;
(statearr_25704_25741[(1)] = (4));

} else {
var statearr_25705_25742 = state_25691__$1;
(statearr_25705_25742[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25692 === (11))){
var inst_25668 = (state_25691[(8)]);
var inst_25678 = (state_25691[(2)]);
var inst_25679 = (inst_25668 + (1));
var inst_25668__$1 = inst_25679;
var state_25691__$1 = (function (){var statearr_25709 = state_25691;
(statearr_25709[(8)] = inst_25668__$1);

(statearr_25709[(10)] = inst_25678);

return statearr_25709;
})();
var statearr_25710_25744 = state_25691__$1;
(statearr_25710_25744[(2)] = null);

(statearr_25710_25744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25692 === (9))){
var state_25691__$1 = state_25691;
var statearr_25714_25745 = state_25691__$1;
(statearr_25714_25745[(2)] = null);

(statearr_25714_25745[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25692 === (5))){
var state_25691__$1 = state_25691;
var statearr_25715_25746 = state_25691__$1;
(statearr_25715_25746[(2)] = null);

(statearr_25715_25746[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25692 === (10))){
var inst_25683 = (state_25691[(2)]);
var state_25691__$1 = state_25691;
var statearr_25716_25747 = state_25691__$1;
(statearr_25716_25747[(2)] = inst_25683);

(statearr_25716_25747[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25692 === (8))){
var inst_25673 = (state_25691[(7)]);
var state_25691__$1 = state_25691;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25691__$1,(11),out,inst_25673);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto___25735,out))
;
return ((function (switch__23144__auto__,c__23309__auto___25735,out){
return (function() {
var cljs$core$async$state_machine__23145__auto__ = null;
var cljs$core$async$state_machine__23145__auto____0 = (function (){
var statearr_25719 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25719[(0)] = cljs$core$async$state_machine__23145__auto__);

(statearr_25719[(1)] = (1));

return statearr_25719;
});
var cljs$core$async$state_machine__23145__auto____1 = (function (state_25691){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_25691);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e25720){if((e25720 instanceof Object)){
var ex__23148__auto__ = e25720;
var statearr_25724_25752 = state_25691;
(statearr_25724_25752[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25691);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25720;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25754 = state_25691;
state_25691 = G__25754;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$state_machine__23145__auto__ = function(state_25691){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23145__auto____1.call(this,state_25691);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23145__auto____0;
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23145__auto____1;
return cljs$core$async$state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto___25735,out))
})();
var state__23311__auto__ = (function (){var statearr_25726 = f__23310__auto__.call(null);
(statearr_25726[(6)] = c__23309__auto___25735);

return statearr_25726;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto___25735,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async25757 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25757 = (function (f,ch,meta25758){
this.f = f;
this.ch = ch;
this.meta25758 = meta25758;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25757.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25759,meta25758__$1){
var self__ = this;
var _25759__$1 = this;
return (new cljs.core.async.t_cljs$core$async25757(self__.f,self__.ch,meta25758__$1));
});

cljs.core.async.t_cljs$core$async25757.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25759){
var self__ = this;
var _25759__$1 = this;
return self__.meta25758;
});

cljs.core.async.t_cljs$core$async25757.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25757.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25757.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25757.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25757.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async25762 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25762 = (function (f,ch,meta25758,_,fn1,meta25763){
this.f = f;
this.ch = ch;
this.meta25758 = meta25758;
this._ = _;
this.fn1 = fn1;
this.meta25763 = meta25763;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25762.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_25764,meta25763__$1){
var self__ = this;
var _25764__$1 = this;
return (new cljs.core.async.t_cljs$core$async25762(self__.f,self__.ch,self__.meta25758,self__._,self__.fn1,meta25763__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async25762.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_25764){
var self__ = this;
var _25764__$1 = this;
return self__.meta25763;
});})(___$1))
;

cljs.core.async.t_cljs$core$async25762.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25762.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async25762.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async25762.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__25756_SHARP_){
return f1.call(null,(((p1__25756_SHARP_ == null))?null:self__.f.call(null,p1__25756_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async25762.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25758","meta25758",-1044624166,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async25757","cljs.core.async/t_cljs$core$async25757",661172501,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta25763","meta25763",-454238064,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async25762.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25762.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25762";

cljs.core.async.t_cljs$core$async25762.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async25762");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25762.
 */
cljs.core.async.__GT_t_cljs$core$async25762 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async25762(f__$1,ch__$1,meta25758__$1,___$2,fn1__$1,meta25763){
return (new cljs.core.async.t_cljs$core$async25762(f__$1,ch__$1,meta25758__$1,___$2,fn1__$1,meta25763));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async25762(self__.f,self__.ch,self__.meta25758,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__3911__auto__ = ret;
if(cljs.core.truth_(and__3911__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__3911__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async25757.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25757.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async25757.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25758","meta25758",-1044624166,null)], null);
});

cljs.core.async.t_cljs$core$async25757.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25757.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25757";

cljs.core.async.t_cljs$core$async25757.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async25757");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25757.
 */
cljs.core.async.__GT_t_cljs$core$async25757 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async25757(f__$1,ch__$1,meta25758){
return (new cljs.core.async.t_cljs$core$async25757(f__$1,ch__$1,meta25758));
});

}

return (new cljs.core.async.t_cljs$core$async25757(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async25778 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25778 = (function (f,ch,meta25779){
this.f = f;
this.ch = ch;
this.meta25779 = meta25779;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25778.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25780,meta25779__$1){
var self__ = this;
var _25780__$1 = this;
return (new cljs.core.async.t_cljs$core$async25778(self__.f,self__.ch,meta25779__$1));
});

cljs.core.async.t_cljs$core$async25778.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25780){
var self__ = this;
var _25780__$1 = this;
return self__.meta25779;
});

cljs.core.async.t_cljs$core$async25778.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25778.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25778.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25778.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async25778.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25778.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async25778.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25779","meta25779",687446187,null)], null);
});

cljs.core.async.t_cljs$core$async25778.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25778.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25778";

cljs.core.async.t_cljs$core$async25778.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async25778");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25778.
 */
cljs.core.async.__GT_t_cljs$core$async25778 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async25778(f__$1,ch__$1,meta25779){
return (new cljs.core.async.t_cljs$core$async25778(f__$1,ch__$1,meta25779));
});

}

return (new cljs.core.async.t_cljs$core$async25778(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async25808 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25808 = (function (p,ch,meta25809){
this.p = p;
this.ch = ch;
this.meta25809 = meta25809;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25808.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25810,meta25809__$1){
var self__ = this;
var _25810__$1 = this;
return (new cljs.core.async.t_cljs$core$async25808(self__.p,self__.ch,meta25809__$1));
});

cljs.core.async.t_cljs$core$async25808.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25810){
var self__ = this;
var _25810__$1 = this;
return self__.meta25809;
});

cljs.core.async.t_cljs$core$async25808.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25808.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25808.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25808.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25808.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async25808.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25808.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async25808.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25809","meta25809",-456061059,null)], null);
});

cljs.core.async.t_cljs$core$async25808.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25808.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25808";

cljs.core.async.t_cljs$core$async25808.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async25808");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25808.
 */
cljs.core.async.__GT_t_cljs$core$async25808 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async25808(p__$1,ch__$1,meta25809){
return (new cljs.core.async.t_cljs$core$async25808(p__$1,ch__$1,meta25809));
});

}

return (new cljs.core.async.t_cljs$core$async25808(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__25868 = arguments.length;
switch (G__25868) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23309__auto___25926 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto___25926,out){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto___25926,out){
return (function (state_25890){
var state_val_25891 = (state_25890[(1)]);
if((state_val_25891 === (7))){
var inst_25886 = (state_25890[(2)]);
var state_25890__$1 = state_25890;
var statearr_25894_25928 = state_25890__$1;
(statearr_25894_25928[(2)] = inst_25886);

(statearr_25894_25928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25891 === (1))){
var state_25890__$1 = state_25890;
var statearr_25896_25936 = state_25890__$1;
(statearr_25896_25936[(2)] = null);

(statearr_25896_25936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25891 === (4))){
var inst_25872 = (state_25890[(7)]);
var inst_25872__$1 = (state_25890[(2)]);
var inst_25873 = (inst_25872__$1 == null);
var state_25890__$1 = (function (){var statearr_25897 = state_25890;
(statearr_25897[(7)] = inst_25872__$1);

return statearr_25897;
})();
if(cljs.core.truth_(inst_25873)){
var statearr_25898_25939 = state_25890__$1;
(statearr_25898_25939[(1)] = (5));

} else {
var statearr_25899_25940 = state_25890__$1;
(statearr_25899_25940[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25891 === (6))){
var inst_25872 = (state_25890[(7)]);
var inst_25877 = p.call(null,inst_25872);
var state_25890__$1 = state_25890;
if(cljs.core.truth_(inst_25877)){
var statearr_25900_25941 = state_25890__$1;
(statearr_25900_25941[(1)] = (8));

} else {
var statearr_25901_25943 = state_25890__$1;
(statearr_25901_25943[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25891 === (3))){
var inst_25888 = (state_25890[(2)]);
var state_25890__$1 = state_25890;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25890__$1,inst_25888);
} else {
if((state_val_25891 === (2))){
var state_25890__$1 = state_25890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25890__$1,(4),ch);
} else {
if((state_val_25891 === (11))){
var inst_25880 = (state_25890[(2)]);
var state_25890__$1 = state_25890;
var statearr_25903_25947 = state_25890__$1;
(statearr_25903_25947[(2)] = inst_25880);

(statearr_25903_25947[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25891 === (9))){
var state_25890__$1 = state_25890;
var statearr_25904_25948 = state_25890__$1;
(statearr_25904_25948[(2)] = null);

(statearr_25904_25948[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25891 === (5))){
var inst_25875 = cljs.core.async.close_BANG_.call(null,out);
var state_25890__$1 = state_25890;
var statearr_25905_25949 = state_25890__$1;
(statearr_25905_25949[(2)] = inst_25875);

(statearr_25905_25949[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25891 === (10))){
var inst_25883 = (state_25890[(2)]);
var state_25890__$1 = (function (){var statearr_25912 = state_25890;
(statearr_25912[(8)] = inst_25883);

return statearr_25912;
})();
var statearr_25914_25951 = state_25890__$1;
(statearr_25914_25951[(2)] = null);

(statearr_25914_25951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25891 === (8))){
var inst_25872 = (state_25890[(7)]);
var state_25890__$1 = state_25890;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25890__$1,(11),out,inst_25872);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto___25926,out))
;
return ((function (switch__23144__auto__,c__23309__auto___25926,out){
return (function() {
var cljs$core$async$state_machine__23145__auto__ = null;
var cljs$core$async$state_machine__23145__auto____0 = (function (){
var statearr_25916 = [null,null,null,null,null,null,null,null,null];
(statearr_25916[(0)] = cljs$core$async$state_machine__23145__auto__);

(statearr_25916[(1)] = (1));

return statearr_25916;
});
var cljs$core$async$state_machine__23145__auto____1 = (function (state_25890){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_25890);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e25917){if((e25917 instanceof Object)){
var ex__23148__auto__ = e25917;
var statearr_25918_25964 = state_25890;
(statearr_25918_25964[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25890);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25917;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25966 = state_25890;
state_25890 = G__25966;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$state_machine__23145__auto__ = function(state_25890){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23145__auto____1.call(this,state_25890);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23145__auto____0;
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23145__auto____1;
return cljs$core$async$state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto___25926,out))
})();
var state__23311__auto__ = (function (){var statearr_25919 = f__23310__auto__.call(null);
(statearr_25919[(6)] = c__23309__auto___25926);

return statearr_25919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto___25926,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__25971 = arguments.length;
switch (G__25971) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__23309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto__){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto__){
return (function (state_26047){
var state_val_26048 = (state_26047[(1)]);
if((state_val_26048 === (7))){
var inst_26041 = (state_26047[(2)]);
var state_26047__$1 = state_26047;
var statearr_26053_26123 = state_26047__$1;
(statearr_26053_26123[(2)] = inst_26041);

(statearr_26053_26123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26048 === (20))){
var inst_26011 = (state_26047[(7)]);
var inst_26022 = (state_26047[(2)]);
var inst_26023 = cljs.core.next.call(null,inst_26011);
var inst_25993 = inst_26023;
var inst_25994 = null;
var inst_25995 = (0);
var inst_25996 = (0);
var state_26047__$1 = (function (){var statearr_26054 = state_26047;
(statearr_26054[(8)] = inst_25995);

(statearr_26054[(9)] = inst_26022);

(statearr_26054[(10)] = inst_25993);

(statearr_26054[(11)] = inst_25994);

(statearr_26054[(12)] = inst_25996);

return statearr_26054;
})();
var statearr_26056_26130 = state_26047__$1;
(statearr_26056_26130[(2)] = null);

(statearr_26056_26130[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26048 === (1))){
var state_26047__$1 = state_26047;
var statearr_26057_26137 = state_26047__$1;
(statearr_26057_26137[(2)] = null);

(statearr_26057_26137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26048 === (4))){
var inst_25982 = (state_26047[(13)]);
var inst_25982__$1 = (state_26047[(2)]);
var inst_25983 = (inst_25982__$1 == null);
var state_26047__$1 = (function (){var statearr_26058 = state_26047;
(statearr_26058[(13)] = inst_25982__$1);

return statearr_26058;
})();
if(cljs.core.truth_(inst_25983)){
var statearr_26059_26138 = state_26047__$1;
(statearr_26059_26138[(1)] = (5));

} else {
var statearr_26060_26140 = state_26047__$1;
(statearr_26060_26140[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26048 === (15))){
var state_26047__$1 = state_26047;
var statearr_26065_26141 = state_26047__$1;
(statearr_26065_26141[(2)] = null);

(statearr_26065_26141[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26048 === (21))){
var state_26047__$1 = state_26047;
var statearr_26067_26142 = state_26047__$1;
(statearr_26067_26142[(2)] = null);

(statearr_26067_26142[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26048 === (13))){
var inst_25995 = (state_26047[(8)]);
var inst_25993 = (state_26047[(10)]);
var inst_25994 = (state_26047[(11)]);
var inst_25996 = (state_26047[(12)]);
var inst_26006 = (state_26047[(2)]);
var inst_26007 = (inst_25996 + (1));
var tmp26061 = inst_25995;
var tmp26062 = inst_25993;
var tmp26063 = inst_25994;
var inst_25993__$1 = tmp26062;
var inst_25994__$1 = tmp26063;
var inst_25995__$1 = tmp26061;
var inst_25996__$1 = inst_26007;
var state_26047__$1 = (function (){var statearr_26075 = state_26047;
(statearr_26075[(14)] = inst_26006);

(statearr_26075[(8)] = inst_25995__$1);

(statearr_26075[(10)] = inst_25993__$1);

(statearr_26075[(11)] = inst_25994__$1);

(statearr_26075[(12)] = inst_25996__$1);

return statearr_26075;
})();
var statearr_26076_26147 = state_26047__$1;
(statearr_26076_26147[(2)] = null);

(statearr_26076_26147[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26048 === (22))){
var state_26047__$1 = state_26047;
var statearr_26077_26148 = state_26047__$1;
(statearr_26077_26148[(2)] = null);

(statearr_26077_26148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26048 === (6))){
var inst_25982 = (state_26047[(13)]);
var inst_25991 = f.call(null,inst_25982);
var inst_25992 = cljs.core.seq.call(null,inst_25991);
var inst_25993 = inst_25992;
var inst_25994 = null;
var inst_25995 = (0);
var inst_25996 = (0);
var state_26047__$1 = (function (){var statearr_26078 = state_26047;
(statearr_26078[(8)] = inst_25995);

(statearr_26078[(10)] = inst_25993);

(statearr_26078[(11)] = inst_25994);

(statearr_26078[(12)] = inst_25996);

return statearr_26078;
})();
var statearr_26080_26155 = state_26047__$1;
(statearr_26080_26155[(2)] = null);

(statearr_26080_26155[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26048 === (17))){
var inst_26011 = (state_26047[(7)]);
var inst_26015 = cljs.core.chunk_first.call(null,inst_26011);
var inst_26016 = cljs.core.chunk_rest.call(null,inst_26011);
var inst_26017 = cljs.core.count.call(null,inst_26015);
var inst_25993 = inst_26016;
var inst_25994 = inst_26015;
var inst_25995 = inst_26017;
var inst_25996 = (0);
var state_26047__$1 = (function (){var statearr_26081 = state_26047;
(statearr_26081[(8)] = inst_25995);

(statearr_26081[(10)] = inst_25993);

(statearr_26081[(11)] = inst_25994);

(statearr_26081[(12)] = inst_25996);

return statearr_26081;
})();
var statearr_26082_26164 = state_26047__$1;
(statearr_26082_26164[(2)] = null);

(statearr_26082_26164[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26048 === (3))){
var inst_26043 = (state_26047[(2)]);
var state_26047__$1 = state_26047;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26047__$1,inst_26043);
} else {
if((state_val_26048 === (12))){
var inst_26031 = (state_26047[(2)]);
var state_26047__$1 = state_26047;
var statearr_26086_26168 = state_26047__$1;
(statearr_26086_26168[(2)] = inst_26031);

(statearr_26086_26168[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26048 === (2))){
var state_26047__$1 = state_26047;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26047__$1,(4),in$);
} else {
if((state_val_26048 === (23))){
var inst_26039 = (state_26047[(2)]);
var state_26047__$1 = state_26047;
var statearr_26087_26169 = state_26047__$1;
(statearr_26087_26169[(2)] = inst_26039);

(statearr_26087_26169[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26048 === (19))){
var inst_26026 = (state_26047[(2)]);
var state_26047__$1 = state_26047;
var statearr_26088_26172 = state_26047__$1;
(statearr_26088_26172[(2)] = inst_26026);

(statearr_26088_26172[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26048 === (11))){
var inst_25993 = (state_26047[(10)]);
var inst_26011 = (state_26047[(7)]);
var inst_26011__$1 = cljs.core.seq.call(null,inst_25993);
var state_26047__$1 = (function (){var statearr_26089 = state_26047;
(statearr_26089[(7)] = inst_26011__$1);

return statearr_26089;
})();
if(inst_26011__$1){
var statearr_26090_26174 = state_26047__$1;
(statearr_26090_26174[(1)] = (14));

} else {
var statearr_26091_26178 = state_26047__$1;
(statearr_26091_26178[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26048 === (9))){
var inst_26033 = (state_26047[(2)]);
var inst_26034 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_26047__$1 = (function (){var statearr_26093 = state_26047;
(statearr_26093[(15)] = inst_26033);

return statearr_26093;
})();
if(cljs.core.truth_(inst_26034)){
var statearr_26094_26180 = state_26047__$1;
(statearr_26094_26180[(1)] = (21));

} else {
var statearr_26095_26181 = state_26047__$1;
(statearr_26095_26181[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26048 === (5))){
var inst_25985 = cljs.core.async.close_BANG_.call(null,out);
var state_26047__$1 = state_26047;
var statearr_26099_26182 = state_26047__$1;
(statearr_26099_26182[(2)] = inst_25985);

(statearr_26099_26182[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26048 === (14))){
var inst_26011 = (state_26047[(7)]);
var inst_26013 = cljs.core.chunked_seq_QMARK_.call(null,inst_26011);
var state_26047__$1 = state_26047;
if(inst_26013){
var statearr_26102_26183 = state_26047__$1;
(statearr_26102_26183[(1)] = (17));

} else {
var statearr_26109_26187 = state_26047__$1;
(statearr_26109_26187[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26048 === (16))){
var inst_26029 = (state_26047[(2)]);
var state_26047__$1 = state_26047;
var statearr_26111_26188 = state_26047__$1;
(statearr_26111_26188[(2)] = inst_26029);

(statearr_26111_26188[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26048 === (10))){
var inst_25994 = (state_26047[(11)]);
var inst_25996 = (state_26047[(12)]);
var inst_26004 = cljs.core._nth.call(null,inst_25994,inst_25996);
var state_26047__$1 = state_26047;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26047__$1,(13),out,inst_26004);
} else {
if((state_val_26048 === (18))){
var inst_26011 = (state_26047[(7)]);
var inst_26020 = cljs.core.first.call(null,inst_26011);
var state_26047__$1 = state_26047;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26047__$1,(20),out,inst_26020);
} else {
if((state_val_26048 === (8))){
var inst_25995 = (state_26047[(8)]);
var inst_25996 = (state_26047[(12)]);
var inst_26001 = (inst_25996 < inst_25995);
var inst_26002 = inst_26001;
var state_26047__$1 = state_26047;
if(cljs.core.truth_(inst_26002)){
var statearr_26112_26201 = state_26047__$1;
(statearr_26112_26201[(1)] = (10));

} else {
var statearr_26113_26202 = state_26047__$1;
(statearr_26113_26202[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto__))
;
return ((function (switch__23144__auto__,c__23309__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__23145__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__23145__auto____0 = (function (){
var statearr_26115 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26115[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__23145__auto__);

(statearr_26115[(1)] = (1));

return statearr_26115;
});
var cljs$core$async$mapcat_STAR__$_state_machine__23145__auto____1 = (function (state_26047){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_26047);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e26116){if((e26116 instanceof Object)){
var ex__23148__auto__ = e26116;
var statearr_26117_26203 = state_26047;
(statearr_26117_26203[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26047);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26116;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26204 = state_26047;
state_26047 = G__26204;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__23145__auto__ = function(state_26047){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__23145__auto____1.call(this,state_26047);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__23145__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__23145__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto__))
})();
var state__23311__auto__ = (function (){var statearr_26121 = f__23310__auto__.call(null);
(statearr_26121[(6)] = c__23309__auto__);

return statearr_26121;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto__))
);

return c__23309__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__26206 = arguments.length;
switch (G__26206) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__26209 = arguments.length;
switch (G__26209) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__26214 = arguments.length;
switch (G__26214) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23309__auto___26272 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto___26272,out){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto___26272,out){
return (function (state_26238){
var state_val_26239 = (state_26238[(1)]);
if((state_val_26239 === (7))){
var inst_26233 = (state_26238[(2)]);
var state_26238__$1 = state_26238;
var statearr_26240_26276 = state_26238__$1;
(statearr_26240_26276[(2)] = inst_26233);

(statearr_26240_26276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26239 === (1))){
var inst_26215 = null;
var state_26238__$1 = (function (){var statearr_26241 = state_26238;
(statearr_26241[(7)] = inst_26215);

return statearr_26241;
})();
var statearr_26242_26277 = state_26238__$1;
(statearr_26242_26277[(2)] = null);

(statearr_26242_26277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26239 === (4))){
var inst_26218 = (state_26238[(8)]);
var inst_26218__$1 = (state_26238[(2)]);
var inst_26219 = (inst_26218__$1 == null);
var inst_26220 = cljs.core.not.call(null,inst_26219);
var state_26238__$1 = (function (){var statearr_26243 = state_26238;
(statearr_26243[(8)] = inst_26218__$1);

return statearr_26243;
})();
if(inst_26220){
var statearr_26244_26278 = state_26238__$1;
(statearr_26244_26278[(1)] = (5));

} else {
var statearr_26245_26279 = state_26238__$1;
(statearr_26245_26279[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26239 === (6))){
var state_26238__$1 = state_26238;
var statearr_26246_26280 = state_26238__$1;
(statearr_26246_26280[(2)] = null);

(statearr_26246_26280[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26239 === (3))){
var inst_26235 = (state_26238[(2)]);
var inst_26236 = cljs.core.async.close_BANG_.call(null,out);
var state_26238__$1 = (function (){var statearr_26247 = state_26238;
(statearr_26247[(9)] = inst_26235);

return statearr_26247;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26238__$1,inst_26236);
} else {
if((state_val_26239 === (2))){
var state_26238__$1 = state_26238;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26238__$1,(4),ch);
} else {
if((state_val_26239 === (11))){
var inst_26218 = (state_26238[(8)]);
var inst_26227 = (state_26238[(2)]);
var inst_26215 = inst_26218;
var state_26238__$1 = (function (){var statearr_26248 = state_26238;
(statearr_26248[(7)] = inst_26215);

(statearr_26248[(10)] = inst_26227);

return statearr_26248;
})();
var statearr_26249_26284 = state_26238__$1;
(statearr_26249_26284[(2)] = null);

(statearr_26249_26284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26239 === (9))){
var inst_26218 = (state_26238[(8)]);
var state_26238__$1 = state_26238;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26238__$1,(11),out,inst_26218);
} else {
if((state_val_26239 === (5))){
var inst_26218 = (state_26238[(8)]);
var inst_26215 = (state_26238[(7)]);
var inst_26222 = cljs.core._EQ_.call(null,inst_26218,inst_26215);
var state_26238__$1 = state_26238;
if(inst_26222){
var statearr_26255_26288 = state_26238__$1;
(statearr_26255_26288[(1)] = (8));

} else {
var statearr_26256_26289 = state_26238__$1;
(statearr_26256_26289[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26239 === (10))){
var inst_26230 = (state_26238[(2)]);
var state_26238__$1 = state_26238;
var statearr_26257_26290 = state_26238__$1;
(statearr_26257_26290[(2)] = inst_26230);

(statearr_26257_26290[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26239 === (8))){
var inst_26215 = (state_26238[(7)]);
var tmp26250 = inst_26215;
var inst_26215__$1 = tmp26250;
var state_26238__$1 = (function (){var statearr_26258 = state_26238;
(statearr_26258[(7)] = inst_26215__$1);

return statearr_26258;
})();
var statearr_26259_26291 = state_26238__$1;
(statearr_26259_26291[(2)] = null);

(statearr_26259_26291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto___26272,out))
;
return ((function (switch__23144__auto__,c__23309__auto___26272,out){
return (function() {
var cljs$core$async$state_machine__23145__auto__ = null;
var cljs$core$async$state_machine__23145__auto____0 = (function (){
var statearr_26260 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26260[(0)] = cljs$core$async$state_machine__23145__auto__);

(statearr_26260[(1)] = (1));

return statearr_26260;
});
var cljs$core$async$state_machine__23145__auto____1 = (function (state_26238){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_26238);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e26261){if((e26261 instanceof Object)){
var ex__23148__auto__ = e26261;
var statearr_26262_26292 = state_26238;
(statearr_26262_26292[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26238);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26261;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26293 = state_26238;
state_26238 = G__26293;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$state_machine__23145__auto__ = function(state_26238){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23145__auto____1.call(this,state_26238);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23145__auto____0;
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23145__auto____1;
return cljs$core$async$state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto___26272,out))
})();
var state__23311__auto__ = (function (){var statearr_26263 = f__23310__auto__.call(null);
(statearr_26263[(6)] = c__23309__auto___26272);

return statearr_26263;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto___26272,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__26295 = arguments.length;
switch (G__26295) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23309__auto___26373 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto___26373,out){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto___26373,out){
return (function (state_26333){
var state_val_26334 = (state_26333[(1)]);
if((state_val_26334 === (7))){
var inst_26329 = (state_26333[(2)]);
var state_26333__$1 = state_26333;
var statearr_26335_26374 = state_26333__$1;
(statearr_26335_26374[(2)] = inst_26329);

(statearr_26335_26374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26334 === (1))){
var inst_26296 = (new Array(n));
var inst_26297 = inst_26296;
var inst_26298 = (0);
var state_26333__$1 = (function (){var statearr_26336 = state_26333;
(statearr_26336[(7)] = inst_26298);

(statearr_26336[(8)] = inst_26297);

return statearr_26336;
})();
var statearr_26337_26375 = state_26333__$1;
(statearr_26337_26375[(2)] = null);

(statearr_26337_26375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26334 === (4))){
var inst_26301 = (state_26333[(9)]);
var inst_26301__$1 = (state_26333[(2)]);
var inst_26302 = (inst_26301__$1 == null);
var inst_26303 = cljs.core.not.call(null,inst_26302);
var state_26333__$1 = (function (){var statearr_26341 = state_26333;
(statearr_26341[(9)] = inst_26301__$1);

return statearr_26341;
})();
if(inst_26303){
var statearr_26342_26376 = state_26333__$1;
(statearr_26342_26376[(1)] = (5));

} else {
var statearr_26343_26377 = state_26333__$1;
(statearr_26343_26377[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26334 === (15))){
var inst_26323 = (state_26333[(2)]);
var state_26333__$1 = state_26333;
var statearr_26344_26378 = state_26333__$1;
(statearr_26344_26378[(2)] = inst_26323);

(statearr_26344_26378[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26334 === (13))){
var state_26333__$1 = state_26333;
var statearr_26348_26379 = state_26333__$1;
(statearr_26348_26379[(2)] = null);

(statearr_26348_26379[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26334 === (6))){
var inst_26298 = (state_26333[(7)]);
var inst_26319 = (inst_26298 > (0));
var state_26333__$1 = state_26333;
if(cljs.core.truth_(inst_26319)){
var statearr_26349_26380 = state_26333__$1;
(statearr_26349_26380[(1)] = (12));

} else {
var statearr_26350_26381 = state_26333__$1;
(statearr_26350_26381[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26334 === (3))){
var inst_26331 = (state_26333[(2)]);
var state_26333__$1 = state_26333;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26333__$1,inst_26331);
} else {
if((state_val_26334 === (12))){
var inst_26297 = (state_26333[(8)]);
var inst_26321 = cljs.core.vec.call(null,inst_26297);
var state_26333__$1 = state_26333;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26333__$1,(15),out,inst_26321);
} else {
if((state_val_26334 === (2))){
var state_26333__$1 = state_26333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26333__$1,(4),ch);
} else {
if((state_val_26334 === (11))){
var inst_26313 = (state_26333[(2)]);
var inst_26314 = (new Array(n));
var inst_26297 = inst_26314;
var inst_26298 = (0);
var state_26333__$1 = (function (){var statearr_26351 = state_26333;
(statearr_26351[(10)] = inst_26313);

(statearr_26351[(7)] = inst_26298);

(statearr_26351[(8)] = inst_26297);

return statearr_26351;
})();
var statearr_26352_26382 = state_26333__$1;
(statearr_26352_26382[(2)] = null);

(statearr_26352_26382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26334 === (9))){
var inst_26297 = (state_26333[(8)]);
var inst_26311 = cljs.core.vec.call(null,inst_26297);
var state_26333__$1 = state_26333;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26333__$1,(11),out,inst_26311);
} else {
if((state_val_26334 === (5))){
var inst_26301 = (state_26333[(9)]);
var inst_26306 = (state_26333[(11)]);
var inst_26298 = (state_26333[(7)]);
var inst_26297 = (state_26333[(8)]);
var inst_26305 = (inst_26297[inst_26298] = inst_26301);
var inst_26306__$1 = (inst_26298 + (1));
var inst_26307 = (inst_26306__$1 < n);
var state_26333__$1 = (function (){var statearr_26353 = state_26333;
(statearr_26353[(11)] = inst_26306__$1);

(statearr_26353[(12)] = inst_26305);

return statearr_26353;
})();
if(cljs.core.truth_(inst_26307)){
var statearr_26354_26383 = state_26333__$1;
(statearr_26354_26383[(1)] = (8));

} else {
var statearr_26355_26384 = state_26333__$1;
(statearr_26355_26384[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26334 === (14))){
var inst_26326 = (state_26333[(2)]);
var inst_26327 = cljs.core.async.close_BANG_.call(null,out);
var state_26333__$1 = (function (){var statearr_26357 = state_26333;
(statearr_26357[(13)] = inst_26326);

return statearr_26357;
})();
var statearr_26358_26386 = state_26333__$1;
(statearr_26358_26386[(2)] = inst_26327);

(statearr_26358_26386[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26334 === (10))){
var inst_26317 = (state_26333[(2)]);
var state_26333__$1 = state_26333;
var statearr_26359_26387 = state_26333__$1;
(statearr_26359_26387[(2)] = inst_26317);

(statearr_26359_26387[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26334 === (8))){
var inst_26306 = (state_26333[(11)]);
var inst_26297 = (state_26333[(8)]);
var tmp26356 = inst_26297;
var inst_26297__$1 = tmp26356;
var inst_26298 = inst_26306;
var state_26333__$1 = (function (){var statearr_26360 = state_26333;
(statearr_26360[(7)] = inst_26298);

(statearr_26360[(8)] = inst_26297__$1);

return statearr_26360;
})();
var statearr_26361_26388 = state_26333__$1;
(statearr_26361_26388[(2)] = null);

(statearr_26361_26388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto___26373,out))
;
return ((function (switch__23144__auto__,c__23309__auto___26373,out){
return (function() {
var cljs$core$async$state_machine__23145__auto__ = null;
var cljs$core$async$state_machine__23145__auto____0 = (function (){
var statearr_26362 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26362[(0)] = cljs$core$async$state_machine__23145__auto__);

(statearr_26362[(1)] = (1));

return statearr_26362;
});
var cljs$core$async$state_machine__23145__auto____1 = (function (state_26333){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_26333);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e26363){if((e26363 instanceof Object)){
var ex__23148__auto__ = e26363;
var statearr_26364_26390 = state_26333;
(statearr_26364_26390[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26333);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26363;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26391 = state_26333;
state_26333 = G__26391;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$state_machine__23145__auto__ = function(state_26333){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23145__auto____1.call(this,state_26333);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23145__auto____0;
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23145__auto____1;
return cljs$core$async$state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto___26373,out))
})();
var state__23311__auto__ = (function (){var statearr_26365 = f__23310__auto__.call(null);
(statearr_26365[(6)] = c__23309__auto___26373);

return statearr_26365;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto___26373,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__26397 = arguments.length;
switch (G__26397) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23309__auto___26479 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23309__auto___26479,out){
return (function (){
var f__23310__auto__ = (function (){var switch__23144__auto__ = ((function (c__23309__auto___26479,out){
return (function (state_26444){
var state_val_26445 = (state_26444[(1)]);
if((state_val_26445 === (7))){
var inst_26440 = (state_26444[(2)]);
var state_26444__$1 = state_26444;
var statearr_26446_26480 = state_26444__$1;
(statearr_26446_26480[(2)] = inst_26440);

(statearr_26446_26480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (1))){
var inst_26398 = [];
var inst_26399 = inst_26398;
var inst_26400 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_26444__$1 = (function (){var statearr_26447 = state_26444;
(statearr_26447[(7)] = inst_26400);

(statearr_26447[(8)] = inst_26399);

return statearr_26447;
})();
var statearr_26448_26484 = state_26444__$1;
(statearr_26448_26484[(2)] = null);

(statearr_26448_26484[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (4))){
var inst_26403 = (state_26444[(9)]);
var inst_26403__$1 = (state_26444[(2)]);
var inst_26404 = (inst_26403__$1 == null);
var inst_26405 = cljs.core.not.call(null,inst_26404);
var state_26444__$1 = (function (){var statearr_26449 = state_26444;
(statearr_26449[(9)] = inst_26403__$1);

return statearr_26449;
})();
if(inst_26405){
var statearr_26450_26517 = state_26444__$1;
(statearr_26450_26517[(1)] = (5));

} else {
var statearr_26451_26518 = state_26444__$1;
(statearr_26451_26518[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (15))){
var inst_26434 = (state_26444[(2)]);
var state_26444__$1 = state_26444;
var statearr_26455_26519 = state_26444__$1;
(statearr_26455_26519[(2)] = inst_26434);

(statearr_26455_26519[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (13))){
var state_26444__$1 = state_26444;
var statearr_26456_26526 = state_26444__$1;
(statearr_26456_26526[(2)] = null);

(statearr_26456_26526[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (6))){
var inst_26399 = (state_26444[(8)]);
var inst_26429 = inst_26399.length;
var inst_26430 = (inst_26429 > (0));
var state_26444__$1 = state_26444;
if(cljs.core.truth_(inst_26430)){
var statearr_26457_26527 = state_26444__$1;
(statearr_26457_26527[(1)] = (12));

} else {
var statearr_26458_26531 = state_26444__$1;
(statearr_26458_26531[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (3))){
var inst_26442 = (state_26444[(2)]);
var state_26444__$1 = state_26444;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26444__$1,inst_26442);
} else {
if((state_val_26445 === (12))){
var inst_26399 = (state_26444[(8)]);
var inst_26432 = cljs.core.vec.call(null,inst_26399);
var state_26444__$1 = state_26444;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26444__$1,(15),out,inst_26432);
} else {
if((state_val_26445 === (2))){
var state_26444__$1 = state_26444;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26444__$1,(4),ch);
} else {
if((state_val_26445 === (11))){
var inst_26403 = (state_26444[(9)]);
var inst_26407 = (state_26444[(10)]);
var inst_26422 = (state_26444[(2)]);
var inst_26423 = [];
var inst_26424 = inst_26423.push(inst_26403);
var inst_26399 = inst_26423;
var inst_26400 = inst_26407;
var state_26444__$1 = (function (){var statearr_26461 = state_26444;
(statearr_26461[(11)] = inst_26424);

(statearr_26461[(7)] = inst_26400);

(statearr_26461[(8)] = inst_26399);

(statearr_26461[(12)] = inst_26422);

return statearr_26461;
})();
var statearr_26462_26532 = state_26444__$1;
(statearr_26462_26532[(2)] = null);

(statearr_26462_26532[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (9))){
var inst_26399 = (state_26444[(8)]);
var inst_26420 = cljs.core.vec.call(null,inst_26399);
var state_26444__$1 = state_26444;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26444__$1,(11),out,inst_26420);
} else {
if((state_val_26445 === (5))){
var inst_26403 = (state_26444[(9)]);
var inst_26400 = (state_26444[(7)]);
var inst_26407 = (state_26444[(10)]);
var inst_26407__$1 = f.call(null,inst_26403);
var inst_26413 = cljs.core._EQ_.call(null,inst_26407__$1,inst_26400);
var inst_26414 = cljs.core.keyword_identical_QMARK_.call(null,inst_26400,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_26415 = ((inst_26413) || (inst_26414));
var state_26444__$1 = (function (){var statearr_26463 = state_26444;
(statearr_26463[(10)] = inst_26407__$1);

return statearr_26463;
})();
if(cljs.core.truth_(inst_26415)){
var statearr_26464_26533 = state_26444__$1;
(statearr_26464_26533[(1)] = (8));

} else {
var statearr_26465_26534 = state_26444__$1;
(statearr_26465_26534[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (14))){
var inst_26437 = (state_26444[(2)]);
var inst_26438 = cljs.core.async.close_BANG_.call(null,out);
var state_26444__$1 = (function (){var statearr_26467 = state_26444;
(statearr_26467[(13)] = inst_26437);

return statearr_26467;
})();
var statearr_26468_26535 = state_26444__$1;
(statearr_26468_26535[(2)] = inst_26438);

(statearr_26468_26535[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (10))){
var inst_26427 = (state_26444[(2)]);
var state_26444__$1 = state_26444;
var statearr_26469_26536 = state_26444__$1;
(statearr_26469_26536[(2)] = inst_26427);

(statearr_26469_26536[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (8))){
var inst_26403 = (state_26444[(9)]);
var inst_26399 = (state_26444[(8)]);
var inst_26407 = (state_26444[(10)]);
var inst_26417 = inst_26399.push(inst_26403);
var tmp26466 = inst_26399;
var inst_26399__$1 = tmp26466;
var inst_26400 = inst_26407;
var state_26444__$1 = (function (){var statearr_26470 = state_26444;
(statearr_26470[(7)] = inst_26400);

(statearr_26470[(8)] = inst_26399__$1);

(statearr_26470[(14)] = inst_26417);

return statearr_26470;
})();
var statearr_26471_26540 = state_26444__$1;
(statearr_26471_26540[(2)] = null);

(statearr_26471_26540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23309__auto___26479,out))
;
return ((function (switch__23144__auto__,c__23309__auto___26479,out){
return (function() {
var cljs$core$async$state_machine__23145__auto__ = null;
var cljs$core$async$state_machine__23145__auto____0 = (function (){
var statearr_26472 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26472[(0)] = cljs$core$async$state_machine__23145__auto__);

(statearr_26472[(1)] = (1));

return statearr_26472;
});
var cljs$core$async$state_machine__23145__auto____1 = (function (state_26444){
while(true){
var ret_value__23146__auto__ = (function (){try{while(true){
var result__23147__auto__ = switch__23144__auto__.call(null,state_26444);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23147__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23147__auto__;
}
break;
}
}catch (e26473){if((e26473 instanceof Object)){
var ex__23148__auto__ = e26473;
var statearr_26474_26541 = state_26444;
(statearr_26474_26541[(5)] = ex__23148__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26444);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26473;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23146__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26542 = state_26444;
state_26444 = G__26542;
continue;
} else {
return ret_value__23146__auto__;
}
break;
}
});
cljs$core$async$state_machine__23145__auto__ = function(state_26444){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23145__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23145__auto____1.call(this,state_26444);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23145__auto____0;
cljs$core$async$state_machine__23145__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23145__auto____1;
return cljs$core$async$state_machine__23145__auto__;
})()
;})(switch__23144__auto__,c__23309__auto___26479,out))
})();
var state__23311__auto__ = (function (){var statearr_26477 = f__23310__auto__.call(null);
(statearr_26477[(6)] = c__23309__auto___26479);

return statearr_26477;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23311__auto__);
});})(c__23309__auto___26479,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1529759827142
