# Welcome

Clojure library for Google Maps


## Latest version [![CircleCI](https://circleci.com/gh/sultanov-team/clj-google-maps/tree/master.svg?style=svg)](https://circleci.com/gh/sultanov-team/clj-google-maps/tree/master)

[![Clojars Project](https://img.shields.io/clojars/v/team.sultanov/clj-google-maps.svg)](https://clojars.org/team.sultanov/clj-google-maps)


## Getting Started

Add the necessary dependency to your project:

### Leiningen/Boot
```clojure
[team.sultanov/clj-google-maps "0.1.1"]
```

### Clojure CLI/deps.edn
```clojure
team.sultanov/clj-google-maps {:mvn/version "0.1.1"}
```


## Quick Start

### Requirements

```bash
#!/bin/bash
export GOOGLE_MAPS_API_URL="https://maps.googleapis.com/maps/api/geocode"
export GOOGLE_MAPS_API_FORMAT="json"        # JSON FORMAT ONLY
export GOOGLE_MAPS_API_KEY="ABCDEFGHIJKLMN" # YOUR API KEY
export GOOGLE_MAPS_API_REGION="ru"          # YOUR DEFAULT REGION
export GOOGLE_MAPS_API_LANGUAGE="ru"        # YOUR DEFAULT LANGUAGE
```

### Google Maps Geocoding API

```clojure
(ns example
  (:require [clj-google-maps.geocode :as geocode]))

;; fetch geocode by address
(geocode/fetch-by :address "Moscow")

;; fetch geocode by location: latitude longitude
(geocode/fetch-by :location 55.755826 37.6172999)

;; fetch geocode by place-id
(geocode/fetch-by :place-id "ChIJybDUc_xKtUYRTM9XV8zWRD0")

```


## License

Copyright © 2018 Sultanov Team

[![MIT License](https://img.shields.io/github/license/mashape/apistatus.svg)](LICENSE)
