(defproject team.sultanov/clj-google-maps "0.1.1"
  :description    "Clojure library for Google Maps"
  :url            "https://github.com/sultanov-team/clj-google-maps"
  :license        {:name "MIT License"
                   :url  "https://github.com/sultanov-team/clj-google-maps/blob/master/LICENSE"}

  :dependencies   [[org.clojure/clojure "1.10.0-alpha4"]
                   [clj-http            "3.9.0"]]

  ;; :jvm-opts ["--add-modules" "java.xml.bind"]

  :profiles       {:dev {:plugins      [[lein-ancient                      "0.6.15"]
                                        [com.jakemccrary/lein-test-refresh "0.22.0"]]
                         :repl-options {:host "0.0.0.0"
                                        :port 7000}}}
  :scm            {:name "git"
                   :url  "https://github.com/sultanov-team/clj-google-maps"}

  :deploy-branches     ["master"]
  :deploy-repositories [["snapshots" {:url      "https://clojars.org/repo"
                                      :username [:gpg :env/sultanov_team_clojars_username]
                                      :password [:gpg :env/sultanov_team_clojars_password]}]
                        ["releases"  {:url      "https://clojars.org/repo"
                                      :username [:gpg :env/sultanov_team_clojars_username]
                                      :password [:gpg :env/sultanov_team_clojars_password]}]])
