(ns clj-kafka.producers
  (:require [clj-kafka.commons :as commons]
            [clj-kafka.serialization.core :as serialization])
  (:import [org.apache.kafka.clients.producer Producer KafkaProducer ProducerRecord]))


(defn producer
  ([properties]
   (producer properties nil nil))

  ([properties value-serializer]
   (producer properties nil value-serializer))

  ([properties key-serializer value-serializer]
   (let [p  (commons/to-properties properties)
         ks (or key-serializer   (serialization/serializer :string))
         vs (or value-serializer (serialization/serializer :string))]
     (KafkaProducer. p ks vs))))
